					  
@extends('dashboard.base')

@section('content')

    @if(Session::has('message'))
        <div class="row">
          <div class="col-12">
            <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
            </div> -->
            <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
              <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
          </div>
        </div>
        @endif                 
       <div class="container-fluid">
          <div class="animated fadeIn">
            <div class="row">
              <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                <div class="card">
                    <div class="card-header">
                      <i class="fa fa-align-justify"></i>{{ __(' Quick Searc') }}
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>First Name</label>
                                    <input type="text" placeholder="Enter First Name" name="first_name" id="first_name" class="form-control" >
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Last Name</label>
                                    <input type="text" placeholder="Enter Last Name" name="last_name" id="last_name"  class="form-control" >
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">  
                                    <label>Passport/ID Number</label>
                                    <input type="text" placeholder="Enter your Passport Number" id="passport_number" name="passport_number" class="form-control">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Nationality*</label>
                                    <select class="form-control " name="nationality" id="nationality">
                                        <option value="0">Please select country</option>
                                        @foreach($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Date Of Birth*</label>
                                    <input type="date" placeholder="Enter Dob" name="date_of_birth" class="form-control" id="dob">
                                </div>
                            </div>
                            <button type ="button" id="apply_search" class="btn">Search <i class="fa fa-search"></i></button><br/><br/>
                        </div>

                        <!-- Criminal records tab starts -->
                        <div id="all_records" style="display:none;">
                            <h5>All records list:</h5>
                            <div class="row" id="display_all">
                               
                            </div>
                   
                        </div> <br/><hr/>
                        <!-- blacklist records tab ends -->
                    
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>


        

        <!-- /.modal-->
        <div class="modal fade" id="criminalModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <input type="hidden" name='criminal_record_id' id="criminal_record_id" value="">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Criminal Record Details</h4>
                        <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                    </div>
                    <div class="modal-body">
                        <table class="footable-details table table-bordered tabel_info">
                            <tbody>  
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">File No.</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="file_no"></label></td>
                                    <td class="text-left" colspan="2" class="view_th">Record ID</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="record_id"></label></td>
                                    <td class="text-center" rowspan="3" style="width: 130px;padding: 5px;"><label id="image"></label></td>
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Name</td>
                                    <td class="text-left" colspan="3" class="view_th"><label id="name"></label></td>
                                    <td class="text-left" colspan="2" class="view_th">Gender</td>
                                    <td class="text-left" colspan="3" class="view_th"><label id="gender"></label></td>
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Description(Charge)</td>
                                    <td class="text-left" colspan="8" class="view_th"><label id="description"></label></td>
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Institution</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="institution"></label></td>
                                    
                                    <td class="text-left" colspan="2" class="view_th">Nationality</td>
                                    <td class="text-left" colspan="4" class="view_th"  ><label id="nationality"></label></td>
                                </tr>
                                <tr> 
                                    <td class="text-left" colspan="2" class="view_th">Age </td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="age"></label></td>
                                    
                                    <td class="text-left" colspan="2" class="view_th">Height</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="height"></label></td>

                                    <td class="text-left" colspan="2" class="view_th">Date of Birth</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="date_of_birth"></label></td>

                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Eye Color</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="eye_color"></label></td>
                                   
                                    <td class="text-left" colspan="2" class="view_th">Hair Color</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="hair_color"></label> </td>
                                
                                    <td class="text-left" colspan="2" class="view_th">Created On</td>
                                    <td class="text-left" colspan="2" class="view_th"><label id="created_at"></label> </td>
                                
                                </tr>
                                <tr>
                                    <td class="text-left" colspan="2" class="view_th">Law Instructions</td>
                                    <td class="text-left" colspan="1" class="view_th"><label id="law_instructions"></label></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    </div>
                </div>
                <!-- /.modal-content-->
            </div>
            <!-- /.modal-dialog-->
        </div>
        <!-- /.modal-->



@endsection


@section('javascript')


<script type="text/javascript">
  $(function () {
    var table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('idprooftypes.index') }}",
        order: [],
        columns: [
            // {data: 'id', name: 'id'},
            {data: 'title', name: 'title'},
            {data: 'description', name: 'description'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ]
    });


    $(document).on( "click", "#apply_search", function() {

        var first_name = $('#first_name').val();
        var last_name = $('#last_name').val();
        var dob = $('#dob').val();
        var nationality = $('#nationality').val();
        var passport_no = $('#passport_number').val();
        $.ajax({
              type: 'POST',
              url: '/customers/getQuickSearchResults',
              data: {
                  '_method':'POST',
                  '_token': $('input[name=_token]').val(),
                  'first_name': first_name,
                  'last_name': last_name,
                  'dob': dob,
                  'nationality': nationality,
                  'passport_no': passport_no,
              },
              success: function(resdata) {
                    $('#all_records').show();  
                    $('#display_all').html(resdata.html);  
                
            }
        }); 

    });


    $(document).on("click", ".view_record", function() {
                $.ajax({
                    type: 'get',
                    url: '/customers/getCriminalRecordDetails',
                    data: {
                        '_method':'GET',
                        '_token': $('input[name=_token]').val(),
                        'type':'criminal_view',
                        'id': $(this).data('record-id'),
                    },
                    success: function(resdata) {
                        if(resdata){
                            $('#criminalModal').modal('show');
                            $('#file_no').text(resdata.file_number);
                            $('#record_id').text(resdata.record_id);
                            $('#image').html('<img src="' + resdata.image + '" height="150">');
                            $('#name').text(resdata.name);
                            $('#description').text(resdata.description);
                            $('#institution').text(resdata.institution);
                            $('#nationality').text(resdata.country);
                            $('#gender').text(resdata.criminal_gender);
                            $('#date_of_birth').text(resdata.date_of_birth);
                            $('#age').text(resdata.age);
                            $('#height').text(resdata.height);
                            $('#eye_color').text(resdata.eye_color);
                            $('#hair_color').text(resdata.hair_color);
                            $('#created_at').text(resdata.created_on);
                            $('#law_instructions').text(resdata.law_instructions);
                            $('#law_instructions').cdd("colot:","red");
                           
                            // $('#title').text(resdata.title);
                            // $('#description').text(resdata.description);
                            // $('#document').html('<a href="' + resdata.document + '" target="_bkank">viwe Document</a>');
                        }
                    }
                });
            });


  });

</script>


@endsection
