
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
        <div class="card-header"><h4>Edit Complaint against {{ $complaint->complaint_against_name }}</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                  <form method="POST" action="/complaints/{{ $complaint->id }}">
                    @csrf
                    @method('PUT')
                    <input name="complaint_against" value="<?php echo $complaint->complaint_against; ?>" type="hidden">
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Complaint Type</label>
                          <select class="form-control select2" name="complaint_type" id="complaint_type">
                            <option value="0">Please select Type</option>
                            @foreach($complaint_types as $type)
                                <option value="{{ $type->id }}" <?php if($complaint->complaint_type ==  $type->id){echo "selected";}?>>{{ $type->title }}</option>
                            @endforeach
                          </select>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Title</label>
                          <input type="text" placeholder="Enter Title" name="title" value="<?php echo $complaint->title; ?>" class="form-control" >
                        </div>
                      </div>
                    </div>

                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Description</label>
                          <textarea class="form-control" id="textarea-input" name="description" rows="4" placeholder="Description.."><?php echo $complaint->description; ?></textarea>
                          <!-- <input type="text" placeholder="Enter Description" name="description" class="form-control" > -->
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Ratings</label>
                          <select class="form-control select2" name="complaint_rating" id="complaint_rating">
                            <option value="0">Please select Rating</option>
                              <option value="5" <?php if($complaint->complaint_rating ==  '5'){echo "selected";}?>>5 (Very Serious)</option>
                              <option value="4" <?php if($complaint->complaint_rating ==  '4'){echo "selected";}?>>4 (Serious)</option>
                              <option value="3" <?php if($complaint->complaint_rating ==  '3'){echo "selected";}?>>3 (Major)</option>
                              <option value="2" <?php if($complaint->complaint_rating ==  '2'){echo "selected";}?>>2 (Minor)</option>
                              <option value="1" <?php if($complaint->complaint_rating ==  '1'){echo "selected";}?>>1 (Very Minor)</option>
                          </select>
                        </div>
                      </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Status</label>
                                <select class="form-control select2" name="complaint_status" id="complaint_status">
                                    <option value="1" <?php if($complaint->complaint_status ==  '1'){echo "selected";}?>>Show</option>
                                    <option value="0" <?php if($complaint->complaint_status ==  '0'){echo "selected";}?>>Hide</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Action Taken</label>
                                <textarea class="form-control" id="textarea-input" name="action_taken" rows="4" placeholder="Action taken.."><?php echo $complaint->action_taken; ?></textarea>
                                <!-- <input type="text" placeholder="Enter Description" name="description" class="form-control" > -->
                            </div>
                        </div>
                    </div>

                      <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label>Document</label><br/>
                          <input type="file" name="document" id="document" ><br/>
                            <small><?php echo "Max File Size : 1MB"?></small>
                          
                            <?php 
                                $doc = '';
                                if($complaint->document){
                                $doc =  base_url().'/public/storage/uploads/hotel_admins/'.$complaint->complaint_from.'/complaints_doccument'.'/'.$complaint->complaint_against.'/'.$complaint->document;
                            ?>
                                <br/><a href="<?php echo $doc;?>" target="_bkank">View Document</a>
                            <?php } ?>
                       
                        </div>
                      </div>

                      <?php if(Auth::user()->id == 1){ //super admin ?>
                        <div class="col-md-6">
                          <div class="form-group">
                            <label>Status</label>
                            <select class="form-control " name="status" id="status">
                                <option value="1" <?php if($complaint->status ==  '1'){echo "selected";}?>>Public</option>
                                <option value="2" <?php if($complaint->status ==  '2'){echo "selected";}?>>Private</option>
                            </select>
                          </div>
                        </div>
                        <?php }?>

                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('customers.index') }}" class="btn btn-primary">
                      Cancel
                    </a>
                  </form>

            </div><br/><br/><br/><br/>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection