<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Properties;
use App\Models\HotelAdmin;
use App\Models\Country;
use App\Models\Customers;
use App\Models\Staffs;
use App\Models\Room;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use DataTables;

class PropertiesController extends Controller
{
    public function index(Request $request){
 
        //get properties list for pin
        $datas = $request->all();
        if(array_key_exists('pin',$datas)){
            $pincode = $datas['pin'];
        } else {
            $pincode = '';
        }

        //show all properties to govt admin and super admin
         if(Auth::user()->user_type == 1 || Auth::user()->user_type == 5){ //1=super admin and 5 = govt admin
            if($pincode){
                $data = Properties::where('status_id','1')->where('pin',$pincode)->orderBy('id','desc')->get();
            } else {
                $data = Properties::where('status_id','1')->orderBy('id','desc')->get();
            }
         } else if(Auth::user()->user_type == 6){ //for govt admin staff
            //get the main user id from user table for staff  
            $getStaff = DB::table('staffs')->select('id')->where('main_user_id',Auth::user()->id)->first();
           
            //check if pincodes assigned to logged in staff
            $assigned_to_staff = DB::table('staff_assigned_pincodes')
                        ->select('assigned_pin')
                        ->where('staff_id',$getStaff->id);
                        if($pincode){ //get pincodes assigned to staff user logged in 
                            $assigned_to_staff->where('assigned_pin',$pincode);
                        }
            $res = $assigned_to_staff->get();
              
            $data = array();
            if(!empty($res)){
                foreach($res as $pin){ 
                    $data = Properties::where('status_id','1')->where('pin',$pin->assigned_pin)->orderBy('id','desc')->get();
                   
                }
            } else {
                $data = array();
            }

         } else {
            if($pincode){
                $data = Properties::where('status_id','1')->where('pin',$pincode)->where('created_by','=',Auth::user()->id)->orderBy('id','desc')->get();
            } else {
                 if(Auth::user()->user_type == 4){
                    //get all assigned properties
                    $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
                    $data = DB::table('staff_assigned_properties as sp')
                            ->select('pr.*')
                            ->join('properties as pr','pr.id', '=' ,'sp.property_id','left')
                            ->where('sp.staff_id',$staff_details->id)
                            ->get();
                } else { 
                $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
                $data = Properties::where('status_id','1')->where('owner','=',$hotelAdmin_id->id)->orderBy('id','desc')->get();
                }
                
                // $data = Properties::where('status_id','1')->where('created_by','=',Auth::user()->id)->orderBy('id','desc')->get();
            }
        }

         //manage privilege if its staff user
         if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','2')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }


        //show pin dropdown filter only for govt aadmin and govt admin staff
        $pincodes_array = array();
        if(Auth::user()->user_type == 5 || Auth::user()->user_type == 6){
            
            if(Auth::user()->user_type == 6){
                    //get all assigned properties
                    $staff_data = Staffs::where('main_user_id',Auth::user()->id)->first();
                    $pincodes_array = DB::table('staff_assigned_pincodes')
                            ->select('assigned_pin as pin')
                            ->where('staff_id',$staff_data->id)
                            ->get();
                    
                } else {
                    $pincodes_array = DB::table('properties')->select('pin')->where('status_id','1')->distinct()->get();
                }
            
        }

                 foreach($data as $prop){
                        //status active and in-active
                        if($prop->status_id == 1){
                            $prop->status_id = 'Active';
                        } else {
                            $prop->status_id = 'In-Active'; 
                        }
                        $id = $prop->id;

                        //get owner full name
                    $owner_name_arr = HotelAdmin::find($prop->owner);
                    $prop->owner = $owner_name_arr->first_name.' '.$owner_name_arr->last_name;
                }
                
        if ($request->ajax()) {

                
                if(!empty($getPrivileges)){
                    if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                        $action =  '<a href="/properties/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;"  data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Delete"  >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button><button style="padding: 0;border: none;background: none;" class="export_customers" data-toggle="modal" data-target="#exportModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Export Customer Data"  >@csrf<i class="fa fa-download" style="font-size: 20px;margin-left: 17px;"></i></button>';
                    } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                        $action = '<a href="/properties/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;"  data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a><button style="padding: 0;border: none;background: none;" class="export_customers" data-toggle="modal" data-target="#exportModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Export Customer Data"  >@csrf<i class="fa fa-download" style="font-size: 20px;margin-left: 17px;"></i></button>';
                    } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                        $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Delete"  >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button><button style="padding: 0;border: none;background: none;" class="export_customers" data-toggle="modal" data-target="#exportModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Export Customer Data"  >@csrf<i class="fa fa-download" style="font-size: 20px;margin-left: 17px;"></i></button>';
                    } else {
                        $action =  '';
                    }
                } else {
                    $action =  '<a href="/properties/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;"  data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Delete"  >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button><button style="padding: 0;border: none;background: none;" class="export_customers" data-toggle="modal" data-target="#exportModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Export Customer Data"  >@csrf<i class="fa fa-download" style="font-size: 20px;margin-left: 17px;"></i></button>';
                }

                return Datatables::of($data)
                        ->addColumn('action', $action)
                        // ->addColumn('action', '<a href="/properties/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;"  data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal" data-record-id={{$id}}   data-toggle="tooltip" data-placement="top" title="Delete"  >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.properties.propertiesList',['privileges'=>$getPrivileges,'pincodes'=>$pincodes_array]);
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $hoteladmins = HotelAdmin::all();
        $countries = Country::all();
        return view('dashboard.properties.create', [ 'owners' => $hoteladmins,'countries'=>$countries]);
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name'      => 'required|min:1|max:64',
            'code'      => 'required|min:1|max:64',
            'email'           => 'required|email',
            'org_name'           => 'required',
            'country'           => 'required',
        ]);
        
         //validate email if duplicate
         $email_if_exists = DB::table('properties')->select('id')->where('email',$request->input('email'))->get();

         if(count($email_if_exists) > 0){
            $request->session()->flash('message', 'Email already exists.');
            return redirect()->route('properties.create');
         }

        //insert new hotel admin in users table
        $property = new Properties();
        $property->name    = $request->input('name');
        $property->code    = $request->input('code');
        $property->email   =  $request->input('email');
        $property->mobile   = $request->input('mobile');
        $property->phone_1 = $request->input('phone_1');
        $property->phone_2   = $request->input('phone_2');
        $property->city   = $request->input('city');
        $property->country   = $request->input('country');
        $property->address   = $request->input('address');
        $property->pin   = $request->input('pin');
        $property->provenance   = $request->input('provenance');
        $property->org_name   = $request->input('org_name');
        $property->owner   = $request->input('owner');
        $property->status_id   = $request->input('status_id');
        $property->created_by   = Auth::user()->id;
        $property->save();
        
        $request->session()->flash('message', 'Property Created Successfully.');
        return redirect()->route('properties.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        //get all owners(hotel admins)
        $hoteladmins = HotelAdmin::all();
        $countries = Country::all();
        //get property by id
        $properties = Properties::find($id);
        return view('dashboard.properties.edit', ['owners' => $hoteladmins,'property' => $properties,'countries'=>$countries]);
    }

     /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name'      => 'required|min:1|max:64',
            'code'      => 'required|min:1|max:64',
            'email'           => 'required|email',
            'org_name'           => 'required',
            'country'           => 'required',
        ]);
        
        $property = Properties::find($id);
        $property->name    = $request->input('name');
        $property->code    = $request->input('code');
        $property->email   =  $request->input('email');
        $property->mobile   = $request->input('mobile');
        $property->phone_1 = $request->input('phone_1');
        $property->phone_2   = $request->input('phone_2');
        $property->city   = $request->input('city');
        $property->country   = $request->input('country');
        $property->address   = $request->input('address');
        $property->pin   = $request->input('pin');
        $property->provenance   = $request->input('provenance');
        $property->org_name   = $request->input('org_name');
        $property->owner   = $request->input('owner');
        $property->status_id   = $request->input('status_id');
        $property->created_by   = Auth::user()->id;
        $property->save();

        $request->session()->flash('message', 'Property Updated Successfully');
        return redirect()->route('properties.index');
    }

  /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $property = Properties::find($id);
        if($property){
            $property->delete();
        }
        $request->session()->flash('message', 'Property Deleted Successfully');
        return redirect()->route('properties.index');
    }


    /* load the customers document info */
    public function show(Request $request)
    { 
        $data = $request->all();
        if($data['type'] == 'export'){ //for customers export
           $export_file =  $this->exportCustomersByProperty($data);
           return $export_file;
        }
    }



    //export customer by property
    public function exportCustomersByProperty($request)
    {
        $datas = $request;
        $headers = [                 
            'Cache-Control'       => 'must-revalidate, post-check=0, pre-check=0',
            'Content-type'        => 'text/x-csv',
            'Content-Disposition' => 'attachment; filename=galleries.csv',
            'Expires'             => '0',
            'Pragma'              => 'public',
        ];

        $data = Customers::where('checkout_date_time','')->where('property_id',$datas['property_id'])->orderBy('id','desc')->get();

        foreach($data as $customer){
            //create full name 
            $customer->first_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            $room_details = Room::find($customer->room_id);
            $customer->room_id =  $room_details->title;

            //get country title
            $country_title = Country::find($customer->nationality);
            $customer->nationality = $country_title->name;
            
            //get customer id
            $id = $customer->id;

            //check if date range is requested and get customer accordingly
                if($datas['export_by'] == 2){   
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                    $customer = $customer;
                    } else {
                    $customer = array();
                    }
                } else {
                    $customer = $customer;
                }
        }

        $columns = array('Name', 'Room', 'Nationality', 'CheckIn DateTime', 'CheckoutDateTime');
    
        $callback = function() use ($data, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($data as $cust) {
                $name = $cust->first_name.' '.$cust->last_name;
                fputcsv($file, array($name, $cust->room_id, $cust->nationality, $cust->checkin_date_time, $cust->checkout_date_time));
            }
            fclose($file);
        };
        return response()->streamDownload($callback, 'Customers-' . date('d-m-Y-H:i:s').'.csv', $headers);
    }
    

}
