

<?php $__env->startSection('content'); ?>
<style>
    .bg-secondary{
        background-color:#a7cef0 !important;
        padding: 12px;
        border-radius: 22px;
        font-size: 16px;
    }
    .bg-primary{
        background-color:#edc0b0  !important;
        padding: 12px;
        border-radius: 22px;
        font-size: 16px;
    }
    .bg-danger {
        background-color: #dc3545 !important;
        color: white !important;
    }

    #chat-box {
        height: 500px;
        overflow-y: auto;
        padding: 20px;
        background: #f5f5f5;
        border: 1px solid #ddd;
    }

    .text-start {
        margin-bottom: 10px;
        text-align: left;
    }

    .text-end {
        margin-bottom: 10px;
        text-align: right;
    }

    #chat-box .fw-bold {
        font-size: 0.9rem;
        color: #6c757d;
    }
    </style>
    
    <!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- Select2 JS -->
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<div class="d-flex" style="height: 100vh; overflow: hidden;">

    
    <div style="width: 300px; background: #f8f9fa; border-right: 1px solid #ddd; padding: 15px;">
        <h5>Properties</h5>
        <select id="property_id" class="form-control mb-3">
            <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($property->id); ?>"><?php echo e($property->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <h5>Guests</h5>
     
     <select id="customer_select" class="form-control mb-3">
            <option value="">Select a Guest</option>
        </select>

    </div>

    
    <div class="flex-grow-1 d-flex flex-column">
        <div style="padding: 15px; border-bottom: 1px solid #ddd; background-color: #e9ecef;">
            <h4>Chat</h4></n>
            <h6>Front Desk to Guest</h6>
        </div>

        <div id="chat-box" class="flex-grow-1" style="overflow-y:auto; padding: 15px; background-color: #fff;"></div>

        <div style="padding: 10px; background-color: #f1f3f5; border-top: 1px solid #ddd;">
            <form id="chat-form" class="d-flex gap-2">
                <input type="hidden" id="sender_id" value="<?php echo e($admin_id); ?>">
                <input type="hidden" id="receiver_id">
                <textarea id="message" class="form-control" rows="1" placeholder="Type your message..."></textarea>
                <button type="submit" class="btn btn-primary">Send</button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

<script src="https://js.pusher.com/8.2.0/pusher.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<script>
    const senderId = document.getElementById('sender_id').value;
    const propertySelect = document.getElementById('property_id');
    const customerList = document.getElementById('customer_list');
    const receiverIdInput = document.getElementById('receiver_id');
    const chatBox = document.getElementById('chat-box');
    let currentReceiverId = null;
    let currentPropertyId = null;


    const customerSelect = document.getElementById('customer_select');

    // Initialize Select2
    $(customerSelect).select2({
        templateResult: formatCustomerOption,
        templateSelection: formatCustomerOption,
        escapeMarkup: function(m) { return m; },
        placeholder: "Select a guest",
        allowClear: true
    });

propertySelect.addEventListener('change', () => {
    const propertyId = propertySelect.value;
    if (!propertyId) return;

    currentPropertyId = propertyId;

    axios.get(`/chat/customers/${propertyId}`).then(res => {
        // Clear current options
        $(customerSelect).empty().append('<option value="">Select a Guest</option>');

        // // Add new options
        // res.data.customers.forEach(customer => {
        //     const option = new Option(`${customer.full_name} ${customer.unread_count > 0 ? `<span class="badge bg-danger">(${customer.unread_count})</span>` : ''}`, customer.id, false, false);
        //     customerSelect.appendChild(option);
            // });
       res.data.customers.forEach(customer => {
            const option = new Option(customer.full_name, customer.id, false, false);
        
            // Attach custom properties to the <option>
            option.dataset.full_name = customer.full_name;
            option.dataset.unread_count = customer.unread_count;
        
            customerSelect.appendChild(option);
        });

        // Refresh Select2
        $(customerSelect).trigger('change.select2');
    });

    updateReadStatus(currentPropertyId, 0);
});


function formatCustomerOption(option) {
    if (!option.id) return option.text;

    const full_name = option.element?.dataset.full_name || option.text;
    const unread_count = option.element?.dataset.unread_count || 0;

    const unread = unread_count > 0
        ? `<span class="badge bg-danger ms-2">(${unread_count})</span>`
        : '';

    return `<span>${full_name}${unread}</span>`;
}

$(customerSelect).on('select2:select', function (e) {
    const customerId = e.params.data.id;
    currentReceiverId = customerId;
    receiverIdInput.value = currentReceiverId;

    loadMessages(currentPropertyId, senderId, currentReceiverId);
});

 propertySelect.dispatchEvent(new Event('change'));













    // Load customer list for selected property
    // propertySelect.addEventListener('change', () => {
    //     const propertyId = propertySelect.value;
    //     if (!propertyId) return;

    //     currentPropertyId = propertyId;

    //     axios.get(`/chat/customers/${propertyId}`).then(res => {
    //         customerList.innerHTML = '';
    //         res.data.customers.forEach(customer => {
                
    //             const li = document.createElement('li');
    //             li.className = 'list-group-item list-group-item-action d-flex justify-content-between align-items-center';
    //             li.style.cursor = 'pointer';
    //             li.dataset.receiverId = customer.id;
    //             li.innerHTML = `
    //                 <span>${customer.full_name}</span>
    //                 ${customer.unread_count > 0 ? `<span class="badge bg-danger">${customer.unread_count}</span>` : ''}
    //             `;

    //             li.addEventListener('click', () => {
    //                 currentReceiverId = customer.id;
    //                 receiverIdInput.value = currentReceiverId;

    //                 // Remove unread badge
    //                 li.querySelector('.badge')?.remove();

    //                 loadMessages(propertyId, senderId, currentReceiverId);
    //             });

    //             customerList.appendChild(li);
                 
                
    //         });
    //     });
    //      updateReadStatus(currentPropertyId,0);
    // });

    $('#customer-select').on('change', function () { alert(2);
        const customerId = $(this).val();
        const propertyId = $('#property-select').val();
         
        $.ajax({
            url: '/chat/messages',
            method: 'POST',
            data: {
                property_id: propertyId,
                customer_id: customerId,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function (res) {
                let html = '';
              
                res.messages.forEach(msg => {
                    if (msg.sender_type === 'admin') {
                        html += `<div class="text-end"><span class="badge bg-warning text-dark">${msg.message}</span></div>`;
                    } else {
                        html += `<div class="text-start"><span class="badge bg-primary">${msg.message}</span></div>`;
                    }
                });
                $('#chat-box').html(html);
                
            }
        });
    });

    //load chat history after every 5 min 
    setInterval(() => {
        if (currentPropertyId && currentReceiverId) {
            loadMessages(currentPropertyId, senderId, currentReceiverId);
        }
    }, 5000);


    // Display a chat bubble
    function appendMessage(msg, type, timestamp) {
        const div = document.createElement('div');
        div.className = 'mb-2';
        div.style.textAlign = type === 'admin' ? 'right' : 'left';

        const time = formatTime(timestamp);

        div.innerHTML = `
            <div class="d-inline-block text-start">
                <span class="badge bg-${type === 'admin' ? 'primary' : 'secondary'}">${msg}</span><br>
                <small class="text-muted">${time}</small>
            </div>
        `;

        chatBox.appendChild(div);
        chatBox.scrollTop = chatBox.scrollHeight;
    }

    //
    function updateReadStatus(property_id,customer_id){
        axios.get(`/chat/updateReadStatus?property_id=${property_id}&user1=0&user2=0`)
        .then(res => {
            //
        })
    }
    
    // Load chat history
    function loadMessages(propertyId, senderId, receiverId) {
        $('.list-group-item').css('border', 'none');
        $('[data-receiver-id="' + receiverId + '"]').css('border', '2px solid blue');
        
        axios.get(`/api/chat/history?property_id=${propertyId}&user1=${senderId}&user2=${receiverId}`)
        .then(res => {
            chatBox.innerHTML = '';

            let currentDate = '';

            res.data.chats.forEach(chat => {
                const messageDate = new Date(chat.created_at);
                const sectionTitle = formatDateHeader(chat.created_at);
                // alert(sectionTitle+' '+currentDate);
                if (sectionTitle !== currentDate) {
                    // New date section
                    currentDate = sectionTitle;
                    const dateHeader = document.createElement('div');
                    dateHeader.className = 'text-center fw-bold my-3 text-muted';
                    dateHeader.innerText = `— ${sectionTitle} —`;
                    chatBox.appendChild(dateHeader);
                }

                appendMessage(chat.message, chat.sender_type, chat.created_at);
            });
        });
    }

    //format header for day
    function formatDateHeader(dateStr) {
        const date = new Date(dateStr);
        const today = new Date();

        const isToday = date.toDateString() === today.toDateString();
        if (isToday) return 'Today';

        const day = date.getDate();
        const suffix = (d => {
            if (d > 3 && d < 21) return 'th';
            switch (d % 10) {
                case 1: return 'st';
                case 2: return 'nd';
                case 3: return 'rd';
                default: return 'th';
            }
        })(day);

        const month = date.toLocaleString('default', { month: 'long' });
        const year = date.getFullYear();

        return `${day}${suffix} ${month} ${year}`;
    }

    //for the timing formating
    function formatTime(timestamp) {
        const date = new Date(timestamp);
        return date.toLocaleTimeString('en-US', {
            hour: 'numeric',
            minute: '2-digit',
            hour12: true
        });
    }

    // Send message
    document.getElementById('chat-form').addEventListener('submit', function (e) {
        e.preventDefault();

        const message = document.getElementById('message').value;
        const propertyId = currentPropertyId;
        const receiverId = currentReceiverId;

        if (!message || !receiverId || !propertyId) return alert('Please select customer and enter message.');

        axios.post('/api/chat/send', {
            property_id: propertyId,
            sender_id: senderId,
            receiver_id: receiverId,
            sender_type: 'admin',
            message: message
        }).then(res => {
            appendMessage(message, 'admin');
            document.getElementById('message').value = '';
        });
    });

    // Pusher setup
    const pusher = new Pusher('<?php echo e(env('PUSHER_APP_KEY')); ?>', {
        cluster: '<?php echo e(env('PUSHER_APP_CLUSTER')); ?>',
        encrypted: true
    });

    // Subscribe to private admin channel
    const channel = pusher.subscribe(`private-chat.${senderId}`);

    // Receive new message from guest
    channel.bind('new-message', function (data) {
        const chat = data.chat;

        // Show message if open with that user
        if (chat.sender_id == currentReceiverId && chat.sender_type === 'guest') {
            appendMessage(chat.message, 'guest');
        } else {
            // If message from other guest, show unread badge
            const targetItem = Array.from(customerList.children).find(
                li => li.dataset.receiverId == chat.sender_id
            );

            if (targetItem) {
                let badge = targetItem.querySelector('.badge');
                if (!badge) {
                    badge = document.createElement('span');
                    badge.className = 'badge bg-danger ms-auto';
                    badge.textContent = '1';
                    targetItem.appendChild(badge);
                } else {
                    badge.textContent = parseInt(badge.textContent) + 1;
                }
            }
        }
    });

</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('dashboard.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmdsaco/public_html/hotelcall/resources/views/dashboard/messages/index.blade.php ENDPATH**/ ?>