

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Room</h4></div>
            <div class="card-body">
                        <?php if(Session::has('message')): ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-success" role="alert"><?php echo e(Session::get('message')); ?></div>
                                </div>
                            </div>
                        <?php endif; ?>     

                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <form method="POST" action="/rooms/<?php echo e($room->id); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Title*</label>
                                        <input type="text" placeholder="Enter Room Title" name="title" style="border: 2px solid blue;" class="form-control"  value="<?php echo e($room->title); ?>">
                                     </div>
                                </div>
                                <div class="col-md-6">
                                   <div class="form-group">
                                   <label>Description*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Description" name="description" class="form-control"  value="<?php echo e($room->description); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                            <div class="col-md-6">
                              <div class="form-group">
                                <label>Select Property*</label>
                                <select class="form-control" style="border: 2px solid blue;" name="property_id" id="property_id">
                                  <option value="0">Please select</option>
                                    <?php $__currentLoopData = $properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($property->id); ?>"  <?php echo e($room->property_id == $property->id  ? 'selected' : ''); ?> ><?php echo e($property->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                              </div>
                            </div>
                            <div class="col-md-6">
                                  <div class="form-group">
                                    <label>Select Room Type*</label>
                                    <select class="form-control" name="room_type" style="border: 2px solid blue;" id="room_type">
                                      <option value="0">Please select Type</option>
                                        <?php $__currentLoopData = $room_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>" <?php echo e($room->room_type == $type->id  ? 'selected' : ''); ?>><?php echo e($type->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                  </div>
                            </div>
                            </div>

                            <div class="row">
                              <div class="col-md-6">
                                <div class="form-group">
                                  <label>STatus</label>
                                  <select class="form-control " name="status" id="status">
                                      <option value="0" <?php echo e($room->status == 0 ? 'selected' : ''); ?>>In-Active</option>
                                      <option value="1" <?php echo e($room->status == 1 ? 'selected' : ''); ?>>Active</option>
                                  </select>
                                </div>
                              </div>
                              
                               <div class="col-md-6" id="inactive_reasons_div">
                                <div class="form-group">
                                  <label>Reason For In-Active</label>
                                  <select class="form-control " name="reason_for_inactive" id="reason_for_inactive">
                                    <option value="1" <?php echo e($room->reason_for_inactive == 1 ? 'selected' : ''); ?>>OOO (Out Of Order)</option>
                                    <option value="2" <?php echo e($room->reason_for_inactive == 2 ? 'selected' : ''); ?>>Maintainance</option>
                                    <option value="3" <?php echo e($room->reason_for_inactive == 3 ? 'selected' : ''); ?>>Staff Use</option>
                                    <option value="4" <?php echo e($room->reason_for_inactive == 4 ? 'selected' : ''); ?>>Others</option>
                                  </select>
                                </div>
                              </div>
                              
                            </div>
                            
                            <div class="row">
                              <div class="col-md-4">
                                <div class="form-group">
                                  <label>Select Extension*</label>
                                  <select class="form-control" style="border: 2px solid blue;" name="extension" id="extension">
                                    <option value="0">Please extension</option>
                                      <!--<?php $__currentLoopData = $pbx_extensions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extension): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                                      <!--  <option value="<?php echo e($extension->id); ?>" <?php echo e($room->extension == $extension->id  ? 'selected' : ''); ?>><?php echo e($extension->title); ?>(<?php echo e($extension->extension); ?>)</option>-->
                                      <!--<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                                      
                                      <?php $__currentLoopData = $pbx_extensions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extension): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <?php
                                              $assigned = $extension->room_id && $extension->deleted_at === null;
                                          ?>
                                          <option 
                                              value="<?php echo e($extension->id); ?>"  <?php echo e($room->extension == $extension->id  ? 'selected' : ''); ?>

                                              data-assigned="<?php echo e($assigned ? '1' : '0'); ?>" 
                                              data-room="<?php echo e($assigned ? $extension->room_title : ''); ?>"
                                              <?php echo e(isset($room) && $room->extension == $extension->id ? 'selected' : ''); ?>

                                              style="<?php echo e($assigned ? 'color: red;' : ''); ?>">
                                              <?php echo e($extension->title); ?> (<?php echo e($extension->extension); ?>) 
                                             - (<?php echo e($assigned ? ' Assigned to '.$extension->room_title : '- Unassigned'); ?>)
                                          </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  </select>
                                </div>
                              </div>

                              <div class="col-md-4">
                                <div class="form-group">
                                  <label>Remark</label>
                                  <textarea placeholder="Enter Remark" name="remark" class="form-control" ><?php echo $room->remark; ?></textarea>
                                </div>
                              </div>
                              <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Welcome Message</label>
                                        <textarea placeholder="Enter Welcome Message" name="welcome_msg" class="form-control" ><?php echo $room->welcome_msg; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                              <?php  
                                $base_url = URL('/');
                                $wifi_path = '';
                                $room_path = '';
                                if($room->wifi_qr_code){
                                     $wifi_path = Storage::url('app/public/uploads/hotel_admins/'.$room->created_by.'/rooms/'.$room->id.'/wifi_qr/'.$room->wifi_qr_code);
                                }
                                if($room->room_service_qr_code){
                               
                                    $room_path = Storage::url('app/public/uploads/hotel_admins/'.$room->created_by.'/rooms/'.$room->id.'/room_qr/'.$room->room_service_qr_code);
                                }
                            ?>
                            
                             <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Room Service Url</label>
                                       <input type="text" placeholder="Enter Room Service Url" name="room_service_url" value="<?php echo e($room->room_service_url); ?>" class="form-control" >
                                    </div>
                                </div>
                                 <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Upload Wifi QR Code</label>
                                        <input type="file" name="wifi_qr_code" class="form-control" >
                                    </div>
                                    <?php if($wifi_path){ ?>
                                        <a href="<?php echo $wifi_path; ?>" target="_blank">View Wifi QR Code</a>
                                    <?php } ?>
                               </div>
                               
                               <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Upload Room Service QR Code</label>
                                        <input type="file" name="room_service_qr_code" class="form-control" >
                                    </div>
                                     <?php if($room_path){ ?>
                                        <a href="<?php echo $room_path; ?>" target="_blank">View Room Service QR Code</a>
                                     <?php } ?>
                               </div>
                               </div>
                               <!--<div class="col-md-6">-->
                               <!--     <div class="form-group">-->
                               <!--         <label>Guest Name*</label>-->
                               <!--                 <input type="text" placeholder="Enter Guest Name" name="guest_name" class="form-control" value="<?php echo e($room->guest_name); ?>">-->
                               <!--     </div>-->
                               <!-- </div>-->
                         
                               <br/>
                                
                            <button type="submit" class="btn btn-primary">Save</button>
                            <a href="<?php echo e(route('rooms.index')); ?>" class="btn btn-primary">
                            Cancel</a>

                        </form>
                        </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

<script type="text/javascript">
  $(function () {
    $(document).on("change", "#status", function() {
      if($(this).val() == 1){
        //status is active , do nothing
        $('#inactive_reasons_div').hide();
      } else {
        $('#inactive_reasons_div').show();
      }
    });
  });
  
   document.addEventListener('DOMContentLoaded', function () {
        const extensionDropdown = document.getElementById('extension');
    
        extensionDropdown.addEventListener('change', function () {
            const selected = this.options[this.selectedIndex];
            const isAssigned = selected.getAttribute('data-assigned') === '1';
            const roomName = selected.getAttribute('data-room');
    
            if (isAssigned) {
                if (!confirm(`This extension is already assigned to room "${roomName}". If you assign it here, it will be removed from the other room. Proceed?`)) {
                    this.value = "0"; // Reset selection
                }
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmdsaco/public_html/hotelcall/resources/views/dashboard/rooms/edit.blade.php ENDPATH**/ ?>