

<?php $__env->startSection('content'); ?>

<style>
.hps_logo {
    margin-top: 3px !important;
}
</style>

    <div class="container">
      <div class="row justify-content-center">
        <div class="col-md-8">
          <div class="card-group">
            <div class="card p-4">
              <div class="card-body">
              <?php if(Session::has('message')): ?>
                <div class="row">
                  <div class="col-12">
                      <div class="alert alert-success" role="alert"><?php echo e(Session::get('message')); ?></div>
                  </div>
                </div>
              <?php endif; ?>     
              <?php if($errors->any()): ?>
                <div class="row">
                  <div class="col-12">
                    <div class="alert alert-danger">
                      <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    </div>
                  </div>
                </div>
              <?php endif; ?>
                <h1>Login</h1>
                <p class="text-muted">Sign In to your account</p>
                <form method="POST" action="<?php echo e(route('login')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="recaptcha_v3" id="recaptcha_v3">
                    <div class="input-group mb-3">
                    <div class="input-group-prepend">
                      <span class="input-group-text">
                        <svg class="c-icon">
                          <use xlink:href="assets/icons/coreui/free-symbol-defs.svg#cui-user"></use>
                        </svg>
                      </span>
                    </div>
                    <input class="form-control" type="text" placeholder="<?php echo e(__('E-Mail Address')); ?>" name="email" value="<?php echo e(old('email')); ?>" required autofocus>
                    </div>
                    <div class="input-group mb-4">
                    <div class="input-group-prepend">
                      <span class="input-group-text">
                        <svg class="c-icon">
                          <use xlink:href="assets/icons/coreui/free-symbol-defs.svg#cui-lock-locked"></use>
                        </svg>
                      </span>
                    </div>
                    <input class="form-control" type="password" placeholder="<?php echo e(__('Password')); ?>" name="password" required>
                    </div>
                    <div class="row">
                    <div class="col-6">
                        <button class="btn btn-primary px-4" type="submit"><?php echo e(__('Login')); ?></button>
                    </div>
                    </form>
                    <div class="col-6 text-right">
                        <a href="<?php echo e(route('password.request')); ?>" class="btn btn-link px-0 foget_pass_lingk"><?php echo e(__('Forgot Password?')); ?></a>
                    </div>
                    </div>
              </div>
            </div>
            <div class="card text-white bg-primary py-5 d-md-down-none" style="width:44%">
                <div class="vertical_line"></div>
              <div class="card-body text-center">
                <div>
                  <!-- <h2>Sign up</h2>
                  <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
                  <?php if(Route::has('password.request')): ?>
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-primary active mt-3"><?php echo e(__('Register')); ?></a>
                  <?php endif; ?> -->
                

                </div>
                
                <img class="hps_logo" src="<?php echo e(url('assets/brand/hotel-call-logo.png')); ?>"  width="240" height="200" alt="Hotel Call Logo"> 
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

<input type="hidden" name="recaptcha_v3" id="recaptcha_v3">
<!-- added recaptcha script here -->
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(env('G_RECAPTCHA_SITE_KEY')); ?>"></script>
<script>
    grecaptcha.ready(function() {
        grecaptcha.execute("<?php echo e(env('G_RECAPTCHA_SITE_KEY')); ?>", {action: 'homepage'}).then(function(token) {
            if(token) {
                //js
                document.getElementById('recaptcha_v3').value = token;
                //if you use jquery library
                //$("#recaptcha_v3").val(token);
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('dashboard.authBase', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jmdsaco/public_html/hotelcall/resources/views/auth/login.blade.php ENDPATH**/ ?>