<?php
use App\Http\Controllers\MessageController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\NotificationsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['get.menu']], function () {
    Route::get('/', function () {           return view('auth.login'); });
    // Route::get('/', function () {           return view('dashboard.homepage'); });
    Route::group(['middleware' => ['role:user']], function () {
        Route::group(['middleware' => ['auth']], function() {
            Route::get('/dashboard', function () {           return view('dashboard.homepage'); })->middleware('auth');;
            Route::get('/colors', function () {     return view('dashboard.colors'); });
            Route::get('/typography', function () { return view('dashboard.typography'); });
            Route::get('/charts', function () {     return view('dashboard.charts'); });
            Route::get('/widgets', function () {    return view('dashboard.widgets'); });
            Route::get('/404', function () {        return view('dashboard.404'); });
            Route::get('/500', function () {        return view('dashboard.500'); });
            Route::prefix('base')->group(function () {  
                Route::get('/breadcrumb', function(){   return view('dashboard.base.breadcrumb'); });
                Route::get('/cards', function(){        return view('dashboard.base.cards'); });
                Route::get('/carousel', function(){     return view('dashboard.base.carousel'); });
                Route::get('/collapse', function(){     return view('dashboard.base.collapse'); });

                Route::get('/forms', function(){        return view('dashboard.base.forms'); });
                Route::get('/jumbotron', function(){    return view('dashboard.base.jumbotron'); });
                Route::get('/list-group', function(){   return view('dashboard.base.list-group'); });
                Route::get('/navs', function(){         return view('dashboard.base.navs'); });

                Route::get('/pagination', function(){   return view('dashboard.base.pagination'); });
                Route::get('/popovers', function(){     return view('dashboard.base.popovers'); });
                Route::get('/progress', function(){     return view('dashboard.base.progress'); });
                Route::get('/scrollspy', function(){    return view('dashboard.base.scrollspy'); });

                Route::get('/switches', function(){     return view('dashboard.base.switches'); });
                Route::get('/tables', function () {     return view('dashboard.base.tables'); });
                Route::get('/tabs', function () {       return view('dashboard.base.tabs'); });
                Route::get('/tooltips', function () {   return view('dashboard.base.tooltips'); });
            });
            Route::prefix('buttons')->group(function () {  
                Route::get('/buttons', function(){          return view('dashboard.buttons.buttons'); });
                Route::get('/button-group', function(){     return view('dashboard.buttons.button-group'); });
                Route::get('/dropdowns', function(){        return view('dashboard.buttons.dropdowns'); });
                Route::get('/brand-buttons', function(){    return view('dashboard.buttons.brand-buttons'); });
            });
            Route::prefix('icon')->group(function () {  // word: "icons" - not working as part of adress
                Route::get('/coreui-icons', function(){         return view('dashboard.icons.coreui-icons'); });
                Route::get('/flags', function(){                return view('dashboard.icons.flags'); });
                Route::get('/brands', function(){               return view('dashboard.icons.brands'); });
            });
            Route::prefix('notifications')->group(function () {  
                Route::get('/alerts', function(){   return view('dashboard.notifications.alerts'); });
                Route::get('/badge', function(){    return view('dashboard.notifications.badge'); });
                Route::get('/modals', function(){   return view('dashboard.notifications.modals'); });
            });

            Route::resource('notes', 'NotesController');
            Route::resource('hoteladmins', 'HotelAdminController');
            Route::resource('properties', 'PropertiesController');
            Route::resource('govadmins', 'GovAdminController');
            Route::resource('generalusers', 'GeneralUserController');
            Route::resource('generaluserscomp', 'GeneralUserCompController');
            Route::resource('mostwanted', 'MostWantedController');
            
            
            Route::resource('myprofile', 'MyprofileController');
            Route::resource('rooms', 'RoomController');

            Route::resource('sources', 'SourcesController');
            Route::resource('reservations', 'ReservationsController');
            

            Route::resource('bookingtypes', 'BookingTypesController');
            Route::resource('roomtypes', 'RoomTypesController');

            Route::resource('customers', 'CustomersController');
            Route::resource('groups', 'GroupsController');
            Route::resource('privileges', 'PrivilegesController'); 
            Route::resource('staffs', 'StaffsController');
            Route::resource('idprooftypes', 'IdProofTypesController');

            Route::resource('paymentmethods', 'PaymentMethodController');

            
            Route::resource('complaints', 'ComplaintsController');

            Route::resource('visitorslist', 'VisitorsController');
            Route::resource('taxsettings', 'TaxController');
            Route::resource('commercialtaxsettings', 'CommercialTaxController');

            
            Route::resource('receiptsettings', 'ReceiptSettingsController');
            Route::resource('commercialreceiptsettings', 'CommercialReceiptSettingsController');
            
            

            Route::resource('taxinvoicelist', 'TaxInvoiceListController');
            Route::resource('commercialtaxinvoicelist', 'CommercialTaxInvoiceListController');

            Route::resource('criminalrecords', 'CriminalRecordsController');
            Route::resource('reports', 'ReportsController');
            Route::resource('roomcheckout', 'RoomCheckoutController');
            Route::resource('undocheckout', 'RoomUndoCheckoutController');
            Route::resource('inhouseguests', 'InHouseGuestsController');
            Route::resource('guestregistration',   'ContractController');

            Route::get('admin/messages', [MessageController::class, 'index'])->name('admin.messages.index');

        });
    });
    Auth::routes();

    Route::resource('resource/{table}/resource', 'ResourceController')->names([
        'index'     => 'resource.index',
        'create'    => 'resource.create',
        'store'     => 'resource.store',
        'show'      => 'resource.show',
        'edit'      => 'resource.edit',
        'update'    => 'resource.update',
        'destroy'   => 'resource.destroy',
        'manageprivilage'=>'resource.manageprivilage'
    ]);
   Route::get('/', function () {           return view('auth.login'); });

   //for super admin
    Route::group(['middleware' => ['role:admin']], function () {
        Route::group(['middleware' => ['auth']], function() {
            Route::resource('bread',  'BreadController');   //create BREAD (resource)
            Route::resource('users',        'UsersController')->except( ['create', 'store'] );
            Route::resource('roles',        'RolesController');
            Route::resource('mail',        'MailController');

            //routes for manage hotel admin
            Route::resource('hoteladmins',        'HotelAdminController')->except( ['create', 'store'] );

            //routes for manage properties
            Route::resource('properties',        'PropertiesController')->except( ['create', 'store'] );

            //routes for manage gov admin
            Route::resource('govadmins',        'GovAdminController')->except( ['create', 'store'] );

            //for general search user
            Route::resource('generalusers',        'GeneralUserController')->except( ['create', 'store'] );
            Route::resource('generaluserscomp',    'GeneralUserCompController')->except( ['create', 'store'] );

            
            
            //routes for manage profile
            Route::resource('myprofile',        'MyProfileController')->except( ['create', 'store'] );

            //routes for manage rooms
            Route::resource('rooms', 'RoomController')->except( ['create', 'store'] );
            Route::resource('sources', 'SourcesController')->except( ['create', 'store'] );
            Route::resource('reservations', 'ReservationsController')->except( ['create', 'store'] );
         

            //routes for manage booking types
            Route::resource('bookingtypes', 'BookingTypesController')->except( ['create', 'store'] );

            //routes for manage room types
            Route::resource('roomtypes', 'RoomTypesController')->except( ['create', 'store'] );
          
            //routes for manage customers
            Route::resource('customers', 'CustomersController')->except( ['create', 'store'] );

            //routes for manage groups
            Route::resource('groups', 'GroupsController')->except( ['create', 'store'] );

            //routes for manage privilages
            Route::resource('privileges', 'PrivilegesController')->except( ['create', 'store'] );

            //routes for manage staffs
            Route::resource('staffs', 'StaffsController')->except( ['create', 'store'] );

            //routes for manage id proof types
            Route::resource('idprooftypes', 'IdProofTypesController')->except( ['create', 'store'] );
            Route::resource('complainttypes', 'ComplaintTypesController')->except( ['create', 'store'] );
            Route::resource('paymentmethods', 'PaymentMethodController')->except( ['create', 'store'] );
           
           
            Route::resource('roomcheckout', 'RoomCheckoutController')->except( ['create', 'store'] );
            Route::resource('inhouseguests', 'InHouseGuestsController')->except( ['create', 'store'] );
            Route::resource('undocheckout', 'RoomUndoCheckoutController')->except( ['create', 'store'] );
            Route::resource('undocheckout', 'RoomUndoCheckoutController')->except( ['create', 'store'] );
            Route::resource('guestregistration',   'ContractController')->except( ['create', 'store'] );


            //routes for manage complaint
            Route::resource('complaints', 'ComplaintsController')->except( ['create', 'store'] );

            Route::resource('visitorslist', 'VisitorsController')->except( ['create', 'store'] );

            Route::resource('taxsettings', 'TaxController')->except( ['create', 'store'] );
            
            Route::resource('commercialtaxsettings', 'CommercialTaxController')->except( ['create', 'store'] );
            Route::resource('commercialtaxinvoicelist', 'CommercialTaxInvoiceListController')->except( ['create', 'store'] );
            Route::resource('generatecommercialtaxinvoice', 'GenerateCommercialTaxInvoiceController')->except( ['create', 'store'] );
            
            Route::resource('taxinvoicelist', 'TaxInvoiceListController')->except( ['create', 'store'] );
            Route::resource('generatetaxinvoice', 'GenerateTaxInvoiceController')->except( ['create', 'store'] );
            Route::resource('receiptsettings', 'ReceiptSettingsController')->except( ['create', 'store'] );
            Route::resource('commercialreceiptsettings', 'CommercialReceiptSettingsController')->except( ['create', 'store'] );

            
            //routes for manage criminal records
            Route::resource('criminalrecords', 'CriminalRecordsController')->except( ['create', 'store'] );
      
            Route::get('prepareSend/{id}',        'MailController@prepareSend')->name('prepareSend');
            Route::post('mailSend/{id}',        'MailController@send')->name('mailSend');
            Route::get('/roles/move/move-up',      'RolesController@moveUp')->name('roles.up');
            Route::get('/roles/move/move-down',    'RolesController@moveDown')->name('roles.down');
            Route::prefix('menu/element')->group(function () { 
                Route::get('/',             'MenuElementController@index')->name('menu.index');
                Route::get('/move-up',      'MenuElementController@moveUp')->name('menu.up');
                Route::get('/move-down',    'MenuElementController@moveDown')->name('menu.down');
                Route::get('/create',       'MenuElementController@create')->name('menu.create');
                Route::post('/store',       'MenuElementController@store')->name('menu.store');
                Route::get('/get-parents',  'MenuElementController@getParents');
                Route::get('/edit',         'MenuElementController@edit')->name('menu.edit');
                Route::post('/update',      'MenuElementController@update')->name('menu.update');
                Route::get('/show',         'MenuElementController@show')->name('menu.show');
                Route::get('/delete',       'MenuElementController@delete')->name('menu.delete');
            });
            Route::prefix('menu/menu')->group(function () { 
                Route::get('/',         'MenuController@index')->name('menu.menu.index');
                Route::get('/create',   'MenuController@create')->name('menu.menu.create');
                Route::post('/store',   'MenuController@store')->name('menu.menu.store');
                Route::get('/edit',     'MenuController@edit')->name('menu.menu.edit');
                Route::post('/update',  'MenuController@update')->name('menu.menu.update');
                Route::get('/delete',   'MenuController@delete')->name('menu.menu.delete');
            });
            Route::prefix('media')->group(function () {
                Route::get('/',                 'MediaController@index')->name('media.folder.index');
                Route::get('/folder/store',     'MediaController@folderAdd')->name('media.folder.add');
                Route::post('/folder/update',   'MediaController@folderUpdate')->name('media.folder.update');
                Route::get('/folder',           'MediaController@folder')->name('media.folder');
                Route::post('/folder/move',     'MediaController@folderMove')->name('media.folder.move');
                Route::post('/folder/delete',   'MediaController@folderDelete')->name('media.folder.delete');;

                Route::post('/file/store',      'MediaController@fileAdd')->name('media.file.add');
                Route::get('/file',             'MediaController@file');
                Route::post('/file/delete',     'MediaController@fileDelete')->name('media.file.delete');
                Route::post('/file/update',     'MediaController@fileUpdate')->name('media.file.update');
                Route::post('/file/move',       'MediaController@fileMove')->name('media.file.move');
                Route::post('/file/cropp',      'MediaController@cropp');
                Route::get('/file/copy',        'MediaController@fileCopy')->name('media.file.copy');
            });

            //for  hotel admins
            Route::prefix('/hoteladmins')->group(function () { 
                Route::post('/store',   'HotelAdminController@store')->name('hoteladmins.store');
                Route::get('/edit',     'HotelAdminController@edit')->name('hoteladmins.edit');
                Route::post('/update',  'HotelAdminController@update')->name('hoteladmins.update');
                Route::get('/delete',   'HotelAdminController@delete');
            });

            //for properties
            Route::prefix('/properties')->group(function () { 
                Route::post('/store',   'PropertiesController@store')->name('properties.store');
                Route::get('/edit',     'PropertiesController@edit')->name('properties.edit');
                Route::post('/update',  'PropertiesController@update')->name('properties.update');
                Route::get('/delete',   'PropertiesController@delete');
                Route::post('/exportCustomersByProperty',     'PropertiesController@exportCustomersByProperty')->name('properties.exportCustomersByProperty'); 
            });

            //for gov admin
            Route::prefix('/govadmins')->group(function () { 
                Route::post('/store',   'GovAdminController@store')->name('govadmins.store');
                Route::get('/edit',     'GovAdminController@edit')->name('govadmins.edit');
                Route::post('/update',  'GovAdminController@update')->name('govadmins.update');
                Route::get('/delete',   'GovAdminController@delete');
            });

            //for general search user
            Route::prefix('/generalusers')->group(function () { 
                Route::post('/store',   'GeneralUserController@store')->name('generalusers.store');
                Route::get('/edit',     'GeneralUserController@edit')->name('generalusers.edit');
                Route::post('/update',  'GeneralUserController@update')->name('generalusers.update');
                Route::get('/delete',   'GeneralUserController@delete');
                // Route::post('/storecomplaint',   'ComplaintsController@addComplaintByGenreal')->name('complaints.addComplaintByGenreal');
            
            });

            Route::prefix('/generaluserscomp')->group(function () { 
                Route::post('/store',   'GeneralUserCompController@store')->name('generaluserscomp.store');
            });
            

            //for rooms
            Route::prefix('/rooms')->group(function () { 
                Route::post('/store',   'RoomController@store')->name('rooms.store');
                Route::get('/edit',     'RoomController@edit')->name('rooms.edit');
                Route::post('/update',  'RoomController@update')->name('rooms.update');
                Route::get('/delete',   'RoomController@delete');
            });

            Route::prefix('/sources')->group(function () { 
                Route::post('/store',   'SourcesController@store')->name('sources.store');
                Route::get('/edit',     'SourcesController@edit')->name('sources.edit');
                Route::post('/update',  'SourcesController@update')->name('sources.update');
                Route::get('/delete',   'SourcesController@delete');
            });

            Route::prefix('/reservations')->group(function () { 
                Route::post('/store',   'ReservationsController@store')->name('reservations.store');
                Route::get('/edit',     'ReservationsController@edit')->name('reservations.edit');
                Route::post('/update',  'ReservationsController@update')->name('reservations.update');
                Route::get('/delete',   'ReservationsController@delete');
            });

            //for Customers
            Route::prefix('/customers')->group(function () { 
                Route::post('/store',   'CustomersController@store')->name('customers.store');
                Route::get('/edit',     'CustomersController@edit')->name('customers.edit');
                Route::post('/update',  'CustomersController@update')->name('customers.update');
                Route::get('/delete',   'CustomersController@delete');
                Route::get('/loadCustomerDocs',     'CustomersController@loadCustomerDocs')->name('customers.loadCustomerDocs');
                Route::get('/addcomplaints','ComplaintsController@addcomplaints')->name('complaints.addcomplaint');
                Route::post('/export',     'CustomersController@export')->name('customers.export');
                Route::get('/contract',     'CustomersController@contract')->name('customers.contract');
            
                Route::post('/guestCheckoutAndSave',     'CustomersController@guestCheckoutAndSave')->name('customers.guestCheckoutAndSave');
            });

            //for groups
            Route::prefix('/groups')->group(function () { 
                Route::post('/store',   'GroupsController@store')->name('groups.store');
                Route::get('/edit',     'GroupsController@edit')->name('groups.edit');
                Route::post('/update',  'GroupsController@update')->name('groups.update');
                Route::get('/delete',   'GroupsController@delete');
                Route::get('/manageprivilage',     'GroupsController@manageprivilage')->name('groups.manageprivilage');
            });

            //for privilages
            Route::prefix('/privileges')->group(function () { 
                Route::get('/edit','PrivilegesController@edit')->name('privileges.edit');
            }); 

            //for staff management in hotel admin
            Route::prefix('/staffs')->group(function () { 
                Route::post('/store',   'StaffsController@store')->name('staffs.store');
                Route::get('/edit',     'StaffsController@edit')->name('staffs.edit');
                Route::post('/update',  'StaffsController@update')->name('staffs.update');
                Route::get('/delete',   'StaffsController@delete');
            });

            //for staff management in hotel admin
            Route::prefix('/idprooftypes')->group(function () { 
                Route::post('/store',   'IdProofTypesController@store')->name('idprooftypes.store');
                Route::get('/edit',     'IdProofTypesController@edit')->name('idprooftypes.edit');
                Route::post('/update',  'IdProofTypesController@update')->name('idprooftypes.update');
                Route::get('/delete',   'IdProofTypesController@delete');
            }); 

            Route::prefix('/paymentmethods')->group(function () { 
                Route::post('/store',   'PaymentMethodController@store')->name('paymentmethods.store');
                Route::get('/edit',     'PaymentMethodController@edit')->name('paymentmethods.edit');
                Route::post('/update',  'PaymentMethodController@update')->name('paymentmethods.update');
                Route::get('/delete',   'PaymentMethodController@delete');
            });

            Route::prefix('/complainttypes')->group(function () { 
                Route::post('/store',   'ComplaintTypesController@store')->name('complainttypes.store');
                Route::get('/edit',     'ComplaintTypesController@edit')->name('complainttypes.edit');
                Route::post('/update',  'ComplaintTypesController@update')->name('complainttypes.update');
                Route::get('/delete',   'ComplaintTypesController@delete');
                Route::get('/create',   'ComplaintTypesController@create')->name('complainttypes.create');
            }); 

            //for blacklist
            Route::prefix('/blacklists')->group(function () { 
                Route::post('/store',   'BlackListsController@store')->name('blacklists.store');
                Route::get('/edit',     'BlackListsController@edit')->name('blacklists.edit');
                Route::post('/update',  'BlackListsController@update')->name('blacklists.update');
                Route::get('/delete',   'BlackListsController@delete');
                Route::get('/create',   'BlackListsController@create')->name('blacklists.create');
            }); 
            
            
            //routes for manage staffs
            Route::resource('myprofilesettings', 'SettingsController')->except( ['create', 'store'] );
        
            //for manage profile
            Route::prefix('/myprofilesettings')->group(function () { 
                Route::post('/',   'SettingsController@@index');
                Route::post('/changePassword',   'SettingsController@changePassword');
            });

            Route::prefix('/pbxsetting')->group(function () {
                Route::get('/', 'SettingsController@pbxSettinglist')->name('pbxsetting.pbxSettinglist');
                Route::post('/submitpbxsettings', 'SettingsController@submitPbxSettings')->name('pbxsetting.submitpbxsettings');
            });

            //for manage profile
            Route::prefix('/guestRegistration')->group(function () { 
                Route::get('/',   'ContractController@@index');
                Route::get('/contract',     'ContractController@contract')->name('guestregistration.contract');;

                // Route::post('/guestregistration',   'ContractController@guestregistration');
            });

            //for complaints
            Route::prefix('/complaints')->group(function () { 
                Route::get('/','ComplaintsController@index');
                Route::get('/edit',     'ComplaintsController@edit')->name('complaints.edit');
                Route::post('/update',  'ComplaintsController@update')->name('complaints.update');
                Route::get('/addcomplaints','ComplaintsController@addcomplaints')->name('complaints.addcomplaints');
               
                // Route::get('/view','ComplaintsController@addcomplaints')->name('complaints.addcomplaints');
            });

            
            //for visitors list
            Route::prefix('/visitorslist')->group(function () { 
                Route::post('/store',   'VisitorsController@store')->name('visitorslist.store');
                Route::get('/edit',     'VisitorsController@edit')->name('visitorslist.edit');
                Route::post('/update',  'VisitorsController@update')->name('visitorslist.update');
                Route::get('/delete',   'VisitorsController@delete');
            });

            //for tax settings
            Route::prefix('/taxsettings')->group(function () { 
                Route::post('/store',   'TaxController@store')->name('taxsettings.store');
                Route::post('/customer_tax_invoice',   'TaxController@customer_tax_invoice')->name('taxsettings.customer_tax_invoice');
                Route::get('/edit',     'TaxController@edit')->name('taxsettings.edit');
                Route::post('/update',  'TaxController@update')->name('taxsettings.update');
                Route::post('/generateTaxInvoice',  'TaxController@generateTaxInvoice')->name('taxsettings.generateTaxInvoice');
                Route::post('/tax_invoice_list',     'TaxController@tax_invoice_list')->name('taxsettings.tax_invoice_list');
                Route::get('/delete',   'TaxController@delete');
                Route::post('/generateInvoiceReceipt',  'TaxController@generateInvoiceReceipt')->name('taxsettings.generateInvoiceReceipt');

                
            });

             //for tax settings
             Route::prefix('/commercialtaxsettings')->group(function () { 
                Route::post('/store',   'CommercialTaxController@store')->name('commercialtaxsettings.store');
                Route::post('/customer_commercial_tax_invoice',   'CommercialTaxController@customer_commercial_tax_invoice')->name('commercialtaxsettings.customer_commercial_tax_invoice');
                Route::get('/edit',     'CommercialTaxController@edit')->name('commercialtaxsettings.edit');
                Route::post('/update',  'CommercialTaxController@update')->name('commercialtaxsettings.update');
                Route::post('/generateCommercialTaxInvoice',  'CommercialTaxController@generateTaxInvoice')->name('commercialtaxsettings.generateTaxInvoice');
                Route::post('/commercial_tax_invoice_list',     'CommercialTaxController@tax_invoice_list')->name('commercialtaxsettings.tax_invoice_list');
                Route::get('/delete',   'CommercialTaxController@delete');
                Route::post('/generateCommercialInvoiceReceipt',  'CommercialTaxController@generateInvoiceReceipt')->name('commercialtaxsettings.generateInvoiceReceipt');
            });

            Route::prefix('/receiptsettings')->group(function () { 
                Route::post('/store',   'ReceiptSettingsController@store')->name('receiptsettings.store');
                Route::get('/edit',     'ReceiptSettingsController@edit')->name('receiptsettings.edit');
                Route::post('/update',  'ReceiptSettingsController@update')->name('receiptsettings.update');
                Route::get('/delete',   'ReceiptSettingsController@delete');
                Route::post('/tax_invoice_receipt',   'ReceiptSettingsController@tax_invoice_receipt')->name('receiptsettings.tax_invoice_receipt');
                
                Route::get('/collectionreport',  'ReportsController@collectionreport')->name('reports.collectionreport');
                Route::get('/collectionsummaryreport',  'ReportsController@collectionsummaryreport')->name('reports.collectionsummaryreport');
                Route::get('/getCollectionReports',  'ReceiptSettingsController@getCollectionReports')->name('receiptsettings.getCollectionReports');
                Route::get('/getCollectionSummaryReports',  'ReceiptSettingsController@getCollectionSummaryReports')->name('receiptsettings.getCollectionSummaryReports');
            });
            
            Route::prefix('/commercialreceiptsettings')->group(function () { 
                Route::post('/store',   'CommercialReceiptSettingsController@store')->name('commercialreceiptsettings.store');
                Route::get('/edit',     'CommercialReceiptSettingsController@edit')->name('commercialreceiptsettings.edit');
                Route::post('/update',  'CommercialReceiptSettingsController@update')->name('commercialreceiptsettings.update');
                Route::get('/delete',   'CommercialReceiptSettingsController@delete');
                Route::post('/commercial_invoice_receipt',   'CommercialReceiptSettingsController@commercial_invoice_receipt')->name('commercialreceiptsettings.commercial_invoice_receipt');
                Route::get('/commercialcollectionreport',  'ReportsController@collectionreport')->name('reports.collectionreport');
                Route::get('/commercialcollectionsummaryreport',  'ReportsController@collectionsummaryreport')->name('reports.collectionsummaryreport');
                Route::get('/getCommercialCollectionReports',  'CommercialReceiptSettingsController@getCommercialCollectionReports')->name('commercialreceiptsettings.getCommercialCollectionReports');
                Route::get('/getCommercialCollectionSummaryReports',  'CommercialReceiptSettingsController@getCommercialCollectionSummaryReports')->name('commercialreceiptsettings.getCommercialCollectionSummaryReports');
                
            });
             //for tax settings
            
             Route::prefix('/taxinvoicelist')->group(function () { 
                Route::post('/taxreports',   'TaxInvoiceListController@tax_invoice_list')->name('taxinvoicelist.tax_invoice_list');
                Route::post('/getInvoiceListByProperty',   'TaxInvoiceListController@getInvoiceListByProperty')->name('taxinvoicelist.getInvoiceListByProperty');
                Route::get('/downloadInvoicePdf',   'TaxInvoiceListController@downloadInvoicePdf')->name('taxinvoicelist.downloadInvoicePdf');
                Route::get('/editInvoice',   'TaxInvoiceListController@editInvoice')->name('taxinvoicelist.editInvoice');
                Route::post('/downloadInvoiceReport',   'TaxInvoiceListController@downloadInvoiceReport')->name('taxinvoicelist.downloadInvoiceReport');
                Route::post('/downloadCollectionReport',   'TaxInvoiceListController@downloadCollectionReport')->name('taxinvoicelist.downloadCollectionReport');
                Route::post('/downloadCollectionSummaryReport',   'TaxInvoiceListController@downloadCollectionSummaryReport')->name('taxinvoicelist.downloadCollectionSummaryReport');
                Route::get('/receiptInvoice',   'TaxInvoiceListController@receiptInvoice')->name('taxinvoicelist.receiptInvoice');
            });
            

            Route::prefix('/commercialtaxinvoicelist')->group(function () { 
                Route::post('/commercial_tax_invoice_list',   'CommercialTaxInvoiceListController@commercial_tax_invoice_list')->name('commercialtaxinvoicelist.commercial_tax_invoice_list');
                Route::post('/getCommercialInvoiceListByProperty',   'CommercialTaxInvoiceListController@getCommercialInvoiceListByProperty')->name('commercialtaxinvoicelist.getCommercialInvoiceListByProperty');
                Route::get('/downloadCommercialInvoicePdf',   'CommercialTaxInvoiceListController@downloadCommercialInvoicePdf')->name('commercialtaxinvoicelist.downloadCommercialInvoicePdf');
                Route::get('/editcommercialInvoice',   'CommercialTaxInvoiceListController@editCommercialInvoice')->name('commercialtaxinvoicelist.editcommercialInvoice');
                Route::post('/downloadCommercialInvoiceReport',   'CommercialTaxInvoiceListController@downloadCommercialInvoiceReport')->name('commercialtaxinvoicelist.downloadCommercialInvoiceReport');
                Route::get('/commercialreceiptInvoice',   'CommercialTaxInvoiceListController@commercialreceiptInvoice')->name('commercialtaxinvoicelist.commercialreceiptInvoice');
                Route::post('/downloadCommercialCollectionReport',   'CommercialTaxInvoiceListController@downloadCommercialCollectionReport')->name('commercialtaxinvoicelist.downloadCommercialCollectionReport');
                Route::post('/downloadCommercialCollectionSummaryReport',   'CommercialTaxInvoiceListController@downloadCommercialCollectionSummaryReport')->name('commercialtaxinvoicelist.downloadCommercialCollectionSummaryReport');
              
            });
            
            //for tax settings
            Route::prefix('/generatetaxinvoice')->group(function () { 
                Route::post('/generate',   'GenerateTaxInvoiceController@generate')->name('generatetaxinvoice.generate');
                Route::post('/generate_tax_invoice',   'GenerateTaxInvoiceController@generate_tax_invoice')->name('generatetaxinvoice.generate_tax_invoice');
                Route::post('/getCustomersListByProperty',   'GenerateTaxInvoiceController@getCustomersListByProperty')->name('generatetaxinvoice.getCustomersListByProperty');
            });

            //for tax settings
            Route::prefix('/generatecommercialtaxinvoice')->group(function () { 
                Route::post('/generateCommercial',   'GenerateCommercialTaxInvoiceController@generateCommercial')->name('generatecommercialtaxinvoice.generateCommercial');
                Route::post('/generate_commercial_tax_invoice',   'GenerateCommercialTaxInvoiceController@generate_commercial_tax_invoice')->name('generatecommercialtaxinvoice.generate_commercial_tax_invoice');
                Route::post('/getCustomersListByProperty',   'GenerateCommercialTaxInvoiceController@getCustomersListByProperty')->name('generatecommercialtaxinvoice.getCustomersListByProperty');
            });
            //for  criminal records
            Route::prefix('/criminalrecords')->group(function () { 
                Route::post('/store',   'CriminalRecordsController@store')->name('criminalrecords.store');
                Route::get('/edit',     'CriminalRecordsController@edit')->name('criminalrecords.edit');
                Route::post('/update',  'CriminalRecordsController@update')->name('criminalrecords.update');
                Route::get('/delete',   'CriminalRecordsController@delete');
            });

            Route::get('admin/messages', [MessageController::class, 'index'])->name('admin.messages.index');

            Route::middleware(['auth'])->group(function () {
                Route::get('/chat/customers/{property_id}', [ChatController::class, 'getCustomersByProperty']);
                Route::post('/chat/messages', [ChatController::class, 'getMessages'])->name('chat.messages');
                Route::get('admin/messages', [MessageController::class, 'index'])->name('admin.messages.index');
                Route::get('/chat/getunreadcnt', [ChatController::class, 'getunreadcnt']);
                Route::get('/chat/updateReadStatus', [ChatController::class, 'updateReadStatus']);

                Route::get('/admin/notifications', [NotificationsController::class, 'index'])->name('admin.notifications.index');
                Route::get('/notifications/rooms/{property_id}', [NotificationsController::class, 'getRoomsByPropertyId']);
                Route::post('/rooms/notifications', [NotificationsController::class, 'getNotificationsByRoom']);
   
            });
        });
    });

    //for only hotel admin
    Route::group(['middleware' => ['role:user']], function () {
        Route::group(['middleware' => ['auth']], function() {
            //routes for manage profile
            Route::resource('myprofile', 'MyProfileController');

            //routes for manage properties
            Route::resource('properties', 'PropertiesController')->except( ['create', 'store'] );

            //routes for manage rooms
            Route::resource('rooms', 'RoomController')->except( ['create', 'store'] );
            Route::resource('reports', 'ReportsController')->except( ['create', 'store'] );

            Route::resource('sources', 'SourcesController')->except( ['create', 'store'] );
            Route::resource('reservations', 'ReservationsController')->except( ['create', 'store'] );


            Route::resource('bookingtypes', 'BookingTypesController')->except( ['create', 'store'] );
            Route::resource('roomtypes', 'RoomTypesController')->except( ['create', 'store'] );

             
            //routes for manage customers
            Route::resource('customers', 'CustomersController')->except( ['create', 'store'] );

            //routes for manage groups
            Route::resource('groups', 'GroupsController')->except( ['create', 'store'] );

            //routes for manage privilages
            Route::resource('privileges', 'PrivilegesController')->except( ['create', 'store'] );

            //routes for manage staffs
            Route::resource('staffs', 'StaffsController')->except( ['create', 'store'] );

            //routes for manage id proof types
            Route::resource('idprooftypes', 'IdProofTypesController')->except( ['create', 'store'] );
            Route::resource('paymentmethods', 'PaymentMethodController')->except( ['create', 'store'] );



            Route::resource('roomcheckout', 'RoomCheckoutController')->except( ['create', 'store'] );
            Route::resource('inhouseguests', 'InHouseGuestsController')->except( ['create', 'store'] );
            Route::resource('undocheckout', 'RoomUndoCheckoutController')->except( ['create', 'store'] );
            Route::resource('guestregistration',   'ContractController')->except( ['create', 'store'] );
            Route::resource('pbxextensions',   'PbxExtensionsController')->except( ['store'] );

            Route::resource('/todayscheckouts','todaysCheckoutsController')->except( ['create', 'store'] );

            //routes for manage staffs
            Route::resource('myprofilesettings', 'SettingsController')->except( ['create', 'store'] );
            
            //routes for manage staffs
            Route::resource('changePassword', 'SettingsController')->except( ['create', 'store'] );
            
            //routes for manage complaint
            Route::resource('complaints', 'ComplaintsController')->except( ['create', 'store'] );

            Route::resource('visitorslist', 'VisitorsController')->except( ['create', 'store'] );
            Route::resource('taxsettings', 'TaxController')->except( ['create', 'store'] );
            Route::resource('taxinvoicelist', 'TaxInvoiceListController')->except( ['create', 'store'] );
            Route::resource('generatetaxinvoice', 'GenerateTaxInvoiceController')->except( ['create', 'store'] );
            Route::resource('generatecommercialtaxinvoice', 'GenerateCommercialTaxInvoiceController')->except( ['create', 'store'] );

                
            Route::resource('receiptsettings', 'ReceiptSettingsController')->except( ['create', 'store'] );
            Route::resource('commercialreceiptsettings', 'CommercialReceiptSettingsController')->except( ['create', 'store'] );
            
            //routes for manage criminal records
            Route::resource('crminalrecords', 'CriminalRecordsController')->except( ['create', 'store'] );

            Route::resource('complainttypes', 'ComplaintTypesController')->except( ['create', 'store'] );

            Route::resource('blacklists', 'BlackListsController')->except( ['create', 'store'] );

            Route::resource('quicksearch', 'QuickSearchController')->except( ['create', 'store'] );
            Route::resource('generaluserscomp',    'GeneralUserCompController')->except( ['create', 'store'] );
            Route::resource('mostwanted', 'MostWantedController')->except( ['create', 'store'] );
            Route::resource('guestRegistration',   'ContractController')->except( ['create', 'store'] );
            Route::resource('pbxextensions',   'PbxExtensionsController')->except( ['store'] );

            

            //for manage profile
            Route::prefix('/myprofilesettings')->group(function () { 
                Route::post('/',   'SettingsController@@index');
                Route::get('/update', 'SettingsController@update')->name('myprofilesettings.update');
            });

              //for pbx settings
            // Route::resource('pbxSetting', 'SettingsController')->except( ['create', 'store'] );
            Route::prefix('/pbxsetting')->group(function () {
                Route::get('/', 'SettingsController@pbxSettinglist')->name('pbxsetting.pbxSettinglist');
                Route::post('/submitpbxsettings', 'SettingsController@submitPbxSettings')->name('pbxsetting.submitpbxsettings');
            });

            //for manage profile
            Route::prefix('/changePassword')->group(function () { 
                Route::post('/changePassword',   'SettingsController@changePassword');
            });

            Route::prefix('/myprofile')->group(function () { 
                Route::post('/',   'GovAdminController@index');
                Route::post('/store',   'MyProfileController@store')->name('myprofile.store');
                Route::get('/edit',   'MyProfileController@edit')->name('myprofile.edit');
                Route::post('/update',  'MyProfileController@update')->name('myprofile.update');
                // Route::post('/changePassword',  'MyProfileController@changePassword')->name('myprofile.update');
            });

            //for properties
            Route::prefix('/properties')->group(function () { 
                Route::post('/store',   'PropertiesController@store')->name('properties.store');
                Route::get('/edit',     'PropertiesController@edit')->name('properties.edit');
                Route::post('/update',  'PropertiesController@update')->name('properties.update');
                Route::get('/delete',   'PropertiesController@delete');
                Route::post('/exportCustomersByProperty',     'PropertiesController@exportCustomersByProperty')->name('properties.exportCustomersByProperty');
            });

            Route::prefix('/generaluserscomp')->group(function () { 
                Route::post('/store',   'GeneralUserCompController@store')->name('generaluserscomp.store');
            });

            //for rooms
            Route::prefix('/rooms')->group(function () { 
                Route::post('/store',   'RoomController@store')->name('rooms.store');
                Route::get('/edit',     'RoomController@edit')->name('rooms.edit');
                Route::post('/update',  'RoomController@update')->name('rooms.update');
                Route::get('/delete',   'RoomController@delete');
            });

            //for sources
            Route::prefix('/sources')->group(function () {
                Route::post('/store',   'SourcesController@store')->name('sources.store');
                Route::get('/edit',     'SourcesController@edit')->name('sources.edit');
                Route::post('/update',  'SourcesController@update')->name('sources.update');
                Route::get('/delete',   'SourcesController@delete');
            });

            Route::prefix('/reservations')->group(function () { 
                Route::post('/store',   'ReservationsController@store')->name('reservations.store');
                Route::get('/edit',     'ReservationsController@edit')->name('reservations.edit');
                Route::post('/update',  'ReservationsController@update')->name('reservations.update');
                Route::get('/delete',   'ReservationsController@delete');
            });
            //for booking type
            Route::prefix('/bookingtypes')->group(function () { 
                Route::post('/store',   'BookingTypesController@store')->name('bookingtypes.store');
                Route::get('/edit',     'BookingTypesController@edit')->name('bookingtypes.edit');
                Route::post('/update',  'BookingTypesController@update')->name('bookingtypes.update');
                Route::get('/delete',   'BookingTypesController@delete');
            }); 

            //for room type
            Route::prefix('/roomtypes')->group(function () { 
                Route::post('/store',   'RoomTypesController@store')->name('roomtypes.store');
                Route::get('/edit',     'RoomTypesController@edit')->name('roomtypes.edit');
                Route::post('/update',  'RoomTypesController@update')->name('roomtypes.update');
                Route::get('/delete',   'RoomTypesController@delete');
            }); 
            
            //for rooms
            Route::get('/checkinreport',   'ReportsController@checkinreport')->name('reports.checkinreport');
            Route::get('/inhouseguestreport',     'ReportsController@inhouseguestreport')->name('reports.inhouseguestreport');
            Route::get('/checkoutguestsreport',  'ReportsController@checkoutguestsreport')->name('reports.checkoutguestsreport');
      
            Route::get('/collectionreport',  'ReportsController@collectionreport')->name('reports.collectionreport');
            Route::get('/collectionsummaryreport',  'ReportsController@collectionsummaryreport')->name('reports.collectionsummaryreport');

            Route::get('/commercialcollectionreport',  'ReportsController@commercialcollectionreport')->name('reports.commercialcollectionreport');
            Route::get('/commercialcollectionsummaryreport',  'ReportsController@commercialcollectionsummaryreport')->name('reports.commercialcollectionsummaryreport');

            

            
            //for Customers
            Route::prefix('/customers')->group(function () { 
                Route::post('/store',   'CustomersController@store')->name('customers.store');
                Route::get('/edit',     'CustomersController@edit')->name('customers.edit');
                Route::post('/update',  'CustomersController@update')->name('customers.update');
                Route::get('/delete',   'CustomersController@delete');
                Route::get('/remove_doc',   'CustomersController@remove_doc')->name('customers.remove_doc');
                Route::post('/saveBasicInfo',     'CustomersController@saveBasicInfo')->name('customers.saveBasicInfo');
                Route::post('/saveGuestInfo',     'CustomersController@saveGuestInfo')->name('customers.saveGuestInfo');
                Route::post('/saveDocumentInfo',     'CustomersController@saveDocumentInfo')->name('customers.saveDocumentInfo');
                Route::post('/getCustomerDocs',     'CustomersController@getCustomerDocs')->name('customers.getCustomerDocs');
                Route::get('/loadCustomerDocs',     'CustomersController@loadCustomerDocs')->name('customers.loadCustomerDocs');
                Route::get('/export',     'CustomersController@export')->name('customers.export');
                Route::get('/getDocs',     'CustomersController@getDocs')->name('customers.getDocs');
                Route::get('/viewdetails',     'CustomersController@viewdetails')->name('customers.viewdetails');
                Route::get('/getComplaints',     'CustomersController@getComplaints')->name('customers.getComplaints');
                Route::get('/getCriminalRecord',     'CustomersController@getCriminalRecord')->name('customers.getCriminalRecord');
                Route::post('/update_basic_info',     'CustomersController@update_basic_info')->name('customers.update_basic_info');
                Route::post('/updatte_profile_image',     'CustomersController@updatte_profile_image')->name('customers.updatte_profile_image');
                Route::post('/saave_docs_by_dropzone',     'CustomersController@saave_docs_by_dropzone')->name('customers.saave_docs_by_dropzone');
                
                Route::get('/getBlacklistRecord',     'CustomersController@getBlacklistRecord')->name('customers.getBlacklistRecord');

                
                Route::post('/getQuickSearchResults',     'CustomersController@getQuickSearchResults')->name('customers.getQuickSearchResults');
                Route::post('/saveAdditionalInfo',     'CustomersController@saveAdditionalInfo')->name('customers.saveAdditionalInfo');
                Route::post('/saveNotesInfo',     'CustomersController@saveNotesInfo')->name('customers.saveNotesInfo');
                Route::get('/getNotes',     'CustomersController@getNotes')->name('customers.getNotes');
                Route::get('/get_recent_cust',     'CustomersController@get_recent_cust')->name('customers.get_recent_cust');

                // Route::post('/saveNotesInfo',     'CustomersController@saveNotesInfo ')->name('customers.saveNotesInfo');
                Route::post('/getRoomsByProperty',     'CustomersController@getRoomsByProperty')->name('customers.getRoomsByProperty');
                
                Route::post('/getAllDashboardInfo',     'CustomersController@getAllDashboardInfo')->name('customers.getAllDashboardInfo');
                
                Route::post('/getInhouseGuestsByProperty',     'CustomersController@getInhouseGuestsByProperty')->name('customers.getInhouseGuestsByProperty');
                Route::post('/saveSubGuestInfo',     'CustomersController@saveSubGuestInfo')->name('customers.saveSubGuestInfo');
                Route::get('/getBlacklistRecordSameAdmin',     'CustomersController@getBlacklistRecordSameAdmin')->name('customers.getBlacklistRecordSameAdmin');
                Route::get('/getRecordsFromOtherAdminAlso',     'CustomersController@getRecordsFromOtherAdminAlso')->name('customers.getRecordsFromOtherAdminAlso');
                
                 Route::post('/getFoliosByRoom',     'CustomersController@getFoliosByRoom')->name('customers.getFoliosByRoom');
                Route::post('/roomAllCheckout',     'CustomersController@roomAllCheckout')->name('customers.roomAllCheckout');
                Route::post('/getInHouseGuests',     'CustomersController@getInHouseGuests')->name('customers.getInHouseGuests');
                
                Route::post('/getTodaysCheckouts',     'CustomersController@getTodaysCheckouts')->name('customers.getTodaysCheckouts');
                
                Route::get('/addNote',     'CustomersController@addNote')->name('customers.addNote');
                Route::post('/getCheckedoutFoliosByRoom',     'CustomersController@getCheckedoutFoliosByRoom')->name('customers.getCheckedoutFoliosByRoom');
                Route::post('/roomAllUndoCheckout',     'CustomersController@roomAllUndoCheckout')->name('customers.roomAllUndoCheckout');
                Route::post('/roomAllUndoCheckout',     'CustomersController@roomAllUndoCheckout')->name('customers.roomAllUndoCheckout');
                 
                Route::get('/contract',     'CustomersController@contract')->name('customers.contract');
                Route::post('/saveContractaspdf',     'CustomersController@saveContractaspdf')->name('customers.saveContractaspdf');
                Route::get('/finalsubmit',     'CustomersController@finalsubmit')->name('customers.finalsubmit');
                
                
            });

            //for groups
            Route::prefix('/groups')->group(function () { 
                Route::post('/store',   'GroupsController@store')->name('groups.store');
                Route::get('/edit',     'GroupsController@edit')->name('groups.edit');
                Route::post('/update',  'GroupsController@update')->name('groups.update');
                Route::get('/delete',   'GroupsController@delete');
                // Route::get('/editprivilages','GroupsController@manageprivilage')->name('groups.manageprivilage');
            });

            //for privilages
            Route::prefix('/privileges')->group(function () { 
                Route::get('/edit','PrivilegesController@edit')->name('privileges.edit');
                Route::post('/update',  'PrivilegesController@update')->name('privileges.update');
            }); 

            //for staff management in hotel admin
            Route::prefix('/staffs')->group(function () { 
                Route::post('/store',   'StaffsController@store')->name('staffs.store');
                Route::get('/edit',     'StaffsController@edit')->name('staffs.edit');
                Route::post('/update',  'StaffsController@update')->name('staffs.update');
                Route::get('/delete',   'StaffsController@delete');
            }); 

           //for complaint types
            Route::prefix('/idprooftypes')->group(function () { 
                Route::post('/store',   'IdProofTypesController@store')->name('idprooftypes.store');
                Route::get('/edit',     'IdProofTypesController@edit')->name('idprooftypes.edit');
                Route::post('/update',  'IdProofTypesController@update')->name('idprooftypes.update');
                Route::get('/delete',   'IdProofTypesController@delete');
            }); 

            Route::prefix('/paymentmethods')->group(function () { 
                Route::post('/store',   'PaymentMethodController@store')->name('paymentmethods.store');
                Route::get('/edit',     'PaymentMethodController@edit')->name('paymentmethods.edit');
                Route::post('/update',  'PaymentMethodController@update')->name('paymentmethods.update');
                Route::get('/delete',   'PaymentMethodController@delete');
            });
            //for blacklist
            Route::prefix('/blacklists')->group(function () { 
                Route::post('/store',   'BlackListsController@store')->name('blacklists.store');
                Route::get('/edit',     'BlackListsController@edit')->name('blacklists.edit');
                Route::post('/update',  'BlackListsController@update')->name('blacklists.update');
                Route::get('/delete',   'BlackListsController@delete');
                Route::get('/create',   'BlackListsController@create')->name('blacklists.create');
            }); 
            

            Route::prefix('/guestregistration')->group(function () { 
                Route::post('/',   'ContractController@index');  
                Route::post('/store',   'ContractController@store')->name('guestregistration.store');
                Route::get('/edit',     'ContractController@edit')->name('guestregistration.edit');
                Route::get('/contract',     'ContractController@contract')->name('guestregistration.contract');
            
            });

             Route::prefix('/pbxextensions')->group(function () { 
                Route::post('/store',   'PbxExtensionsController@store')->name('pbxextensions.store');
                Route::get('/edit',     'PbxExtensionsController@edit')->name('pbxextensions.edit');
                Route::post('/update',  'PbxExtensionsController@update')->name('pbxextensions.update');
                Route::get('/delete',   'PbxExtensionsController@delete');
            });

            //for complaints
            Route::prefix('/complaints')->group(function () { 
                Route::post('/store','ComplaintsController@store')->name('complaints.store');
            });
            
            Route::prefix('/complainttypes')->group(function () { 
                Route::post('/store',   'ComplaintTypesController@store')->name('complainttypes.store');
                Route::get('/edit',     'ComplaintTypesController@edit')->name('complainttypes.edit');
                Route::post('/update',  'ComplaintTypesController@update')->name('complainttypes.update');
                Route::get('/delete',   'ComplaintTypesController@delete');
            }); 

            //for  criminal records
            Route::prefix('/criminalrecords')->group(function () { 
                Route::post('/store',   'CriminalRecordsController@store')->name('criminalrecords.store');
                Route::get('/edit',     'CriminalRecordsController@edit')->name('criminalrecords.edit');
                Route::post('/update',  'CriminalRecordsController@update')->name('criminalrecords.update');
                Route::get('/delete',   'CriminalRecordsController@delete');
            });

            Route::prefix('/mostwanted')->group(function () { 

            });
            
            
        });
    });
});