<?php

use Illuminate\Http\Request;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\NotificationsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

//hotel admin and its staff login
Route::post('login', 'ApiController@hotelAdminLogin');

//for customer managememnt
// Route::get('customers/{group_id}', 'ApiController@getCustomers');
Route::get('guestlist', 'ApiController@getCustomers');

Route::get('getcustomersdetails', 'ApiController@getCustomersDetails');
Route::post('customers', 'ApiController@addCustomer');
Route::post('updatecustomer', 'ApiController@updateCustomer');

//get room details
Route::get('getRooms', 'ApiController@getRooms');

//get all document types details
Route::get('getdoctypes', 'ApiController@getDocTypes');

//for property management
// Route::get('properties', 'ApiController@getAllProperties');
Route::get('getallproperties', 'ApiController@getAllProperties');
Route::get('properties/{id}', 'ApiController@getProperty');

//for customer document managemet
Route::post('documents', 'ApiController@addCustomerDocument');
// Route::delete('documents/{id}', 'ApiController@removeCustomerDocument');
Route::post('removedocument', 'ApiController@removeCustomerDocument');

//get countries
Route::get('getcountries', 'ApiController@getCountries');

//manage user profile
Route::post('myprofile', 'ApiController@manageProfile');

//change password
Route::post('changepassword', 'ApiController@changePassword');

//get all assigned properties to staff
Route::get('assignedproperties/{id}', 'ApiController@getAssignedProperties');

//get all data 
Route::get('getguestinfo', 'ApiController@getCustomerData');

//get info of account
Route::get('getaccountinfo', 'ApiController@getAccountInfo');

//get guest code
Route::get('getguestcode', 'ApiController@getguestcode');

//add notes
Route::post('addnote', 'ApiController@addNote');

//store digital sign on contract
Route::post('submitDigitalSign', 'ApiController@submitDigitalSign');
Route::get('getRoomCallInfo', 'ApiController@getRoomCallInfo');
Route::get('/chat/history', [ChatController::class, 'history']);
Route::post('/chat/send', [ChatController::class, 'send']);
Route::post('/notification/send', [NotificationsController::class, 'send']);
Route::get('/notifications/history', [NotificationsController::class, 'notificationHistory']);
Route::get('/rooms/notifications', [NotificationsController::class, 'notificationHistory']);
Route::post('roomLogin', 'ApiController@roomLogin');
Route::post('checkAllExtValidToken', 'PbxExtensionsController@checkAllExtValidToken');

Route::post('roomLogout', 'ApiController@roomLogout');
