
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Visitor</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif      

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif      
           
                        <form method="POST" action="{{ route('visitorslist.store') }}"  enctype="multipart/form-data">
                            @csrf
                            <input name="marker" value="selectModel" type="hidden">
                               <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Name</label>
                                        <input type="text" placeholder="Enter Name" name="name" class="form-control" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Title</label>
                                        <input type="text" placeholder="Enter Title" name="title" class="form-control" >
                                     </div>
                                   </div>
                                </div>
                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Select Property</label>
                                      <select class="form-control" name="property_id" id="property_id">
                                        <option value="0">Please select</option>
                                          @foreach($properties as $property)
                                              <option value="{{ $property->id }}">{{ $property->name }}</option>
                                          @endforeach
                                      </select>
                                    </div>
                                  </div>
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Company</label>
                                        <input type="text" placeholder="Enter Company" name="company" class="form-control" >
                                     </div>
                                   </div>
                                </div>

                                <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Telephone</label>
                                        <input type="number" placeholder="Enter Telephone" name="telephone" class="form-control" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Visiting Whoom</label>
                                        <input type="text" placeholder="Enter Visiting Whoom" name="visiting_whoom" class="form-control" >
                                     </div>
                                   </div>
                                </div>

                                
                                <div class="row">
                                  <div class="col-md-3">
                                      <div class="form-group">
                                          <label>Visit In Date</label>
                                          <input type="date" placeholder="Enter Visit In Date" id="visit_in_date" value="<?php echo $curr_date;?>" name="visit_in_date" class="form-control datetimepicker">
                                      </div>
                                  </div>
                                  <div class="col-md-3">
                                      <div class="form-group">
                                          <label>Visit In Time</label>
                                          <input type="time" placeholder="Enter Visit In Time" id="visit_in_time" value="<?php echo $curr_time;?>"   name="visit_in_time" class="form-control datetimepicker">
                                      </div>
                                  </div>
                                  <div class="col-md-3">
                                      <div class="form-group">
                                          <label>Visit Out Date</label>
                                          <input type="date" placeholder="Enter Visit Out Date" id="visit_out_date"  name="visit_out_date" class="form-control datetimepicker">
                                      </div>
                                  </div>
                                  <div class="col-md-3">
                                      <div class="form-group">
                                          <label>Visit Out Time</label>
                                          <input type="time" placeholder="Enter Visit Out Time" id="visit_out_time"  name="visit_out_time" class="form-control datetimepicker">
                                      </div>
                                  </div>
                              </div>

                                <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Reason</label>
                                        <textarea placeholder="Enter Reason" cols="5" rows="5" name="reason" class="form-control" ></textarea>
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Remark</label>
                                        <textarea placeholder="Enter Remark" cols="5" rows="5" name="remark" class="form-control" ></textarea>
                                     </div>
                                   </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Vehicle No</label>
                                        <input type="text" placeholder="Enter Vehicle No" name="vehicle_no" class="form-control" >
                                     </div>
                                   </div>
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Photo</label>
                                      <input type="file" name="visitor_image[]" class="form-control" multiple="multiple">
                                    </div>
                                   </div>
                                </div>
                                
                                <div class="row">
                                  <div class="col-md-6">
                                    <div class="form-group">
                                      <label>Qr Code</label>
                                      <input type="text" placeholder="Enter qr code" name="qr_code" class="form-control" >
                                    </div>
                                  </div>
                                </div>

                                <button type="submit" class="btn btn-primary">Submit</button>
                                <a href="{{ route('visitorslist.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')


@endsection