@extends('dashboard.base')
@section('css')

@endsection
@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Tax Settings</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                @endif      

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif 

                <form method="POST" id="basic_info" action="/taxsettings/{{ $tax->id }}"  enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                     <?php 
                        $base_url = URL('/');

                        $headerpath = $base_url.'/public/storage/uploads/hotel_admins/'.$tax->created_by.'/tax_settings'.'/'.$tax->header_logo;
    
                        $footerpath = $base_url.'/public/storage/uploads/hotel_admins/'.$tax->created_by.'/tax_settings'.'/'.$tax->footer_logo;
    
                    ?>
                    
                    <input name="marker" value="selectModel" type="hidden">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Select Property</label>
                                <select class="form-control" name="property_id" id="property_id">
                                    <option value="0">Please select</option>
                                    @foreach($properties as $property)
                                        <option value="{{ $property->id }}" <?php if($tax->property_id == $property->id ){ echo "selected";}?>>{{ $property->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4" style="margin-top: 34px;">
                            <div class="form-group">
                                <label style="padding-right: 7px;">Tax Sequence No</label>
                                <input type="text" style="width: 47px;" name="curr_tax_year" value="<?php echo $curr_year; ?>" readonly><span style="padding:-3px;"> -</span>
                                <input type="number" style="margin-top: -38px;margin-left: 196px;" placeholder="Enter Tax Sequence No" name="tax_seq_no" value="<?php echo $tax->tax_seq_no;?>" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Header Logo</label>
                                <input type="file" name="header_logo" class="form-control" >
                                <a href='<?php echo $headerpath;?>' target="_blank">View</a>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Footer Logo</label>
                                <input type="file" name="footer_logo" class="form-control" >
                                <a href='<?php echo $footerpath;?>' target="_blank">View</a>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="row show_tax_details" style="display:none;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 1</label>
                                <input type="text" placeholder="Enter Footer Text 1"  name="footer_text_1" value="<?php echo $tax->footer_text_1;?>" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 2</label>
                                <input type="text" placeholder="Enter Footer Text 2" name="footer_text_2" value="<?php echo $tax->footer_text_2;?>" class="form-control" >
                            </div>
                        </div>
                    </div><hr/>
                    

                    <!-- <div class="row">
                        <h4>Added Tax Items:</h4><br/>
                        <table class="table table-bordered data-table" >
                            <thead>
                                <tr>
                                    <th>Charge Type</th>
                                    <th>SC (%)</th>
                                    <th>AT (%)</th>
                                    <th>VAT (%)</th>
                                </tr>
                            </thead>
                            <tbody class="" id="">
                                <?php foreach($taxsettingsItems as $item){ ?>
                                    <tr>
                                        <td><?php echo $item->tax_item_charge_type; ?></td>
                                        <td><?php echo $item->service_tax; ?></td>
                                        <td><?php echo $item->accomodation_tax; ?></td>
                                        <td><?php echo $item->vat; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div><hr/> -->

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h4>Add New Tax Items:</h4>
                                <button id="add-more-field" style="float:right;margin-top: -28px;margin-bottom: 21px;" class="btn btn-primary btn-sm" type="button">Add More +</button>
                            </div>
                        </div>
                    </div>

                    <div class="row" style="max-width:100%;overflow-x: auto; white-space: nowrap;">
                        <div class="col-md-12">
                            <table class="table table-bordered data-table" >
                                <thead>
                                    <tr>
                                        <th>Charge Type</th>
                                        <th>SC (%)</th>
                                        <th>AT (%)</th>
                                        <th>VAT (%)</th>
                                    </tr>
                                </thead>
                                <tbody class="tax_fields" id="tax_table_body">

                                <?php $i =1; foreach($taxsettingsItems as $item){ ?>
                                    <tr>
                                        <td><input type="text" style="text-align:left;" id="tax_item_charge_type_<?php echo $i;?>" class="tax_item_charge_type" name="tax_item_charge_type[]" value="<?php echo $item->tax_item_charge_type;;?>"></td>
                                        <td><input type="text" style="text-align:right;" id="tax_item_sc_<?php echo $i;?>" class="tax_item_sc" name="tax_item_sc[]" value="<?php echo $item->service_tax;;?>"></td>
                                        <td><input type="text" style="text-align:right;" id="tax_item_at_<?php echo $i;?>" class="tax_item_at" name="tax_item_at[]" value="<?php echo $item->accomodation_tax;;?>"></td>
                                        <td><input type="text" style="text-align:right;" id="tax_item_vat_<?php echo $i;?>" class="tax_item_vat"  name="tax_item_vat[]" value="<?php echo $item->vat;;?>"></td>
                                    </tr>
                                <?php $i++; } ?>

                                   
                                </tbody>
                            </table>
                        </div>
                    </div><br/>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('taxsettings.index') }}" class="btn btn-primary">
                        Cancel
                    </a>
                </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')


<script type="text/javascript">
  $(function () {

    if($('#property_id').val() == 0){
        $('.show_tax_details').hide(); 
    } else {
        $('.show_tax_details').show(); 
    }

    $(document).on('click','#add-more-field', (function (e) {
        e.preventDefault();  
        var table_tax_body = $('#tax_table_body');
        var tax_body_row_length = table_tax_body.find('tr').length;
        var new_row_number = tax_body_row_length+1;
        var more_fields =  '<tr id="tax_row_'+new_row_number+'"><td><input type="text"  id="tax_item_charge_type_'+new_row_number+'" class="tax_item_charge_type"  name="tax_item_charge_type[]" value=""></td><td><input type="text" id="tax_item_sc_'+new_row_number+'" class="tax_item_sc" style="text-align:right;" name="tax_item_sc[]" value="0"></td><td><input type="text" style="text-align:right;" id="tax_item_at_'+new_row_number+'" class="tax_item_at"  name="tax_item_at[]" value="0"></td><td><input type="text" style="text-align:right;" id="tax_item_vat_'+new_row_number+'" class="tax_item_vat" name="tax_item_vat[]" value="0"></td><td><span class="remove_this_tax_row" class="btn btn-danger" id="remove_this_tax_row_'+new_row_number+'" style="cursor:pointer;">X</span></td></tr>';
        $(".tax_fields").append(more_fields);
    }));

    $(document).on('click','.remove_this_tax_row',function(){
        var this_row = $(this);
        var this_row_id = this_row.attr('id').substr(20);
        $('#tax_row_'+this_row_id).remove();
        var j = 1;
        $('.remove_this_tax_row').each(function(i, obj) {
            $(this).attr('id','remove_this_tax_row_'+j);
            $(this).parent().parent().attr('id','tax_row_'+j);
            $(this).parent().parent().find('td:first-child').text(j);
            j++;
        });
    });
});
</script>


@endsection