@extends('dashboard.base')

@section('content')
 
<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Reservation</h4></div>
            <div class="card-body">
              @if(Session::has('message'))
                <div class="row">
                  <div class="col-12">
                    <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                  </div>
                </div>
              @endif      

              @if ($errors->any())
                <div class="alert alert-danger">
                  <ul>
                    @foreach ($errors->all() as $error)
                      <li>{{ $error }}</li>
                    @endforeach
                  </ul>
                </div>
              @endif      
           
                <form method="POST" action="/reservations/{{ $reservation->id }}">
                @csrf
                @method('PUT')
                <input name="marker" value="selectModel" type="hidden">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Reservation No.*</label>
                      <input type="text" style="border: 2px solid blue;" placeholder="Enter Reservation No" name="reservation_no" class="form-control" value="<?php echo $reservation->reservation_no; ?>">
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Source Booking No.*</label>
                      <input type="text" style="border: 2px solid blue;" placeholder="Enter Source Booking No" name="source_booking_no" class="form-control" value="<?php echo $reservation->source_booking_no; ?>">
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Select Source*</label>
                      <select class="form-control" style="border: 2px solid blue;" name="source" id="source">
                        <option value="0">Please select</option>
                          @foreach($sources as $source)
                              <option value="{{ $source->id }}" {{ $reservation->source == $source->id  ? 'selected' : '' }}>{{ $source->title }}</option>
                          @endforeach
                      </select>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Select Property*</label>
                      <select class="form-control" style="border: 2px solid blue;" name="property_id" id="property_id">
                        <option value="0">Please select</option>
                          @foreach($properties as $property)
                              <option value="{{ $property->id }}" {{ $reservation->property_id == $property->id  ? 'selected' : '' }}>{{ $property->name }}</option>
                          @endforeach
                      </select>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Room*</label>
                      <select class="form-control " style="border: 2px solid blue;" name="room_id" id="room">
                        <option value="0">Select Room</option>
                        @foreach($rooms as $room)
                        <option value="{{ $room->id }}" {{ $reservation->room_id == $room->id  ? 'selected' : '' }}>{{ $room->title }}</option>
                        @endforeach
                      </select>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>From Date</label>
                      <input type="date" placeholder="Enter From Date" id="from_date" value="<?php echo $reservation->from_date; ?>" name="from_date" class="form-control datetimepicker">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>From Time</label>
                      <input type="time" value="02:00" placeholder="Enter From Time" id="from_time" value="<?php echo $reservation->from_time; ?>"  name="from_time" class="form-control datetimepicker">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>TO Date</label>
                      <input type="date" placeholder="Enter To Date" id="to_date" value="<?php echo $reservation->to_date; ?>" name="to_date" class="form-control datetimepicker">
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label>To Time</label>
                      <input type="time" value="02:00" placeholder="Enter TO Time" id="to_time" value="<?php echo $reservation->to_time; ?>" name="to_time" class="form-control datetimepicker">
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Reserved By</label>
                      <input type="text" placeholder="Reserved By" name="reserved_by"  value="<?php echo $reservation->reserved_by; ?>" class="form-control" >
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Reservation Details</label>
                      <textarea placeholder="Reservation Details" name="reservation_details" class="form-control" ><?php echo $reservation->reservation_details; ?></textarea>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Reservation Notes</label>
                      <textarea placeholder="Reservation Notes" name="reservation_notes" class="form-control" ><?php echo $reservation->reservation_notes; ?></textarea>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Remarks</label>
                      <textarea placeholder="Reservation Remarks" name="reservation_remarks" class="form-control" ><?php echo $reservation->reservation_remarks; ?></textarea>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Status</label>
                      <select class="form-control " name="status" id="status">
                        <option value="1" {{ $reservation->status == 1  ? 'selected' : '' }}>Pending</option>
                        <option value="2" {{ $reservation->status == 2 ? 'selected' : '' }}>Checked In</option>
                        <option value="3" {{ $reservation->status == 3  ? 'selected' : '' }}>Don't Show</option>
                        <option value="4" {{ $reservation->status == 4  ? 'selected' : '' }}>Cancel</option>
                      </select>
                    </div>
                  </div>
                </div>

                <button type="submit" class="btn btn-primary">Submit</button>
                <a href="{{ route('reservations.index') }}" class="btn btn-primary">
                  Cancel
                </a>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">
  $(document).on("change", "#property_id", function() {
    var propVal = $('#property_id').val(); 
    $.ajax({
      type: 'post',
      url: '/customers/getRoomsByProperty',
      data: {
        '_method':'POST',
        '_token': $('input[name=_token]').val(),
        'property_id': propVal,//id of customer
      },
      success: function(resdata) {
        if(resdata){
          $('#room').html(resdata.html);  
        }
      }
    }); 
  });
</script>

@endsection



                     
         