					  
@extends('dashboard.base')

@section('content')

        @if(Session::has('message'))
            <div class="row">
                <div class="col-12">
                    <!-- <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                    </div> -->
                    <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
                        <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                    </div>
                </div>
            </div>
        @endif       

        <div class="container-fluid">
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                        <div class="card">
                            <div class="card-header">
                                <i class="fa fa-align-justify"></i>{{ __(' Properties') }}
                                <?php
                                if(!empty($privileges)){
                                    if($privileges->add && Auth::user()->user_type == 1){ //show add button ?>
                                        <a id="add_button" href="{{ route('properties.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a>
                                        <?php } else {  //dont show add button ?>
                                        <?php } 
                                        } else {  
                                        if(Auth::user()->user_type == 1){?>
                                        <a id="add_button" href="{{ route('properties.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a>
                                        <?php }} ?>

                                <!-- <a id="add_button" href="{{ route('properties.create') }}" class="btn">{{ __('Add ') }}<i class="fa fa-plus-circle"></i></a> -->
                            </div>
                                <div class="card-body">
                                <?php if(!empty($pincodes)){?>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Select Pin Code</label>
                                                <select class="form-control" name="pincode_filter" id="pincode_filter">
                                                    <option value="0">Please select</option>
                                                    @foreach($pincodes as $pin)
                                                        <option value="{{ $pin->pin }}">{{ $pin->pin }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                   <?php } ?>

                                    <!-- <div class="row"> 
                                         <a href="{{ route('properties.create') }}" class="btn btn-primary m-2">{{ __('Add Properties') }}</a>
                                    </div>
                                    <br> -->

                                    <table style="width: 102%; margin-left: -15px;" class="table table-bordered data-table">
                                        <thead>
                                                <tr>
                                                    <!-- <th width="50">No</th> -->
                                                    <th>Name</th>
                                                    <th>E-mail</th>
                                                    <th>Mobile</th>
                                                    <th>Org Name</th>
                                                    <th>City</th>
                                                    <th>Owner</th>
                                                    <th>Status</th>
                                                    <th width="100px">Action</th>
                                                </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



            <!-- /.modal-->
            <div class="modal fade" id="dangerModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
             <input type="hidden" name='delete_record_id' id="delete_record_id" value="">
              <div class="modal-dialog modal-danger" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h4 class="modal-title">Delete</h4>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                  </div>
                  <div class="modal-body">
                    <p>Are you sure, You want to delete this record ? </p>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button class="btn btn-danger" id="confirm" data-dismiss="modal" type="button">Confirm</button>
                  </div>
                </div>
                <!-- /.modal-content-->
              </div>
              <!-- /.modal-dialog-->
            </div>
            <!-- /.modal-->



            <!-- model pop up for export confirmations  -->
            <div class="modal fade" id="exportModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                    
                            <input type="hidden" name="property_id" id="property_id" value="">
                            <div class="modal-header">
                                <h5 class="modal-title">Export Guests</h5>
                                <button class="close" type="button" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                            </div>

                            <div class="modal-body">
                                <div class="row">
                                    <div class ="col-md-5">
                                        <div class="form-check">
                                            <input class="form-check-input export_radio" id="currently_stay" type="radio" value="1" name="radios">
                                            <label class="form-check-label" for="radio1">Cusrrently Staying</label>
                                        </div>
                                    </div>
                                    <div class ="col-md-5"> 
                                        <div class="form-check">
                                            <input class="form-check-input export_radio" id="date_range" type="radio" value="2" name="radios">
                                            <label class="form-check-label" for="radio2">Staying-In</label>
                                        </div>
                                    </div>
                                </div><hr/>
                                <h6 style="display:none;" id="currently_staying_head">This will export custmers currently staying in this property.</h6>
                                <div class="row">
                                    <div class="col-md-1" ></div>
                                    <div class="col-md-5" >
                                        <div class="form-group" id="from_date_div" style="display:none;" >
                                            <label>Start Date</label>
                                            <input type="date" placeholder="Enter Start date" id="from_date" name="from_date" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                         <div class="form-group"  id="to_date_div" style="display:none;">
                                            <label>End Date</label>
                                            <input type="date" placeholder="Enter End date" id="to_date" name="to_date" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-1" ></div>
                            </div>

                            <div class="modal-footer">
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button class="btn btn-primary" id="export_cust_by_property" type="button">Export</button>
                            </div>

                    </div><!-- /.modal-content-->       
                </div><!-- /.modal-dialog-->
            </div>
            <!-- /.modal-->

@endsection


@section('javascript')

<script type="text/javascript">
    $(function () {
        let table;
        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('properties.index') }}",
            order: [],
            columns: [
                // {data: 'id', name: 'id'},
                {data: 'name', name: 'name'},
                {data: 'email', name: 'email'},
                {data: 'mobile', name: 'mobile'},
                {data: 'org_name', name: 'org_name'},
                {data: 'city', name: 'city'},
                {data: 'owner', name: 'owner'},
                {data: 'status_id', name: 'status_id'},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ]
        });
 
        $(document).on( "click", ".delete", function() {
            $('#delete_record_id').val($(this).data('record-id'));
            $('#dangerModal').on( "click", "#confirm", function() {
                
                $.ajax({
                    type: 'post',
                    url: '/properties/delete',
                    data: {
                        '_method':'DELETE',
                        '_token': $('input[name=_token]').val(),
                        'id': $('#delete_record_id').val(),
                    },
                    success: function(resdata) {
                        if(resdata){ 
                            table.ajax.reload();
                        }
                    }
                });
            });
        });

        //customer list using stay filter
        $(document).on("change", "#pincode_filter", function() {
            var pinVal = $('#pincode_filter').val();  
            $('.data-table').DataTable({
                bDestroy: true,
                processing: true,
                serverSide: true,
                ajax:   {
                            url: "{{ route('properties.index')}}",
                            data: {
                                pin: pinVal,
                            },
                        },
                order: [],
                columns: [
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'mobile', name: 'mobile'},
                    {data: 'org_name', name: 'org_name'},
                    {data: 'city', name: 'city'},
                    {data: 'owner', name: 'owner'},
                    {data: 'status_id', name: 'status_id'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
        });

        //export customers by property
        $(document).on( "click", ".export_customers", function() {
            $('#property_id').val($(this).data('record-id'));
        });

        $('#currently_stay').on( "click", function() {
            if($('#currently_stay').is(":checked")){
                $('#from_date_div').hide();
                $('#to_date_div').hide();
            } 
        });

        $('#date_range').on( "click", function() {
            if($('#date_range').is(":checked")){
                $('#from_date_div').show();
                $('#to_date_div').show();
                $('#currently_staying_head').hide();
            } else {  
                $('#from_date_div').hide();
                $('#to_date_div').hide();
            }
        });
        $('#currently_stay').on( "click", function() {
            if($('#currently_stay').is(":checked")){
                $('#currently_staying_head').show();
            }
        });
        

        $(document).on( "click", "#export_cust_by_property", function() {
            
            let from_date;
            from_date = '';

            let to_date;
            to_date = '';
            if($('#currently_stay').is(":checked")){
                var export_by = $('#currently_stay').val();
            
            } else if($('#date_range').is(":checked")){
                var export_by = $('#date_range').val();
                from_date = $('#from_date').val();
                to_date = $('#to_date').val();
            } else {
                var export_by = '';
            }

            var property_id = $('#property_id').val();
            var export_by = export_by;
            var from = from_date;
            var to = to_date;
            //get base url 
            var base_url = "{{ url('/')}}"; 
            var export_url = base_url+'/properties/exportCustomersByProperty?type=export&property_id='+property_id+'&export_by='+export_by+'&from_date='+from+'&to_date='+to;
            window.location.href = export_url;

            //close model
            $("#exportModal .close").click();
            $('.modal-backdrop').remove();
            // alert(export_by);
            // $.ajax({
            //     type: 'post',
            //     url: '/properties/exportCustomersByProperty',
            //     data: {
            //         'property_id': $('#property_id').val(),
            //         '_token': $('input[name=_token]').val(),
            //         'export_by':export_by,
            //         'from_date' : from_date,
            //         'to_date' : to_date,
            //     },
            //     success: function(resdata) {
            //         if(resdata){

            //         }
            //     }
            // });
        });
    });

</script>

@endsection
