
@extends('dashboard.base')

@section('css')

@endsection

@section('content')

<?php 
   if(Auth::user()->user_type == 5 || Auth::user()->user_type == 6){
      $disable_class = 'readonly';
   } else {
      $disable_class = '';
   }

?>
<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Edit Property</h4></div>
            <div class="card-body">
            {{ Session::get('message') }}
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif      

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif      
           
                        <form method="POST"  action="/properties/{{ $property->id }}">
                            @csrf
                            @method('PUT')
                            <input name="marker" value="selectModel" type="hidden">
                               <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Name*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Name" name="name" value="{{ $property->name }}" class="form-control" <?php echo $disable_class; ?> >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Code*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Code" name="code" class="form-control" value="{{ $property->code }}" <?php echo $disable_class; ?>>
                                     </div>
                                   </div>
                                   
                                   
                                </div>

                               <div class="row">
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Email*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Your Email" name="email" value="{{ $property->email }}" class="form-control" <?php echo $disable_class; ?> >
                                    </div>
                                  </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Mobile</label>
                                          <input type="number" placeholder="Enter your Mobile" name="mobile" value="{{ $property->mobile }}" class="form-control" <?php echo $disable_class; ?>>
                                    </div>
                                 </div>
                                 
                               </div>

                             <div class="row">
                              <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Organization Name*</label>
                                        <input type="text" style="border: 2px solid blue;" placeholder="Enter Your Org Name" name="org_name" value="{{ $property->org_name }}" class="form-control" <?php echo $disable_class; ?>>
                                     </div>
                                  </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Address</label>
                                          <input type="text" placeholder="Enter Address" name="address" value="{{ $property->address }}" class="form-control" <?php echo $disable_class; ?>>
                                    </div>
                                 </div>
                                 
                              </div>

                              <div class="row">
                              <div class="col-md-6">
                                     <div class="form-group">
                                        <label>City</label>
                                        <input type="text"  placeholder="Enter City" class="form-control" name="city" value="{{ $property->city }}" <?php echo $disable_class; ?>/>
                                     </div>
                                  </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                       <label>Country</label>
                                       <select class="form-control " name="country" id="country" <?php echo $disable_class; ?>>
                                             @foreach($countries as $country)
                                                <option value="{{ $country->id }}" {{ $property->country == $country->id  ? 'selected' : '' }}  >{{ $country->name }}</option>
                                             @endforeach
                                       </select>
                                    </div>
                                 </div>
                                
                              </div>

                                <div class="row">
                                <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Provenance</label>
                                        <input type="text"  placeholder="Enter Provenance" class="form-control " value="{{ $property->provenance }}" name="provenance" <?php echo $disable_class; ?>/>
                                     </div>
                                  </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                        <label>PIN</label>
                                        <input type="number"  placeholder="Enter Pin" class="form-control" name="pin" value="{{ $property->pin }}" <?php echo $disable_class; ?>/>
                                     </div>
                                    </div>
                                    
                                </div>

                                <div class="row">
                                   <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Phone 1</label>
                                        <input type="number"  placeholder="Enter Phone 1" class="form-control" name="phone_1" value="{{ $property->phone_1 }}" <?php echo $disable_class; ?> />
                                     </div>
                                    </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                        <label>Phone 2</label>
                                        <input type="number"  placeholder="Enter Phone 2" class="form-control" name="phone_2" value="{{ $property->phone_2 }}" <?php echo $disable_class; ?>/>
                                     </div>
                                  </div>
                                 
                               </div>

                                <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                     <label>Owner</label>
                                        <select class="form-control" name="owner" id="owner" <?php echo $disable_class; ?>>
                                              @foreach($owners as $owner)
                                                 <option value="{{ $owner->id }}"  {{ $property->owner == $owner->id  ? 'selected' : '' }} >{{ $owner->first_name }} {{ $owner->last_name }}</option>
                                             @endforeach
                                          </select>
                                      </div>
                                   </div>
                                 <div class="col-md-6">
                                    <div class="form-group">
                                     <label>Status</label>
                                        <select class="form-control" name="status_id" id="status_id" <?php echo $disable_class; ?>>
                                            <option value="1" {{ $property->status_id == 1 ? 'selected' : '' }}>Active</option>
                                            <option value="2" {{ $property->status_id == 2 ? 'selected' : '' }}>In-Active</option>
                                          </select>
                                      </div>
                                   </div>
                                </div>

                                
                                 <div class="row">
                                    <div class="col-md-6">
                                       <div class="form-group">
                                          <label>Service Url</label>
                                          <input type="text"  placeholder="Enter Url" class="form-control" value="{{ $property->service_url }}"  name="service_url"/>
                                       </div>
                                    </div>
                                    <div class="col-md-6">
                                       <div class="form-group">
                                          <label>Welcome Message</label>
                                          <input type="text"  placeholder="Enter Welcome message" class="form-control" value="{{ $property->welcome_msg }}"  name="welcome_msg"/>
                                       </div>
                                    </div>
                                 </div>

                                  <div class="row">
                                    <div class="col-md-6">
                                       <div class="form-group">
                                          <label>POS Service Url</label>
                                          <input type="text"  placeholder="Enter Url" class="form-control" value="{{ $property->pos_service_url }}" name="pos_service_url"/>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label>Show Guest Name</label>
                                            <select class="form-control " name="show_guest_name" id="show_guest_name">
                                                <option value="0">Please choose</option>
                                          <option value="1" {{ $property->show_guest_name == 1 ? 'selected' : '' }}>Yes</option>
                                          <option value="2" {{ $property->show_guest_name == 2 ? 'selected' : '' }}>No</option>
                                            </select>
                                        </div>
                                    </div>
                                 </div>

                                <?php if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){ ?>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                 <?php } ?>
                                <a href="{{ route('properties.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

              </div>
           </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection