
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Group</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

           
                        <form method="POST" action="{{ route('groups.store') }}">
                            @csrf
                            <input name="marker" value="selectModel" type="hidden">
                               <div class="row">
                                  <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Group Name</label>
                                        <input type="text" placeholder="Enter Group Name" name="group_name" class="form-control" >
                                     </div>
                                   </div>
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Description</label>
                                        <input type="text" placeholder="Enter Description" name="description" class="form-control" >
                                     </div>
                                   </div>
                                </div>

                                <div class="row">
                                   <div class="col-md-6">
                                     <div class="form-group">
                                       <label>Memebers</label>
                                        <input type="text" placeholder="Enter Members" name="members" class="form-control" >
                                     </div>
                                   </div>
                               </div>

                                <button type="submit" class="btn btn-primary">Submit</button>
                                <a href="{{ route('groups.index') }}" class="btn btn-primary">
                                Cancel
                              </a>
                       </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection