
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Create Criminal Record</h4></div>
            <div class="card-body">
              @if(Session::has('message'))
                <div class="row">
                  <div class="col-12">
                    <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                  </div>
                </div>
                @endif      

                @if ($errors->any())
                  <div class="alert alert-danger">
                    <ul>
                      @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                      @endforeach
                    </ul>
                  </div>
                @endif      
           
                <form method="POST" action="{{ route('criminalrecords.store') }}" enctype="multipart/form-data">
                  @csrf
                  <input name="marker" value="selectModel" type="hidden">
                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>First Name</label>
                        <input type="text" placeholder="Enter First Name" name="first_name" class="form-control" >
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Last Name</label>
                        <input type="text" placeholder="Enter Last Name" name="last_name" class="form-control" >
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Passport No/ID No</label>
                        <input type="text" placeholder="Enter Passport/ID Number" name="passport_no" class="form-control" >
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>File Number</label>
                        <input type="text" placeholder="Enter File Number" name="file_number" class="form-control" >
                      </div>
                    </div>
                  </div>

                  <div class="row">
                
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Record ID</label>
                        <input type="text" placeholder="Enter Record ID" name="record_id" class="form-control" >
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Description(Charge)</label>
                        <textarea type="text" placeholder="Enter Description" cols="3" rows="3" name="description" class="form-control" ></textarea>
                      </div>
                    </div>
                  </div>

                  <div class="row">
                  
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Nationality</label>
                        <select class="form-control " name="nationality" id="nationality">
                          <option value="0">Please select country</option>
                          @foreach($countries as $country)
                              <option value="{{ $country->id }}">{{ $country->name }}</option>
                          @endforeach
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Gender</label>
                        <select class="form-control" name="gender" id="gender">
                          <option value="1">Male</option>
                          <option value="2">Female</option>
                        </select>
                      </div>
                    </div>
                  </div>
                
                  <div class="row">
                    
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Date Of Birth</label>
                        <input type="date" placeholder="Enter Dob" name="date_of_birth" id="date_of_birth" class="form-control">
                      </div>
                    </div>
                    <!-- <div class="col-md-6">
                      <div class="form-group">
                        <label>Institution</label>
                        <input type="text" placeholder="Enter Institution" name="institution" class="form-control">
                      </div>
                    </div> -->
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Case No.</label>
                        <input type="text" placeholder="Enter Case No" name="case_no" class="form-control">
                      </div>
                    </div>
                  </div>

                  <div class="row">
                   
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Age</label>
                        <input type="text" placeholder="Enter Age" name="age" id="age" class="form-control">
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Height</label>
                        <input type="text" placeholder="Enter Height" name="height" class="form-control">
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Eye Color</label>
                        <input type="text" placeholder="Enter Eye Color" name="eye_color" class="form-control">
                      </div>
                    </div>
                  </div>


                  <div class="row">
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Hair Color</label>
                        <input type="text" placeholder="Enter Hair Color" name="hair_color" class="form-control">
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Law Instructions</label>
                        <textarea type="text" placeholder="Enter Law Instructions" cols="3" rows="3" name="law_instructions" class="form-control" ></textarea>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Status</label>
                        <select class="form-control" name="status" id="status">
                          <option value="1">Active</option>
                          <option value="2">In-Active</option>
                        </select>
                      </div>
                    </div>
                  </div>
             

                  <div class="row">
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Most Wanted</label>
                        <select class="form-control" name="most_wanted" id="most_wanted">
                          <option value="1">Yes</option>
                          <option value="2">No</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Image</label><br/>
                        <input type="file" name="image" id="image" ><br/>
                        <small><?php echo "Max File Size : 1MB & File Type:jpg,jpeg,png";?></small>
                      </div>
                    </div>
                  </div>
              


                  <button type="submit" class="btn btn-primary">Submit</button>
                  <a href="{{ route('criminalrecords.index') }}" class="btn btn-primary">
                    Cancel
                  </a>
                </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">
$(document).ready(function(){
  $('#date_of_birth').on('change', function(){ 
    var ty = $('#date_of_birth').val();
    var start = new Date().getFullYear();
    var selected_date_arr = ty.split('-');

    var end = selected_date_arr[0];
    console.log(start+' - '+end);
    var diff = parseFloat(start) - parseFloat(end);
    $('#age').val(diff);
  }); 
});
</script>

@endsection