@extends('dashboard.base')
@section('css')

@endsection
@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Commercial Invoice Details</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                @endif      

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif      
           
                  <form method="POST" action="{{ route('commercialtaxsettings.customer_commercial_tax_invoice') }}"  enctype="multipart/form-data">
                    @csrf
                    <input name="marker" value="selectModel" type="hidden">
                    <input name="customer_id" value="<?php echo $customer->id;?>" type="hidden">
                    <input name="tax_row_id" value="<?php echo $commercialsettings->id; ?>" type="hidden">
                      <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Company Name</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text" readonly placeholder="Enter Comapny Name" name="company_name" value="<?php echo $customer->company_details;?>" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Invoice No</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text" readonly  placeholder="Enter Invoice No" readonly name="invoice_no" value="<?php echo $commercialtaxDetails->invoice_no;?>" class="form-control" >
                            </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Guest Name</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text" readonly placeholder="Enter Guest Name" name="guest_name" value="<?php echo $customer->first_name.' '.$customer->last_name;?>" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Invoice Date</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text"  placeholder="Enter Invoice Date" name="invoice_date" value="<?php echo $commercialtaxDetails->invoice_date;?>" class="form-control" >
                            </div>
                        </div>
                       
                      </div>

                      <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Guest Code</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text" readonly placeholder="Enter Guest Code" name="guest_code" value="<?php echo $customer->guest_code;?>" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Address</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text" readonly placeholder="Enter Address" name="guest_address" value="<?php echo $customer->address;?>" class="form-control" >
                            </div>
                        </div>
                      </div>


                      <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Telephone No</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text"readonly  placeholder="Enter Mobile" name="guest_mobile" value="<?php echo $customer->mobile;?>" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>VAT TIN No</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text"  placeholder="Enter Vat Tin NO" name="guest_vat_tin_no" value="<?php echo $customer->vat_in_no;?>" class="form-control" >
                            </div>
                        </div>
                      </div>
                 
                      <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>CheckIn Date</label>
                                <?php
                                  $ar = explode(' ',$customer->checkin_date_time);
                                ?>
                                <input type="date" placeholder="Enter CheckIn Date" id="checkin_date"  name="checkin_date" value="<?php echo $ar[0];?>" class="form-control datetimepicker">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>CheckIn Time</label>
                                <input type="time" placeholder="Enter CheckIn Time" id="checkin_time"  name="checkin_time"  value="<?php echo $ar[1];?>" class="form-control datetimepicker">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>CheckOut Date</label>
                                <input type="date" placeholder="Enter CheckOut date" name="checkout_date" value="<?php echo date('Y-m-d');?>" class="form-control datetimepicker">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>CheckOut Time</label>
                                <input type="time" placeholder="Enter CheckOut Time" name="checkout_time" value="<?php echo $curr_time;?>"  class="form-control datetimepicker">
                            </div>
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                              <label>Exchange Rate*</label>
                              </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                              <input type="text"  placeholder="Enter Exchange Rate" name="exchange_rate" style="text-align:right;" id="exchange_rate" value="<?php echo $commercialtaxDetails->exchange_rate;?>" class="form-control" >
                              <span id="exchange_rate_error" style="color:red;display:none;">Please enter the exchange rate.</span>
                            </div>
                        </div>
                      </div>


                      <div class="row tax_table">
                        <div class="col-md-12">
                          <div class="form-group">
                            <h4>Items:</h4><br/>
                            <button id="add-more-field" style="float:right;" class="btn btn-primary btn-sm" type="button">Add More +</button>
                          </div>
                        </div>
                      </div>

                      
                      <center><div class="row" style="max-width:100%;overflow-x: auto; white-space: nowrap;">
                        <div class="col-md-12">
                          <table class="table table-bordered data-table tax_table" >
                            <thead>
                                <tr>
                                    <th>Seq.</th>
                                    <th>Charge Type</th>
                                    <th>Description</th>
                                    <th>Qty.</th>
                                    <th>Unit Price ($)</th>
                                    <th>Total ($)</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <tbody class="tax_fields" id="tax_table_body">

                            <?php $i =1; foreach($commercialInvoiceItems as $item){ ?>
                                <tr>
                                    <td><input type="number" style="text-align:right;width:45px;" id="tax_item_seq_no_<?php echo $i;?>" class="tax_item_seq_no" name="tax_item_seq_no[]" value="<?php echo $i;?>"></td>
                                    <!-- <td><input type="text" id="tax_item_guest_id_1" class="tax_item_guest_id" name="tax_item_guest_id[]" value="<?php echo $customer->guest_code;?>"></td> -->
                                    <td>
                                      <select name="tax_item_charge_type[]" style="width:150px;" id="tax_item_charge_type_<?php echo $i;?>" class="tax_item_charge_type">
                                        <option value="0">Please Select Type</option>
                                        <?php foreach($commercialsettingsItems as $items){ ?>
                                          <option value="<?php echo $items->id.'-0';?>" <?php if($items->id == $item->tax_item_charge_type){echo "selected";} ?> ><?php echo $items->tax_item_charge_type;?></option>
                                        <?php } ?>
                                      </select>
                                    </td>
                                    <td><input type="text" id="tax_item_charge_description_<?php echo $i;?>" class="tax_item_charge_description" name="tax_item_charge_description[]" value="<?php echo $item->tax_item_charge_description;?>"></td>
                                    <td><input type="text" id="tax_item_quantity_<?php echo $i;?>" class="tax_item_quantity" name="tax_item_quantity[]"  style="text-align:right;width:50px;float:right;" value="<?php echo number_format($item->tax_item_quantity,2);?>"></td>
                                    <td><input type="text" id="tax_item_unit_price_<?php echo $i;?>" class="tax_item_unit_price" name="tax_item_unit_price[]" style="text-align:right;width:77px;float:right;" value="<?php echo number_format($item->tax_item_unit_price,2);?>"></td>
                                    <!--<td>-->
                                    <!--  <input type="text" id="tax_amount_<?php echo $i;?>" class="tax_amount" name="tax_amount[]" value="<?php echo number_format($item->tax_amount,2);?>" style="text-align:right;width:50px;">-->
                                    <!--</td>-->
                                    <td><input type="text" id="tax_item_amount_<?php echo $i;?>" class="tax_item_amount"  name="tax_item_amount[]" value="<?php echo number_format($item->tax_item_amount,2);?>" style="text-align:right;width:50px;float:right;"></td>
                                    <td></td>
                                </tr>
                            <?php $i++; } ?>
                            </tbody>
                            <tfoot>
                              <tr>
                                <td></td>
                                <!-- <td></td> -->
                                <td></td>
                                <td><b>Total  in USD</b></td>
                                <td></td>
                                <td>
                                  <input type="hidden" name="total_amount_usd" value="<?php echo number_format($commercialtaxDetails->total_amount_usd,2);?>" id="total_amount_usd">
                                  <!--<b><span id="total_amoumt_usd_text" style="float:right;"><?php echo number_format($commercialtaxDetails->total_amount_usd,2);?></span></b>-->
                                </td>
                                <td>
                                  <input type="hidden" name="total_amt_usd" value="<?php echo number_format($commercialtaxDetails->total_amt_usd,2);?>" id="total_amt_usd">
                                  <b><span id="total_amt_usd_text" style="float:right;"><?php echo number_format($commercialtaxDetails->total_amt_usd,2);?></span></b>
                                </td>

                              </tr>

                              <tr>
                                <td></td>
                                <!-- <td></td> -->
                                <td></td>
                                <td><b>Total In Khmer Reil</b></td>
                                <td></td>
                                <td>
                                  <input type="hidden" name="total_amount_kh" value="<?php echo number_format($commercialtaxDetails->total_amount_kh);?>" id="total_sc_kh">
                                  <!--<b><span id="total_amount_kh_text" style="float:right;"><?php echo number_format($commercialtaxDetails->total_amount_kh);?></span></b>-->
                                </td>
                                <td>
                                  <input type="hidden" name="total_amt_kh" value="<?php echo number_format($commercialtaxDetails->total_amt_kh);?>" id="total_amt_kh">
                                  <b><span id="total_amt_kh_text" style="float:right;"><?php echo number_format($commercialtaxDetails->total_amt_kh);?></span></b>
                                </td>

                              </tr>


                            </tfoot>
                        </table>
                      </div>
                    </div></center><br/>

                    <?php if($is_valid_to_edit == 1){ ?>
                        <button type="submit" class="btn btn-primary">Update</button>
                    <?php  } else { ?>
                        <span style="color:red;">Receipt Already Generated.</span> 
                    <?php } ?>
                    
                    <!--<button type="submit" class="btn btn-primary">Update</button>-->
                    <a href="{{ route('commercialtaxinvoicelist.commercial_tax_invoice_list') }}" class="btn btn-primary">
                        Cancel
                    </a>
                  </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


@endsection

@section('javascript')

<script type="text/javascript">
  $(function () {

    $(document).on('change','#exchange_rate', (function (e) {
      if(!$('#exchange_rate').val()){
        $('#exchange_rate_error').show();
        $('.tax_table').hide();
      } else {
        $('#exchange_rate_error').hide();
        $('.tax_table').show();
      }
    }));

    $(document).on('click','#add-more-field', (function (e) {
      e.preventDefault();  
      var table_tax_body = $('#tax_table_body');
      var tax_body_row_length = table_tax_body.find('tr').length;
      var new_row_number = tax_body_row_length+1;

      var more_fields =  '<tr id="tax_row_'+new_row_number+'"><input type="hidden" id="tax_item_amount_hidden_'+new_row_number+'" name="tax_item_amount_hidden_'+new_row_number+'" value=""><td><input type="number" style="text-align:right;width:45px;" id="tax_item_seq_no_'+new_row_number+' class="tax_item_seq_no" name="tax_item_seq_no[]" value="'+new_row_number+'"></td><td><select name="tax_item_charge_type[]" style="width:150px;" id="tax_item_charge_type_'+new_row_number+'" class="tax_item_charge_type"><option value="0">Please Select Type</option><?php foreach($commercialsettingsItems as $iyems){ ?><option value="<?php echo $iyems->id.'-'.$iyems->amount;?>" ><?php echo $iyems->tax_item_charge_type;?></option><?php } ?></select></td><td><input type="text" id="tax_item_charge_description_'+new_row_number+'"  class="tax_item_charge_description" name="tax_item_charge_description[]" value=""></td><td><input type="text" id="tax_item_quantity_'+new_row_number+'"  class="tax_item_quantity" style="text-align:right;width:50px;float:right;" name="tax_item_quantity[]" value="1.00"></td><td><input type="text" style="text-align:right;width:77px;float:right;" id="tax_item_unit_price_'+new_row_number+'" class="tax_item_unit_price"  name="tax_item_unit_price[]" value="1.00"></td><td><input type="text" style="text-align:right;width:50px;float:right;" id="tax_item_amount_'+new_row_number+'" class="tax_item_amount" name="tax_item_amount[]" value="0.00"></td><td><span class="remove_this_tax_row" class="btn btn-danger" id="remove_this_tax_row_'+new_row_number+'" style="cursor:pointer;">X</span></td></tr>';
      $(".tax_fields").append(more_fields);
    }));
    $(document).on('click','.remove_this_tax_row',function(){
      var this_row = $(this);
      var this_row_id = this_row.attr('id').substr(20);
      $('#tax_row_'+this_row_id).remove();
      var j = 1;
      $('.remove_this_tax_row').each(function(i, obj) {
          $(this).attr('id','remove_this_tax_row_'+j);
          $(this).parent().parent().attr('id','tax_row_'+j);
          $(this).parent().parent().find('td:first-child').text(j);
          j++;
      });
      calculateFooterTotals();
    });

    $(document).on('change','.tax_item_charge_type',function(){
        var this_row = $(this).attr('id');
        var this_row_id = this_row.substr(21);
        // calculatetaxes(this_row_id);
        var tax_info = $('#tax_item_charge_type_'+this_row_id).val();
        console.log('tax_info');
        // console.log(tax_info);
        // var tax_ar = tax_info.split("-");
        // var amount = tax_ar[1];
        var amount = 0;
        $('#tax_item_amount_hidden_'+this_row_id).val(amount);
        calculatetaxes(this_row_id);
      });

      $(document).on('change','.tax_item_quantity',function(){
        var this_row = $(this).attr('id');
        var this_row_id = this_row.substr(18);
        // resetFooters();
        calculatetaxes(this_row_id);
      });

      $(document).on('change','.tax_item_unit_price',function(){
        var this_row = $(this).attr('id');
        var this_row_id = this_row.substr(20);
        // resetFooters();
        calculatetaxes(this_row_id);
      });

      function resetFooters(){
        $('#total_amount_usd_text').text('0.00');
        $('#total_amount_kh_text').text('0.00');
        $('#total_amt_usd_text').text('0.00');
        $('#total_amt_kh_text').text('0.00');
      }

    function calculatetaxes(row_no){
      var sc = $('#tax_item_amount_hidden_'+row_no).val();

      //get entered qty
      var qty = $('#tax_item_quantity_'+row_no).val();

      //get unit price
      var unitprice = $('#tax_item_unit_price_'+row_no).val();
     
      //for total amount
      var total_amt = parseFloat(unitprice) * parseFloat(qty);
  
      //for service charge taxes
      var pre_amount_charge = parseFloat(total_amt);
    //   var final_amount_charge = (parseFloat(pre_amount_charge/100)).toFixed(2);
    var final_amount_charge = (parseFloat(pre_amount_charge)).toFixed(2);
      $('#tax_amount_'+row_no).val(final_amount_charge);

      //for final amount
      var final_amount = parseFloat(total_amt);
      var final_total_amt =  parseFloat(final_amount).toFixed(2);
      $('#tax_item_amount_'+row_no).val(final_total_amt);

      calculateFooterTotals();
    }

    function calculateFooterTotals(){
      //get pre defined exchange rate
      // var exchange_rate = "<?php echo $commercialsettings->exchange_rate; ?>";
      var exchange_rate = $('#exchange_rate').val();
      // alert(exchange_rate);
      //for usd
      var tax_item_total_amount = 0;
      $('.tax_amount').each(function(){
        tax_item_total_amount += parseFloat(this.value);
      });
      $('#total_amount_usd_text').text(tax_item_total_amount.toFixed(2));
      $('#total_amount_usd').val(tax_item_total_amount);

      //for khmer
      var new_total_amount_kh =  parseFloat(tax_item_total_amount) * parseFloat(exchange_rate);
      $('#total_amount_kh_text').text(new_total_amount_kh);
      $('#total_amount_kh').val(new_total_amount_kh);
      
      //for usd
      var tax_item_amount = 0;
      $('.tax_item_amount').each(function(){
        tax_item_amount += parseFloat(this.value);
      });
      $('#total_amt_usd_text').text(tax_item_amount.toFixed(2));
      $('#total_amt_usd').val(tax_item_amount);

      //for khmer
      var new_total_amt_kh =  parseFloat(tax_item_amount) * parseFloat(exchange_rate);
      $('#total_amt_kh_text').text(new_total_amt_kh);
      $('#total_amt_kh').val(new_total_amt_kh);
    }
  });
</script>
@endsection