@extends('dashboard.base')
@section('css')

@endsection
@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Commercial Settings</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                @endif      

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif      
           
                <form method="POST" action="{{ route('commercialtaxsettings.store') }}"  enctype="multipart/form-data">
                    @csrf
                    <input name="marker" value="selectModel" type="hidden">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Select Property</label>
                                <select class="form-control" name="property_id" id="property_id">
                                    <option value="0">Please select</option>
                                    @foreach($properties as $property)
                                        <option value="{{ $property->id }}">{{ $property->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 show_tax_details" style="margin-top: 34px; display:none;">
                            <div class="form-group">
                                <label style="padding-right: 7px;">Sequence No</label>
                                <input type="text" style="width: 47px;" name="curr_tax_year" value="<?php echo $curr_year; ?>" readonly><span style="padding:-3px;"> -</span>
                                <input type="number" style="margin-top: -38px;margin-left: 196px;" placeholder="Enter Sequence No" name="tax_seq_no" value="<?php echo $tax_seq_no;?>" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row show_tax_details" style="display:none;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 1</label>
                                <input type="text" placeholder="Enter Footer Text 1"  name="footer_text_1" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 2</label>
                                <input type="text" placeholder="Enter Footer Text 2" name="footer_text_2" class="form-control" >
                            </div>
                        </div>
                    </div>
                    <div class="row show_tax_details" style="display:none;" >
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Header Logo</label>
                                <input type="file" name="header_logo" class="form-control" >
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Logo</label>
                                <input type="file" name="footer_logo" class="form-control" >
                            </div>
                        </div>
                    </div><hr/>


                    <div class="row show_tax_details" style="display:none;">
                        <div class="col-md-12">
                            <div class="form-group">
                                <h4> Items:</h4><br/>
                                <button id="add-more-field" style="float:left;" class="btn btn-primary btn-sm" type="button">Add More +</button>
                            </div>
                        </div>
                    </div><br/>

                    
                    <div class="row show_tax_details" style="max-width:50%;overflow-x: auto; white-space: nowrap;display:none;">
                        <div class="col-md-12">
                            <div class="col-md-2"></div>
                            <div class="col-md-8">
                            <table class="table table-bordered data-table" >
                                <thead>
                                    <tr>
                                        <th>Charge Type</th>
                                        <!--<th>Amount ($)</th>-->
                                    </tr>
                                </thead>
                                <tbody class="tax_fields" id="tax_table_body">
                                    <tr>
                                        <td><input type="text" id="tax_item_charge_type_1" style="text-align:left;" class="tax_item_charge_type" name="tax_item_charge_type[]" value=""></td>
                                        <!--<td><input type="text" id="tax_item_amount_1" style="text-align:right;" class="tax_item_amount" name="tax_item_amount[]" value="0"></td>-->
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-md-2"></div>
                    </div><br/>


                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('commercialtaxsettings.index') }}" class="btn btn-primary">
                        Cancel
                    </a>
                </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">
  $(function () {
    $(document).on('change','#property_id', (function (e) {
        if($('#property_id').val() == 0){
            $('.show_tax_details').hide(); 
        } else {
            $('.show_tax_details').show(); 
        }
    }));

    $(document).on('click','#add-more-field', (function (e) {
        e.preventDefault();  
        var table_tax_body = $('#tax_table_body');
        var tax_body_row_length = table_tax_body.find('tr').length;
        var new_row_number = tax_body_row_length+1;
        var more_fields =  '<tr id="tax_row_'+new_row_number+'"><td><input type="text"  id="tax_item_charge_type_'+new_row_number+'" class="tax_item_charge_type"  name="tax_item_charge_type[]" value=""></td><td><span class="remove_this_tax_row" class="btn btn-danger" id="remove_this_tax_row_'+new_row_number+'" style="cursor:pointer;">X</span></td></tr>';
        $(".tax_fields").append(more_fields);
    }));

    $(document).on('click','.remove_this_tax_row',function(){
        var this_row = $(this);
        var this_row_id = this_row.attr('id').substr(20);
        $('#tax_row_'+this_row_id).remove();
        var j = 1;
        $('.remove_this_tax_row').each(function(i, obj) {
            $(this).attr('id','remove_this_tax_row_'+j);
            $(this).parent().parent().attr('id','tax_row_'+j);
            $(this).parent().parent().find('td:first-child').text(j);
            j++;
        });
    });

});
</script>
@endsection