@extends('dashboard.base')
@section('css')

@endsection
@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Commercial Receipt Settings</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                @endif      

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif 
                <form method="POST" id="basic_info" action="/commercialreceiptsettings/{{ $receipt->id }}"  enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                     <?php 
                        $base_url = URL('/');

                        $headerpath = $base_url.'/public/storage/uploads/hotel_admins/'.$receipt->created_by.'/commercial_receipt_settings'.'/'.$receipt->header_logo;
    
                        $footerpath = $base_url.'/public/storage/uploads/hotel_admins/'.$receipt->created_by.'/commercial_receipt_settings'.'/'.$receipt->footer_logo;
    
                    ?>
                    
                    
                    <input name="marker" value="selectModel" type="hidden">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Select Property</label>
                                <select class="form-control" name="property_id" id="property_id">
                                    <option value="0">Please select</option>
                                    @foreach($properties as $property)
                                        <option value="{{ $property->id }}" <?php if($receipt->property_id == $property->id ){ echo "selected";}?>>{{ $property->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" placeholder="Enter Title" value="<?php echo $receipt->title; ?>" name="title" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Header Logo</label>
                                <input type="file" name="header_logo" class="form-control" >
                                <a href='<?php echo $headerpath;?>' target="_blank">View</a>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Footer Logo</label>
                                <input type="file" name="footer_logo" class="form-control" >
                                 <a href='<?php echo $footerpath;?>' target="_blank">View</a>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 1</label>
                                <input type="text" placeholder="Enter Footer Text 1" value="<?php echo $receipt->footer_text_1; ?>"  name="footer_text_1" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 2</label>
                                <input type="text" placeholder="Enter Footer Text 2" value="<?php echo $receipt->footer_text_2; ?>" name="footer_text_2" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('commercialreceiptsettings.index') }}" class="btn btn-primary">
                        Cancel
                    </a>
                </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')
<script type="text/javascript">
  $(function () {
    $(document).on('change','#property_id', (function (e) {
        if($('#property_id').val() == 0){
            $('.show_tax_details').hide(); 
        } else {
            $('.show_tax_details').show(); 
        }
    }));
});
</script>
@endsection