@extends('dashboard.base')
@section('css')

@endsection
@section('content')

<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
          <div class="card-header"><h4>Commercial Receipt Settings</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                @endif      

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif      
           
                <form method="POST" action="{{ route('commercialreceiptsettings.store') }}"  enctype="multipart/form-data">
                    @csrf
                    <input name="marker" value="selectModel" type="hidden">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Select Property</label>
                                <select class="form-control" name="property_id" id="property_id">
                                    <option value="0">Please select</option>
                                    @foreach($properties as $property)
                                        <option value="{{ $property->id }}">{{ $property->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3 show_tax_details" style="display:none;">
                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" placeholder="Enter Title" name="title" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row show_tax_details" style="display:none;" >
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Header Logo</label>
                                <input type="file" name="header_logo" class="form-control" >
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Logo</label>
                                <input type="file" name="footer_logo" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row show_tax_details" style="display:none;">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 1</label>
                                <input type="text" placeholder="Enter Footer Text 1"  name="footer_text_1" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Footer Text 2</label>
                                <input type="text" placeholder="Enter Footer Text 2" name="footer_text_2" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('commercialreceiptsettings.index') }}" class="btn btn-primary">
                        Cancel
                    </a>
                </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

<script type="text/javascript">
  $(function () {
    $(document).on('change','#property_id', (function (e) {
        if($('#property_id').val() == 0){
            $('.show_tax_details').hide(); 
        } else {
            $('.show_tax_details').show(); 
        }
    }));
});
</script>
@endsection