
@extends('dashboard.base')

@section('css')

@endsection

@section('content')


<div class="container-fluid">
  <div class="fade-in">
    <div class="row">
      <div class="col-sm-12">
        <div class="card">
        <div class="card-header"><h4>Add Blacklist</h4></div>
            <div class="card-body">
                @if(Session::has('message'))
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
                        </div>
                    </div>
                 @endif     

                 @if ($errors->any())
                      <div class="alert alert-danger">
                          <ul>
                              @foreach ($errors->all() as $error)
                                  <li>{{ $error }}</li>
                              @endforeach
                          </ul>
                      </div>
                  @endif

                  <form method="POST" action="{{ route('blacklists.store') }}"  enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Name*</label>
                                <input type="text" required placeholder="Enter Name" name="name" class="form-control" >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Passport No.*</label>
                                <input type="text" required placeholder="Enter Passport No." name="passport_no" class="form-control" >
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Date Of Birth*</label>
                                <input type="date" required placeholder="Enter Dob" name="date_of_birth" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Nationality*</label>
                                <select class="form-control " name="nationality" id="nationality_main" required>
                                    <option value="0">Please select Nationality*</option>
                                    @foreach($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Select Property*</label>
                                <select class="form-control" name="property_id" id="property">
                                    <option value="0">Please select Property</option>
                                    @foreach($properties as $property)
                                    <option value="{{ $property->id }}">{{ $property->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Reason</label>
                                <textarea placeholder="Enter Reason" cols='5' rows='3' name="reason" id="reason"  class="form-control"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Block Status</label>
                                <select class="form-control " name="block_status" id="block_status">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Complaint Type</label>
                                <select class="form-control " name="complaint_type" id="complaint_type">
                                    <option value="0">Please select Type</option>
                                    @foreach($complaint_types as $type)
                                        <option value="{{ $type->id }}">{{ $type->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Severity</label>
                                <select class="form-control " name="severity" id="severity">
                                    <option value="0">Please select severity</option>
                                    <option value="5">5 (Very Serious)</option>
                                    <option value="4">4 (Serious)</option>
                                    <option value="3">3 (Major)</option>
                                    <option value="2">2 (Minor)</option>
                                    <option value="1">1 (Very Minor)</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Action Taken</label>
                                <textarea placeholder="Enter Action Taken" cols='5' rows='3' name="action_taken" id="action_taken"  class="form-control"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Share To Other Hotels</label>
                                <select class="form-control " name="share_to_other_hotel_status" id="share_to_other_hotel_status">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Submit</button>
                    <a href="{{ route('blacklists.index') }}" class="btn btn-primary">
                      Cancel
                    </a>
                  </form>

            </div><br/><br/><br/><br/>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('javascript')

@endsection