<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;
use Illuminate\Support\Str;
use App\Models\Modules;

class ModulesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $numberOfUsers = 10;
        $numberOfNotes = 100;
        $usersIds = array();
        $statusIds = array();
        $faker = Faker::create();

        /* Truncate all previous rows and insert new rows to avoid double entries */
         Modules::truncate();

         /* Create modules */
         DB::table('modules')->insert(['module_name' => 'Hotel Admins','created_by'=>1]);
         DB::table('modules')->insert(['module_name' => 'Properties']);
         DB::table('modules')->insert(['module_name' => 'Govt. Admins','created_by'=>1]);
         DB::table('modules')->insert(['module_name' => 'Rooms']);
         DB::table('modules')->insert(['module_name' => 'Customers']);
         DB::table('modules')->insert(['module_name' => 'Groups']);
         DB::table('modules')->insert(['module_name' => 'Staffs']);
         DB::table('modules')->insert(['module_name' => 'ID Proof Type']);
      
    }
}


