<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePbxSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pbx_settings', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();
            $table->string('property_id')->nullable();
            $table->string('ip_or_url')->nullable();
            $table->string('extension')->nullable();
            $table->string('password')->nullable();
            $table->integer('created_by')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pbx_settings');
    }
}
