<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCustomersTaxInvoiceItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_customers_tax_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->string('tax_invoice_row_id')->nullable();
            $table->string('tax_item_seq_no')->nullable();
            $table->string('tax_item_guest_id')->nullable();
            $table->string('tax_item_charge_type')->nullable();
            $table->string('tax_item_charge_description')->nullable();
            $table->string('tax_item_quantity')->nullable();
            $table->string('tax_item_unit_price')->nullable();
            $table->string('tax_item_amount')->nullable();
            $table->integer('created_by')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_customers_tax_invoice_items');
    }
}
