<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTblCustomersTaxInvoiceDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tbl_customers_tax_invoice_details', function (Blueprint $table) {
            $table->id();
            $table->string('tax_row_id')->nullable();
            $table->string('customer_id')->nullable();
            $table->string('company_name')->nullable();
            $table->string('guest_name')->nullable();
            $table->string('guest_address')->nullable();
            $table->string('guest_mobile')->nullable();
            $table->string('guest_vat_tin_no')->nullable();
            $table->integer('created_by')->unsigned();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbl_customers_tax_invoice_details');
    }
}
