<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateComplaintsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('complaints', function (Blueprint $table) {
            $table->id();
            $table->string('complaint_against')->nullable();
            $table->string('complaint_from')->nullable();
            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->string('document')->nullable();
            $table->string('complaint_type')->nullable();
            $table->string('complaint_rating')->nullable();
            $table->string('complaint_status')->nullable();
            $table->string('action_taken')->nullable();
            $table->string('created_by')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('complaints');
    }
}
