<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStaffsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staffs', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email');
            $table->string('designation')->nullable();
            $table->string('mobile')->nullable();
            $table->string('password')->nullable();
            $table->string('org_password')->nullable();
            $table->string('group_id')->default('0');
            $table->string('assigned_pin')->nullable();
            $table->integer('main_user_id')->unsigned();
            $table->integer('users_type')->unsigned();
            $table->integer('status_id')->unsigned();
            $table->string('created_by','10')->nullable();
            $table->softDeletes();
            $table->timestamps();
        });   
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('staffs');
    }
}
