<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\IdProofTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Properties;
use DataTables;

class todaysCheckoutsController extends Controller
{
    public function index(Request $request){
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        //check if logged in user in govt admin staff for property filter
        if($user_type == 3 || $user_type == 5 || $user_type == 6){ //govt admin staff
            $propertiesq = Properties::where('status_id','1');
            if($user_type == 3){
                $propertiesq->where('created_by',$main_id);
            }
            $properties = $propertiesq->get();
        } else {
            $properties = array();
        }
        return view('dashboard.todayscheckouts.todayscheckouts',['properties'=>$properties]);
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        return view('dashboard.idprooftypes.create');
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

        //insert new type
        $type = new IdProofTypes();
        $type->title    = $request->input('title');
        $type->description   =  $request->input('description');
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'ID Proof Type Created Successfully.');
        return redirect()->route('idprooftypes.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $id_proof_type = IdProofTypes::find($id);
        return view('dashboard.idprooftypes.edit', [ 'type' => $id_proof_type ]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

          //insert new type
          $type = IdProofTypes::find($id);
          $type->title    = $request->input('title');
          $type->description   =  $request->input('description');
          $type->save();

        $request->session()->flash('message', 'ID Proof Type Updated Successfully');
        return redirect()->route('idprooftypes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $type = IdProofTypes::find($id);
        if($type){
            $type->delete();
        }
        return redirect()->route('idprooftypes.index');
    }

    
}
