<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use App\Models\HotelAdmin;
use App\Models\Visitors;
use App\Models\Properties;
use App\Models\VisitorImages;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;

class VisitorsController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = Auth::user()->id;
        $data = Visitors::orderBy('id','desc')->get();
       

        foreach($data as $visit){
            $visit->visit_in_date_time    = $visit->visit_in_date.' '.$visit->visit_in_time;
            $visit->visit_out_date_time    = $visit->visit_out_date.' '.$visit->visit_out_time;
        }
        if ($request->ajax()) {
            // $action =  '<a href="/visitorslist/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
            $action =  '<a href="/visitorslist/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
           return Datatables::of($data)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.visitorslist.visitorsList');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::all(); 
        $main_id = Auth::user()->id ;
        $curr_date = date('Y-m-d');
        $curr_time = date('H:i');
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        
        return view('dashboard.visitorslist.create',['curr_date'=>$curr_date,'curr_time'=>$curr_time,'properties'=>$properties]);
    }

       /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name'          => 'required',
            'title'   => 'required',
            'company'   => 'required',
            'property_id'     => 'required',
            // 'visitor_image'         => '/mimes:jpeg,png,jpg|min:1|max:1000',
        ]);

    //   echo "<pre>";print_R($request->all());exit;

        //insert new criminal record
        $record = new Visitors();
        $record->name    = $request->input('name');
        $record->title      = $request->input('title');
        $record->company     = $request->input('company');
        $record->property_id      = $request->input('property_id');
        $record->reason    = $request->input('reason');
        $record->visit_in_date    = $request->input('visit_in_date');
        $record->visit_in_time    = $request->input('visit_in_time');
        $record->visit_out_date    = $request->input('visit_out_date');
        $record->visit_out_time         = $request->input('visit_out_time');
        $record->remark	= $request->input('remark');
        $record->telephone            = $request->input('telephone');
        $record->visiting_whoom         = $request->input('visiting_whoom');
        $record->qr_code   =  $request->input('qr_code');
        // $record->visitor_image   =  $headerfileNameToStore; 
        $record->created_by     = Auth::user()->id;
        $record->save();
        $visitor_id = $record->id;

        //for complaint document
        
        $img_ar = array();
        $headerfileNameToStore = '';
        $headerimg = '';
        foreach($request->file('visitor_image') as $file){

            $headerfilenameWithExt = $file->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $file->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $file->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/visitors', $headerfileNameToStore);
        
            $visitor_iamge = new VisitorImages();
            $visitor_iamge->visitor_id = $visitor_id;
            $visitor_iamge->image = $headerfileNameToStore;
            // echo "<pre>";print_r();exit;
            $visitor_iamge->save();
        }
        
        $request->session()->flash('message', 'Record Created Successfully.');
        return redirect()->route('visitorslist.index');
    }

    //for editing criminal record
    public function edit($id)
    {
        $visitor = Visitors::find($id);
        $main_id = Auth::user()->id ;
       
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        
        $images = DB::table('tbl_visitor_images')->where('visitor_id',$id)->where('deleted_at',null)->get();

        $baseUrl = url('/');
        // $visitor->visitor_image = $baseUrl.'/public/storage/uploads/visitors/'. $visitor->visitor_image;
       
        return view('dashboard.visitorslist.edit', [ 'visitor' => $visitor,'properties' => $properties,'images' => $images]);
    }
    
 /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name'          => 'required',
            'title'   => 'required',
            'company'   => 'required',
            'property_id'     => 'required',
            // 'visitor_image'         => 'mimes:jpeg,png,jpg|min:1|max:1000',
        ]);


         // create or update file in directory if exists 
         $path = public_path('storage/uploads/hotel_admins/visitors');
         if(!File::isDirectory($path)){
             File::makeDirectory($path, 0777, true, true);
         }
         
        //get requested rcord id
        $record = Visitors::find($id);
        //for criminal image


        $img_ar = array();
        $headerfileNameToStore = '';
        $headerimg = '';
        foreach($request->file('visitor_image') as $file){

            $headerfilenameWithExt = $file->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $file->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'Visitor_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $file->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/visitors', $headerfileNameToStore);
        
            $visitor_iamge = new VisitorImages();
            $visitor_iamge->visitor_id = $id;
            $visitor_iamge->image = $headerfileNameToStore;
            // echo "<pre>";print_r();exit;
            $visitor_iamge->save();
        }

        $record->name    = $request->input('name');
        $record->title      = $request->input('title');
        $record->company     = $request->input('company');
        $record->property_id      = $request->input('property_id');
        $record->reason    = $request->input('reason');
        $record->visit_in_date    = $request->input('visit_in_date');
        $record->visit_in_time    = $request->input('visit_in_time');
        $record->visit_out_date    = $request->input('visit_out_date');
        $record->visit_out_time         = $request->input('visit_out_time');
        $record->remark	= $request->input('remark');
        $record->telephone            = $request->input('telephone');
        $record->visiting_whoom         = $request->input('visiting_whoom');
        // $record->visitor_image         = $fileNameToStore;
        $record->visitor_image   =  $headerfileNameToStore; 
        $record->qr_code   =  $request->input('qr_code');
        $record->created_by     = Auth::user()->id;
        // echo "<pre>";print_r($record);exit;
        $record->save();

        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('visitorslist.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $record = Visitors::find($id);
        if($record){
            $existing_file_path = public_path('storage/uploads/visitors/'.$record->image);
            $trash_file_path_dir = public_path('storage/trash/visitors/'.$record->image);
            File::move($existing_file_path, $trash_file_path_dir);
            $record->delete();
        }
        return redirect()->route('visitorslist.index');
    }

}
