<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use App\Models\HotelAdmin;
use App\Models\Visitors;
use App\Models\Properties;
use App\Models\Customers;
use App\Models\Tax;
use App\Models\TaxDetails;
use App\Models\TaxInvoiceItems;
use App\Models\TaxSettingsItems;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;
use PDF;


class TaxController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = Auth::user()->id;
        $dataq = DB::table('tbl_tax_settings as tx')->select('tx.id','tx.service_charge','tx.accomodation_tax','tx.vat','tx.exchange_rate','tx.property_id','pr.name');
        $dataq->join('properties as pr','pr.id','=','tx.property_id','left');
        $data = $dataq->orderBy('tx.id','desc')->where('tx.created_by',$main_id)->get();
        if ($request->ajax()) {
            $action =  '<a href="/taxsettings/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
           return Datatables::of($data)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.taxsettings.taxsettingsList');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::all(); 
        $main_id = Auth::user()->id ;
        $curr_year = date('Y');
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        $tax_seq_no = '00001';   
        return view('dashboard.taxsettings.create',['curr_year'=>$curr_year,'properties'=>$properties,'tax_seq_no'=>$tax_seq_no]);
    }

       /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'property_id'          => 'required',
            'tax_seq_no'   => 'required',
        ]);

        $data = $request->all();
        //for tax header
        if ($request->hasFile('header_logo')) {

            $headerfilenameWithExt = $request->file('header_logo')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('header_logo')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'tax_header_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('header_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/tax_settings', $headerfileNameToStore);    
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }

        //for tax footer
        if ($request->hasFile('footer_logo')) {

            $footerfilenameWithExt = $request->file('footer_logo')->getClientOriginalName ();
            // Get Filename
            $footerfilename = pathinfo($footerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $footerextension = $request->file('footer_logo')->getClientOriginalExtension();
            // Filename To store
            $footerfileNameToStore = 'tax_footer_'.$footerfilename. '_'. time().'.'.$footerextension;
            // Upload Image$path = 
            $footerimg = $request->file('footer_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/tax_settings', $footerfileNameToStore);    
        } else {
            $footerfileNameToStore = '';
            $footerimg = '';
        }

        //insert new criminal record
        $record = new Tax();
        $record->property_id      = $request->input('property_id');
        $record->tax_seq_no    =  $request->input('tax_seq_no');
        $record->exchange_rate    = $request->input('exchange_rate');
        $record->header_logo   =  $headerfileNameToStore; 
        $record->footer_logo   =  $footerfileNameToStore; 
        $record->footer_text_1    = $request->input('footer_text_1');
        $record->footer_text_2    = $request->input('footer_text_2');
        $record->created_by     = Auth::user()->id;
        $record->save();
        $tax_settings_id = $record->id;
        $seq = 0;
        //echo "<pre>";print_r($tax_detail_id);exit; 

        foreach( $data['tax_item_charge_type'] as $seqkey => $seqk){
            $invoiceitems = new TaxSettingsItems();
            $invoiceitems->tax_settings_id = $tax_settings_id;
            $invoiceitems->tax_item_charge_type =  $data['tax_item_charge_type'][$seq];
            $invoiceitems->service_tax =  $data['tax_item_sc'][$seq];
            $invoiceitems->accomodation_tax =  $data['tax_item_at'][$seq];
            $invoiceitems->vat =  $data['tax_item_vat'][$seq];
            $invoiceitems->save();
            $seq++;
        }
        $request->session()->flash('message', 'Record Created Successfully.');
        return redirect()->route('taxsettings.index');
    }

    //for editing criminal record
    public function edit($id)
    {
        $tax = Tax::find($id);
        $curr_year = date('Y');
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $taxsettingsItems = TaxSettingsItems::where('tax_settings_id',$id)->get();
        
        $baseUrl = url('/');
        // $visitor->visitor_image = $baseUrl.'/public/storage/uploads/visitors/'. $visitor->visitor_image;
        return view('dashboard.taxsettings.edit', [ 'tax' => $tax,'properties' => $properties,'curr_year'=> $curr_year,'taxsettingsItems' => $taxsettingsItems]);
    }
    
 /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'property_id'          => 'required',
            'tax_seq_no'   => 'required',
        ]);

         // create or update file in directory if exists 
         $path = public_path('storage/uploads/hotel_admins/tax_settings');
         if(!File::isDirectory($path)){
             File::makeDirectory($path, 0777, true, true);
         }
         
        //get requested rcord id
        $record = Tax::find($id);
        $data = $request->all();
        //for tax header
        if (array_key_exists('header_logo',$data) != false && $request->hasFile('header_logo')) {

            $headerfilenameWithExt = $request->file('header_logo')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('header_logo')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'tax_header_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $record->header_logo   =  $headerfileNameToStore; 
            $headerimg = $request->file('header_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/tax_settings', $headerfileNameToStore);    
       
        }

        //for tax footer
        if (array_key_exists('footer_logo',$data) != false && $request->hasFile('footer_logo')) {

            $footerfilenameWithExt = $request->file('footer_logo')->getClientOriginalName ();
            // Get Filename
            $footerfilename = pathinfo($footerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $footerextension = $request->file('footer_logo')->getClientOriginalExtension();
            // Filename To store
            $footerfileNameToStore = 'tax_footer_'.$footerfilename. '_'. time().'.'.$footerextension;
            // Upload Image$path = 
            $footerimg = $request->file('footer_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/tax_settings', $footerfileNameToStore);    
            $record->footer_logo   =  $footerfileNameToStore;
        } 
        $record->property_id      = $request->input('property_id');
        $record->tax_seq_no    = $request->input('tax_seq_no');
        $record->service_charge    = $request->input('service_charge');
        $record->accomodation_tax    = $request->input('accomodation_tax');
        $record->vat    = $request->input('vat');
        $record->exchange_rate    = $request->input('exchange_rate');
         
        $record->footer_text_1    = $request->input('footer_text_1');
        $record->footer_text_2    = $request->input('footer_text_2');
        $record->updated_by     = Auth::user()->id;
        $record->save();

        $taxitemsdel = DB::table('tbl_tax_settings_items')->where('tax_settings_id', $id)->delete(); 
        $seq = 0;
        foreach( $data['tax_item_charge_type'] as $seqkey => $seqk){
            $invoiceitems = new TaxSettingsItems();
            $invoiceitems->tax_settings_id = $id;
            $invoiceitems->tax_item_charge_type =  $data['tax_item_charge_type'][$seq];
            $invoiceitems->service_tax =  $data['tax_item_sc'][$seq];
            $invoiceitems->accomodation_tax =  $data['tax_item_at'][$seq];
            $invoiceitems->vat =  $data['tax_item_vat'][$seq];
            $invoiceitems->save();
            $seq++;
        }

        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('taxsettings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $record = Tax::find($id);
        if($record){
            $record->delete();
        }
        return redirect()->route('taxsettings.index');
    }

    public function show(Request $request)
    {   
       $data = $request->all();
        if(array_key_exists('is_tax_invoice',$data) == true){
            return  $this->generateTaxInvoice($data);
        }
    }
    
    public function generateTaxInvoice($data)
    { 
        $cust_id = base64_decode($data['cust_id']);
        $customer = Customers::find($cust_id);
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $taxsettings = Tax::where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        $taxsettingsItems = TaxSettingsItems::where('tax_settings_id',$taxsettings->id)->get();
        // echo "<pre>";print_r($taxsettingsItems);exit; 

        // $taxsettintax_details_exists = DB::table('tbl_customers_tax_invoice_details')->where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        // if(empty($taxsettintax_details_exists)){
            $tx_inv_no = date('Y-m-d').'-00001';
        // } else {
        //     $existing_inv_no_ar =  explode('-',$taxsettintax_details_exists->invoice_no);
        //     $inv_no_suffix = $existing_inv_no_ar[3];
        //     $tx_inv_no = date('Y-m-d').'-'.$inv_no_suffix+1;
        // }
        // echo "<pre>";print_r($tx_inv_no);exit; 

        $curr_time = date('H:i');
        
        return view('dashboard.taxsettings.taxinvoicepreview', ['customer' => $customer,'taxsettings'=>$taxsettings,'taxsettingsItems' => $taxsettingsItems,'tx_inv_no'=>$tx_inv_no,'curr_time' => $curr_time]);
    }
    
    public function customer_tax_invoice(Request $request)
    {
        ini_set('max_execution_time', 180); //3 minutes
        $data = $request->all();
        
        
        $tax_set = TAX::find($data['tax_row_id']);
        // echo "<pre>";print_r($data);exit;
        $taxsettintax_details_exists = DB::table('tbl_customers_tax_invoice_details')->where('customer_id',$data['customer_id'])->first();
        if(!empty($taxsettintax_details_exists)){
            $tax_record = TaxDetails::find($taxsettintax_details_exists->id);
        } else {
            $tax_record = new TaxDetails();
            $tax_record->created_by = Auth::user()->id;
        }

        $tax_record->customer_id = $data['customer_id'];
        $tax_record->property_id = $tax_set->property_id;
        $tax_record->tax_row_id = $data['tax_row_id'];
        $tax_record->company_name = $data['company_name'];
        $tax_record->invoice_no = $data['invoice_no'];
        $tax_record->guest_name = $data['guest_name'];
        $tax_record->invoice_date = $data['invoice_date'];
        $tax_record->guest_code = $data['guest_code'];
        $tax_record->exchange_rate = $data['exchange_rate'];
        $tax_record->guest_address = $data['guest_address'];
        $tax_record->guest_checkindate_time = $data['checkout_date'].' '.$data['checkin_time'];
        $tax_record->guest_mobile = $data['guest_mobile'];
        $tax_record->guest_checkoutdate_time = $data['checkout_date'].' '.$data['checkout_time'];
        $tax_record->guest_vat_tin_no = $data['guest_vat_tin_no'];
        $tax_record->total_sc_usd = $data['total_sc_usd'];
        $tax_record->total_at_usd = $data['total_at_usd'];
        $tax_record->total_vat_usd = $data['total_vat_usd'];
        $tax_record->total_amt_usd = $data['total_amt_usd'];
        $tax_record->total_sc_kh = $data['total_sc_kh'];
        $tax_record->total_at_kh = $data['total_at_kh'];
        $tax_record->total_vat_kh = $data['total_vat_kh'];
        $tax_record->total_amt_kh = $data['total_amt_kh'];
        $tax_record->save();
        if(!empty($taxsettintax_details_exists)){
            $tax_detail_id = $taxsettintax_details_exists->id;
        } else {
            $tax_detail_id = $tax_record->id;
        }
        $taxitemsdel = DB::table('tbl_customers_tax_invoice_items')->where('tax_detail_id', $tax_detail_id)->delete(); 
        $seq = 0;
    //    echo "<pre>";print_r($tax_detail_id);exit; 

        foreach( $data['tax_item_seq_no'] as $seqkey => $seqk){

            $item_str_ar = explode('-',$data['tax_item_charge_type'][$seq]);
            $taxsettingsItems = TaxSettingsItems::where('id',$item_str_ar[0])->first();

            $invoiceitems = new TaxInvoiceItems();
            $invoiceitems->tax_detail_id = $tax_detail_id;
            $invoiceitems->tax_customer_id = $data['customer_id'];;
            $invoiceitems->tax_item_seq_no =  $data['tax_item_seq_no'][$seq];
            // $invoiceitems->tax_item_guest_id =  $data['tax_item_guest_id'][$seq];
            $invoiceitems->tax_item_charge_type =  $item_str_ar[0];
            $invoiceitems->tax_item_charge_type_name =  $taxsettingsItems->tax_item_charge_type;
            $invoiceitems->tax_item_charge_description =  $data['tax_item_charge_description'][$seq];
            $invoiceitems->tax_item_quantity =  $data['tax_item_quantity'][$seq];
            $invoiceitems->tax_item_unit_price =  $data['tax_item_unit_price'][$seq];
            $invoiceitems->tax_item_sc =  $data['tax_item_sc'][$seq];
            $invoiceitems->tax_item_at =  $data['tax_item_at'][$seq];
            $invoiceitems->tax_item_vat =  $data['tax_item_vat'][$seq];
            $invoiceitems->tax_item_amount =  $data['tax_item_amount'][$seq];
            $invoiceitems->save();
            $seq++;
        }

        $filename = "tax_invoice";
        $ar['taxsettings'] = Tax::find($data['tax_row_id']);
        $ar['taxDetails'] = TaxDetails::find($tax_detail_id);
        $ar['taxInvoiceItems'] = DB::table('tbl_customers_tax_invoice_items')->where('tax_detail_id',$tax_detail_id)->get();
        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('taxinvoicelist.tax_invoice_list');

        // $pdf = PDF::loadView('dashboard.taxsettings.invoice',$ar);
        // return $pdf->download('disney.pdf');
        echo "<pre>";print_r($data);exit; 
    }
     

    public function tax_invoice_list(Request $request){ echo "ddddd";exit;
        $datas = $request->all();
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.taxsettings.taxinvoicelist',['properties'=>$properties]);
    }
    

}
