<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\Staffs;
use App\Models\Groups;
use App\Models\Properties;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use DataTables;
use App\Models\HotelAdmin;
use App\Models\GovAdmin;
use File;

class StaffsController extends Controller
{
    public function index(Request $request){
     
        if(Auth::user()->user_type == 3){
            $users_type = '4';
        } else {
            $users_type = '6';
        }

        $data = Staffs::where('users_type',$users_type)->where('created_by',Auth::user()->id)->orderBy('id','desc')->get();

        //show pin dropdown filter only for govt aadmin and govt admin staff
        $pincodes_array = array();
        if(Auth::user()->user_type == 5 || Auth::user()->user_type == 6){
                $pincodes_array = DB::table('properties')->select('pin')->where('status_id','1')->distinct()->get();
        } 
       
        if ($request->ajax()) { //users_type = 4 here is hotel admin staff
            
                foreach($data as $staff){
                    //create full name 
                    $staff->first_name =  $staff->first_name.' '.$staff->last_name;

                    //get group name
                    $group_details = Groups::find($staff->group_id);
                    $staff->group_id = $group_details->group_name;
                    
                    //status active / in-active
                    if($staff->status_id == 1){
                        $staff->status_id = 'Active';
                    } else {
                        $staff->status_id = 'In-Active'; 
                    }
                    $id = $staff->id;
                }
                return Datatables::of($data)
                        ->addColumn('action', '<a href="/staffs/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        // ->addColumn('action', '<a href="/hoteladmins/{{$id}}/edit" style="width: 51px;padding: 7px;"><i class="fa fa-edit" style="font-size: 20px;"></i></a> <a class="btn btn-danger" onclick="return confirm("Are you sure?")" href="/hoteladmins/delete/"><i class="fa fa-trash"></i></a>')
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.staffs.staffsList',['pincodes'=>$pincodes_array]);
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $main_id = Auth::user()->id;
        
        if(Auth::user()->user_type == 3){
            $groups = Groups::where('created_by',$main_id)->orderBy('id','desc')->get();
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $properties = Properties::where('status_id','1')->where('owner',$h_admin->id)->get();    
        } else {
            $groups = Groups::orderBy('id','desc')->get();
            $g_admin = GovAdmin::where('main_user_id',$main_id)->get();
            $properties = Properties::where('status_id','1')->where('created_by',$main_id)->get();    
        }
        
        
       
        //show pin dropdown filter only for govt aadmin and govt admin staff
        $pincodes_array = array();
        if(Auth::user()->user_type == 5 || Auth::user()->user_type == 6){
             $pincodes_array = DB::table('properties')->select('pin')->where('status_id','1')->distinct()->get();
        } 

        return view('dashboard.staffs.create',['groups'=>$groups,'pincodes'=>$pincodes_array,'properties'=>$properties]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            'email'           => 'required|email|unique:staffs',
            'mobile'          => 'required|max:10',
            'password'        => 'required|min:6',
        ]);

        //insert new hotel admin in users table
        $user1=  User::create([
            'name' => $request->input('first_name').' '.$request->input('last_name'),
            'email' => $request->input('email'),
            'password' => Hash::make($request->input('password')),
            'user_type'=> 4,
        ]);
        $user1->assignRole('user');
        
        //get the main user id from user table for hotel admin table
        if(Auth::user()->user_type == 3){
            $users_type = '4'; //its hotel admin staff
        } else {
            $users_type = '6'; //its gov admin staff
        }

        $getUser = DB::table('users')->select('id','user_type')->where('email',$request->input('email'))->first();
        $main_user_id =  $getUser->id;
         
        //update user type
        $update_user_type = array('user_type'=>$users_type);
        DB::table('users')->where('id', $main_user_id)->update($update_user_type);

        //insert new hotel admin in hotel admins table
        $user = auth()->user();
        $staff = new Staffs();
        $staff->first_name     = $request->input('first_name');
        $staff->last_name     = $request->input('last_name');
        $staff->email   = $request->input('email');
        $staff->status_id = $request->input('status_id');
        $staff->mobile = $request->input('mobile');
        $staff->password   = Hash::make($request->input('password'));
        $staff->org_password = $request->input('password');
        $staff->designation   = $request->input('designation');
        $staff->group_id   = $request->input('group_id');
        $staff->users_type = $users_type;
        $staff->main_user_id = $main_user_id;
        $staff->created_by = Auth::user()->id;
        $staff->save();
        

        //assign pincode
        //check if pincode assigned is available or not
        $datas = $request->all();

        //get the main user id from user table for hotel admin table
        $getStaff = DB::table('staffs')->select('id','users_type','created_by')->where('main_user_id',$main_user_id)->first();
        $staff_id =  $getStaff->id;
        DB::table('staff_assigned_pincodes')->where('staff_id', $staff_id)->delete();
        if(array_key_exists('assigned_pin',$datas)){
            $assigned_pin = $request->input('assigned_pin');
            foreach($assigned_pin as $pin){
                $insert_pin_array = array('staff_id'=>$staff_id,'assigned_pin'=>$pin);
                DB::table('staff_assigned_pincodes')->insert($insert_pin_array); 
            }
        }

        //property assigned 
        if(array_key_exists('property_id',$datas)){
            $assigned_property = $request->input('property_id');
            foreach($assigned_property as $property){
                $insert_property_array = array('staff_id'=>$staff_id,'property_id'=>$property);
                DB::table('staff_assigned_properties')->insert($insert_property_array); 
            }
        }
        
        //for staff profile pic
        if($getStaff->users_type == 4){ //hotel admin staff
            //create staff path to store profile image
            $staff_path = public_path('storage/uploads/hotel_admins/'.$getStaff->created_by.'/hotel_admin_staffs/'.$staff_id);
            
            //profile pic pth
            $staff_profile_pic_path = 'storage/uploads/hotel_admins/'.$getStaff->created_by.'/hotel_admin_staffs/'.$staff_id.'/profile_picture';

            //public folder path to upload
            $public_path = 'public/uploads/hotel_admins/'.$getStaff->created_by.'/hotel_admin_staffs/'.$staff_id.'/profile_picture';
        } else { //govt admin staff
            //create staff path to store profile image
            $staff_path = public_path('storage/uploads/govt_admins/'.$getStaff->created_by.'/govt_admin_staffs/'.$staff_id);
        
            //profile pic pth
            $staff_profile_pic_path = 'storage/uploads/govt_admins/'.$getStaff->created_by.'/govt_admin_staffs/'.$staff_id.'/profile_picture';
        
            //public folder path to upload
            $public_path =  'public/uploads/govt_admins/'.$getStaff->created_by.'/govt_admin_staffs/'.$staff_id.'/profile_picture';
        }

        //create respective path if not exists
        if(!File::isDirectory($staff_path)){
            File::makeDirectory($staff_path, 0777, true, true);
            File::makeDirectory($staff_profile_pic_path, 0777, true, true);
        }
   
        //for hotel admin profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;

            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = '';
        }
        //update profile image
        $profile_pic_array = array('profile_image'=>$fileNameToStore);
        DB::table('staffs')->where('id', $staff_id)->update($profile_pic_array);

        $request->session()->flash('message', 'Staff Created Successfully.');
        return redirect()->route('staffs.index');
    }

    //for editing gov admin
    public function edit($id)
    {
        $main_id = Auth::user()->id;
        $staff = Staffs::find($id);
         
        
        if(Auth::user()->user_type == 3){
            $groups = Groups::where('created_by',$main_id)->orderBy('id','desc')->get();
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $properties = Properties::where('status_id','1')->where('owner',$h_admin->id)->get();    
        } else {
            $g_admin = GovAdmin::where('main_user_id',$main_id)->get();
            $groups = Groups::orderBy('id','desc')->get();
            $properties = Properties::where('status_id','1')->get();    
        }
        
        
        $assigned_properties = DB::table('staff_assigned_properties')->where('staff_id', $id)->get();
        
        $assigned_pincodes = DB::table('staff_assigned_pincodes')->where('staff_id', $id)->get();
        //show pin dropdown filter only for govt aadmin and govt admin staff
        $pincodes_array = array();
        if($staff->users_type == 4){
            //hotel dmin staff
            $staff->profile_image = 'public/storage/uploads/hotel_admins/'.$staff->created_by.'/hotel_admin_staffs'.'/'.$staff->id.'/profile_picture'.'/'.$staff->profile_image;

        } else {
            //govt admin staff
            $staff->profile_image = 'public/storage/uploads/govt_admins/'.$staff->created_by.'/govt_admin_staffs'.'/'.$staff->id.'/profile_picture'.'/'.$staff->profile_image;

        }
        if(Auth::user()->user_type == 5 || Auth::user()->user_type == 6){
            $pincodes_array = DB::table('properties')->select('pin')->where('status_id','1')->distinct()->get();
        } 

        return view('dashboard.staffs.edit', [ 'staff' => $staff ,'groups'=>$groups,'pincodes'=>$pincodes_array,'assigned_pincodes'=>$assigned_pincodes,'properties'=>$properties,'assigned_properties'=>$assigned_properties]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            // 'email'           => 'required|email',
            'mobile'          => 'required|max:10',
        ]);
        
        $staff = Staffs::find($id);

        //check if pincode assigned is available or not
        $datas = $request->all();  
        DB::table('staff_assigned_pincodes')->where('staff_id', $id)->delete();
        if(array_key_exists('assigned_pin',$datas)){
            $assigned_pin = $request->input('assigned_pin');
            foreach($assigned_pin as $pin){
                $insert_pin_array = array('staff_id'=>$id,'assigned_pin'=>$pin);
                DB::table('staff_assigned_pincodes')->insert($insert_pin_array); 
            }
        }
        
        //property assigned 
        DB::table('staff_assigned_properties')->where('staff_id', $id)->delete();
        if(array_key_exists('property_id',$datas)){
            $assigned_property = $request->input('property_id');
            foreach($assigned_property as $property){
                $insert_property_array = array('staff_id'=>$id,'property_id'=>$property);
                DB::table('staff_assigned_properties')->insert($insert_property_array); 
            }
        }

        if($staff->users_type == 4){ //hotel admin staff
            //create staff path to store profile image
            $staff_path = public_path('storage/uploads/hotel_admins/'.$staff->created_by.'/hotel_admin_staffs/'.$id);
            
            //profile pic pth
            $staff_profile_pic_path = 'storage/uploads/hotel_admins/'.$staff->created_by.'/hotel_admin_staffs/'.$id.'/profile_picture';

            //public folder path to upload
            $public_path = 'public/uploads/hotel_admins/'.$staff->created_by.'/hotel_admin_staffs/'.$id.'/profile_picture';
        } else { //govt admin staff
            //create staff path to store profile image
            $staff_path = public_path('storage/uploads/govt_admins/'.$staff->created_by.'/govt_admin_staffs/'.$id);
        
            //profile pic pth
            $staff_profile_pic_path = 'storage/uploads/govt_admins/'.$staff->created_by.'/govt_admin_staffs/'.$id.'/profile_picture';
        
            //public folder path to upload
            $public_path =  'public/uploads/govt_admins/'.$staff->created_by.'/govt_admin_staffs/'.$id.'/profile_picture';
        }

        //create respective path if not exists
        if(!File::isDirectory($staff_path)){
            File::makeDirectory($staff_path, 0777, true, true);
            File::makeDirectory($staff_profile_pic_path, 0777, true, true);//create  customer_documents folder
        }
   
        //for hotel admin profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path = 
            // echo "<pre>";print_r($fileNameToStore);exit;
            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = $staff->profile_image;
        }

        
        $staff->first_name     = $request->input('first_name');
        $staff->last_name     = $request->input('last_name');
        $staff->email   = $request->input('email');
        $staff->designation   = $request->input('designation');
        $staff->group_id   = $request->input('group_id');
        $staff->status_id = $request->input('status_id');
        $staff->mobile = $request->input('mobile');
        $staff->profile_image = $fileNameToStore;
        $staff->save();

        //get the main user id from user table for hotel admin table
        $getUser = DB::table('users')->select('id','password')->where('email',$request->input('email'))->first();
        $main_user_id =  $getUser->id;
        if($request->input('password')){
            $staff_pass = Hash::make($request->input('password'));
            $staff_org_pass = $request->input('password');
        } else {
            $staff_pass = $getUser->password;
        }
        //insert new hotel admin in users table
        $hotel_user_staff = User::find($main_user_id);
        $hotel_user_staff->name    = $request->input('first_name').' '.$request->input('last_name');
        $hotel_user_staff->email   =  $request->input('email');
        $hotel_user_staff->password   = $staff_pass;
        $hotel_user_staff->save();

        $request->session()->flash('message', 'Staff Updated Successfully');
        return redirect()->route('staffs.index');
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $staff = Staffs::find($id);
        $user = User::find($staff->main_user_id);
        if($staff){
            $staff->delete();
            $user->delete();
        }
        return redirect()->route('staffs.index');
    }
}
