<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Properties;
use App\Models\Sources;
use App\Models\Room;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Staffs;
use App\Models\RoomTypes;
use DataTables;

class SourcesController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = '';
        $main_id = Auth::user()->id;
     
        if ($request->ajax()) {
            $data = Sources::where('created_by',$main_id)->orderBy('id','desc')->get();
            foreach($data as $source){
                $id = $source->id;
            }

            $action =  '<a href="/sources/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
            return Datatables::of($data)
                    ->addColumn('action', $action)
                    ->rawColumns(['action'])
                    ->make(true);
            }
        return view('dashboard.sources.sourcesList');
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        $main_id = Auth::user()->id ;
        return view('dashboard.sources.create');
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'code'      => 'required',
            'description'       => 'required|min:1|max:64',
        ]);

        //insert new room
        $type = new Sources();
        $type->title    = $request->input('title');
        $type->code    = $request->input('code');
        $type->description   =  $request->input('description');
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'Source Created Successfully.');
        return redirect()->route('sources.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $source = Sources::find($id);
        $main_id = Auth::user()->id ;
        return view('dashboard.sources.edit', [ 'source' => $source ]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'code'      => 'required',
            'description'       => 'required|min:1|max:64',
        ]);

          //insert new room
          $type = Sources::find($id);
          $type->title    = $request->input('title');
          $type->code    = $request->input('code');
          $type->description   =  $request->input('description');
          $type->save();

        $request->session()->flash('message', 'Source Updated Successfully');
        return redirect()->route('sources.index');
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $source = Sources::find($id);
        if($source){
            $source->delete();
        }
        return redirect()->route('sources.index');
    }
    
    
}

