<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\IdProofTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Properties;
use DataTables;

class RoomUndoCheckoutController extends Controller
{
    public function index(Request $request)
    {
        $data = $request->all();
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        //check if logged in user in govt admin staff for property filter
        if($user_type == 3 || $user_type == 5 || $user_type == 6){ //govt admin staff
            $propertiesq = Properties::where('status_id','1');
            if($user_type == 3){
                $propertiesq->where('created_by',$main_id);
            }
            $properties = $propertiesq->get();
        } else {
            $properties = array();
        }
        return view('dashboard.roomCheckout.undocheckout',['properties'=>$properties]);

    }
    
}
