<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Properties;
use App\Models\Reservations;
use App\Models\Sources;
use App\Models\Room;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Staffs;
use App\Models\RoomTypes;
use DataTables;

class ReservationsController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = '';
        $main_id = Auth::user()->id;
     
        if ($request->ajax()) {
            $data = DB::table('reservations as rs')->select('rs.*','pr.name as property_name','ro.title as room_title','sr.title as source_name')->where('rs.created_by',$main_id)->orderBy('rs.id','desc')
            ->join('properties as pr','pr.id','=', 'rs.property_id','left')
            ->join('rooms as ro','ro.id','=', 'rs.room_id')
            ->join('sources as sr','sr.id','=', 'rs.source')
            ->get();
            foreach($data as $reservation){
                $id = $reservation->id;
                $reservation->reserved_from_date_and_time = $reservation->from_date.' '.$reservation->from_time;
                $reservation->reserved_to_date_and_time = $reservation->to_date.' '.$reservation->to_time;
            }

            $action =  '<a href="/reservations/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
            return Datatables::of($data)
                    ->addColumn('action', $action)
                    ->rawColumns(['action'])
                    ->make(true);
            }
        return view('dashboard.reservations.reservationsList');
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        $sources = Sources::where('created_by',Auth::user()->id)->get();    

        return view('dashboard.reservations.create',['properties'=> $properties,'sources' => $sources]);
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'reservation_no'      => 'required',
            'source_booking_no'      => 'required',
        ]);

        // $res_no_q = Reservations::where('created_by',Auth::user()->id)->where('id','desc')->first();
        // if(empty($res_no_q)){
        //     $res_no = 'RES-0001';
        // } else {
        //     $resno_ar = explode('-',$res_no_q->reservation_no);
        //     $no_suffix_first = $resno_ar[1] + 1;
        //     $no_suffix = sprintf('%04s', $no_suffix_first);
        //     $res_no = 'RES-'.$no_suffix;
        // }
        //insert new Reservations
        $type = new Reservations();
        $type->reservation_no    = 'RES-'.$request->input('reservation_no');
        $type->source_booking_no    = $request->input('source_booking_no');
        $type->source   =  $request->input('source');
        $type->property_id   =  $request->input('property_id');
        $type->room_id   =  $request->input('room_id');
        $type->from_date   =  $request->input('from_date');
        $type->from_time   =  $request->input('from_time');
        $type->to_date   =  $request->input('to_date');
        $type->to_time   =  $request->input('to_time');
        $type->to_date   =  $request->input('to_date');
        $type->remarks   =  $request->input('remarks');
        $type->reserved_by   =  $request->input('reserved_by');
        $type->reservation_details   =  $request->input('reservation_details');
        $type->reservation_notes   =  $request->input('reservation_notes');
        $type->reservation_remarks   =  $request->input('reservation_remarks');
        $type->status   =  $request->input('status');
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'Reservation Created Successfully.');
        return redirect()->route('reservations.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $reservation = Reservations::find($id);
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        $sources = Sources::where('created_by',Auth::user()->id)->get();    
        $rooms = Room::where('created_by',Auth::user()->id)->where('deleted_at',null)->where('status','1')->get();

        return view('dashboard.reservations.edit', [ 'reservation' => $reservation ,'sources'=> $sources,'properties'=> $properties,'rooms'=>$rooms]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'reservation_no'      => 'required',
            'source_booking_no'      => 'required',
        ]);

        //insert new Reservations
        $type = Reservations::find($id);
        $type->reservation_no    = 'RES-'.$request->input('reservation_no');
        $type->source_booking_no    = $request->input('source_booking_no');
        $type->source   =  $request->input('source');
        $type->property_id   =  $request->input('property_id');
        $type->room_id   =  $request->input('room_id');
        $type->from_date   =  $request->input('from_date');
        $type->from_time   =  $request->input('from_time');
        $type->to_date   =  $request->input('to_date');
        $type->to_time   =  $request->input('to_time');
        $type->to_date   =  $request->input('to_date');
        $type->remarks   =  $request->input('remarks');
        $type->reserved_by   =  $request->input('reserved_by');
        $type->reservation_details   =  $request->input('reservation_details');
        $type->reservation_notes   =  $request->input('reservation_notes');
        $type->reservation_remarks   =  $request->input('reservation_remarks');
        $type->status   =  $request->input('status');
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'Reservations Updated Successfully');
        return redirect()->route('reservations.index');
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $source = Reservations::find($id);
        if($source){
            $source->delete();
        }
        return redirect()->route('reservations.index');
    }   
}

