<?php
namespace App\Http\Controllers;

use App\Models\PaymentMethod;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;

class PaymentMethodController extends Controller
{
    public function index(Request $request){
        $main_id = Auth::user()->id;
            //manage privilege if its staff user
            if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','8')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if ($request->ajax()) {
            $data = PaymentMethod::orderBy('id','desc')->get();
            foreach($data as $type){
                $id = $type->id;
            }
            $action =  '<a href="/paymentmethods/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
            return Datatables::of($data)
                ->addColumn('action',$action) 
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.paymentmethods.paymentMethodsList',['privileges'=>$getPrivileges]);
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        return view('dashboard.paymentmethods.create');
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
        ]);

        //insert new type
        $type = new PaymentMethod();
        $type->title    = $request->input('title');
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'Payment Method Created Successfully.');
        return redirect()->route('paymentmethods.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $method = PaymentMethod::find($id);
        return view('dashboard.paymentmethods.edit', [ 'method' => $id_proof_type ]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
        ]);

          //insert new type
          $type = PaymentMethod::find($id);
          $type->title    = $request->input('title');
          $type->save();

        $request->session()->flash('message', 'Payment Method Updated Successfully');
        return redirect()->route('paymentmethods.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $type = PaymentMethod::find($id);
        if($type){
            $type->delete();
        }
        return redirect()->route('paymentmethods.index');
    }

}
