<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Staffs;
use App\Models\GovAdmin;
use App\Models\MyProfile;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use File;
use Illuminate\Support\Facades\Auth;

class MyProfileController extends Controller
{
    public function index()
    { 
        $this->edit(Auth::user()->id);
    }
    
    //for editing hotel admin
    public function edit($id)
    {  
        $mainUser = User::find($id); 
        //check if logged in user type
        if($mainUser->user_type == 3){ //hotel admin
            $user = HotelAdmin::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/hotel_admins/'.$user->id.'/profile_picture/'.$user->profile_image;
        } else if($mainUser->user_type == 4){ //hotel admin staff
            $user = Staffs::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/hotel_admins/'.$user->created_by.'/hotel_admin_staffs/'.$user->id.'/profile_picture/'.$user->profile_image;
        } else if($mainUser->user_type == 5){ //govt admin
            $user = GovAdmin::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/govt_admins/'.$user->id.'/profile_picture/'.$user->profile_image;
        } else { //govt dmin staff
            $user = Staffs::where('main_user_id',$mainUser->id)->first();
            $user->profile_image = 'public/storage/uploads/govt_admins/'.$user->created_by.'/govt_admin_staffs/'.$user->id.'/profile_picture/'.$user->profile_image;
        } 
        return view('dashboard.myprofile.edit', [ 'user' => $user ]);
    }


      //for editing hotel admin
      public function show($id)
      {
        return redirect()->route('myprofile.edit');
      }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            'mobile'          => 'required|max:10',
            'status_id'       => 'required',
            'mobile'          => 'min:10|max:10',
        ]);

        //get user info from main table
        $id = Auth::user()->id;
        $user = MyProfile::find($id);

        if($user->user_type == 3){ //hotel admin
            //get user info from sub table
            $sub_user = HotelAdmin::where('main_user_id',$id)->first();

            //create staff path to store profile image
            $user_path = public_path('storage/uploads/hotel_admins/'.$sub_user->id);
           
            //profile pic pth
            $user_profile_pic_path = 'storage/uploads/hotel_admins/'.$sub_user->id.'/profile_picture';

            //public folder path to upload
            $public_path = 'public/uploads/hotel_admins/'.$sub_user->id.'/profile_picture';
        
        } else if($user->user_type == 4){ //hotel admin staff
            //get user info from sub table
            $sub_user = Staffs::where('main_user_id',$id)->first();

            //create staff path to store profile image
            $user_path = public_path('storage/uploads/hotel_admins/'.$sub_user->created_by.'/hotel_admin_staffs/'.$id);
            
            //profile pic pth
            $user_profile_pic_path = 'storage/uploads/hotel_admins/'.$sub_user->created_by.'/hotel_admin_staffs/'.$id.'/profile_picture';

            //public folder path to upload
            $public_path = 'public/uploads/hotel_admins/'.$sub_user->created_by.'/hotel_admin_staffs/'.$id.'/profile_picture';
        
        } else if($user->user_type == 5){ //govt admin
            //get user info from sub table
            $sub_user = GovAdmin::where('main_user_id',$id)->first();

            //create staff path to store profile image
            $user_path = public_path('storage/uploads/govt_admins/'.$sub_user->id);
           
            //profile pic pth
            $user_profile_pic_path = 'storage/uploads/govt_admins/'.$sub_user->id.'/profile_picture';

            //public folder path to upload
            $public_path = 'public/uploads/govt_admins/'.$sub_user->id.'/profile_picture';
        
        } else { //govt admin staff
            //get user info from sub table
            $sub_user = Staffs::where('main_user_id',$id)->first();

            //create staff path to store profile image
            $user_path = public_path('storage/uploads/govt_admins/'.$sub_user->created_by.'/govt_admin_staffs/'.$sub_user->id);
        
            //profile pic pth
            $user_profile_pic_path = 'storage/uploads/govt_admins/'.$sub_user->created_by.'/govt_admin_staffs/'.$sub_user->id.'/profile_picture';
        
            //public folder path to upload
            $public_path =  'public/uploads/govt_admins/'.$sub_user->created_by.'/govt_admin_staffs/'.$sub_user->id.'/profile_picture';
        }

         //create respective path if not exists
         if(!File::isDirectory($user_path)){
            File::makeDirectory($user_path, 0777, true, true);
            File::makeDirectory($user_profile_pic_path, 0777, true, true);
        }

        //for user profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;

            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = '';
        }

        //update user info in main user table
        $user->name = $request->input('first_name').' '.$request->input('last_name');
        $user->email   = $user->email;
        $user->profile_image = $fileNameToStore;
        $user->save();

        //update user info in sub user table respectively
        $sub_user->first_name     = $request->input('first_name');
        $sub_user->last_name     = $request->input('last_name');
        $sub_user->email   = $sub_user->email;
        $sub_user->status_id = $request->input('status_id');
        $sub_user->mobile = $request->input('mobile');
        $sub_user->profile_image = $fileNameToStore;
        $sub_user->save();

        //get updted user
        if($user->user_type == 3){ //hotel admin
            $updted_user = HotelAdmin::find($sub_user->id);
            $updted_user->profile_image = 'storage/uploads/hotel_admins/'.$updted_user->id.'/profile_picture/'.$updted_user->profile_image;

        } else if($user->user_type == 4){//hotel admin staff
            $updted_user = Staffs::find($sub_user->id); 
            $updted_user->profile_image = 'storage/uploads/hotel_admins/'.$updted_user->created_by.'/hotel_admin_staffs/'.$updted_user->id.'/profile_picture/'.$updted_user->profile_image;
        
        } else if($user->user_type == 5){//govt admin
            $updted_user = GovAdmin::find($sub_user->id);
            $updted_user->profile_image = 'storage/uploads/govt_admins/'.$updted_user->created_by.'/govt_admin_staffs/'.$updted_user->id.'/profile_picture/'.$updted_user->profile_image;
        
        } else { //govt admin staff
            $updted_user = Staffs::find($sub_user->id);
            $updted_user->profile_image = 'storage/uploads/govt_admins/'.$updted_user->created_by.'/govt_admin_staffs/'.$updted_user->id.'/profile_picture/'.$updted_user->profile_image;
        }
        return view('dashboard.myprofile.edit', [ 'user' => $updted_user ]);
    }

}
