<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use File;

class HotelAdminController extends Controller
{
    public function index(Request $request){

        if ($request->ajax()) {
            $data = HotelAdmin::orderBy('id','desc')->get();
     
                foreach($data as $admin){
                    //create full name 
                    $admin->first_name =  $admin->first_name.' '.$admin->last_name;
        
                    //status active / in-active
                    if($admin->status_id == 1){
                        $admin->status_id = 'Active';
                    } else {
                        $admin->status_id = 'In-Active'; 
                    }
                    $id = $admin->id;
                }
                
                $action = '<a href="/hoteladmins/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
      
                return Datatables::of($data)
                        ->addColumn('action', $action) 
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.hoteladmins.hotelAdminsList');
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        return view('dashboard.hoteladmins.create', [ 'statuses' => '1' ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            'email'           => 'required|email|unique:users',
            'password'        => 'required',
            'mobile'          => 'required|max:10',
            'expiry_date'     => 'required|date_format:Y-m-d',
            'status_id'       => 'required',
        ]);
        
        $user1=  User::create([
            'name' => $request->input('first_name').' '.$request->input('last_name'),
            'email' => $request->input('email'),
            'password' => Hash::make($request->input('password')),
            'user_type'=> 3,
        ]);
        $user1->assignRole('user');

        //get the main user id from user table for hotel admin table
        $getUser = DB::table('users')->select('id')->where('email',$request->input('email'))->first();
        $main_user_id =  $getUser->id;

        $update_user_type = array('user_type'=>'3');
        DB::table('users')->where('id', $main_user_id)->update($update_user_type);

        //insert new hotel admin in hotel admins table
        $user = auth()->user();
        $hoteladmin = new HotelAdmin();
        $hoteladmin->first_name     = $request->input('first_name');
        $hoteladmin->last_name     = $request->input('last_name');
        $hoteladmin->email   = $request->input('email');
        $hoteladmin->password = Hash::make($request->input('password'));
        $hoteladmin->org_password = $request->input('password');
        $hoteladmin->status_id = $request->input('status_id');
        $hoteladmin->mobile = $request->input('mobile');
        $hoteladmin->expiry_date = $request->input('expiry_date');
        $hoteladmin->group_name = $request->input('group_name');
        $hoteladmin->users_type = 2;
        $hoteladmin->main_user_id = $main_user_id;
        $hoteladmin->save();

        $getHotelAdmin = DB::table('tbl_hotel_admins')->select('id')->where('email',$request->input('email'))->first();
        $id =  $getHotelAdmin->id;

        //get recently added user from gov admin table
        $user = HotelAdmin::where('main_user_id',$main_user_id)->first();

        //create staff path to store profile image
       $user_path = public_path('storage/uploads/hotel_admins/'.$id);
           
       //profile pic pth
       $user_profile_pic_path = 'storage/uploads/hotel_admins/'.$id.'/profile_picture';

       //public folder path to upload
       $public_path = 'public/uploads/hotel_admins/'.$id.'/profile_picture';
   
        //create respective path if not exists
        if(!File::isDirectory($user_path)){
            File::makeDirectory($user_path, 0777, true, true);
            File::makeDirectory($user_profile_pic_path, 0777, true, true);
        }

        //for user profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;

            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = '';
        }
        $profile_pic_array = array('profile_image'=>$fileNameToStore);
        DB::table('tbl_hotel_admins')->where('id', $user->id)->update($profile_pic_array);
        DB::table('users')->where('id', $user->main_user_id)->update($profile_pic_array);


        $request->session()->flash('message', 'Hotel Admin Created Successfully.');
        return redirect()->route('hoteladmins.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $hoteladmins = HotelAdmin::find($id);
        $hoteladmins->profile_image = 'public/storage/uploads/hotel_admins/'.$hoteladmins->id.'/profile_picture/'.$hoteladmins->profile_image;

        return view('dashboard.hoteladmins.edit', [ 'hoteladmin' => $hoteladmins ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            'email'           => 'required',
            'mobile'          => 'required|max:10',
            'expiry_date'     => 'required|date_format:Y-m-d',
            'status_id'       => 'required',
        ]);
        
       //create staff path to store profile image
       $user_path = public_path('storage/uploads/hotel_admins/'.$id);
           
       //profile pic pth
       $user_profile_pic_path = 'storage/uploads/hotel_admins/'.$id.'/profile_picture';

       //public folder path to upload
       $public_path = 'public/uploads/hotel_admins/'.$id.'/profile_picture';
   
        //create respective path if not exists
        if(!File::isDirectory($user_path)){
            File::makeDirectory($user_path, 0777, true, true);
            File::makeDirectory($user_profile_pic_path, 0777, true, true);
        }
        $hoteladmin = HotelAdmin::find($id);
        //for user profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;

            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = $hoteladmin->profile_image;
        }

        
        $hoteladmin->first_name     = $request->input('first_name');
        $hoteladmin->last_name     = $request->input('last_name');
        $hoteladmin->email   = $request->input('email');
        if($request->input('password') == ''){
            $hoteladmin->password = $hoteladmin->password;
        } else {
            $hoteladmin->password = Hash::make($request->input('password'));
            $hoteladmin->org_password = $request->input('password');
        }
        $hoteladmin->status_id = $request->input('status_id');
        $hoteladmin->mobile = $request->input('mobile');
        $hoteladmin->expiry_date = $request->input('expiry_date');
        $hoteladmin->group_name = $request->input('group_name');

        $hoteladmin->profile_image = $fileNameToStore;
        $hoteladmin->save();

        //get the main user id from user table for hotel admin table
        $getUser = DB::table('users')->select('id','password')->where('id',$hoteladmin->main_user_id)->first();
        $main_user_id =  $getUser->id;

        //insert new hotel admin in users table
        $hotel_user = User::find($main_user_id);
        $hotel_user->name    = $request->input('first_name').' '.$request->input('last_name');
        $hotel_user->email   =  $request->input('email');
        $hotel_user->password   =  $getUser->password;
        $hotel_user->profile_image = $fileNameToStore;
        $hotel_user->save();

        $request->session()->flash('message', 'Hotel Admin Updated Successfully');
        return redirect()->route('hoteladmins.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $hoteladmin = HotelAdmin::find($id);
        $user = User::find($hoteladmin->main_user_id);
        if($hoteladmin){
            $hoteladmin->delete(); 
            $user->delete();
        }
        $request->session()->flash('message', 'Hotel Admin Deleted Successfully.');

        return redirect()->route('hoteladmins.index');
    }
    
    
    
    public function show(Request $request)
    {
        $data = $request->all(); echo "<pre>AA";print_r($data);exit;
        return  $this->saave_docs_by_dropzone_e($data);
        
    }
    
     //for dropzone in docs
    public function saave_docs_by_dropzone_e($data){
        echo "<pre>AA";print_r($data);exit;
    }

}
