<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Groups;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class GroupsController extends Controller
{
    public function index(Request $request){

        if ($request->ajax()) {
             $main_id = Auth::user()->id;
            $data = Groups::where('created_by',$main_id)->orderBy('id','desc')->get();
     
                foreach($data as $group){
                    $id = $group->id;
                }
                return Datatables::of($data)
                        ->addColumn('action', '<a href="/groups/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>    <a href="/privileges/{{$id}}/edit" style="width: 51px;padding: 7px;" data-toggle="tooltip" title="Edit Privilages" data-original-title="Default tooltip" ><i class="fa fa-tasks" style="font-size: 20px;color: grey;"></i></a>')
                        // ->addColumn('action', '<a href="/hoteladmins/{{$id}}/edit" style="width: 51px;padding: 7px;"><i class="fa fa-edit" style="font-size: 20px;"></i></a> <a class="btn btn-danger" onclick="return confirm("Are you sure?")" href="/hoteladmins/delete/"><i class="fa fa-trash"></i></a>')
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.groups.groupsList');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('dashboard.groups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'group_name'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);
        
        //insert new group
        $group = new Groups();
        $group->group_name    = $request->input('group_name');
        $group->description   =  $request->input('description');
        $group->members   =  $request->input('members');
        $group->created_by   = Auth::user()->id;
        $group->save();

        $request->session()->flash('message', 'Group Created Successfully.');

        return redirect()->route('groups.index');
    }

     //for editing groups
     public function edit($id)
     {   
         $group = Groups::find($id);
         return view('dashboard.groups.edit', [ 'group' => $group ]);
     }
     
 
    /**
      * Update the specified resource in storage.
      *
      * @param  \Illuminate\Http\Request  $request
      * @param  int  $id
      * @return \Illuminate\Http\Response
      */
 
     public function update(Request $request, $id)
     {
        $validatedData = $request->validate([
            'group_name'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

           //create group
           $group = Groups::find($id);
           $group->group_name    = $request->input('group_name');
           $group->description   =  $request->input('description');
           $group->members   =  $request->input('members');
           $group->save();
 
         $request->session()->flash('message', 'Group Updated Successfully');
         return redirect()->route('groups.index');
     }
 
    /**
      * Remove the specified resource from storage.
      *
      * @param  int  $id
      * @return \Illuminate\Http\Response
      */
     public function destroy(Request $request)
     {
         $data = $request->all();
         $id = $data['id'];
         $group = Groups::find($id);
         if($group){
             $group->delete();
         }
         return redirect()->route('groups.index');
     }

}
