<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\GovAdmin;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use File;

class GovAdminController extends Controller
{
    public function index(Request $request){

        if ($request->ajax()) {
            $data = GovAdmin::orderBy('id','desc')->get();
     

                foreach($data as $admin){
                    //create full name 
                    $admin->first_name =  $admin->first_name.' '.$admin->last_name;
        
                    //status active / in-active
                    if($admin->status_id == 1){
                        $admin->status_id = 'Active';
                    } else {
                        $admin->status_id = 'In-Active'; 
                    }
                    $id = $admin->id;
                }

                return Datatables::of($data)
                        ->addColumn('action', '<a href="/govadmins/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        // ->addColumn('action', '<a href="/hoteladmins/{{$id}}/edit" style="width: 51px;padding: 7px;"><i class="fa fa-edit" style="font-size: 20px;"></i></a> <a class="btn btn-danger" onclick="return confirm("Are you sure?")" href="/hoteladmins/delete/"><i class="fa fa-trash"></i></a>')
                        ->rawColumns(['action'])
                        ->make(true);


        }
        return view('dashboard.govadmins.govAdminsList');
    }
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        return view('dashboard.govadmins.create', [ 'statuses' => '1' ]);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            'email'           => 'required|is_unique[users.email]',
            'mobile'          => 'required|max:10',
            'password'        => 'required',
        ]);
        //insert new hotel admin in users table
        $user1=  User::create([
            'name' => $request->input('first_name').' '.$request->input('last_name'),
            'email' => $request->input('email'),
            'password' => Hash::make($request->input('password')),
            'user_type'=> 5,
        ]);
        $user1->assignRole('user');

        //get the main user id from user table for hotel admin table
        $getUser = DB::table('users')->select('id')->where('email',$request->input('email'))->first();
        $main_user_id =  $getUser->id;

        $update_user_type = array('user_type'=>'5');
        DB::table('users')->where('id', $main_user_id)->update($update_user_type);
 
        //insert new hotel admin in hotel admins table
        $user = auth()->user();
        $govadmin = new GovAdmin();
        $govadmin->first_name     = $request->input('first_name');
        $govadmin->last_name     = $request->input('last_name');
        $govadmin->email   = $request->input('email');
        $govadmin->password   = Hash::make($request->input('password'));
        $govadmin->org_password   = $request->input('password');
        $govadmin->status_id = $request->input('status_id');
        $govadmin->mobile = $request->input('mobile');
        $govadmin->designation   = $request->input('designation');
        $govadmin->station   = $request->input('station');
        $govadmin->users_type = 5;
        $govadmin->main_user_id = $main_user_id;
        $govadmin->save();

        //get recently added user from gov admin table
        $user = GovAdmin::where('main_user_id',$main_user_id)->first();

        //create path to store profile image
        $user_path = public_path('storage/uploads/govt_admins/'.$user->id);
           
        //profile pic pth
        $user_profile_pic_path = 'storage/uploads/govt_admins/'.$user->id.'/profile_picture';
 
        //public folder path to upload
        $public_path = 'public/uploads/govt_admins/'.$user->id.'/profile_picture';
     
        //create respective path if not exists
        if(!File::isDirectory($user_path)){
            File::makeDirectory($user_path, 0777, true, true);
            File::makeDirectory($user_profile_pic_path, 0777, true, true);
        }

        //for user profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;

            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = '';
        }
        $profile_pic_array = array('profile_image'=>$fileNameToStore);
        DB::table('gov_admins')->where('id', $user->id)->update($profile_pic_array);
        DB::table('users')->where('id', $user->main_user_id)->update($profile_pic_array);

        $request->session()->flash('message', 'Goverment Admin Created Successfully.');

        return redirect()->route('govadmins.index');
    }

    //for editing gov admin
    public function edit($id)
    {
        $govadmins = GovAdmin::find($id);
        $govadmins->profile_image = 'public/storage/uploads/govt_admins/'.$govadmins->id.'/profile_picture/'.$govadmins->profile_image;

        return view('dashboard.govadmins.edit', [ 'govadmin' => $govadmins ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            // 'email'           => 'required|email',
            'mobile'          => 'required|max:10',
        ]);
        
        //create path to store profile image
        $user_path = public_path('storage/uploads/govt_admins/'.$id);
           
        //profile pic pth
        $user_profile_pic_path = 'storage/uploads/govt_admins/'.$id.'/profile_picture';

        //public folder path to upload
        $public_path = 'public/uploads/govt_admins/'.$id.'/profile_picture';
    
        //create respective path if not exists
        if(!File::isDirectory($user_path)){
            File::makeDirectory($user_path, 0777, true, true);
            File::makeDirectory($user_profile_pic_path, 0777, true, true);
        }
        $govadmin = GovAdmin::find($id);
        //for user profile picture
        if ($request->hasFile('profile_image')) {

            $filenameWithExt = $request->file('profile_image')->getClientOriginalName();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('profile_image')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;

            $img = $request->file('profile_image')->storeAs($public_path, $fileNameToStore);
        } else {
            $fileNameToStore = $govadmin->profile_image;
        }

       
        $govadmin->first_name     = $request->input('first_name');
        $govadmin->last_name     = $request->input('last_name');
        $govadmin->email   = $request->input('email');
        $govadmin->password   = Hash::make($request->input('password'));
        $govadmin->org_password   = $request->input('password');
        $govadmin->designation   = $request->input('designation');
        $govadmin->station   = $request->input('station');
        $govadmin->profile_image = $fileNameToStore;
        $govadmin->status_id = $request->input('status_id');
        $govadmin->mobile = $request->input('mobile');
        $govadmin->save();

        //get the main user id from user table for hotel admin table
        $getUser = DB::table('users')->select('id','password')->where('id',$govadmin->main_user_id)->first();
        $main_user_id =  $getUser->id;

        //insert new hotel admin in users table
        $gov_user = User::find($main_user_id);
        $gov_user->name    = $request->input('first_name').' '.$request->input('last_name');
        $gov_user->email   =  $request->input('email');
        $gov_user->password   =  $getUser->password;
        $gov_user->profile_image = $fileNameToStore;
        $gov_user->save();

        $request->session()->flash('message', 'Goverment admin Updated Successfully');
        return redirect()->route('govadmins.index');
    }

        /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $govadmin = GovAdmin::find($id);
        $user = User::find($govadmin->main_user_id);
        if($govadmin){
            $govadmin->delete();
            $user->delete();
        }
        return redirect()->route('govadmins.index');
    }
}

