<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Customers;
use App\Models\CriminalRecords;
use App\Models\CustomerDocuments;
use App\Models\Room;
use App\Models\Staffs;
use App\Models\Country;
use App\Models\Complaints;
use App\Models\BlackLists;
use App\Models\Properties;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\IdProofTypes;
use App\Models\GuestContracts;
use App\Models\BookingTypes;
use Google\Client as GoogleClient;
use PDF;
use DataTables;
use File;
use Carbon\CarbonPeriod;

class CustomersController extends Controller
{
     public function index(Request $request){
         
        // $title = "CheckOut Alert";
        // $body = 'Customer George Joe has been checked out to this room';
        // $x = self::sendNotification(27,$title,$body,2);
        // echo "<pre>";print_R($x);exit;
        
        $uparr = array('checkout_date_time' => NULL);
        $x = DB::table('customers')->where('checkout_date_time','')->update($uparr);
   
        $datas = $request->all();
        // echo "<pre>";print_r($datas);exit;
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        //check if logged in user in govt admin staff for property filter
        if($user_type == 3 || $user_type == 5 || $user_type == 6){ //govt admin staff
            $propertiesq = Properties::where('status_id','1');
            
            if($user_type == 3){
                 $owner_arr = HotelAdmin::where('main_user_id',$main_id)->first();
                $propertiesq->where('owner',$owner_arr->id);
                // $propertiesq->where('created_by',$main_id);
            }
            $properties = $propertiesq->get();
        } else {
            $properties = array();
        }
        
        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first() ;
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }
        //  echo $h_main_id;exit;
        //manage privilege if its staff user
        if($user_type == 4 || $user_type == 6){//4 = hotel admin staff and govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','5')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }
        DB::enableQueryLog();
        if(array_key_exists('is_gov',$datas)){
            if(array_key_exists('govt_propVal',$datas)){
                $preData = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.confirm_checkin','customers.created_by');

                $preData->join('rooms','rooms.id','=','customers.room_id','left');
                $preData->join('countries','countries.id','=','customers.nationality','left');
                if($datas['govt_propVal']){
                    $preData->where('customers.property_id',$datas['govt_propVal']);
                }
                if($datas['govt_stayVal'] == 1){
                     $preData->whereNull('customers.checkout_date_time');
                }
                if($datas['govt_stayVal'] == 2){
                      $fromd = date('Y-m-d',strtotime($datas['govt_from_date']));
                    $post_start_date =  \Carbon\Carbon::parse($fromd);
                     
                    $tod = date('Y-m-d',strtotime($datas['govt_to_date']));
                    $post_end_date =  \Carbon\Carbon::parse($tod);
                    $preData->where('customers.checkin_date_time','!=','')->whereBetween('customers.checkin_date_time', [$post_start_date, $post_end_date]);
                }
                
                $data = $preData->orderBy('customers.id','desc')->where('customers.deleted_at',null)->get();
            } else {
                $data = array();
            }
            //  dd(DB::getQueryLog());;exit;
        } else {
            DB::enableQueryLog();
            //get customers list only of checking in
            $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.confirm_checkin','customers.created_by');

            $dataq->join('rooms','rooms.id','=','customers.room_id','left');
            $dataq->join('countries','countries.id','=','customers.nationality','left');
           $dataq->WhereNull('rooms.deleted_at');
            
            if(array_key_exists('stay_vals',$datas)){ 
                if($datas['stay_vals'] == 1){  //get customers only checked in currently
                    $dataq->whereNull('customers.checkout_date_time');
                } else { //get customer datewise
                    $fromd = date('Y-m-d',strtotime($datas['from_date']));
                    $post_start_date =  \Carbon\Carbon::parse($fromd);
                     
                    $tod = date('Y-m-d',strtotime($datas['to_date']));
                    $post_end_date =  \Carbon\Carbon::parse($tod);
                    $dataq->where('customers.checkin_date_time','!=','')->whereBetween('customers.checkin_date_time', [$post_start_date, $post_end_date]);
                }
            }
            
            $dataq->Where('customers.checkout_date_time',NULL);
            if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){ 
                $dataq->where('customers.property_id',$datas['property_id']); 
            }

            if(array_key_exists('room',$datas) && $datas['room'] > 0){
                $dataq->where('customers.room_id',$datas['room']);
            }
            
            if (array_key_exists('confirm_checkin', $datas) && $datas['confirm_checkin']) {
                $dataq->where('customers.confirm_checkin', 1);
            } else {
                $dataq->where(function ($q) {
                    $q->where('customers.confirm_checkin', 0)
                      ->orWhereNull('customers.confirm_checkin');
                });
            } 
            
            if(array_key_exists('include_cambodia',$datas) && $datas['include_cambodia'] == 1){ 
                $dataq->where('customers.nationality','38');
            } else {
                $dataq->where('customers.nationality','!=','38');
            }
            
            $hotel_sub_id =   Auth::user()->id ;
            if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff ){//4 = hotel admin staff
    
                //get staff info for group 
                $getGroup = DB::table('staffs')->select('group_id','created_by')->where('main_user_id', Auth::user()->id)->first();
                 $hotelAdmin_id = HotelAdmin::where('main_user_id',$getGroup->created_by)->first();
                 $main_id = $getGroup->created_by;
                 $hotel_sub_id= $getGroup->created_by;
            } else {
                $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id )->first();
                $main_id = Auth::user()->id;
            }
          
            $data = $dataq->where('customers.created_by',$main_id)->whereNull('customers.deleted_at')->orderBy('customers.id','desc')->get();
        }
        // dd(DB::getQueryLog());;exit;
       
        $check ='';
        
        
        foreach($data as $key => $customer){
            if($customer->created_by == Auth::user()->id){
            // echo "<pre>";print_r($data);exit;
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if(array_key_exists('stay_vals',$datas)){
                    if($datas['stay_vals'] == 1){ 
                        if($customer->checkout_date_time){
                            unset($data[$key]);
                        }
                    }
                }
            }
            
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if($customer->created_by != $main_id){
                    unset($data[$key]);
                }
            }
            
            //   echo "<pre> === ";print_r($customer);
            // if(Auth::user()->user_type == 4){  //hotel admin staff
            //     $assigned_properties = DB::table('staff_assigned_properties')->where('property_id',  $customer->property_id)->first();
            // //  echo "<pre>";print_r($assigned_properties);exit;
            //     if(!empty($assigned_properties)){
            //         $customer = $customer;
            //     } else {
            //         $customer = array();
            //     }
            // }
            $id = $customer->id;
            
            //complaint found if any for complaint tab
            $criminalExists = DB::table('blacklists')
            ->select('id')
            // ->where('first_name', 'like', '%' . $customer->first_name . '%')
            ->where('name', 'like', '%' . $customer->first_name . '%')
            ->orWhere('name', 'like', '%' . $customer->last_name . '%')
            ->get();
                
            if(count($criminalExists) > 0){
                $check =  $id;
                $check = '<a href="/customers/{{$id}}/edit"  style=" animation: flashing-style 0.6s linear infinite;width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
            }

            $customer->full_name =  $customer->first_name.' '.$customer->last_name;
          
            //get room title
            $room_details = Room::find($customer->room_id);
            
            if(!$customer->room_id){
                $customer->room_id =  '';
            } else {
                $customer->room_id =  $room_details->title;
            }
            
            $customer_nationality_id = '';
            $customer_nationality_id = $customer->nationality;
            $customer->nationality = $customer->country_name;
            // $customer->nationality = $customer->country_name;
            
            //check if date range is requested and get customer accordingly
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if( array_key_exists('stay_vals',$datas)){
                    if($datas['stay_vals'] == 2){  
                        $from = $datas['from_date'].' 00:00:00';
                        $to = $datas['to_date'].' 00:00:00'; 
                       if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                        $customer = $customer;
                       } else {
                        $customer = array();
                       }
                    } 
                }
            }
            
            //check if property id for filter
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if( array_key_exists('property_id',$datas)){
                    if($datas['property_id']) {
                        $from = $datas['from_date'].' 00:00:00';
                        $to = $datas['to_date'].' 00:00:00'; 
                        if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                            $customer = $customer;
                        } else {
                            $customer = array();
                        }
                    }
                }
            }
            
            if( array_key_exists('confirm_checkin',$datas) && $datas['confirm_checkin'] == 1 && $customer->confirm_checkin != 1){
                 $final_customer[] =  $customer;
                 unset($data[$key]);
            }
            
            if( array_key_exists('include_cambodia',$datas) && $datas['include_cambodia'] == 1 && $customer_nationality_id != 38){
                 $final_customer[] =  $customer;
                 unset($data[$key]);
            }
        }
        }
        // echo "<pre>";print_r($final_customer);exit;

        $action = '';
        if($user_type == 5 || Auth::user()->user_type == 6){
            $action .= '<a href="{{ route("customers.viewdetails",["id"=>base64_encode($id)]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="View Details" class="view_cust_details" ><i class="cil-folder-open"></i></a>';
        } else {
            $action .= '<a href="{{ route("customers.contract",["id"=>base64_encode($id),"is_contract_preview" =>1]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="Preview Contract" class="view_contract_details" ><i class="cil-newspaper"></i></a>';
            if(!empty($getPrivileges)){
                if($getPrivileges->view ==1){
                    if($getPrivileges->edit ==1){
                        $action .= '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>';
                    } 
                    if($getPrivileges->delete ==1){
                         $action .= '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                    }
                } else {
                    $action .= '';
                }
            } else {
                $action .= '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button><a href="{{ route("complaints.create",["id"=>$id]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="File Complaint" ><i class="cil-folder-open"></i></a>';
            }
        }
   
        if ($request->ajax()) {
            return Datatables::of($data)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                // ->addColumn('check', $check)
                // ->rawColumns(['check'])
                ->make(true);
        } 
        return view('dashboard.customers.customersList',['privileges'=>$getPrivileges,'properties'=>$properties,'todaysdate' =>date('Y-m-d')]);
    }
    
    public function index_org_23_08_2023(Request $request){
        $datas = $request->all();
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;

        //check if logged in user in govt admin staff for property filter
        if($user_type == 5 || $user_type == 6){ //govt admin staff
            $properties = Properties::where('status_id','1')->get();
        } else {
            $properties = array();
        }

        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $h_main_id = $h_admin->main_user_id;
        } else {
            $h_main_id = $main_id;
        }
        //  echo $h_main_id;exit;
        //manage privilege if its staff user
        if($user_type == 4 || $user_type == 6){//4 = hotel admin staff and govt admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','5')->first();//module_id = 5(Only customer module)

        } else {
            $getPrivileges = array();
        }

        if(array_key_exists('is_gov',$datas)){
            if(array_key_exists('govt_propVal',$datas)){
                $preData = DB::table('customers')->select('*');
                if($datas['govt_propVal']){
                    $preData->where('property_id',$datas['govt_propVal']);
                }
                if($datas['govt_stayVal'] == 1 || $datas['govt_stayVal'] == 2){
                    $preData->where('checkout_date_time',''); 
                }
                $data = $preData->orderBy('id','desc')->where('deleted_at',null)->get();
            } else {
                $data = array();
            }

        } else {
        
            //get customers list only of checking in
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 1){  //get customers only checked in currently
                    $data = Customers::where('checkout_date_time','')->where('created_by',$h_main_id)->orderBy('id','desc')->where('deleted_at',null)->get();
                } else {//get customer datewise
                    $data = Customers::orderBy('id','desc')->where('created_by',$h_main_id)->where('deleted_at',null)->get();
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    
                     $fromd = date('Y-m-d',strtotime($datas['from_date']));
                    $post_start_date =  \Carbon\Carbon::parse($fromd);
                     
                    $tod = date('Y-m-d',strtotime($datas['to_date']));
                    $post_end_date =  \Carbon\Carbon::parse($tod);
            
            
                    $data = Customers::orderBy('checkin_date_time','desc')
                            ->where('checkin_date_time','!=','')
                            // ->where('checkin_date_time','!=','')
                             ->whereBetween('checkin_date_time', [$post_start_date, $post_end_date])
                            ->where('deleted_at',null)->get();
                }
            } else { 
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$h_main_id)->orderBy('id','desc')->where('deleted_at',null)->get();
            }
            // echo "<pre>";print_r($data);exit;
            if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$h_main_id)->where('property_id',$datas['property_id'])->orderBy('id','desc')->where('deleted_at',null)->get();
            } else {
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$h_main_id)->orderBy('id','desc')->where('deleted_at',null)->get();
            }
            
            if($user_type == 4 ){//4 = hotel admin staff
             $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
                $data = Customers::where('checkout_date_time','=',NULL)->orWhere('checkout_date_time','=','')->where('created_by',$staff_details->created_by)->orderBy('id','desc')->where('deleted_at',null)->get();
            }
        }
// echo "<pre>";print_r($data);exit;
        // and then you can get query log
        foreach($data as $customer){
  
            
         if(Auth::user()->user_type == 4){  //hotel admin staff
            $assigned_properties = DB::table('staff_assigned_properties')->where('property_id',  $customer->property_id)->first();
        
                if(!empty($assigned_properties)){
                    $customer = $customer;
                } else {
                    $customer = array();
                }
            }
            
            //create full name 
            $customer->first_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            // echo "<pre>";print_r($customer);exit;
            $room_details = Room::find($customer->room_id);
            
            if($customer->room_id){
                $customer->room_id =  $room_details->title;
            } else {
                $customer->room_id =  '';
            }
            

            //get country title
            if($customer->nationality){
                $country_title = Country::find($customer->nationality);
                if(empty($country_title)){
                    $customer->nationality = '';
                } else {
                    $customer->nationality = $country_title->name;
                }
                
            } else {
                $customer->nationality = 'India';
            }

            //get customer id
            $id = $customer->id;

            //check if date range is requested and get customer accordingly
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 2){  
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                   if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                    $customer = $customer;
                   } else {
                    $customer = array();
                   }
                } 
            }
            
            
            //check if property id for filter
            if(array_key_exists('property_id',$datas)){
                if($datas['property_id']) {
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                        $customer = $customer;
                    } else {
                        $customer = array();
                    }
                }
            }
        }

        if($user_type == 5){
            $action = '<a href="{{ route("customers.viewdetails",["id"=>base64_encode($id)]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="View Details" class="view_cust_details" ><i class="cil-folder-open"></i></a>';
        } else {
            if(!empty($getPrivileges)){
                if($getPrivileges->edit ==1 && $getPrivileges->delete ==1){ //allow delete and edit access
                    $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                } else if($getPrivileges->edit ==1 && $getPrivileges->delete !=1){//allow edit access
                    $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
                } else if($getPrivileges->delete == 1 && $getPrivileges->edit != 1){
                    $action = '<button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
                } else {
                    $action =  '';
                }
            } else {
                $action = '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button><a href="{{ route("complaints.create",["id"=>$id]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="File Complaint" ><i class="fa fa-folder"></i></a>';
            }
        }

        if ($request->ajax()) {
            return Datatables::of($data)
                    ->addColumn('action', $action)
                    // ->addColumn('action', '<a href="/customers/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                    ->rawColumns(['action'])
                    ->make(true);
        }
        return view('dashboard.customers.customersList',['privileges'=>$getPrivileges,'properties'=>$properties]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
       
        // $id_proof_type = IdProofTypes::where('created_by',Auth::user()->id)->get();
        $id_proof_type = IdProofTypes::where('deleted_at',null)->get();
        $countries = Country::all(); 
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        
        $booking_type = BookingTypes::where('created_by',Auth::user()->id)->get();    


        if(Auth::user()->user_type == 3){
            $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
            $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
             $rooms = Room::where('created_by',Auth::user()->id)->where('deleted_at',null)->where('status','1')->whereDoesntHave('customers')->get();
        } else if(Auth::user()->user_type == 4){
            $staff_info = Staffs::where('email',Auth::user()->email)->first();
            $staff_property_info = DB::table('staff_assigned_properties')->where('staff_id',$staff_info->id)->get();
            // echo "<pre>";print_r($staff_property_info);exit;
             $properties = Properties::where('status_id','1')->where('id',$staff_property_info[0]->property_id)->get(); 
              $rooms = Room::where('property_id',$staff_property_info[0]->property_id)
              ->whereNotIn('id', function ($query) {
                    $query->select('room_id')->from('customers')->whereNotNull('room_id');
                })
    ->where('deleted_at',null)->where('status','1')->get();
        }
        
        $cust = array();
        return view('dashboard.customers.create',['customer'=>$cust,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>array(),'countries'=>$countries,'properties'=>$properties,'booking_type'=> $booking_type]);
    }

     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // echo "<pre>";orint_r("HERE1");exit;
        $hotel_admin_id = Auth::user()->id;

        // $validatedData = $request->validate([
        //     'first_name'      => 'required|min:1|max:64',
        //     'last_name'       => 'required|min:1|max:64',
        //     // 'email'           => 'required|email|unique:customers',
        //     'mobile'          => 'required|max:10',
        //     'profile_pic' => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
        // ]);
       
        //insert new hotel admin in users table
        //get recently adde cust
        $check_if_exists = Customers::where('email',$request->input('email'))->first();
        if(!$check_if_exists){
            $customer = new Customers();
        } else {
            $customerID = $check_if_exists->id;
            $customer = Customers::find($customerID);
        }
        
        //for basic info tab details
        // $customer = new Customers();
        $customer->full_name    = $request->input('full_name');
        $customer->first_name    = $request->input('first_name');
        $customer->middle_name    = $request->input('middle_name');
        $customer->last_name    = $request->input('last_name');
        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->nationality   =  $request->input('nationality');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->gender   =  $request->input('gender');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        
        $customer->no_of_nights   =  $request->input('no_of_nights');
        $customer->tentative_checkout_date   =  $request->input('tentative_checkout_date');
        $customer->room_rate_info   =  $request->input('room_rate_info');
        $customer->no_of_guests   =  $request->input('no_of_guests');
          
        $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        // $customer->checkout_date_time   = 

        //for address tab details
        $customer->address    = $request->input('address');
        // $customer->address_line_1    = $request->input('address_line_1');
        // $customer->address_line_2    = $request->input('address_line_2');
        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');
        
        $customer->visa_number   =  $request->input('visa_number');
        $customer->visa_issue_date   =  $request->input('visa_issue_date');
        $customer->visa_expiry_date   =  $request->input('visa_expiry_date');
        $customer->other_id_type   =  $request->input('other_id_type');
        $customer->other_id_number   =  $request->input('other_id_number');
        $customer->other_id_expiry_date   =  $request->input('other_id_expiry_date');

        $customer->emergency_contact_no   =  $request->input('emergency_contact_no');
        $customer->emergency_contact_name   =  $request->input('emergency_contact_name');
        $customer->emergency_contact_description   =  $request->input('emergency_contact_description');
        
        $customer->booking_type   =  $request->input('booking_type');
        $customer->booking_no   =  $request->input('booking_no');
        $customer->booking_description   =  $request->input('booking_description');
        $customer->guest_folio_id   =  $request->input('guest_folio_id');

        $customer->vat_in_no   =  $request->input('vat_in_no');
        $customer->company_details   =  $request->input('company_details');
        $customer->created_by = Auth::user()->id;
        $customer->save();
        
        //get recently adde cust
        $recent = Customers::where('email',$request->input('email'))->first();
        $recent_cust_id = $recent->id;

        $title = "CheckIn Alert";
        $body = 'Customer '.$customer->first_name.' '.$customer->last_name.' has been checked in to this room';
        self::sendNotification($customer->room_id,$title,$body,1);
        
        //create guest code
        $property = Properties::find($request->input('property_id'));
        $total_cnt_q = DB::table('customers')
            ->select('id')
            ->Where('property_id', $request->input('property_id'))
            ->get();
        $total_cnt = count($total_cnt_q);
        $total_cnt = $total_cnt + 1;
        $cust_code = sprintf("%'.04d\n", $total_cnt);
       
        $guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;    
        $update_guest_code_ar = array('guest_code' => $guest_code);
        DB::table('customers')->where('id', $recent_cust_id)->update($update_guest_code_ar);

            //for custoomer uploaded document
            //Create hotel admin folder if not exists
            $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
            if(!File::isDirectory($hotel_admin_path)){
                File::makeDirectory($hotel_admin_path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
            }
            
            // create or update file in directory if exists in hotel admin folder
            $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
            if(!File::isDirectory($path)){
                File::makeDirectory($path, 0777, true, true);
                File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
            }

            //for customer dp
            if ($request->hasFile('profile_pic')) {

                $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('profile_pic')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                // Upload Image$path = 
                $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
                $dp_array = array('profile_image'=>$fileNameToStore,);
                DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
                
            } else {
                $fileNameToStore = '';
                $img = '';
            }



         

            // $cnt = count($request->input('document_type'));
            // $cust_docs_arr = array();
            // for ($i=0; $i < $cnt; $i++){
            //     //store uploaded docs
            //     if ($request->hasFile('uploaded_document')) {

            //          // Get filename with the extension
            //         $custDocsfilenameWithExt = $request->file('uploaded_document')[$i]->getClientOriginalName();
            //         // Get Filename
            //         $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
            //         // Get just Extension
            //         $custDocsextension = $request->file('uploaded_document')[$i]->getClientOriginalExtension();
            //         // 
            //         $custDocsfileNameToStore = $custDocfilename. '_'. time().'.'.$custDocsextension;
                
            //         $cust_doc = $request->file('uploaded_document')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$recent_cust_id,$custDocsfileNameToStore);
            //     } else {
            //         $custDocsfileNameToStore = '';
            //         $cust_doc = '';
            //     }
            
            //     $cust_docs_arr = array(
            //         'customer_id'=>$recent_cust_id,
            //         'document_type'=>$request->input('document_type')[$i],
            //         'number'=>$request->input('number')[$i],
            //         'uploaded_document'=>$custDocsfileNameToStore,
            //     );
            //     $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
            // }	

        $request->session()->flash('message', 'Customer Created Successfully.');
        return redirect()->route('customers.index');
    }

    //for editing gov admin
    public function edit($id)
    {
        $customer = Customers::find($id);
       
        $countries = Country::all();
        $booking_type = BookingTypes::where('created_by',Auth::user()->id)->get();    
        
        if(Auth::user()->user_type == 3){
            $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
            $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
             $rooms = Room::where('created_by',Auth::user()->id)->where('deleted_at',null)->where('status','1')->get();
        } else if(Auth::user()->user_type == 4){
            $staff_info = Staffs::where('email',Auth::user()->email)->first();
            $staff_property_info = DB::table('staff_assigned_properties')->where('staff_id',$staff_info->id)->get();
            // echo "<pre>";print_r($staff_property_info);exit;
            $properties = Properties::where('status_id','1')->where('id',$staff_property_info[0]->property_id)->get();   
            $rooms = Room::where('property_id',$staff_property_info[0]->property_id)->where('deleted_at',null)->where('status','1')->get();
        }
        
        
        
        // $id_proof_type = IdProofTypes::where('created_by',Auth::user()->id)->get();
        $id_proof_type = IdProofTypes::where('deleted_at',null)->get();
        

        $docs = DB::table('customer_documents')->where('customer_id',$id)->where('deleted_at',null)->get();
        
        $docs_array = array();
       
        $all_notes = DB::table('customer_notes')->where('customer_id',$id)->where('deleted_at','0')->get();
        $notes_ar = array();
        foreach($all_notes as $note){
            $notes_ar[] = $note;
        }
        if($customer->checkin_date_time){
            $checkin_date_time = explode(' ',$customer->checkin_date_time);
            $customer->checkin_date = '';
            $customer->checkin_time = '';
            $customer->checkin_date = $checkin_date_time[0];
            $customer->checkin_time = $checkin_date_time[1];
        } else {
            $customer->checkin_date = '';
            $customer->checkin_time = '';
        }
        
        if($customer->checkout_date_time){
            $checkout_date_time = explode(' ',$customer->checkout_date_time);
            $customer->checkout_date = '';
            $customer->checkout_time = '';
            $customer->checkout_date = $checkout_date_time[0];
            $customer->checkout_time = $checkout_date_time[1];
        } else {
            $customer->checkout_date = '';
            $customer->checkout_time = '';
        }
        //customer profile image path
        // $customer->profile_image = 'storage/app/public/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/display_picture'.'/'.$customer->profile_image;
        // echo $customer->profile_image;exit;
        if($docs){
            $docs_array = $docs;
            $base_url = URL('/');
            foreach($docs_array as $doc){
                // echo "<pre>";print_r($docs);exit;
                //  $path = $base_url.'/public/storage/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/'.$doc->uploaded_document;
                 
                 
                //  $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $path = Storage::url('app/public/uploads/hotel_admins/'.$customer->created_by.'/customer_documents/'.$customer->id.'/'.$doc->uploaded_document);

                $doc->uploaded_document= $path;
                // $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;

                //get doc type
                $types = IdProofTypes::find($doc->document_type);
                $doc->document_type = $types->title;
         }
        } else {
            $docs_array = array();
        }
         //complaint found if any for complaint tab
          $complaintExists = DB::table('customers as cs')
          ->select('cs.id','cs.passport_number')
          ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
          ->where('cs.passport_number',$customer->passport_number)
          ->orWhere('cs.first_name', 'like', '%' . $customer->first_name . '%')
          ->orWhere('cs.last_name', 'like', '%' . $customer->last_name . '%')
          ->get();
            $complaint_cust_str = '';
            if(!empty($complaintExists)){
                foreach($complaintExists as $cust ){
                    $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                    if(!empty($complaints_list)){
                        if($cust->passport_number == $customer->passport_number){
                            $complaint_cust_str .= $cust->id.',';
                        }
                    }
                }
            }

            //complaint found if any for complaint tab
            $criminalExists = DB::table('criminal_records as cr')
            ->select('id')
            ->orWhere('first_name', 'like', '%' . $customer->full_name . '%')
            ->orWhere('last_name', 'like', '%' . $customer->full_name . '%')
            // ->orWhere('full_name', 'like', '%' . $customer->full_name . '%')
            ->get();
            // echo "<pre>";print_r( $criminalExists)  ;exit;
            $crminal_cust_str = '';
            foreach($criminalExists as $cust ){
                $crminal_cust_str .= $customer->id.',';
            }
            
        // echo "<pre>";print_r($docs_array);exit;
        
         $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$id)->get();
         
        return view('dashboard.customers.edit', ['notes_ar'=>$notes_ar,'rooms'=>$rooms, 'customer' => $customer,'docs'=>$docs_array ,'types'=>$id_proof_type,'countries'=>$countries,'properties'=>$properties,'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str,'booking_type'=> $booking_type,'sub_guests'=> $all_customer_sub_guests]);
        // return response()->json(array('cust_id'=>$recent_cust_id, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str));
   
    }

        /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            // 'full_name'      => 'required|min:1|max:64',
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
            // 'email'           => 'required|email|unique:customers',
            'mobile'          => 'max:10',
            // 'profile_pic' => 'mimes:jpg,png,jpeg|min:1|max:1000',
        ]);

        $customer = Customers::find($id);
        $cusrID =  $request->input('cusrID');
        //Create hotel admin folder if not exists
        $hotel_admin_id  = Auth::user()->id;
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }

        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$cusrID);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$cusrID.'/display_picture', 0777, true, true);
        }

        //if customer display image
        if ($request->hasFile('file')) { 

            $filenameWithExt = $request->file('file')->getClientOriginalName();
            //Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file')->getClientOriginalExtension();
            // Filename to store
            $fileNameToStore = 'profile_'.time().'.'.$extension;
            // Upload Image
            $path = $request->file('file')->storeAs('public/upl',$fileNameToStore);


            $path2 =  Storage::disk('public')->putFile('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$cusrID.'/display_picture', $request->file('file'));


            // echo "<pre>ssssssssss";print_r($path2);exit;
            
            $filenameWithExt = $request->file('file')->getClientOriginalName ();
            // Get Filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $request->file('file')->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore =  'prodile_'. time().'.'.$extension;
            // Upload Image$path = 
            $img = $request->file('file')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$cusrID.'/display_picture', $fileNameToStore);
        } else { 
            // echo "<pre>ssssssssss";print_r($request->file('file'));exit;
            $fileNameToStore = $customer->profile_image; 
            $img = '';
        }

        //create guest code 
        if(!$request->input('guest_code')){
            $property = Properties::find($request->input('property_id'));
            $total_cnt_q = DB::table('customers')
                ->select('id')
                ->Where('property_id', $request->input('property_id')) 
                ->get();
            $total_cnt = count($total_cnt_q);
            $total_cnt = $total_cnt + 1;
            $cust_code = sprintf("%'.04d\n", $total_cnt);
            $customer->guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;    
        } else {
            $customer->guest_code = $request->input('guest_code');
        }
   
        //for basic info tab details
        $customer->full_name    = $request->input('full_name');
        $customer->first_name    = $request->input('first_name');
        $customer->middle_name    = $request->input('middle_name');
        $customer->last_name    = $request->input('last_name');
        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->nationality   =  $request->input('nationality');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->gender   =  $request->input('gender');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        // $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');

        $customer->profile_image   =  $fileNameToStore;

        //for address tab details
        $customer->address    = $request->input('address');
        // $customer->address_line_1    = $request->input('address_line_1');
        // $customer->address_line_2    = $request->input('address_line_2');
        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');

        $customer->visa_number   =  $request->input('visa_number');
        $customer->visa_issue_date   =  $request->input('visa_issue_date');
        $customer->visa_expiry_date   =  $request->input('visa_expiry_date');
        $customer->other_id_type   =  $request->input('other_id_type');
        $customer->other_id_number   =  $request->input('other_id_number');
        $customer->other_id_expiry_date   =  $request->input('other_id_expiry_date');
        
        if(!$request->input('confirm_checkin')){
            $confirm_checkin = 0;
        } else {
            $confirm_checkin = $request->input('confirm_checkin');
        }
        $customer->confirm_checkin   =  $confirm_checkin;
        
        $customer->emergency_contact_no   =  $request->input('emergency_contact_no');
        $customer->emergency_contact_name   =  $request->input('emergency_contact_name');
        $customer->emergency_contact_description   =  $request->input('emergency_contact_description');
        
        $customer->booking_type   =  $request->input('booking_type');
        $customer->booking_no   =  $request->input('booking_no');
        $customer->booking_description   =  $request->input('booking_description');
        $customer->guest_folio_id   =  $request->input('guest_folio_id');

        $customer->no_of_nights   =  $request->input('no_of_nights');
        $customer->tentative_checkout_date   =  $request->input('tentative_checkout_date');
        $customer->room_rate_info   =  $request->input('room_rate_info');
         $customer->no_of_guests   =  $request->input('no_of_guests');
        
         $customer->vat_in_no   =  $request->input('vat_in_no');
        $customer->company_details   =  $request->input('company_details');

// echo "<pre>";print_r($customer);exit;
        // $customer->created_by = Auth::user()->id;
        $customer->save();

        //for custoomer uploaded document

        // $cnt = count($request->input('document_type'));
        // $cust_docs_arr = array();
        // for ($i=0; $i < $cnt; $i++){
        //     //store uploaded docs
        //     if ($request->hasFile('uploaded_document')) { 
        //         if(empty($request->file('uploaded_document')[$i])){

        //         } else {
        //             // Get filename with the extension
        //             $custDocsfilenameWithExt = $request->file('uploaded_document')[$i]->getClientOriginalName();
        //             // Get Filename
        //             $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
        //             // Get just Extension
        //             $custDocsextension = $request->file('uploaded_document')[$i]->getClientOriginalExtension();
        //             $custDocsfileNameToStore = $custDocfilename. '_'. time().'.'.$custDocsextension;
        //             $cust_doc = $request->file('uploaded_document')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$id,$custDocsfileNameToStore);
                    
        //             $cust_docs_arr = array(
        //                 'customer_id'=>$id,
        //                 'document_type'=>$request->input('document_type')[$i],
        //                 'number'=>$request->input('number')[$i],
        //                 'uploaded_document'=>$custDocsfileNameToStore,
        //             );
        //             $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
        //         }    
        //     } 
        // }	

        $request->session()->flash('message', 'Customer Updated Successfully.');
        return redirect()->route('customers.index');
    }

       /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();  
        $id = $data['id'];
        // if delete request is for remove doument for removing document
      
        if($data['type'] == 'remove_document'){
            //here $id is primary id of document table
            $custDocs = CustomerDocuments::find($id);
            $curr_doc = $custDocs->uploaded_document;
            $customer_id = $custDocs->customer_id;
            $customer = Customers::find($customer_id);
            // echo $customer_id.' - '.$curr_doc;exit;
            $custDocs->delete();
            $path = public_path('storage/trash/hotel_admins/'.$customer->created_by.'/removed_customer_documents/'.$customer_id);
            if(!File::isDirectory($path)){
                File::makeDirectory($path, 0777, true, true);
            }
            $existing_file_path = public_path('storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer_id.'/'.$curr_doc);
            // $trash_file_path_dir = public_path('storage/trash/hotel_admins/'.$customer->created_by.'/'.'removed_customer_documents/'.$customer_id.'/'.$curr_doc);
        
            // File::move($existing_file_path, $trash_file_path_dir);

            $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->orderBy('id','desc')->get();
            $docs_array_updated = array();
            if($docs){
                $docs_array = $docs;
                foreach($docs_array as $doc){
                    $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                    $doc->uploaded_document= $path;
    
                    //get doc type
                    $types = IdProofTypes::find($doc->document_type);
                    $doc->document_type = $types->title;
                    $docs_array_updated[] = $doc;
                }
            } else {
                $docs_array_updated = array();
            }
            $baseUrl = url('/');
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
                            <thead>
                                <tr>
                                    <th>Document Type</th>
                                    <th>Number</th>
                                    <th>Expiry Date</th>
                                    <th>Uploaded File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>";
            if(!empty($docs_array_updated)){
                foreach($docs_array_updated as $docs){
                    $tbl .=   "<tr>
                                    <td>".$docs->document_type."</td>
                                    <td>".$docs->number."</td>
                                    <td>".$docs->doc_expiry_date."</td> 
                                    <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                    <td>
                                        <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;'><i class='cil-folder-open' aria-hidden='true' id='doc_{$docs->id}'></i></a>
                                        <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}' data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
        
                                    </td>
                                </tr>";
                }
            } else {
                $tbl .=   "<tr><td>No documents found</td>
                <td></td>
                <td></td>
                <td></td></tr>";
            }
            $tbl .= "</tbody></html>";
            return response()->json(array('success'=>true, 'html'=>$tbl));

        } else if($data['type'] == 'remove_note'){//remove note
            $notes_array = array('deleted_at'=>'1');
            $notes_info = DB::table('customer_notes')->where('id', $id)->first();
            $cid =$notes_info->customer_id;
            $cid = DB::table('customer_notes')->where('id', $id)->update($notes_array);
            $all_notes = DB::table('customer_notes')->where('customer_id',$cid)->where('deleted_at','0')->get();
            
            $request->session()->flash('message', 'Customer Deleted Successfully.');
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
            <thead>
                <tr>
                    <th>Date & Time</th>
                    <th>Note</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>'";
            if(!empty($all_notes)){
                foreach($all_notes as $note){
                    $tbl .=   "'<tr>
                    <td>".$note->date_time."</td>
                    <td>".$note->note."</td>
                    <td>
                        <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$note->id}'  data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
                    </td>
                </tr>";
                }
            } else {
                $tbl .=   "<tr><td>No Notes found</td>
                <td></td>
                <td></td></tr>";
            }
            $tbl .= "</tbody></html>";
            return response()->json(array('success'=>true, 'html'=>$tbl));
        } else {    
            //here $id is for primary id of customer table for deleteing customer
            $customer = Customers::find($id);
            if($customer){
                $customer->delete();
            } 
            $request->session()->flash('message', 'Customer Deleted Successfully.');
            return redirect()->route('customers.index');
        }        
    }

   /*
    Save the customers additional info
    */

    

    public function saveAdditionalInfo(Request $request)
    { 
        $data = $request->all();  
        $validatedData = $request->validate([
        ]);
        // echo "<pre>";print_r($data);exit;
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        $recent = Customers::orderBy('id','desc')->first();
        $recent_cust_id = $recent->id;

        $docs = DB::table('customer_documents')->where('customer_id',$recent_cust_id)->where('deleted_at',null)->get();
        $docs_array = array();
        $hotel_admin_id = Auth::user()->id;
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
        }

        //customer profile image path
        $recent->profile_image = 'public/storage/uploads/hotel_admins/'.$recent->created_by.'/customer_documents'.'/'.$recent->id.'/display_picture'.'/'.$recent->profile_image;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'public/storage/uploads/hotel_admins/'.$recent->created_by.'/'.'customer_documents/'.$recent->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;
            }
        } else {
            $docs_array = array();
        }

        //complaint found if any for complaint tab
        $complaintExists = DB::table('customers as cs')
                            ->select('cs.id','cs.passport_number')
                            ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
                            ->where('cs.passport_number',$recent->passport_number)
                            ->orWhere('cs.first_name', 'like', '%' . $recent->first_name . '%')
                            ->orWhere('cs.last_name', 'like', '%' . $recent->last_name . '%')
                            ->get();
        $complaint_cust_str = '';
        if(!empty($complaintExists)){
            foreach($complaintExists as $cust ){
                $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                if(!empty($complaints_list)){
                    if($cust->passport_number == $recent->passport_number){
                        $complaint_cust_str .= $cust->id.',';
                    }
                }
            }
        }
        
        //complaint found if any for complaint tab
        $criminalExists = DB::table('criminal_records as cr')
        ->select('id')
        ->orWhere('first_name', 'like', '%' . $recent->first_name . '%')
        ->orWhere('last_name', 'like', '%' . $recent->last_name . '%')
        ->get();
        $crminal_cust_str = '';
        foreach($criminalExists as $cust ){
            $crminal_cust_str .= $recent_cust_id.',';
        }

        // return $recent_cust_id;
        return response()->json(array('cust_id'=>$recent_cust_id, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str));
    }

    public function saveBasicInfo_old(Request $request)
    { 
        $data = $request->all();  
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
        ]);
      
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        //insert new hotel admin in users table
        $customer = new Customers();
        // //for basic info tab details
        $customer->first_name    = $request->input('first_name');
        // $customer->middle_name    = $request->input('middle_name');
        $customer->last_name    = $request->input('last_name');
        // $customer->email   =  $request->input('email');
        // $customer->mobile   =  $request->input('mobile');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        // $customer->gender   =  $request->input('gender');
        // $customer->room_id   =  $request->input('room_id');
        $customer->nationality   =  $request->input('nationality');
        // $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        // $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');
        // $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        // $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->passport_number   =  $request->input('passport_number');
        // $customer->property_id   =  $request->input('property_id');
        $customer->created_by = Auth::user()->id;
        $customer->save();
        $recent_cust_id = $customer->id;
        //get recently adde cust
        // $recent = Customers::where('full_name',$request->input('email'))->first();
        // $recent_cust_id = $recent->id;

        $recent = Customers::orderBy('id','desc')->first();
        $created_by = Auth::user()->id;
        if($recent){
             $recent_cust_id = $recent->id;
        } else {
             $recent_cust_id = 1;
        }
        
        //   echo "<pre>";print_r($recent);exit;

        $docs = DB::table('customer_documents')->where('customer_id',$recent_cust_id)->where('deleted_at',null)->get();
        $docs_array = array();
        $hotel_admin_id = Auth::user()->id;
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
        }

        // //for customer dp
        // if ($request->hasFile('profile_pic')) {

        //     $filenameWithExt = $request->file('profile_pic')->getClientOriginalName ();
        //     // Get Filename
        //     $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //     // Get just Extension
        //     $extension = $request->file('profile_pic')->getClientOriginalExtension();
        //     // Filename To store
        //     $fileNameToStore = $filename. '_'. time().'.'.$extension;
        //     // Upload Image$path = 
        //     $img = $request->file('profile_pic')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
        //     $dp_array = array('profile_image'=>$fileNameToStore,);
        //     DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
            
        // } else {
        //     $fileNameToStore = '';
        //     $img = '';
        // }

        //customer profile image path
        $recent->profile_image = 'public/storage/uploads/hotel_admins/'.$created_by.'/customer_documents'.'/'.$recent_cust_id.'/display_picture'.'/'.$recent->profile_image;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'public/storage/uploads/hotel_admins/'.$created_by.'/'.'customer_documents/'.$recent_cust_id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;
            }
        } else {
            $docs_array = array();
        }

        //complaint found if any for complaint tab
        $complaintExists = DB::table('customers as cs')
                            ->select('cs.id','cs.passport_number')
                            ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
                            ->where('cs.passport_number',$recent->passport_number)
                            ->orWhere('cs.first_name', 'like', '%' . $recent->first_name . '%')
                            ->orWhere('cs.last_name', 'like', '%' . $recent->last_name . '%')
                            ->get();
        $complaint_cust_str = '';
        if(!empty($complaintExists)){
            foreach($complaintExists as $cust ){
                $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                if(!empty($complaints_list)){
                    if($cust->passport_number == $recent->passport_number){
                        $complaint_cust_str .= $cust->id.',';
                    }
                }
            }
        }
        
        // Show exclamatory mark if guest is blacklisted from any of logged in hotel admin properties.
        $blacklist_by_same_hotel_admin = DB::table('blacklists')
                ->select('id')
                ->where('created_by', Auth::user()->id)
                ->where('passport_no',$recent->passport_number)
                ->where('date_of_birth',$recent->date_of_birth)
                ->orWhere('name', 'like', '%' . $recent->first_name . '%')
                ->orWhere('name', 'like', '%' . $recent->last_name . '%')
                ->orWhere('nationality',$recent->nationality)
            ->get();
        $show_exclamatory_mark = '';
        if(!empty($blacklist_by_same_hotel_admin)){
            $show_exclamatory_mark = '1';
        }

      // Show exclamatory mark if guest is blacklisted from any of logged in hotel admin properties.
      $blacklist_by_other_hotel_admin = DB::table('blacklists')
            ->select('id')
            ->where('passport_no',$recent->passport_number)
            ->where('date_of_birth',$recent->date_of_birth)
            ->orWhere('name', 'like', '%' . $recent->first_name . '%')
            ->orWhere('name', 'like', '%' . $recent->last_name . '%')
            ->orWhere('nationality',$recent->nationality)
        ->get();
        $show_multiple_triangles_mark = '';
        if(!empty($blacklist_by_other_hotel_admin)){
            $show_multiple_triangles_mark = '1';
        }


        //complaint found if any for complaint tab
        $criminalExists = DB::table('criminal_records as cr')
        ->select('id')
        ->orWhere('first_name', 'like', '%' . $recent->first_name . '%')
        ->orWhere('last_name', 'like', '%' . $recent->last_name . '%')
        ->get();
        $crminal_cust_str = '';
        foreach($criminalExists as $cust ){
            $crminal_cust_str .= $recent_cust_id.',';
        }

        //complaint found if any for complaint tab
        $blacklistExists = DB::table('blacklists')
            ->select('id')
            ->Where('date_of_birth', 'like', '%' . $recent->date_of_birth . '%')
            ->Where('passport_no', 'like', '%' . $recent->passport_no . '%')
            ->orWhere('name', 'like', '%' . $recent->first_name . '%')
            ->orWhere('name', 'like', '%' . $recent->last_name . '%')
            ->orWhere('nationality', 'like', '%' . $recent->nationality . '%')
        ->get();
        $blacklists_str = '';
        foreach($blacklistExists as $cust ){
            $blacklists_str .= $recent_cust_id.',';
        }

        //show caution icon
        $show_caution_mark =''; 
        if($blacklists_str || $crminal_cust_str){
            $show_caution_mark = '1';
        }

        // return $recent_cust_id;
        return response()->json(array('cust_id'=>$recent_cust_id,'show_exclamatory_mark'=>$show_exclamatory_mark,'show_multiple_triangles_mark'=>$show_multiple_triangles_mark,'show_caution_mark'=>$show_caution_mark, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str,'blacklists_str'=>$blacklists_str));
        // return view('dashboard.customers.create',['customer'=>$recent,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>$docs_array]);
    }


    public function saveBasicInfo(Request $request)
    { 
        
        //   echo "<pre>";print_r("HERE14e4444");exit;
          
        $data = $request->all();  
        $validatedData = $request->validate([
            'first_name'      => 'required|min:1|max:64',
            'last_name'       => 'required|min:1|max:64',
        ]);
      
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        //insert new hotel admin in users table
        $customer = new Customers();
        // //for basic info tab details
        $customer->first_name    = $request->input('first_name');
        $customer->last_name    = $request->input('last_name');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->nationality   =  $request->input('nationality');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->created_by = Auth::user()->id;
        $customer->save();
        $recent_cust_id = $customer->id;

        //complaint found if any for complaint tab
        $complaintExists = DB::table('customers as cs')->select('cs.id','cs.passport_number')
                            ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
                            ->where('cs.passport_number',$request->input('passport_number'))
                            ->orWhere('cs.first_name', 'like', '%' . $request->input('first_name') . '%')
                            ->orWhere('cs.last_name', 'like', '%' . $request->input('last_name') . '%')
                            ->get();
        $complaint_cust_str = '';
        if(!empty($complaintExists)){
            foreach($complaintExists as $cust ){
                $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                if(!empty($complaints_list)){
                    if($cust->passport_number == $recent->passport_number){
                        $complaint_cust_str .= $cust->id.',';
                    }
                }
            }
        }
        
        // Show exclamatory mark if guest is blacklisted from any of logged in hotel admin properties.
        $blacklist_by_same_hotel_admin = DB::table('blacklists')
                ->select('id')
                ->where('created_by', Auth::user()->id)
                ->where('passport_no',$request->input('passport_number'))
                ->where('date_of_birth',$request->input('date_of_birth'))
                ->orWhere('name', 'like', '%' . $request->input('first_name') . '%')
                ->orWhere('name', 'like', '%' . $request->input('last_name') . '%')
                ->orWhere('nationality', $request->input('nationality'))
            ->get();
        $show_exclamatory_mark = '';
        if(!empty($blacklist_by_same_hotel_admin)){
            $show_exclamatory_mark = '1';
        }

      // Show exclamatory mark if guest is blacklisted from any of logged in hotel admin properties.
      $blacklist_by_other_hotel_admin = DB::table('blacklists')
            ->select('id')
            ->where('passport_no',$request->input('passport_number'))
            ->where('date_of_birth',$request->input('date_of_birth'))
            ->orWhere('name', 'like', '%' . $request->input('first_name') . '%')
            ->orWhere('name', 'like', '%' . $request->input('last_name') . '%')
            ->orWhere('nationality', $request->input('nationality'))
        ->get();
        $show_multiple_triangles_mark = '';
        if(!empty($blacklist_by_other_hotel_admin)){
            $show_multiple_triangles_mark = '1';
        }

        //complaint found if any for complaint tab
        $criminalExists = DB::table('criminal_records as cr')
            ->select('id')
            ->orWhere('first_name', 'like', '%' . $request->input('first_name'). '%')
            ->orWhere('last_name', 'like', '%' . $request->input('last_name') . '%')
        ->get();
        $crminal_cust_str = '';
        foreach($criminalExists as $cust ){
            $crminal_cust_str .= '1';
        }

        //complaint found if any for complaint tab
        $blacklistExists = DB::table('blacklists')
            ->select('id')
            ->Where('date_of_birth', 'like', '%' . $request->input('date_of_birth') . '%')
            ->Where('passport_no', 'like', '%' . $request->input('passport_number') . '%')
            ->orWhere('name', 'like', '%' . $request->input('first_name') . '%')
            ->orWhere('name', 'like', '%' . $request->input('last_name') . '%')
            ->orWhere('nationality', 'like', '%' . $request->input('nationality'). '%')
        ->get();
        $blacklists_str = '';
        foreach($blacklistExists as $cust ){
            $blacklists_str .= '1';
        }

        //show caution icon
        $show_caution_mark =''; 
        if($blacklists_str || $crminal_cust_str){
            $show_caution_mark = '1';
        }

        // return $recent_cust_id;
        return response()->json(array('cust_id'=>$recent_cust_id,'show_exclamatory_mark'=>$show_exclamatory_mark,'show_multiple_triangles_mark'=>$show_multiple_triangles_mark,'show_caution_mark'=>$show_caution_mark, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str,'blacklists_str'=>$blacklists_str));
        // return view('dashboard.customers.create',['customer'=>$recent,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>$docs_array]);
    }

   /*
    Save the customers note info
    */
    public function saveNotesInfo(Request $request)
    { 
        $customer_id = $request->input('note_customer_id');
        $w_customer_id = $request->input('customer_id');
        // echo $customer_id.' - '.$w_customer_id;exit;
        $hotel_admin_id = Auth::user()->id;
        $data = $request->all();  
        $customer = Customers::find($customer_id);
        $notes_array = array('customer_id'=>$customer_id,'note'=>$data['note']);
        $insert_cust_docs = DB::table('customer_notes')->insertGetId($notes_array);
        $all_notes = DB::table('customer_notes')->where('customer_id',$customer_id)->where('deleted_at','0')->get();
        $all_notes_arr = array();
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Date & Time</th>
                <th>Note</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>'";
        if(!empty($all_notes)){
    
            foreach($all_notes as $note){
                $tbl .=   "'<tr>
                <td>".$note->date_time."</td>
                <td>".$note->note."</td>
                <td>
                    <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$note->id}' data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>

                </td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Notes not found</td>
            <td></td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
     
    /*
    Save the customers document info
    */
    public function saveDocumentInfo(Request $request)
    { 
        $customer_id = $request->input('customer_id');
        $hotel_admin_id = Auth::user()->id;
       
        $customer = Customers::find($customer_id);
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();
        $countries = Country::all();
        //for custoomer uploaded document
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id);
        
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id.'/display_picture', 0777, true, true);
        }
// echo "<pre>";print_r($request->all());exit;
        //for customer dp
        // if ($request->hasFile('guest_doc')) {

        //     $filenameWithExt = $request->file('guest_doc')->getClientOriginalName ();
        //     // Get Filename
        //     $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //     // Get just Extension
        //     $extension = $request->file('guest_doc')->getClientOriginalExtension();
        //     // Filename To store
        //     $fileNameToStore = $filename. '_'. time().'.'.$extension;
        //     // Upload Image$path = 
        //     $img = $request->file('guest_doc')->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id.'/display_picture', $fileNameToStore);
        //     $dp_array = array('profile_image'=>$fileNameToStore,);
        //     DB::table('customers')->where('id', $customer_id)->update($dp_array);
    
        // } else {
        //     $fileNameToStore = '';
        //     $img = '';
        // }
// echo "<pre>";print_r($request->all());exit;
        $cnt = count($request->input('doc_expiry_date'));
        $cust_docs_arr = array();
        for ($i=0; $i < $cnt; $i++){
            //store uploaded docs
            if ($request->hasFile('guest_doc')) {

                    // Get filename with the extension
                $custDocsfilenameWithExt = $request->file('guest_doc')[$i]->getClientOriginalName();
                // Get Filename
                $custDocfilename = pathinfo($custDocsfilenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $custDocsextension = $request->file('guest_doc')[$i]->getClientOriginalExtension();
                // 
                $custDocsfileNameToStore = 'Doc_'. time().'.'.$custDocsextension;
            
                $cust_doc = $request->file('guest_doc')[$i]->storeAs('public/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id,$custDocsfileNameToStore);
            }else if($request->input('docs_image') !=''){//webcam image
                $web_cam_image = $request->input('docs_image');
                $image_parts = explode(";base64,", $web_cam_image);
                $image_type_aux = explode("image/", $image_parts[0]);
                $image_type = $image_type_aux[1];
              
                $image_base64 = base64_decode($image_parts[1]);
                $custDocsfileNameToStore = uniqid() . '.png';
         
                $baseUrl = url('/');
                $file_path = 'storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents'.'/'.$customer_id.'/';
               
                $file = $file_path . $custDocsfileNameToStore; //echo $file;exit;
                file_put_contents($file, $image_base64);
            
            } else {
                $custDocsfileNameToStore = '';
                $cust_doc = '';
            }
          
            $cust_docs_arr = array(
                'customer_id'=>$customer_id,
                'document_type'=>$request->input('document_type')[$i],
                'number'=>$request->input('number')[$i],
                'uploaded_document'=>$custDocsfileNameToStore,
                'doc_expiry_date' => $request->input('doc_expiry_date')[$i],
            );
            // echo "<pre>";print_r($cust_docs_arr);exit;
            $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);
        }

        $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->orderBy('id','desc')->get();
        $docs_array_updated = array();
        
          if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                // $path = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $path = Storage::url('app/public/uploads/hotel_admins/'.$customer->created_by.'/customer_documents/'.$customer->id.'/'.$doc->uploaded_document);
            
                $doc->uploaded_document= $path;

                 //get doc type
                 $types = IdProofTypes::find($doc->document_type);
                 $doc->document_type = $types->title;

                $docs_array_updated[] = $doc;
            }
        } else {
            $docs_array_updated = array();
        }

        $baseUrl = url('/');
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Document Type</th>
                                        <th>Number</th>
                                        <th>Expiry Date</th>
                                        <th>Uploaded File</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($docs_array_updated) > 0){
                    foreach($docs_array_updated as $docs){
                        $tbl .=   "'<tr>
                                        <td>".$docs->document_type."</td>
                                        <td>".$docs->number."</td>
                                        <td>".$docs->doc_expiry_date."</td> 
                                        <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                        <td>
                                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;'><i class='cil-folder-open' aria-hidden='true' id='doc_{$docs->id}'></i></a>
                                            <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}' data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
            
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .= "<tr><td>No documents found</td>
                    <td></td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
        // return view('dashboard.customers.edit', ['rooms'=>$rooms, 'customer' => $customer,'docs'=>$docs_array ,'types'=>$id_proof_type,'countries'=>$countries]);
    }
    public function getNotes(Request $request)
    { 
        $data = $request->all();
        
        // echo "<pre>";print_r($data);exit;
        $all_notes = DB::table('customer_notes')->where('customer_id',$data['id'])->where('deleted_at','0')->get();
        $all_notes_arr = array();
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Date & Time</th>
                <th>Note</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>'";
        if(!empty($all_notes)){
    
            foreach($all_notes as $note){
                $tbl .=   "'<tr>
                <td>".$note->date_time."</td>
                <td>".$note->note."</td>
                <td>
                    <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$note->id}' data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>

                </td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Notes not found</td>
            <td></td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
        
    }
    
     /* load the customers document info */
     public function show(Request $request)
     { 
        $data = $request->all();
        // echo "<pre>";print_r($data);exit;
        //for filters
        if(array_key_exists('filters',$data) == true){
            return  $this->getPropertyFilterVal($data);
        }

        if(array_key_exists('is_inhouse',$data) == true){
            return  $this->getInHouseGuests($data);
        }
        
        
        if(array_key_exists('is_todays_checkouts',$data) == true){
            return  $this->getTodaysCheckouts($data);
        }
         if(array_key_exists('get_subguests',$data) == true){
            return  $this->getSubguests($data);
        }
        
        if(array_key_exists('is_undo_checkout',$data) == true){
            return  $this->getCheckedoutFoliosByRoom($data);
        }
        
        if(array_key_exists('is_contract_preview',$data) == true){
             $chk = $this->contract($data);
            if(!$chk){
                $request->session()->flash('error', 'Please create template from Guest Registration to preview contract.');
                return redirect()->route('customers.index');
            } else {
             return $chk;
            }
        }
        
        
        // if(array_key_exists('is_rc',$data) == false && !empty($data)){ 
        //     return  $this->getFoliosByRoom($data);
        // }
        
        if(array_key_exists('is_rc',$data) == true && !empty($data)){ 
            return  $this->getRoomDueCheckOut($data);
        }
        
        //for customer details view
        if(array_key_exists('type',$data) == false && !empty($data)){
            // if($data['type'] != 'get_complaints'){
                return  $this->viewCustomerDetails($data);
            // }
        }
       
        //for complaints list in customr 
        if(!empty($data)  && $data['type'] == 'get_complaints'    ){
            return  $this->getComplaints($data);
        }
        
        //for criminal list in customr 
        if(!empty($data)  &&  $data['type'] == 'get_criminal_record' ){
            return  $this->getCriminalRecord($data);
        }

         //for criminal list in customr 
         if(!empty($data)  && $data['type'] == 'criminal_view'){
            return  $this->getCriminalRecordDetails($data);
        }
        
        
         //for criminal list in customr 
        //  if($data['type'] == 'cust_contract'){
        //     return  $this->saveContractaspdf($data);
        // }
        
        
        //for criminal list in customr 
        if(!empty($data)  &&  $data['type'] == 'get_blacklists_record' ){
            return  $this->getBlacklistRecord($data);
        }
        
        //for blacklist list in customr 
        if(!empty($data)  && $data['type'] == 'blacklist_view'){
            return  $this->getBlacklistRecordDetails($data);
        }
            // echo "<pre>";print_r($data);exit;
        if(!empty($data)  &&  $data['type'] == 'get_subguests'){
            return  $this->getSubguests($data);
        }
        //for exclamation view
        if(!empty($data)  && $data['type'] == 'exclamation_view'){
            return  $this->getBlacklistRecordSameAdmin($data);
        }
        
         if(array_key_exists('is_rc',$data) == true && !empty($data)){ 
            return  $this->getDueRoomsByProperty($data);
        }
        
        //for exclamation view
        if(!empty($data)  && $data['type'] == 'get_other_admin_blacklist_record'){
            return  $this->getRecordsFromOtherAdminAlso($data);
        }
        
        if(!empty($data)  &&  $data['type'] == 'get_document'){//for getting customers docs
            
            $customer_id = $data['id'];
            $customer = Customers::find($customer_id);
            $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
            $docs_array = array();
            $baseUrl = url('/');
                foreach($docs as $doc){
                    // $path = $baseUrl.'/public/storage/uploads/hotel_admins/'.Auth::user()->id.'/'.'customer_documents/'.$customer_id.'/'.$doc->uploaded_document;
                    
                     

                        // $path = $baseUrl.'storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$customer_id.'/'.$doc->uploaded_document;
    $path = Storage::url('app/public/uploads/hotel_admins/'.$customer->created_by.'/customer_documents/'.$customer->id.'/'.$doc->uploaded_document);

    
                    $doc->action ='';
                    $doc->action ='<a data-toggle="tooltip" data-placement="top" title="View Document" href="'.$path.'" target="_blank" style="color: black;" class="anchordoc"><i class="cil-folder-open" aria-hidden="true" id="doc_'.$doc->id.'"></i></a><button style="padding: 0;border: none;background: none;" class="remove-doc" id="'.$doc->id.'" data-toggle="tooltip" data-placement="top" title="Remove Document" ><i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>'; 
                    
                    //get doc type
                    $types = IdProofTypes::find($doc->document_type);
                    $doc->document_type = $types->title;
                }
            
                $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->orderBy('id','desc')->get();
                $docs_array_updated = array();
                if($docs){
                    $docs_array = $docs;
                    foreach($docs_array as $doc){ 
                        // $path = 'storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                        $path = Storage::url('app/public/uploads/hotel_admins/'.$customer->created_by.'/customer_documents/'.$customer->id.'/'.$doc->uploaded_document);

                        $doc->uploaded_document= $path;
        
                        //get doc type
                        $types = IdProofTypes::find($doc->document_type);
                        $doc->document_type = $types->title;
                        $docs_array_updated[] = $doc;
                    }
                } else {
                    $docs_array_updated = array();

                }
                
                // echo "<pre>";print_r($docs_array_updated);exit;
                $baseUrl = url('/');
                $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Document Type</th>
                                        <th>Number</th>
                                        <th>Expiry Date</th>
                                        <th>Uploaded File</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($docs_array_updated) > 0){
                    foreach($docs_array_updated as $docs){
                        $tbl .=   "'<tr>
                                        <td>".$docs->document_type."</td>
                                        <td>".$docs->number."</td>
                                        <td>".$docs->doc_expiry_date."</td> 
                                        <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                        <td>
                                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;' class='anchordoc' ><i class='cil-folder-open' aria-hidden='true' id='doc_{$doc->id}'></i></a>
                                            <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}'  data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
            
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .=   "<tr><td>No documents found</td>
                    <td></td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
                return response()->json(array('success'=>true, 'html'=>$tbl));

        }else if(!empty($data)  &&  $data['type'] == 'get_notes'){//for getting customers docs
            
            $customer_id = $data['id'];
            $customer = Customers::find($customer_id);
             $notes = DB::table('customer_notes')->where('customer_id',$customer_id)->where('deleted_at','0')->get();
            $notes_array = array();
                foreach($notes as $note){
                    $notes_array[] = $note;
                }
                // echo "<pre>";print_r($notes_array);exit;
                $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Date & Time</th>
                                        <th>Note</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($notes_array) > 0){
                    foreach($notes_array as $not){
                        $tbl .=   "'<tr>
                                        <td>".$not->date_time."</td>
                                        <td>".$not->note."</td>
                                        <td>
                                            <button style='padding: 0;border: none;background: none;' class='remove-note' id='{$not->id}'  data-toggle='tooltip' data-placement='top' title='Remove Note' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .=   "<tr><td>No Notes found</td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
                return response()->json(array('success'=>true, 'html'=>$tbl));

        } else if(!empty($data)  &&  $data['type'] == 'get_recent_cust'){//for getting customers docs
            return $this->get_recent_cust($request);
        } else if(!empty($data)  &&  $data['type'] == 'export'){ //for customers export
            $export_file =  $this->export($data);
            return $export_file;
        } else if(!empty($data)  &&  $data['type'] == 'final_sub'){
            $roomid =  $data['roomid'];
            $final_submit =  $this->finalsubmit($request);
            return $final_submit;
        } else if(!empty($data)  &&  $data['type'] == 'get_subguests'){//for getting
            $customer_id = $data['id'];
            $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$customer_id)->get();
            $sub_guests_arr = array();
            
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
            <thead>
                <tr>
                    <th>Name</th>
                    <thpadding:5px !important;font-family:Arial, sans-serif !important;>Reamrk</th>
                </tr>
            </thead>
            <tbody>'";
            if(!empty($sub_guests_arr)){
        
                foreach($sub_guests_arr as $sug_guest){
                    $tbl .=   "'<tr>
                    <td>".$sug_guest->sub_guest_name."</td>
                    <td>".$sug_guest->sub_guest_remark."</td>
                </tr>";
                }
            } else {
                $tbl .= "<tr><td>Data not found</td>
                <td></td></tr>";
            }
            $tbl .= '</tbody></table>';
             return response()->json(array('success'=>true, 'html'=>$tbl));
        }
    }

    // export customer
    public function export($datas)
     { 
        $headers = [                 
            'Cache-Control'       => 'must-revalidate, post-check=0, pre-check=0',
            'Content-type'        => 'text/x-csv',
            'Content-Disposition' => 'attachment; filename=galleries.csv',
            'Expires'             => '0',
            'Pragma'              => 'public',
        ];

        // if(array_key_exists('stay_vals',$datas)){
        //     if($datas['stay_vals'] == 1){  //get customers only checked in currently
        //         $data = Customers::where('checkout_date_time','')->orderBy('id','desc')->get();
        //     } else {//get customer datewise
        //         $data = Customers::orderBy('id','desc')->get();
        //     }
        // } 
        // if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){
        //     $data = Customers::where('checkout_date_time','')->where('property_id',$datas['property_id'])->orderBy('id','desc')->get();
        // } else {
        //     $data = Customers::where('checkout_date_time','')->orderBy('id','desc')->get();
        // }

        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }
        
              DB::enableQueryLog();
        //get customers list only of checking in
                $dataq = DB::table('customers')->select('customers.first_name','customers.last_name','customers.visa_expiry_date', 'customers.other_id_type', 'customers.other_id_number', 'customers.other_id_expiry_date', 'customers.confirm_checkin' ,'customers.visa_issue_date', 'customers.visa_number','customers.id','customers.full_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.created_by');

            // $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.confirm_checkin','customers.created_by');
            $dataq->join('rooms','rooms.id','=','customers.room_id','left');
            $dataq->join('countries','countries.id','=','customers.nationality','left');
           
            if(array_key_exists('stay_vals',$datas)){ 
                if($datas['stay_vals'] == 1){  //get customers only checked in currently
                    $dataq->whereNull('customers.checkout_date_time');
                } else { //get customer datewise
                    $fromd = date('Y-m-d',strtotime($datas['from_date']));
                    $post_start_date =  \Carbon\Carbon::parse($fromd);
                     
                    $tod = date('Y-m-d',strtotime($datas['to_date']));
                    $post_end_date =  \Carbon\Carbon::parse($tod);
                    $dataq->where('customers.checkin_date_time','!=','')->whereBetween('customers.checkin_date_time', [$post_start_date, $post_end_date]);
                }
            }
            
            $dataq->Where('customers.checkout_date_time',NULL);
            if(array_key_exists('property_id',$datas) && $datas['property_id'] > 0){ 
                $dataq->where('customers.property_id',$datas['property_id']);
            }

            if(array_key_exists('room',$datas) && $datas['room'] > 0){
                $dataq->where('customers.room_id',$datas['room']);
            }
            
            if(array_key_exists('confirm_checkin',$datas) && $datas['confirm_checkin']){
                $dataq->where('customers.confirm_checkin',1);
            } else {
                $dataq->where('customers.confirm_checkin',0);
                $dataq->orWhere('customers.confirm_checkin',null);
            }
           
           if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){ 
                if(array_key_exists('include_cambodia',$datas) && $datas['include_cambodia'] == 1){ 
                    $dataq->where('customers.nationality','!=','38');
                } else {
                    $dataq->where('customers.nationality','38');
                }
           }
            
            $hotel_sub_id =   Auth::user()->id ;
            if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff ){//4 = hotel admin staff
    
                //get staff info for group 
                $getGroup = DB::table('staffs')->select('group_id','created_by')->where('main_user_id', Auth::user()->id)->first();
                 $hotelAdmin_id = HotelAdmin::where('main_user_id',$getGroup->created_by)->first();
                 $main_id = $getGroup->created_by;
                 $hotel_sub_id= $getGroup->created_by;
            } else {
                $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id )->first();
                $main_id = Auth::user()->id;
            }
            
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                  $dataq->where('customers.created_by',$main_id);
            }
         $data = $dataq->orderBy('customers.id','desc')->where('customers.deleted_at',null)->get();
        //   dd(DB::getQueryLog());;exit;
        //  echo "<pre>";print_r($data);exit;
        foreach($data as $key => $customer){
            
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if(array_key_exists('stay_vals',$datas)){
                    if($datas['stay_vals'] == 1){ 
                        if($customer->checkout_date_time){
                            unset($data[$key]);
                        }
                    }
                }
            }
            
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if($customer->created_by != $main_id){
                    unset($data[$key]);
                }
            }
            
            //create full name 
            // $customer->first_name =  $customer->full_name;
            $customer->full_name =  $customer->first_name.' '.$customer->last_name;
            //get room title
            // $room_details = Room::find($customer->room_id);
            $customer->room_id =  $customer->room_title;

            //get country title
            // $country_title = Country::find($customer->nationality);
            $customer_nationality_id = $customer->nationality;
            $customer->nationality = $customer->country_name;
            
            //get customer id
            $id = $customer->id;

            //check if date range is requested and get customer accordingly
            if(array_key_exists('stay_vals',$datas)){
                if($datas['stay_vals'] == 2){  
                    $from = $datas['from_date'].' 00:00:00';
                    $to = $datas['to_date'].' 00:00:00'; 
                    if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                    $customer = $customer;
                    } else {
                    $customer = array();
                    }
                }
            }
            
             //check if property id for filter
            if(Auth::user()->user_type != 5 && Auth::user()->user_type != 6){
                if( array_key_exists('property_id',$datas)){
                    if($datas['property_id']) {
                        $from = $datas['from_date'].' 00:00:00';
                        $to = $datas['to_date'].' 00:00:00'; 
                        if($customer->checkin_date_time < $from && $customer->checkout_date_time > $to ){
                            $customer = $customer;
                        } else {
                            $customer = array();
                        }
                    }
                }
            }
            
            if( array_key_exists('confirm_checkin',$datas) && $datas['confirm_checkin'] == 1 && $customer->confirm_checkin != 1){
                 $final_customer[] =  $customer;
                 unset($data[$key]);
            }
            
            if( array_key_exists('include_cambodia',$datas) && $datas['include_cambodia'] == 1 && $customer_nationality_id != 38){
                 $final_customer[] =  $customer;
                 unset($data[$key]);
            }
        }

        $columns = array('Name','Guest Code', 'Room', 'Nationality', 'CheckIn DateTime', 'CheckoutDateTime','Visa Number','Visa Issue Date','visa Expiry Date','Other ID Type','Other ID NUmber','Other ID Expiry Date','Confirmed Checkin');
    
        
        $callback = function() use ($data, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
                                                    
            foreach($data as $cust) { 
                $name = $cust->first_name.' '.$cust->last_name;
                fputcsv($file, array($name,$cust->guest_code, $cust->room_id, $cust->nationality, $cust->checkin_date_time, $cust->checkout_date_time,$cust->visa_number,$cust->visa_issue_date,$cust->visa_expiry_date,$cust->other_id_type,$cust->other_id_number,$cust->other_id_expiry_date,$cust->confirm_checkin));
            }
            fclose($file);
        };
        return response()->streamDownload($callback, 'Customers-' . date('d-m-Y-H:i:s').'.csv', $headers);
    }
    
    //for view of customer details in govt admin
    public function viewCustomerDetails($data)
    { 
        // base64_encode
        // echo "<pre>";print_r($data);exit;
       $customer_id = base64_decode($data['id']);
       $customer = Customers::find($customer_id);
       $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
       $docs_array = array();
       $baseUrl = url('/');
           foreach($docs as $doc){
               $path = $baseUrl.'/public/storage/uploads/hotel_admins/'.Auth::user()->id.'/'.'customer_documents/'.$customer_id.'/'.$doc->uploaded_document;
               $doc->action ='';
               $doc->action ='<a data-toggle="tooltip" data-placement="top" title="View Document" href="'.$path.'" target="_blank" style="color: black;"><i class="cil-folder-open" aria-hidden="true" id="doc_'.$doc->id.'"></i></a><button style="padding: 0;border: none;background: none;" class="remove-doc" id="'.$doc->id.'" data-toggle="tooltip" data-placement="top" title="Remove Document" ><i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>'; 
               
               //get doc type
               $types = IdProofTypes::find($doc->document_type);
               $doc->document_type = $types->title;
           }
       
           //customer profile image path
           $customer->profile_image = 'public/storage/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/display_picture'.'/'.$customer->profile_image;

           //get gender 
           $customer->gender = ($customer->gender == 1) ? 'Male':'Female';

           //get country
           $countries = Country::find($customer->nationality);
           $customer->nationality = $countries->name;

           $country_of_issue = Country::find($customer->country_of_issue);
           $customer->country_of_issue = $countries->country_of_issue;

           //get property detial
           $property = Properties::find($customer->property_id);
           $customer->property_id = $property->name;

           //get property owner
           $property_owner = HotelAdmin::find($property->owner);
           $property->owner = $property_owner->first_name.' '.$property_owner->last_name;

           //get property country
           $prop_country = Country::find($property->country);
           $property->country = $prop_country->name;

           //get ciust docs
           $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->get();
           $docs_array_updated = array();
           if($docs){
               $docs_array = $docs;
               foreach($docs_array as $doc){
                   $path = $baseUrl.'/public/storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                   $doc->uploaded_document= $path;
   
                   //get doc type
                   $types = IdProofTypes::find($doc->document_type);
                   $doc->document_type = $types->title;
                   $docs_array_updated[] = $doc;
               }
           } else {
               $docs_array_updated = array();
           }
      return view('dashboard.customers.viewdetails',['customer'=>$customer,'docs'=>$docs_array_updated,'property'=>$property]);
    }

    //for complaints
    public function getComplaints($data){
        //get complaints
        $ids_array = explode(',',$data['cust_ids']);
        $baseUrl = url('/');
        $complaint_array_updated = array();
        foreach($ids_array as $id){
            $complaints_list = Complaints::where('complaint_against',$id)->get();
            foreach($complaints_list as $complaint){
                $id = $complaint->id;
                //get complaint against
                $complaint_against = Customers::find($complaint->complaint_against);
                $complaint->complaint_against = $complaint_against->first_name.' '.$complaint_against->last_name;
                
                //get passport number 
                $complaint->passport_number = '';
                $complaint->passport_number = $complaint_against->passport_number;

                //get complaint from
                $hotel_admin_id = $complaint->complaint_from;
                $complaint_from = HotelAdmin::where('main_user_id',$complaint->complaint_from)->first();
                $complaint->complaint_from = $complaint_from->first_name.' '.$complaint_from->last_name;
                
                $complaint->document  = $baseUrl.'/public/storage/uploads/hotel_admins/'.$hotel_admin_id.'/complaints_doccument'.'/'.$complaint_against->id.'/'.$complaint->document;
                $complaint_array_updated[] = $complaint;
            }
        }
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                    <thead>
                        <tr>
                            <th width='25%'>Complaint Against</th>
                            <th width='25%'>Complaint From</th>
                            <th width='25%''>Title</th>
                            <th>Passport Numbe </th>
                            <th>Description</th>
                            <th width='25%''>Action</th>
                        </tr>
                    </thead>
                    <tbody>'";
        if(count($complaint_array_updated) > 0){
            foreach($complaint_array_updated as $comp){
            $tbl .= "'<tr>
                        <td>".$comp->complaint_against."</td>
                        <td>".$comp->complaint_from."</td>
                        <td>".$comp->title."</td>
                        <td>".$comp->passport_number."</td>
                        <td>".$comp->description."</td>
                        <td>
                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$comp->document}' target='_blank' style='color: black;'><i class='cil-folder-open' aria-hidden='true' id='doc_{$comp->id}'></i></a>
                        </td>
                    </tr>";
            }
        } else {
            $tbl .= "<tr><td>No documents found</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";
        }
        
            $tbl .= '</tbody></table>';
            return response()->json(array('success'=>true, 'html'=>$tbl));
    }


        //for criminal
        public function getCriminalRecord($data){
            //get complaints
            $ids_array = explode(',',$data['cust_ids']);
            $baseUrl = url('/');
            $criminal_array_updated = array();
            // echo "<pre>";print_r(array_unique($ids_array));exit;
            foreach(array_unique($ids_array) as $id){
                if($id){
                    //get customer fname and lname
                    $customer_details = Customers::select('first_name','last_name')->where('id',$id)->first();
                    // echo "<pre>";print_R($customer_details);exit;
                    $criminal_details = CriminalRecords::where('first_name',$customer_details->first_name)->orWhere('last_name',$customer_details->last_name)->get();
                
                    foreach($criminal_details as $criminal){
                        $criminal->name = $criminal->first_name.' '.$criminal->last_name;

                        $criminal->image  = $baseUrl.'/public/storage/uploads/criminal_records/'.$criminal->image;
                        $criminal_array_updated[] = $criminal;
                    }
                }
            }
            
            $tbl = "<table class='table table-striped table-bordered datatable docs'>
                        <thead>
                            <tr>
                                <th width='25%'>Name</th>
                                <th width='25%'>File Number</th>
                                <th width='25%''>Record ID</th>
                                <th>Description</th>
                                <th>Institution</th>
                                <th width='25%''>Action</th>
                            </tr>
                        </thead>
                        <tbody>'";
            if(count($criminal_array_updated) > 0){
                foreach($criminal_array_updated as $crime){
                    $record_id = "{$crime->id}";
                $tbl .= "'<tr>
                            <td>".$crime->first_name.' '.$crime->last_name."</td>
                            <td>".$crime->file_number."</td>
                            <td>".$crime->record_id."</td>
                            <td>".$crime->description."</td>
                            <td>".$crime->institution."</td>
                            <td>
                                <button type='button' class='view_record'  data-record-id={$crime->id} style=padding: 0;border: none;background: none;' data-toggle='tooltip' data-placement='top' title=View Record details ><i class='cil-folder-open' style='font-size: 20px;'></i></button>
                            </td>
                        </tr>";
                }
            } else {
                $tbl .= "<tr><td>No documents found</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>";
            }
            
                $tbl .= '</tbody></table>';
                return response()->json(array('success'=>true, 'html'=>$tbl));
        }

        
    public function getPropertyFilterVal($data)
    { 
        //get property detial
        $property = Properties::find($data['property_id']);
        return $property->name;
    }

    public function getCriminalRecordDetails($data)
    { 
        $datas = CriminalRecords::find($data['id']);
        $baseUrl = url('/');
        
        $id = $datas->id;
        //get country
        $datas->country = '';
        $nationality = Country::find($datas->nationality);
        $datas->country = $nationality->name;

        //full name
        $datas->name = '';
        $datas->name = $datas->first_name.' '.$datas->last_name;

        //get gender 
        $datas->criminal_gender = '';
        $datas->criminal_gender = ($datas->gender == 1) ? 'Male':'Female';

        //get created date  $user->created_at->format('m/d/Y')
        $datas->created_on = '';
        $datas->created_on = $datas->created_at->format('d F Y');

        //get image
        $datas->image  = $baseUrl.'/public/storage/uploads/criminal_records/'.$datas->image;

        return response()->json( $datas);
    }

    //for dropzone in docs
    public function saave_docs_by_dropzone(Request $request){
        $datas = $request->all();
        // echo "<pre>AA";print_r($request->all());exit;
        $customer_id = $request->input('customer_id');
        $hotel_admin_id = Auth::user()->id;
        $customer = Customers::find($customer_id);
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$customer_id.'/display_picture', 0777, true, true);
        }
       
      
        // if(array_key_exists('dropzone',$datas) == true){
            $docs = $request->file('file'); 
            if (!empty($docs)) { 
                $filenameWithExt = $request->file('file')->getClientOriginalName();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('file')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                // echo "<pre>AA";print_r($customer_id);exit; 
                $img = $request->file('file')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents/'.$customer_id, $fileNameToStore);
            } else {  
                $fileNameToStore = '';
            }
        // } else {
        //     $fileNameToStore = '';
        // }

        $cust_docs_arr = array(
            'customer_id'=>$customer_id,
            'document_type'=>$request->input('document_type'),
            'number'=>$request->input('number'),
            'uploaded_document'=>$fileNameToStore,
            'doc_expiry_date' => $request->input('doc_expiry_date'),
        );
        $insert_cust_docs = DB::table('customer_documents')->insertGetId($cust_docs_arr);

        $docs = DB::table('customer_documents')->where('customer_id',$customer_id)->where('deleted_at',null)->orderBy('id','DESC')->get();
        $docs_array_updated = array();
        
          if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;

                 //get doc type
                 $types = IdProofTypes::find($doc->document_type);
                 $doc->document_type = $types->title;

                $docs_array_updated[] = $doc;
            }
        } else {
            $docs_array_updated = array();
        }

        $baseUrl = url('/');
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                                <thead>
                                    <tr>
                                        <th>Document Type</th>
                                        <th>Number</th>
                                        <th>Expiry Date</th>
                                        <th>Uploaded File</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>'";
                if(count($docs_array_updated) > 0){
                    foreach($docs_array_updated as $docs){
                        $tbl .=   "'<tr>
                                        <td>".$docs->document_type."</td>
                                        <td>".$docs->number."</td>
                                        <td>".$docs->doc_expiry_date."</td>
                                        <td><img src='{$baseUrl}/{$docs->uploaded_document}' style='width: 50px;'></td>
                                        <td>
                                            <a data-toggle='tooltip' data-placement='top' title='View Document' href='{$baseUrl}/{$docs->uploaded_document}' target='_blank' style='color: black;'><i class='cil-folder-open' aria-hidden='true' id='doc_{$docs->id}'></i></a>
                                            <button style='padding: 0;border: none;background: none;' class='remove-doc' id='{$docs->id}' data-toggle='tooltip' data-placement='top' title='Remove Document' ><i class='fa fa-trash' style='font-size: 20px;margin-left: 9px;'></i></button>
            
                                        </td>
                                    </tr>";
                    }
                } else {
                    $tbl .= "<tr><td>No documents found</td>
                    <td></td>
                    <td></td>
                    <td></td></tr>";
                }
    
                $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
    
    
        public function update_basic_info(Request $request)
    {
        $new_cust_id = Customers::orderBy('id','desc')->first();
        $cust_id = $new_cust_id->id + 1;
        $datas = $request->all();
        $datas['custID'] = $cust_id;
        if(array_key_exists('edit_page',$datas) == false){
                    $insert = $this->insertBasicInfo($datas);
                    return $insert;
        }
        if(array_key_exists('dropzone',$datas) == true){
            $image = $request->file('file');
            if($request->hasFile('file')){

                $filenameWithExt = $request->file('file')->getClientOriginalName();
                //Get just filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just ext
                $extension = $request->file('file')->getClientOriginalExtension();
                // Filename to store
                $fileNameToStore = $filename.'_'.time().'.'.$extension;
                // Upload Image
                $path = $request->file('file')->storeAs('public/uploads',$fileNameToStore);


                $filenameWithExt = $request->file('file')->getClientOriginalName();
                // Get Filename
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                // Get just Extension
                $extension = $request->file('file')->getClientOriginalExtension();
                // Filename To store
                $fileNameToStore = $filename. '_'. time().'.'.$extension;
                $img = $request->file('file')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$cust_id.'/display_picture', $fileNameToStore);
                
                $dp_array = array('profile_image'=>$fileNameToStore,);
                DB::table('customers')->where('id', $cust_id)->update($dp_array);
            }
            return true;
        }
    }
    
        public function updatte_profile_image(Request $request)
    { 
        $data = $request->all(); 
        if($request->input('webcam_image') !=''){
            $web_cam_image = $request->input('webcam_image');
            $image_parts = explode(";base64,", $web_cam_image);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type = $image_type_aux[1];
          
            $image_base64 = base64_decode($image_parts[1]);
            $fileNameToStore = uniqid() . '.png';
     
            $baseUrl = url('/');
            $file_path = 'storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$request->input('customer_id') .'/'.'display_picture/';
           
            $file = $file_path . $fileNameToStore; //echo $file;exit;
            file_put_contents($file, $image_base64);
        
            // move_uploaded_file($fileNameToStore, $file_path.$fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $request->input('customer_id') )->update($dp_array);
     
        }
    }
    
    
    
    public function insertBasicInfo($data)
    { 
        // echo "<pre>";print_r($data);exit;
        $rooms = Room::all();
        $id_proof_type = IdProofTypes::all();

        //insert new hotel admin in users table
        $customer = new Customers();
        //for basic info tab details
        $customer->first_name    = $data['first_name'];
        $customer->middle_name    = $data['middle_name'];
        $customer->last_name    = $data['last_name'];
        $customer->email   =  $data['email'];
        $customer->mobile   =  $data['mobile'];
        $customer->date_of_birth   =  $data['date_of_birth'];
        $customer->gender   =  $data['gender'];
        $customer->nationality   =  $data['nationality'];
        $customer->passport_expiry_date   =  $data['passport_expiry_date'];
        $customer->country_of_issue   =  $data['country_of_issue'];
        $customer->passport_number   =  $data['passport_number'];

        //for address tab details
        $customer->address_line_1    = $data['address_line_1'];
        $customer->address_line_2    = $data['address_line_2'];
        $customer->city    =$data['city'];
        $customer->state   = $data['state'];
        $customer->pin   =  $data['pin'];
        $customer->country   =  $data['country'];

        $customer->created_by = Auth::user()->id;
        $customer->save();
        //get recently adde cust
        // $recent = Customers::where('email',$data['email'])->first();
        // $recent_cust_id = $recent->id;
        $recent_cust_id = $customer->id;
        $docs = DB::table('customer_documents')->where('customer_id',$recent_cust_id)->where('deleted_at',null)->get();
        $docs_array = array();
        $hotel_admin_id = Auth::user()->id;
        //Create hotel admin folder if not exists
        $hotel_admin_path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id);
        if(!File::isDirectory($hotel_admin_path)){
            File::makeDirectory($hotel_admin_path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents', 0777, true, true);//create  customer_documents folder
        }
        
        // create or update file in directory if exists in hotel admin folder
        $path = public_path('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id);
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            File::makeDirectory('storage/uploads/hotel_admins/'.$hotel_admin_id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
        }



        //for customer dp
        if (!empty($data['file'])) {

            $filenameWithExt = $data['file']->getClientOriginalName();
            // Get Filename
           

            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $extension = $data['file']->getClientOriginalExtension();
            // Filename To store
            $fileNameToStore = $filename. '_'. time().'.'.$extension;
            // Upload Image$path =
           
            $img = $data['file']->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $fileNameToStore);
            // $p = 'public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture';
            // echo "<pre>";print_r($p);exit; 
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
            
        } else if(!empty($data['webcam_image'])){
            $web_cam_image = $data['webcam_image'];
            $image_parts = explode(";base64,", $web_cam_image);
            $image_type_aux = explode("image/", $image_parts[0]);
            $image_type = $image_type_aux[1];
          
            $image_base64 = base64_decode($image_parts[1]);
            $fileNameToStore = uniqid() . '.png';
     
            $baseUrl = url('/');
            $file_path = 'storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$customer->id.'/'.'display_picture/';
           
            $file = $file_path . $fileNameToStore; //echo $file;exit;
            file_put_contents($file, $image_base64);
        
            // move_uploaded_file($fileNameToStore, $file_path.$fileNameToStore);
            $dp_array = array('profile_image'=>$fileNameToStore,);
            DB::table('customers')->where('id', $customer->id)->update($dp_array);
     
        } else {
            $fileNameToStore = '';
            $img = '';
        }

        //customer profile image path
        $customer->profile_image = 'storage/uploads/hotel_admins/'.$customer->created_by.'/customer_documents'.'/'.$customer->id.'/display_picture'.'/'.$customer->profile_image;
        if($docs){
            $docs_array = $docs;
            foreach($docs_array as $doc){
                $path = 'storage/uploads/hotel_admins/'.$customer->created_by.'/'.'customer_documents/'.$customer->id.'/'.$doc->uploaded_document;
                $doc->uploaded_document= $path;
            }
        } else {
            $docs_array = array();
        }

        return $recent_cust_id;

        // return view('dashboard.customers.create',['customer'=>$recent,'rooms'=>$rooms,'types'=>$id_proof_type,'docs'=>$docs_array]);
    }

    public function getRoomsByProperty(Request $request)
    { 
        $data = $request->all();
        $all_prop_rooms_q = Room::where('property_id',$data['property_id'])->where('status',1);
        
        if(array_key_exists('is_for_customer_create',$data)){
            $all_prop_rooms_q->whereDoesntHave('customers', function($q) {
                $q->whereNull('checkout_date_time');
            });
        }
        $all_prop_rooms = $all_prop_rooms_q->get();
        
        $html = "<option value='0'>Select Room</option>";
        if(!empty($all_prop_rooms)){
            foreach($all_prop_rooms  as $room){
                $html .= "<option value='".$room->id."'>".$room->title."</option>";
            }
        } else {
            $html = "<option value='0'>Room not available.</option>";

        }
        return response()->json(array('success'=>true, 'html'=>$html));
    }

    //for blacklist
    public function getBlacklistRecord($data){
        //get blacklist
        $ids_array = explode(',',$data['cust_ids']);
        $baseUrl = url('/');
        $blacklist_array_updated = array();
        foreach($ids_array as $id){
            if($id){
                //get customer fname and lname
                $customer_details = Customers::select('first_name','last_name','passport_number as passport_no','date_of_birth','nationality')->where('id',$id)->first();
                $blacklist_details_q = DB::table('blackLists as bl')->select('bl.id','bl.passport_no','bl.date_of_birth','bl.name','bl.nationality','bl.created_at','pr.name as property_name','ct.title as complaint_type','ct.complaint_rating as severity','bl.action_taken','bl.reason');
                $blacklist_details_q->join('properties as pr','pr.id','=','bl.property_id','left');
                $blacklist_details_q->join('complaint_types as ct','ct.id','=','bl.complaint_type','left');
                $blacklist_details_q->where('bl.passport_no',$customer_details->passport_no)
                                    ->where('bl.date_of_birth',$customer_details->date_of_birth)
                                    ->orWhere('bl.name',$customer_details->first_name)
                                    ->orWhere('bl.name',$customer_details->last_name)
                                    ->orWhere('bl.nationality',$customer_details->nationality);
                $blacklist_details = $blacklist_details_q->get();
                // echo "<pre>";print_R($blacklist_details);exit;
            
                foreach($blacklist_details as $blacklist){
                        $blacklist_array_updated[] = $blacklist;
                }
            }
        }
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                    <thead>
                        <tr>
                            <th width='15%'>Name</th>
                            <th width='15%'>Complaint Type & Sevirity</th>
                            <th>Property</th>
                            <th>Reason</th>
                            <th width='25%'>Action Taken</th>
                            <th>Created On</th>
                            <th width='8%''>Action</th>
                        </tr>
                    </thead>
                    <tbody>'";
        if(count($blacklist_array_updated) > 0){
            foreach($blacklist_array_updated as $list){
                $record_id = "{$list->id}";
                
                $severity = '';
                if($list->severity == '5'){
                    $severity = '(Very Serious)';
                } else  if($list->severity == '4'){
                    $severity = '(Serious)';
                } else  if($list->severity == '3'){
                    $severity = '(Major)';
                } else  if($list->severity == '2'){
                    $severity = '(Minor)';
                } else {
                    $severity = '(Very Minor)';
                } 
            $tbl .= "'<tr>
                        <td>".$list->name."</td>
                        <td>".$list->complaint_type.' '.$severity."</td>
                        <td>".$list->property_name."</td>
                        <td>".$list->reason."</td>
                        <td>".$list->action_taken."</td>
                        <td>".$list->created_at."</td>
                        <td>
                            <button type='button' class='view_blacklist_record'  data-record-id={$list->id} style=padding: 0;border: none;background: none;' data-toggle='tooltip' data-placement='top' title=View Record details ><i class='cil-folder-open' style='font-size: 20px;'></i></button>
                        </td>
                    </tr>";
            }
        } else {
            $tbl .= "<tr>
                        <td>No data found</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";
        }
        
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }

    
    public function getBlacklistRecordDetails($data)
    {  
        //get customer fname and lname
        $datas_q = DB::table('blacklists as bl')->select('bl.*','pr.name as property_name','ct.title as complaint_type','ct.complaint_rating as severity');
        $datas_q->join('properties as pr','pr.id','=','bl.property_id','left');
        $datas_q->join('complaint_types as ct','ct.id','=','bl.complaint_type','left');
        $datas_q->where('bl.id',$data['id']);
        $datas = $datas_q->first();

        $baseUrl = url('/');
      
        $id = $datas->id;
        //get country
  
        $nationality = Country::find($datas->nationality);
        $datas->nationality = '';
        // echo "<pre>";print_r($nationality);exit;
        $datas->nationality = $nationality->name;

        $datas->blacklist_created_by = '';
        $hotelAdmin = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $datas->blacklist_created_by =  $hotelAdmin->first_name.' '.$hotelAdmin->last_name;

        //get created date  $user->created_at->format('m/d/Y')
        $datas->blacklist_created_on = '';
        $datas->blacklist_created_on = $datas->created_at;

        $severity = '';
        if($datas->severity == '5'){
            $severity = 'Very Serious';
        } else  if($datas->severity == '4'){
            $severity = 'Serious';
        } else  if($datas->severity == '3'){
            $severity = 'Major';
        } else  if($datas->severity == '2'){
            $severity = 'Minor';
        } else {
            $severity = 'Very Minor';
        } 
        $datas->severity =  $severity;
        return response()->json( $datas);
    }
     

    public function getRecordsFromOtherAdminAlso($data)
    {  
        // $data = $request->all();

        //complaint found if any for complaint tab
        $criminalExists_q = DB::table('criminal_records as cr')->select('*');
        if($data['first_name']){
            $criminalExists_q->orWhere('first_name', 'like', '%' . $data['first_name'] . '%');
        }
        if($data['last_name']){
            $criminalExists_q->orWhere('last_name', 'like', '%' . $data['last_name'] . '%');
        }   
        if($data['passport_number']){
            $criminalExists_q->orWhere('passport_no',$data['passport_number']);
        }
        if($data['nationality']){
            $criminalExists_q->orWhere('nationality',$data['nationality']);
        }
        if($data['date_of_birth']){
            $criminalExists_q->orWhere('date_of_birth',$data['date_of_birth']);
        }
        
        $criminalExists = $criminalExists_q->get();
        $html = '';
        $html .= "<b><h4>Criminal Records</h4></b><br/>";
        $html .= "<table class='table table-striped table-bordered datatable docs'>
                        <thead>
                            <tr>
                                <th width='25%'>Name</th>
                                <th width='25%'>File Number</th>
                                <th width='25%''>Record ID</th>
                                <th>Description</th>
                                <th>Institution</th>
                                <th width='25%''>Action</th>
                            </tr>
                        </thead>
                        <tbody>'";
                        if(count($criminalExists) > 0){
                            foreach($criminalExists as $crime){
                                $record_id = "{$crime->id}";
                                $html .= "'<tr>
                                        <td>".$crime->first_name.' '.$crime->last_name."</td>
                                        <td>".$crime->file_number."</td>
                                        <td>".$crime->record_id."</td>
                                        <td>".$crime->description."</td>
                                        <td>".$crime->institution."</td>
                                        <td>
                                            <button type='button' class='view_record'  data-record-id={$crime->id} style=padding: 0;border: none;background: none;' data-toggle='tooltip' data-placement='top' title=View Record details ><i class='cil-folder-open' style='font-size: 20px;'></i></button>
                                        </td>
                                    </tr>";
                            }
                        } else {
                            $html .= "<tr><td>No documents found</td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>";
                        }
        $html .= '</tbody></table>';

        //complaint found if any for complaint tab

        $blacklist_details_q = DB::table('blackLists as bl')->select('bl.id','bl.passport_no','bl.date_of_birth','bl.name','bl.nationality','bl.created_at','pr.name as property_name','ct.title as complaint_type','ct.complaint_rating as severity','bl.action_taken','bl.reason');
        $blacklist_details_q->join('properties as pr','pr.id','=','bl.property_id','left');
        $blacklist_details_q->join('complaint_types as ct','ct.id','=','bl.complaint_type','left');
        if($data['first_name']){
            $blacklist_details_q->orWhere('bl.name', 'like', '%' . $data['first_name'] . '%');
        }
        if($data['last_name']){
            $blacklist_details_q->orWhere('bl.name', 'like', '%' . $data['last_name'] . '%');
        }   
        if($data['passport_number']){
            $blacklist_details_q->orWhere('bl.passport_no',$data['passport_number']);
        }
        if($data['nationality']){
            $blacklist_details_q->orWhere('bl.nationality',$data['nationality']);
        }
       
        if($data['date_of_birth']){
            $blacklist_details_q->orWhere('date_of_birth',$data['date_of_birth']);
        }
        $blacklistExists = $blacklist_details_q->get();
        $html .= "<hr/><b><h4>BlackList Records</h4></b><br/>";
        $html .= "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th width='15%'>Name</th>
                <th width='15%'>Complaint Type & Sevirity</th>
                <th>Property</th>
                <th>Reason</th>
                <th width='25%'>Action Taken</th>
                <th>Created On</th>
                <th width='8%''>Action</th>
            </tr>
        </thead>
        <tbody>'";
        if(count($blacklistExists) > 0){
        foreach($blacklistExists as $list){
            $record_id = "{$list->id}";
            
            $severity = '';
            if($list->severity == '5'){
                $severity = '(Very Serious)';
            } else  if($list->severity == '4'){
                $severity = '(Serious)';
            } else  if($list->severity == '3'){
                $severity = '(Major)';
            } else  if($list->severity == '2'){
                $severity = '(Minor)';
            } else {
                $severity = '(Very Minor)';
            } 
        $html .= "'<tr>
                    <td>".$list->name."</td>
                    <td>".$list->complaint_type.' '.$severity."</td>
                    <td>".$list->property_name."</td>
                    <td>".$list->reason."</td>
                    <td>".$list->action_taken."</td>
                    <td>".$list->created_at."</td>
                    <td>
                        <button type='button' class='view_blacklist_record'  data-record-id={$list->id} style=padding: 0;border: none;background: none;' data-toggle='tooltip' data-placement='top' title=View Record details ><i class='cil-folder-open' style='font-size: 20px;'></i></button>
                    </td>
                </tr>";
        }
        } else {
        $html .= "<tr>
                    <td>No data found</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>";
        }
        $html .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$html));
    }



    public function getQuickSearchResults(Request $request)
    {  
        $data = $request->all();

        //complaint found if any for complaint tab
        $criminalExists_q = DB::table('criminal_records as cr')->select('*');
        if($data['first_name']){
            $criminalExists_q->orWhere('first_name', 'like', '%' . $data['first_name'] . '%');
        }
        if($data['last_name']){
            $criminalExists_q->orWhere('last_name', 'like', '%' . $data['last_name'] . '%');
        }   
        if($data['passport_no']){
            $criminalExists_q->orWhere('passport_no',$data['passport_no']);
        }
        if($data['nationality']){
            $criminalExists_q->orWhere('nationality',$data['nationality']);
        }
        if($data['dob']){
            $criminalExists_q->orWhere('date_of_birth',$data['dob']);
        }
           
        $criminalExists = $criminalExists_q->get();
        $totalcriminalList = 0;
        if(count($criminalExists) > 0){
            $totalcriminalList = count($criminalExists) ;
        }
        $html = '';
        $html .= "<b><h4>Criminal Records (".$totalcriminalList.")</h4></b><br/>";
        $html .= "<table class='table table-striped table-bordered datatable docs'>
                    <thead>
                        <tr>
                            <th width='25%'>Name</th>
                            <th width='25%'>File Number</th>
                            <th width='25%''>Record ID</th>
                            <th>Description</th>
                            <th width='25%''>Action</th>
                        </tr>
                    </thead>
                    <tbody>";
                    if(count($criminalExists) > 0){
                        foreach($criminalExists as $crime){
                            $record_id = $crime->id;
                            $cname = $crime->first_name.' '.$crime->last_name;
                            $html .= '<tr>
                                    <td>'.$cname.'</td>
                                    <td>'.$crime->file_number.'</td>
                                    <td>'.$crime->record_id.'</td>
                                    <td>'.$crime->description.'</td>
                                    <td><button type="button" class="view_record"  data-record-id="'.$crime->id.'"  data-toggle="tooltip" data-placement="top" title="View Record details" ><i class="cil-folder-open" style="font-size: 20px;"></i></button>
                                    </td>
                                </tr>';
                        }
                    } else {
                        $html .= '<tr>
                        <td>No documents found</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>';
                    }
        $html .= "</tbody></table><br/><br/>";

        //complaint found if any for complaint tab

        $blacklist_details_q = DB::table('blacklists as bl')->select('bl.id','bl.passport_no','bl.date_of_birth','bl.name','bl.nationality','bl.created_at','pr.name as property_name','ct.title as complaint_type','ct.complaint_rating as severity','bl.action_taken','bl.reason');
        $blacklist_details_q->join('properties as pr','pr.id','=','bl.property_id','left');
        $blacklist_details_q->join('complaint_types as ct','ct.id','=','bl.complaint_type','left');
        if($data['first_name']){
            $blacklist_details_q->orWhere('bl.name', 'like', '%' . $data['first_name'] . '%');
        }
        if($data['last_name']){
            $blacklist_details_q->orWhere('bl.name', 'like', '%' . $data['last_name'] . '%');
        }   
        if($data['passport_no']){
            $blacklist_details_q->orWhere('bl.passport_no',$data['passport_no']);
        }
        if($data['nationality']){
            $blacklist_details_q->orWhere('bl.nationality',$data['nationality']);
        }
       
        if($data['dob']){
            $blacklist_details_q->orWhere('date_of_birth',$data['dob']);
        }
        $blacklistExists = $blacklist_details_q->get();
        $totalBlackList = 0;
        if(count($blacklistExists) > 0){
            $totalBlackList = count($blacklistExists) ;
        }
        $html .= "<hr/><b><h4>BlackList Records (".$totalBlackList.")</h4></b><br/>";
        $html .= "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th width='15%'>Name</th>
                <th width='15%'>Complaint Type & Sevirity</th>
                <th>Property</th>
                <th>Reason</th>
                <th width='25%'>Action Taken</th>
                <th>Created On</th>
                <th width='8%''>Action</th>
            </tr>
        </thead>
        <tbody>'";
        if(count($blacklistExists) > 0){
        foreach($blacklistExists as $list){
            $record_id = "{$list->id}";
            
            $severity = '';
            if($list->severity == '5'){
                $severity = '(Very Serious)';
            } else  if($list->severity == '4'){
                $severity = '(Serious)';
            } else  if($list->severity == '3'){
                $severity = '(Major)';
            } else  if($list->severity == '2'){
                $severity = '(Minor)';
            } else {
                $severity = '(Very Minor)';
            } 
            $html .= "'<tr>
                    <td>".$list->name."</td>
                    <td>".$list->complaint_type.' '.$severity."</td>
                    <td>".$list->property_name."</td>
                    <td>".$list->reason."</td>
                    <td>".$list->action_taken."</td>
                    <td>".$list->created_at."</td>
                    <td>
                        <button type='button' class='view_blacklist_record'  data-record-id={$list->id}  data-toggle='tooltip' data-placement='top' title=View Record details ><i class='cil-folder-open' style='font-size: 20px;'></i></button>
                    </td>
                </tr>";
        }
        } else {
        $html .= "<tr>
                    <td>No data found</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>";
        }
        $html .= '</tbody></table><br/><hr/><br/>';


        //complaint found if any for complaint tab
        $complaints_details_q = DB::table('complaints as cm')->select('cm.*','cs.first_name','cs.last_name','ct.title as complaint_type_title','pr.name as property_title');
        $complaints_details_q->join('complaint_types as ct','ct.id','=','cm.complaint_type','left');
        $complaints_details_q->join('customers as cs','cs.id','=','cm.complaint_against','left');
        $complaints_details_q->join('properties as pr','pr.id','=','cs.property_id','left');

        if($data['first_name']){
            $complaints_details_q->Where('cs.first_name', 'like', '%' . $data['first_name'] . '%');
        }
        if($data['last_name']){
            $complaints_details_q->orWhere('cs.last_name', 'like', '%' . $data['last_name'] . '%');
        }   
        if($data['passport_no']){
            $complaints_details_q->orWhere('cs.passport_number',$data['passport_no']);
        }
        if($data['nationality']){
            $complaints_details_q->orWhere('cs.nationality',$data['nationality']);
        }
        if($data['dob']){
            $complaints_details_q->orWhere('cs.date_of_birth',$data['dob']);
        }
        $complaintExists = $complaints_details_q->get();
        $totalcomplaintExists = 0;
        if(count($complaintExists) > 0){
            $totalcomplaintExists = count($complaintExists) ;
        }
        // echo "<pre>";print_r($complaintExists);exit;
        $html .= "<hr/><b><h4>Complaint Records (".$totalcomplaintExists.")</h4></b><br/>";
        $html .= "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th width='15%'>Name</th>
                <th width='15%'>Complaint Type</th>
                <th>Property</th>
                <th>Title</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>'";
        if(count($complaintExists) > 0){
        foreach($complaintExists as $comp){
            $record_id_c = "{$comp->id}";
            
        $html .= "'<tr>
                    <td>".$comp->first_name.' '.$comp->last_name."</td>
                    <td>".$comp->complaint_type_title."</td>
                    <td>".$comp->property_title."</td>
                    <td>".$comp->title."</td>
                    <td>".$comp->description."</td>
                </tr>";
        }
        } else {
        $html .= "<tr>
                    <td>No data found</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>";
        }
        $html .= '</tbody></table><hr/><hr/>';

        return response()->json(array('success'=>true, 'html'=>$html));
    }
    

    public function getBlacklistRecordSameAdmin($data){
        //get blacklist
        $ids_array = explode(',',$data['cust_ids']);
        $baseUrl = url('/');
        $blacklist_array_updated = array();
        foreach($ids_array as $id){
            if($id){
                //get customer fname and lname
                $customer_details = Customers::select('first_name','last_name','passport_number as passport_no','date_of_birth','nationality')->where('passport_number',$data['passport_number'])->where('date_of_birth',$data['date_of_birth'])->first();
                // echo "<pre>";print_R($customer_details);exit;
                $blacklist_details_q = DB::table('blackLists as bl')->select('bl.id','bl.passport_no','bl.date_of_birth','bl.name','bl.nationality','bl.created_at','pr.name as property_name','ct.title as complaint_type','ct.complaint_rating as severity','bl.action_taken','bl.reason');
                $blacklist_details_q->join('properties as pr','pr.id','=','bl.property_id','left');
                $blacklist_details_q->join('complaint_types as ct','ct.id','=','bl.complaint_type','left');
                $blacklist_details_q->where('bl.passport_no',$customer_details->passport_no)
                                    ->where('bl.date_of_birth',$customer_details->date_of_birth)
                                    ->orWhere('bl.name',$customer_details->first_name)
                                    ->orWhere('bl.name',$customer_details->last_name)
                                    ->orWhere('bl.nationality',$customer_details->nationality);
                $blacklist_details = $blacklist_details_q->get();
                // echo "<pre>";print_R($blacklist_details);exit;
            
                foreach($blacklist_details as $blacklist){
                        $blacklist_array_updated[] = $blacklist;
                }
            }
        }
                
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
                    <thead>
                        <tr>
                            <th width='15%'>Name</th>
                            <th width='15%'>Complaint Type & Sevirity</th>
                            <th>Property</th>
                            <th>Reason</th>
                            <th width='25%'>Action Taken</th>
                            <th>Created On</th>
                            <th width='8%''>Action</th>
                        </tr>
                    </thead>
                    <tbody>'";
        if(count($blacklist_array_updated) > 0){
            foreach($blacklist_array_updated as $list){
                $record_id = "{$list->id}";
                
                $severity = '';
                if($list->severity == '5'){
                    $severity = '(Very Serious)';
                } else  if($list->severity == '4'){
                    $severity = '(Serious)';
                } else  if($list->severity == '3'){
                    $severity = '(Major)';
                } else  if($list->severity == '2'){
                    $severity = '(Minor)';
                } else {
                    $severity = '(Very Minor)';
                } 
            $tbl .= "'<tr>
                        <td>".$list->name."</td>
                        <td>".$list->complaint_type.' '.$severity."</td>
                        <td>".$list->property_name."</td>
                        <td>".$list->reason."</td>
                        <td>".$list->action_taken."</td>
                        <td>".$list->created_at."</td>
                        <td>
                            <button type='button' class='view_blacklist_record'  data-record-id={$list->id} style=padding: 0;border: none;background: none;' data-toggle='tooltip' data-placement='top' title=View Record details ><i class='cil-folder-open' style='font-size: 20px;'></i></button>
                        </td>
                    </tr>";
            }
        } else {
            $tbl .= "<tr>
                        <td>No data found</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>";
        }
        
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
    
     public function getInhouseGuestsByProperty(Request $request){ 
        $datas = $request->all();
        
        $customerCountsq = DB::table('customers')
            ->select('countries.name', DB::raw('count(customers.id) as customer_count'))
            ->join('countries', 'customers.nationality', '=', 'countries.id')
            ->where('customers.deleted_at',null)->where('customers.property_id','=',$datas['property_id'])->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL)->where('customers.checkin_date_time','!=','');
                if(Auth::user()->user_type != '1'){
                    $customerCountsq->where('customers.created_by',Auth::user()->id);
                }
           $customerCounts = $customerCountsq->groupBy('customers.nationality', 'countries.name')->get();

            $tbl = "";
            // $total_inhouse_guests_cnt = $total_inhouse_cnt;
            $total_inhouse_guests_cnt = 0;
            // echo "<pre>";print_r($nationality_array);exit; 
            $tbl = "<table class='table table-striped table-bordered datatable docs' id='total_in_house_guest_table'>
                <thead>
                    <tr>
                        <th>Nationality</th>
                        <th>Total Count</th>      
                    </tr>
                </thead>
            <tbody>";

            if(!empty($customerCounts)){
                foreach($customerCounts as $key => $record){
                    // echo "<pre>";print_r($total_in_house);exit; 
                    $tbl .= "<tr>
                        <td>".$record->name."</td>
                        <td>".$record->customer_count."</td>
                    </tr>";
                    $total_inhouse_guests_cnt = $total_inhouse_guests_cnt + $record->customer_count;
                
                }
            } else {
                $tbl .= "<tr><td>No data found.</td><td></td></tr>";
            }

            $tbl .= '</tbody></table>';
            return response()->json(array('success'=>true, 'html'=>$tbl,'total_inhouse_guests_cnt' => $total_inhouse_guests_cnt));
    }
    
        
    public function getInhouseGuestsByProperty_local_live(Request $request){ 
        $datas = $request->all();
        
        $customerCountsq = DB::table('customers')
            ->select('countries.name', DB::raw('count(customers.id) as customer_count'))
            ->join('countries', 'customers.nationality', '=', 'countries.id')
            ->where('customers.deleted_at',null)->where('customers.property_id','=',$datas['property_id'])->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL)->where('customers.checkin_date_time','!=','');
                if(Auth::user()->user_type != '1'){
                    $customerCountsq->where('customers.created_by',Auth::user()->id);
                }
           $customerCounts = $customerCountsq->groupBy('customers.nationality', 'countries.name')->get();
    // echo "<pre>";print_r($customerCounts);exit;
    
        $dataq = DB::table('customers')->select('customers.property_id','customers.last_name','customers.visa_expiry_date', 'customers.other_id_type', 'customers.other_id_number', 'customers.other_id_expiry_date', 'customers.confirm_checkin' ,'customers.visa_issue_date', 'customers.visa_number','customers.id','customers.full_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
        $dataq->join('countries','countries.id','=','customers.nationality','left');
        if($datas['property_id'] != 'all'){
            $dataq->where('customers.property_id','=',$datas['property_id']);
        }
        $dataq->where('customers.nationality','!=',NULL);
        // $dataq->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);
        $dataq->where('customers.checkin_date_time','!=','');
        $dataq->whereNull('customers.checkout_date_time');

        if(Auth::user()->user_type != '1'){
            $dataq->where('customers.created_by',Auth::user()->id);
        }
        $data = $dataq->get();
        $nationality_array = array();
        $nationality_cnt_array = array();
        $total_inhouse_cnt = count($data); 
        foreach($data as $customer){
            //get country title
            if($customer->nationality){
                $country_title = Country::find($customer->nationality);
                $customer->nationality_name = $country_title->name;
                // $total_inhouse_cnt =    $total_inhouse_cnt + 1;
                if(empty($nationality_array)){
                    // array_push($nationality_array,$customer->nationality);
                    $nationality_array[$customer->nationality] =  $customer->nationality_name;
                } else {
                    if(!in_array($customer->nationality,$nationality_array)){
                        // array_push($nationality_array,$customer->nationality);
                        $nationality_array[$customer->nationality] =  $customer->nationality_name;
                    }
                }
            }
            //get customer id
            $id = $customer->id;
        }
        $tbl = "";
        $total_inhouse_guests_cnt = $total_inhouse_cnt;

        echo "<pre>";print_r($nationality_array);exit; 
        $tbl = "<table class='table table-striped table-bordered datatable docs' id='total_in_house_guest_table'>
            <thead>
                <tr>
                    <th>Nationality</th>
                    <th>Total Count</th>      
                </tr>
            </thead>
        <tbody>";

        if(!empty($customerCounts)){
            foreach($customerCounts as $key => $nation){
                $total_in_house_q = DB::table('customers')->where('nationality',$key)->where('deleted_at',null);
                $total_in_house_q->where('customers.property_id','=',$datas['property_id']);
                $total_in_house_q->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);
                $total_in_house_q->where('customers.checkin_date_time','!=','');
                if(Auth::user()->user_type != '1'){
                    $total_in_house_q->where('customers.created_by',Auth::user()->id);
                }
                $total_in_house = $total_in_house_q->count();
                // echo "<pre>";print_r($total_in_house);exit; 
                $tbl .= "<tr>
                    <td>".$nation."</td>
                    <td>".$total_in_house."</td>
                </tr>";
            
            }
        } else {
            $tbl .= "<tr><td>No data found.</td><td></td></tr>";
        }

        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl,'total_inhouse_guests_cnt' => $total_inhouse_guests_cnt));
    }
    
    public function getInhouseGuestsByProperty_old(Request $request){ 
        $datas = $request->all();
       
      
        $dataq = DB::table('customers')->select('customers.property_id','customers.last_name','customers.visa_expiry_date', 'customers.other_id_type', 'customers.other_id_number', 'customers.other_id_expiry_date', 'customers.confirm_checkin' ,'customers.visa_issue_date', 'customers.visa_number','customers.id','customers.full_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name')->orderBy('customers.id','desc')->where('customers.deleted_at',null);
        $dataq->join('countries','countries.id','=','customers.nationality','left');
        $dataq->where('customers.property_id','=',$datas['property_id']);
        $dataq->where('customers.nationality','!=',NULL);
        $dataq->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);
        $dataq->where('customers.checkin_date_time','!=','');
        
        if(Auth::user()->user_type != '1'){
            $dataq->where('customers.created_by',Auth::user()->id);
        }
        $data = $dataq->get();
        $nationality_array = array();
        $nationality_cnt_array = array();
        $total_inhouse_cnt = count($data); 
        foreach($data as $customer){
            //get country title
            if($customer->nationality){
                $country_title = Country::find($customer->nationality);
                $customer->nationality_name = $country_title->name;
                // $total_inhouse_cnt =    $total_inhouse_cnt + 1;
                if(empty($nationality_array)){
                    // array_push($nationality_array,$customer->nationality);
                    $nationality_array[$customer->nationality] =  $customer->nationality_name;
                    
                  
                } else {
                    if(!in_array($customer->nationality,$nationality_array)){
                        // array_push($nationality_array,$customer->nationality);
                        $nationality_array[$customer->nationality] =  $customer->nationality_name;
                    }
                }

            }
            //get customer id
            $id = $customer->id;
           
        }
        $tbl = "";
        // echo "<pre>";print_r($nationality_array);exit; 
        $tbl = "<b>Total In-House Guest as of : ".date('Y-m-d H:i s')."</b><br/><b>Total In-House Count : ".$total_inhouse_cnt."</b><table class='table table-striped table-bordered datatable docs' id='total_in_house_guest_table'>
            <thead>
                <tr>
                    <th>Nationality</th>
                    <th>Total Inhouse Guest Count</th>      
                </tr>
            </thead>
        <tbody>";

        if(!empty($nationality_array)){
            foreach($nationality_array as $key => $nation){
                $total_in_house_q = DB::table('customers')->where('nationality',$key)->where('deleted_at',null);
                $total_in_house_q->where('customers.property_id','=',$datas['property_id']);
                $total_in_house_q->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);
                $total_in_house_q->where('customers.checkin_date_time','!=','');
                if(Auth::user()->user_type != '1'){
                    $total_in_house_q->where('customers.created_by',Auth::user()->id);
                }
                $total_in_house = $total_in_house_q->count();
                // echo "<pre>";print_r($total_in_house);exit; 
                $tbl .= "<tr>
                    <td>".$nation."</td>
                    <td>".$total_in_house."</td>
                </tr>";
            
            }
        } else {
            $tbl .= "<tr><td>No data found.</td><td></td></tr>";
        }

        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }


    public function guestCheckoutAndSave(Request $request){ 
        $datas = $request->all(); 
        $dp_array = array('checkout_date_time'=>date('Y-m-d').' '.date('H:i s'));
        // echo "<pre>";print_r($dp_array);exit;
        DB::table('customers')->where('id', $datas['id'])->update($dp_array);
        $custinfo = DB::table('customers')->select('first_name','last_name','room_id')->where('id',$datas['id'])->get()->first();
        $title = "Checkout Alert";
        $body = 'Customer '.$custinfo->first_name.' '.$custinfo->last_name.' has been checked out from this room';
        self::sendNotification($custinfo->room_id,$title,$body,2);
        echo true;
        // echo "<pre>";print_r($datas);exit;
    }
    
    
    public function getFoliosByRoom(Request $request)
    {         
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }

        $data = $request->all();
      
        $custs = DB::table('customers')->select('id','first_name','last_name','guest_code','nationality','guest_folio_id')->where('room_id',$data['room_id'])->where('checkout_date_time',null)->orWhere('checkout_date_time','')->where('created_by',$created_by_id)->get();
        //   echo "<pre>";print_r($custs);exit;
        $action =  '--';
        $tbl = "<button type='button' id='checkout_all' class='btn btn-primary' name='checkout_all'>Checkout</button><br/><be><table class='table table-striped table-bordered datatable docs'>
            <thead>
                <tr>
                <th><input type='checkbox' class='checkout_cust_select_all' name='checkout_cust_select_all' id='checkout_cust_select_all' value='all'><span id='select_all_checkbox' style='padding: 8px;'>Select All</span></th>
                    <th>Guest</th>
                    <th>Guest Folio ID</th>
                </tr>
            </thead>
            <tbody>";
            if($custs){
                foreach($custs as $cs){
                    $tbl .= "<tr>
                        <td><input type='checkbox' class='checkout_cust' name='cust' id='cust_".$cs->id."' value=".$cs->id."></td>
                        <td>".$cs->first_name." ".$cs->last_name."(".$cs->guest_code.")</td>
                        <td>".$cs->guest_folio_id."</td>
                    </tr>";
                }
            } else {
                $tbl .= "<tr>
                    <td>No data found.</td>
                    <td></td>
                    <td></td>
                </tr>";
            }
        echo $tbl;
        
        // if ($request->ajax()) {
        // return Datatables::of($custs)
        //                 ->addColumn('action', $action)
        //                 // ->addColumn('action', '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
        //                 ->rawColumns(['action'])
        //                 ->make(true);
        // // }
        // // echo "<pre>ssssssssss";print_r($data);exit; 
        // return view('dashboard.roomCheckout.roomCheckout',['properties'=>$properties]);
    }

    public function roomAllCheckout(Request $request){
        $data = $request->all();
        $dp_array = array();
        // echo "<pre>";print_r($data['checkout_cust_ar']);exit;
        foreach($data['checkout_cust_ar'] as $check){
            // echo "<pre>";print_r($dp_array);exit;
        
            $dp_array = array('checkout_date_time'=>date('Y-m-d H:i s') );
            DB::table('customers')->where('id', $check)->update($dp_array);
            
            $custinfo = DB::table('customers')->select('first_name','last_name','room_id')->where('id',$check)->get()->first();
            $title = "Checkout Alert";
            $body = 'Customer '.$custinfo->first_name.' '.$custinfo->last_name.' has been checked out from this room';
            self::sendNotification($custinfo->room_id,$title,$body,2);
            
            
        }
        echo true;
    }
    

    public function getInHouseGuests($data)
    { 
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }
        // $data = $request->all();
        // echo "<pre>";print_r($data);exit;
        // $custs = DB::table('customers')->select('id','first_name','last_name','guest_code',p,'nationality','guest_folio_id')->where('room_id',$data['room_id'])->where('checkout_date_time',null)->get();
        $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.guest_folio_id')->where('customers.created_by',$created_by_id)->orderBy('customers.id','desc')->where('customers.deleted_at',null);
        $dataq->join('rooms','rooms.id','=','customers.room_id','left');
        $dataq->join('countries','countries.id','=','customers.nationality','left');
        $dataq->where('customers.checkin_date_time','!=','')->where('customers.checkout_date_time','')->orWhere('customers.checkout_date_time','=',NULL);
        $dataq->where('customers.property_id',$data['property_id']);
        if($data['room_id']){
            $dataq->where('customers.room_id',$data['room_id']);
        }
        // $dataq->where('customers.room_id',$data['room_id']);
        $custs = $dataq->get();
        foreach($custs as $cs){
            $id = $cs->id;
            $cs->first_name =  $cs->first_name.' '.$cs->last_name;
        }

        $action = '<button type="button"  class="add_note_pop_up" id="{{$id}}" style="border: 1px solid darkblue;color: darkblue;" class="btn">Note <i class="fa fa-plus-circle"></i></button>';
        
        // $action = '<button type="button" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-toggle="modal" data-target="#largeNotesModal" id="add_note_pop_up" data-placement="top" title="Note" ><i class="fa fa-edit" style="font-size: 20px;"></i></button>';

        // if ($request->ajax()) {
        return Datatables::of($custs)
                        ->addColumn('action', $action)
                        // ->addColumn('action', '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        ->rawColumns(['action'])
                        ->make(true);
        // }
        // echo "<pre>ssssssssss";print_r($data);exit; 
        // return view('dashboard.inhouseguests.inhouseguests',['properties'=>$properties]);
    }
    
    public function getCheckedoutFoliosByRoom(Request $request)
    {   
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }

        $data = $request->all();
        // echo "<pre>";print_r($data);exit;
        $custs = DB::table('customers')->select('id','first_name','last_name','guest_code','nationality','guest_folio_id')->where('room_id',$data['room_id'])->where('checkout_date_time','!=','')->where('checkout_date_time','!=',null)->where('created_by',$created_by_id)->get();
        
        $action =  'gg';
        $tbl = "<button type='button' id='undo_checkout_all' class='btn btn-primary' name='undo_checkout_all'>Undo Checkout</button><br/><be><table class='table table-striped table-bordered datatable docs'>
            <thead>
                <tr>
                    <th><input type='checkbox' class='checkout_cust_select_all' name='checkout_cust_select_all' id='checkout_cust_select_all' value='all'><span id='select_all_checkbox' style='padding: 8px;'>Select All</span></th>
                    <th>Guest</th>
                    <th>Guest Folio ID</th>
                </tr>
            </thead>
            <tbody>";
            if($custs){
                foreach($custs as $cs){
                    $tbl .= "<tr>
                        <td><input type='checkbox' class='checkout_cust' name='cust' id='cust_".$cs->id."' value=".$cs->id."></td>
                        <td>".$cs->first_name." ".$cs->last_name."(".$cs->guest_code.")</td>
                        <td>".$cs->guest_folio_id."</td>
                    </tr>";
                }
            } else {
                $tbl .= "<tr>
                    <td>No data found.</td>
                    <td></td>
                    <td></td>
                </tr>";
            }
        echo $tbl;
    }

    public function roomAllUndoCheckout(Request $request){
        $data = $request->all();
        $dp_array = array();
        // echo "<pre>";print_r($data['checkout_cust_ar']);exit;
        foreach($data['checkout_cust_ar'] as $check){
            $dp_array = array('checkout_date_time'=>'' );
            DB::table('customers')->where('id', $check)->update($dp_array);
        }
        echo true;
    }
    
               
    public function getTodaysCheckouts($data)
    { 
        $user_type = Auth::user()->user_type ;
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();

        $created_by_id = '';
        if($user_type == 3){
            $h_admin = HotelAdmin::where('main_user_id',$main_id)->first();
            $created_by_id = $h_admin->main_user_id;
        } else  if($user_type == 4 ){//4 = hotel admin staff
            $staff_details = Staffs::where('main_user_id',Auth::user()->id)->first();
            $created_by_id = $staff_details->created_by;
        } else {
            $created_by_id = $main_id;
        }
        // $data = $request->all();
        // echo "<pre>";print_r($data);exit;
        
        $dataq = DB::table('customers')->select('customers.property_id', 'customers.id','customers.full_name','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.checkout_date_time','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.guest_folio_id')->where('customers.created_by',$created_by_id)->orderBy('customers.id','desc')->where('customers.deleted_at',null);
        $dataq->join('rooms','rooms.id','=','customers.room_id','left');
        $dataq->join('countries','countries.id','=','customers.nationality','left');
        $dataq->where('customers.checkin_date_time','!=','');
        $dataq->where('customers.property_id',$data['property_id']);
        if($data['room_id']){
            $dataq->where('customers.room_id',$data['room_id']);
        }
        
        $fromd = date('Y-m-d');
        $post_start_date =  \Carbon\Carbon::parse($fromd);
        $dataq->where('customers.tentative_checkout_date','=',$fromd);
        $dataq->where('customers.tentative_checkout_date','!=',null);
        
        $custs = $dataq->get();
    //   echo "<pre>";print_r($custs);exit;
        foreach($custs as $cs){
            $id = $cs->id;
             $cs->fisrt_name = $cs->fisrt_name.' '.$cs->last_name;
        }

        // $action = '<button type="button"  class="add_note_pop_up" id="{{$id}}" style="border: 1px solid darkblue;color: darkblue;" class="btn">Note <i class="fa fa-plus-circle"></i></button>';
        
        return Datatables::of($custs)
                        // ->addColumn('action', $action)
                        // ->addColumn('action', '<a href="/rooms/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>')
                        // ->rawColumns(['action'])
                        ->make(true);
    }
     
      
          
    //for getting and preview contract as per hotel template and customer selcted
    public function contract($data)
    { 
        // echo "dddddddd";exit;
        $id = base64_decode($data['id']);
        $hotel_admin_id = Auth::user()->id;
        $customerq = DB::table('customers')->select( 'customers.id','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.tentative_checkout_date','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.no_of_nights','customers.room_rate_info','customers.guest_folio_id','customers.remarks','customers.digital_sign','customers.passport_number','customers.emergency_contact_no','customers.created_by');
        $customerq->join('rooms','rooms.id','=','customers.room_id','left');
        $customerq->join('countries','countries.id','=','customers.nationality','left');
        $customerq->where('customers.id',$id);
        $customer = $customerq->get()->toArray();
        // echo "<pre>";print_R($customer);exit;
        
        $gurstInfo = DB::table('customers')->where('customers.id',$id)->first();
        $contract = GuestContracts::where('created_by',$hotel_admin_id)->where('property_id',$gurstInfo->property_id)->orderBy('id','desc')->first();
         if(empty($contract)){
             
                return 0;
         }
         $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$id)->get();
         
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Name</th>
                <th>Reamrk</th>
            </tr>
        </thead>
        <tbody>";
        if(!empty($all_customer_sub_guests)){
    
            foreach($all_customer_sub_guests as $sug_guest){
                $tbl .= "<tr>
                <td>".$sug_guest->sub_guest_name."</td>
                <td>".$sug_guest->sub_guest_remark."</td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Data not found</td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        
        
        return view('dashboard.customers.preview', ['customer' => $customer,'contract'=>$contract,'sub_guest' => $tbl]);
    }

    public function saveContractaspdfOLD(Request $request)
    {
        $data = $request->all();
        $hotel_admin_id = Auth::user()->id;
        $dp_array = array();
        // echo "<pre>";print_r($data);exit;

        $filename = "contract";
        $path = storage_path('pdf/orders');

        $id = $data['cust_id'];
        $customerq = DB::table('customers')->select( 'customers.id','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.tentative_checkout_date','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.no_of_nights','customers.guest_folio_id','customers.remarks','customers.passport_number','customers.emergency_contact_no','customers.created_by');
        $customerq->join('rooms','rooms.id','=','customers.room_id','left');
        $customerq->join('countries','countries.id','=','customers.nationality','left');
        $customerq->where('customers.id',$id);
        $customer = $customerq->get()->toArray();
        // echo "<pre>";print_R($customer);exit;
         $gurstInfo = DB::table('customers')->where('customers.id',$id)->first();
        $contract = GuestContracts::where('created_by',$hotel_admin_id)->where('property_id',$gurstInfo->property_id)->orderBy('id','desc')->first();

        if(!File::exists($path)) {
            File::makeDirectory($path, $mode = 0755, true, true);

        } 
        else {}

 $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$id)->get();
          $ar['customer_sub_guest']  = $all_customer_sub_guests;
          
        // echo "<pre>";print_r( $data);exit;
        $pdf = PDF::loadView('dashboard.customers.pdf',compact('contract','customer','all_customer_sub_guests'))->save(''.$path.'/'.$filename.'.pdf');
        return $pdf->download('disney.pdf');
    }
    
    
    
    
    public function saveContractaspdf(Request $request)
    {
        ini_set('max_execution_time', 180); //3 minutes
        $data = $request->all();
        $hotel_admin_id = Auth::user()->id;
        $dp_array = array();
        // echo "<pre>";print_r($data);exit;

        $filename = "contract";
        $path = storage_path('pdf/orders');

        $id = $data['cust_id'];
        $customerq = DB::table('customers')->select( 'customers.id','customers.first_name','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.tentative_checkout_date','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.no_of_nights','customers.guest_folio_id','customers.remarks','customers.digital_sign','customers.passport_number','customers.emergency_contact_no','customers.created_by','customers.room_rate_info');
        $customerq->join('rooms','rooms.id','=','customers.room_id','left');
        $customerq->join('countries','countries.id','=','customers.nationality','left');
        $customerq->where('customers.id',$id);
        $customer = $customerq->get()->toArray();
        // echo "<pre>";print_R($customer);exit;
        $contract = GuestContracts::where('created_by',$hotel_admin_id)->orderBy('id','desc')->first();

        $ar['contract'] = $contract;
        $ar['customer'] = $customer;
        
        $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$id)->get();
       
        // echo "<pre>";print_r($tbl);exit;
        $tbl = "<table cellspacing=0 class='footable-details table table-bordered tabel_info' style='width:100%;border-collapse:collapse !important;border:1px solid black !important;'>
        <thead>
            <tr style='width:25% !important;'>
                <th style='border:1px solid black !important;padding:5px !important;font-family:Arial, sans-serif !important; ' class='tabel_info_th'>Name</th>
                <th  style='border:1px solid black !important;padding:5px !important;font-family:Arial, sans-serif !important;' class='tabel_info_th'>Reamrk</th>
            </tr>
        </thead>
        <tbody>";
        if(!empty($all_customer_sub_guests)){
    
            foreach($all_customer_sub_guests as $sug_guest){
                $tbl .= "<tr style='border:1px solid black !important;' class='tabel_info_th'>
                <td style='border:1px solid black !important;padding:5px !important;font-family:Arial, sans-serif !important;' class='tabel_info_th'>".$sug_guest->sub_guest_name."</td>
                <td style='border:1px solid black !important;padding:5px !important;font-family:Arial, sans-serif !important;' class='tabel_info_th'>".$sug_guest->sub_guest_remark."</td>
            </tr>";
            }
        } else {
            $tbl .= "<tr style='border:1px solid black !important;padding:5px !important;font-family:Arial, sans-serif !important;'><td>Data not found</td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        
        //
          $ar['customer_sub_guest']  = $tbl;
         $filename = $customer[0]->guest_code.'.pdf';
        //  echo "<pre>";print_r($filename);exit;
        $pdf = PDF::loadView('dashboard.customers.pdf',$ar);
        return $pdf->download('Contract.pdf');
    }
    
    public function saveContractaspdf___________(Request $request)
    {
        ini_set('max_execution_time', 180); //3 minutes
        $data = $request->all();
        $hotel_admin_id = Auth::user()->id;
        $dp_array = array();

        $filename = "contract";
        $path = storage_path('pdf/orders');

        $id = $data['cust_id'];
        $customerq = DB::table('customers')->select( 'customers.id','customers.first_name','customers.guest_code','customers.last_name','customers.guest_code','customers.nationality','customers.checkin_date_time','customers.tentative_checkout_date','customers.room_id','countries.name as country_name','rooms.title as room_title','customers.no_of_nights','customers.room_rate_info','customers.guest_folio_id','customers.remarks','customers.digital_sign','customers.passport_number','customers.emergency_contact_no','customers.created_by');
        $customerq->join('rooms','rooms.id','=','customers.room_id','left');
        $customerq->join('countries','countries.id','=','customers.nationality','left');
        $customerq->where('customers.id',$id);
        $customer = $customerq->get()->toArray();
        // echo "<pre>";print_R($customer);exit;
        $contract = GuestContracts::where('created_by',$hotel_admin_id)->first();
// 
        $ar['contract'] = $contract;
        $ar['customer'] = $customer;
      
        $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$id)->get();
       
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Name</th>
                <th>Reamrk</th>
            </tr>
        </thead>
        <tbody>";
        if(!empty($all_customer_sub_guests)){
    
            foreach($all_customer_sub_guests as $sug_guest){
                $tbl .= "<tr>
                <td>".$sug_guest->sub_guest_name."</td>
                <td>".$sug_guest->sub_guest_remark."</td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Data not found</td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        
        // echo "<pre>";print_r($tbl);exit;
          $ar['customer_sub_guest']  = $tbl;
        $pdf = PDF::loadView('dashboard.customers.pdf',$ar);
        return $pdf->download($customer[0]->guest_code.'.pdf');
    }


   /*
    Save the customers note info
    */
    public function saveSubGuestInfo(Request $request)
    { 
        $customer_id = $request->input('customer_id');
        $hotel_admin_id = Auth::user()->id;
        $data = $request->all();  
        $customer = Customers::find($customer_id);
        $sub_guest_array = array(
            'customer_id'=>$customer_id,
            'sub_guest_name'=>$data['sub_guest_name'],
            'sub_guest_remark'=>$data['sub_guest_remark'],
        );
        $insert_cust_docs = DB::table('customer_sub_guests')->insertGetId($sub_guest_array);
        $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$customer_id)->get();
        $sub_guests_arr = array();
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Name</th>
                <th>Reamrk</th>
            </tr>
        </thead>
        <tbody>'";
        if(!empty($all_customer_sub_guests)){
    
            foreach($all_customer_sub_guests as $sug_guest){
                $tbl .=   "'<tr>
                <td>".$sug_guest->sub_guest_name."</td>
                <td>".$sug_guest->sub_guest_remark."</td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Data not found</td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
     
      public function getCustSubGuests(Request $request)
    { 
          $data = $request->all(); 
        //   echo "dddddddd";exit;
         $all_customer_sub_guests = DB::table('customer_sub_guests')->where('customer_id',$data['id'])->get();
        $sub_guests_arr = array();
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Name</th>
                <th>Reamrk</th>
            </tr>
        </thead>
        <tbody>'";
        if(!empty($sub_guests_arr)){
    
            foreach($sub_guests_arr as $sug_guest){
                $tbl .=   "'<tr>
                <td>".$sug_guest->sub_guest_name."</td>
                <td>".$sug_guest->sub_guest_remark."</td>
            </tr>";
            }
        } else {
            $tbl .= "<tr><td>Data not found</td>
            <td></td></tr>";
        }
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
    }
     
     
     
       public function getDueRoomsByProperty(Request $request)
    { 
        $data = $request->all();
        $all_prop_rooms = Room::where('property_id',$data['property_id'])->get();
        $html = "<option value='0'>Select Room</option>";
        if(!empty($all_prop_rooms)){
            foreach($all_prop_rooms  as $room){
                
                 $custs = DB::table('customers')->select('id')->where('room_id',$room->id)->where('checkout_date_time',null)->orWhere('checkout_date_time','')->where('created_by',$created_by_id)->get();
                 
                 if($custs){
                     $html .= "<option value='".$room->id."'>".$room->title."</option>";
                 } else {
                     $html = "<option value='0'>Room not available.</option>";
                 }
                
            }
        } else {
            $html = "<option value='0'>Room not available.</option>";

        }
        return response()->json(array('success'=>true, 'html'=>$html));
    }
     

    public function saveGuestInfo_29_05_2024_org_backup(Request $request)
    { 
        $data = $request->all();

        $customer = new Customers();
        // //for basic info tab details

        $property = Properties::find($request->input('property_id'));
        $total_cnt_q = DB::table('customers')
            ->select('id')
            ->Where('property_id', $request->input('property_id')) 
            ->get();
        $total_cnt = count($total_cnt_q);
        $total_cnt = $total_cnt + 1;
        $cust_code = sprintf("%'.04d\n", $total_cnt);
        $customer->guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;  
        
        $customer->first_name    = $request->input('first_name');
        $customer->last_name    = $request->input('last_name');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->nationality   =  $request->input('nationality');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->emergency_contact_no   =  $request->input('emergency_contact_no');
        $customer->emergency_contact_name   =  $request->input('emergency_contact_name');
        $customer->emergency_contact_description   =  $request->input('emergency_contact_description');
        $customer->booking_type   =  $request->input('booking_type');
        $customer->booking_no   =  $request->input('booking_no');
        $customer->booking_description   =  $request->input('booking_description');
        $customer->guest_folio_id   =  $request->input('guest_folio_id');

        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->gender   =  $request->input('gender');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');
        $customer->no_of_nights   =  $request->input('no_of_nights');
        $customer->tentative_checkout_date   =  $request->input('tentative_checkout_date');
        $customer->room_rate_info   =  $request->input('room_rate_info');
        $customer->no_of_guests   =  $request->input('no_of_guests');
        
        $customer->address    = $request->input('address');
        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');
        $customer->visa_number   =  $request->input('visa_number');
        $customer->visa_issue_date   =  $request->input('visa_issue_date');
        $customer->visa_expiry_date   =  $request->input('visa_expiry_date');
        $customer->other_id_type   =  $request->input('other_id_type');
        $customer->other_id_number   =  $request->input('other_id_number');
        $customer->other_id_expiry_date   =  $request->input('other_id_expiry_date');
        $customer->vat_in_no   =  $request->input('vat_in_no');
        $customer->company_details   =  $request->input('company_details');
        $customer->confirm_checkin = 0;

        $customer->created_by = Auth::user()->id;
        $customer->save();
        $recent_cust_id = $customer->id;
        
        if($customer->checkout_date_time){
            $custinfo = DB::table('customers')->select('room_id')->where('id',$recent_cust_id)->get()->first();
            $title = "Checkout Alert";
            $body = 'Customer '.$customer->first_name.' '.$customer->last_name.' has been checked out from this room';
            self::sendNotification($custinfo->room_id,$title,$body,2);
        }
        
        File::makeDirectory('storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
 
        //for tax header
        if ($request->hasFile('guest_profile_pic')) {

            $headerfilenameWithExt = $request->file('guest_profile_pic')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('guest_profile_pic')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'profile_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('guest_profile_pic')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $headerfileNameToStore);    
            $dp_array = array('profile_image'=>$headerfileNameToStore,);
            DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }
        return response()->json(array('cust_id'=>$recent_cust_id));
    }

    public function saveGuestInfo(Request $request)
    { 
        $data = $request->all();

        $customer = new Customers();
        // //for basic info tab details
        // echo "<pre>";print_r($data);exit;
        $property = Properties::find($request->input('property_id'));
        $total_cnt_q = DB::table('customers')
            ->select('id')
            ->Where('property_id', $request->input('property_id')) 
            ->get();
        $total_cnt = count($total_cnt_q);
        $total_cnt = $total_cnt + 1;
        $cust_code = sprintf("%'.04d\n", $total_cnt);
        $customer->guest_code =   $property->code.'-'.date('d-m-Y').'-'.$cust_code;  
        
        $customer->first_name    = $request->input('first_name');
        $customer->last_name    = $request->input('last_name');
        $customer->date_of_birth   =  $request->input('date_of_birth');
        $customer->nationality   =  $request->input('nationality');
        $customer->passport_number   =  $request->input('passport_number');
        $customer->emergency_contact_no   =  $request->input('emergency_contact_no');
        $customer->emergency_contact_name   =  $request->input('emergency_contact_name');
        $customer->emergency_contact_description   =  $request->input('emergency_contact_description');
        $customer->booking_type   =  $request->input('booking_type');
        $customer->booking_no   =  $request->input('booking_no');
        $customer->booking_description   =  $request->input('booking_description');
        $customer->guest_folio_id   =  $request->input('guest_folio_id');

        $customer->email   =  $request->input('email');
        $customer->mobile   =  $request->input('mobile');
        $customer->gender   =  $request->input('gender');
        $customer->passport_expiry_date   =  $request->input('passport_expiry_date');
        $customer->country_of_issue   =  $request->input('country_of_issue');
        $customer->room_id   =  $request->input('room_id');
        $customer->property_id   =  $request->input('property_id');
        $customer->checkin_date_time   =  $request->input('checkin_date').' '.$request->input('checkin_time');
        $customer->checkout_date_time   =  $request->input('checkout_date').' '.$request->input('checkout_time');
        $customer->no_of_nights   =  $request->input('no_of_nights');
        $customer->tentative_checkout_date   =  $request->input('tentative_checkout_date');
        $customer->room_rate_info   =  $request->input('room_rate_info');
        $customer->no_of_guests   =  $request->input('no_of_guests');

        $customer->address    = $request->input('address');
        $customer->city    = $request->input('city');
        $customer->state   =  $request->input('state');
        $customer->pin   =  $request->input('pin');
        $customer->country   =  $request->input('country');
        $customer->visa_number   =  $request->input('visa_number');
        $customer->visa_issue_date   =  $request->input('visa_issue_date');
        $customer->visa_expiry_date   =  $request->input('visa_expiry_date');
        $customer->other_id_type   =  $request->input('other_id_type');
        $customer->other_id_number   =  $request->input('other_id_number');
        $customer->other_id_expiry_date   =  $request->input('other_id_expiry_date');
        $customer->vat_in_no   =  $request->input('vat_in_no');
        $customer->company_details   =  $request->input('company_details');
        $customer->confirm_checkin = 0;


        $main_id = Auth::user()->id ;
        $hotel_sub_id =   Auth::user()->id ;
         if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff ){//4 = hotel admin staff
            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id','created_by')->where('main_user_id', Auth::user()->id)->first();
             $main_id = $getGroup->created_by;
             $hotel_sub_id= $getGroup->created_by;
        }
        
        $customer->created_by = $main_id;
        $customer->save();
        $recent_cust_id = $customer->id;

        // $title = "CheckIn Alert";
        // $body = 'Customer '.$customer->first_name.' '.$customer->last_name.' has been checked in to this room';
        // self::sendNotification($customer->room_id,$title,$body,1);
        
        
        File::makeDirectory('storage/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents/'.$recent_cust_id.'/display_picture', 0777, true, true);
 
        //for tax header
        if ($request->hasFile('guest_profile_pic')) {

            $headerfilenameWithExt = $request->file('guest_profile_pic')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('guest_profile_pic')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'profile_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('guest_profile_pic')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/customer_documents'.'/'.$recent_cust_id.'/display_picture', $headerfileNameToStore);    
            $dp_array = array('profile_image'=>$headerfileNameToStore,);
            DB::table('customers')->where('id', $recent_cust_id)->update($dp_array);
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }


        //complaint found if any for complaint tab
        $complaintExists = DB::table('customers as cs')->select('cs.id','cs.passport_number')
                            ->join('complaints as cp','cp.complaint_against','=','cs.id','left')
                            ->where('cs.passport_number',$request->input('passport_number'))
                            ->orWhere('cs.first_name', 'like', '%' . $request->input('first_name') . '%')
                            ->orWhere('cs.last_name', 'like', '%' . $request->input('last_name') . '%')
                            ->get();
        $complaint_cust_str = '';
        if(!empty($complaintExists)){
            foreach($complaintExists as $cust ){
                $complaints_list = Complaints::where('complaint_against',$cust->id)->first();
                if(!empty($complaints_list)){
                    if($cust->passport_number == $request->input('passport_number')){
                        $complaint_cust_str .= $cust->id.',';
                    }
                }
            }
        }
        
        // Show exclamatory mark if guest is blacklisted from any of logged in hotel admin properties.
        $blacklist_by_same_hotel_admin = DB::table('blacklists')
                ->select('id')
                ->where('created_by', Auth::user()->id)
                ->where('passport_no',$request->input('passport_number'))
                ->where('date_of_birth',$request->input('date_of_birth'))
                ->orWhere('name', 'like', '%' . $request->input('first_name') . '%')
                ->orWhere('name', 'like', '%' . $request->input('last_name') . '%')
                ->orWhere('nationality', $request->input('nationality'))
            ->get();
        $show_exclamatory_mark = '';
        if(!empty($blacklist_by_same_hotel_admin)){
            $show_exclamatory_mark = '1';
        }

      // Show exclamatory mark if guest is blacklisted from any of logged in hotel admin properties.
      $blacklist_by_other_hotel_admin = DB::table('blacklists')
            ->select('id')
            ->where('passport_no',$request->input('passport_number'))
            ->where('date_of_birth',$request->input('date_of_birth'))
            ->orWhere('name', 'like', '%' . $request->input('first_name') . '%')
            ->orWhere('name', 'like', '%' . $request->input('last_name') . '%')
            ->orWhere('nationality', $request->input('nationality'))
        ->get();
        $show_multiple_triangles_mark = '';
        if(!empty($blacklist_by_other_hotel_admin)){
            $show_multiple_triangles_mark = '1';
        }

        //complaint found if any for complaint tab
        $criminalExists = DB::table('criminal_records as cr')
            ->select('id')
            ->orWhere('first_name', 'like', '%' . $request->input('first_name'). '%')
            ->orWhere('last_name', 'like', '%' . $request->input('last_name') . '%')
        ->get();
        $crminal_cust_str = '';
        foreach($criminalExists as $cust ){
            $crminal_cust_str .= '1';
        }

        //complaint found if any for complaint tab
        $blacklistExists = DB::table('blacklists')
            ->select('id')
            ->Where('date_of_birth', 'like', '%' . $request->input('date_of_birth') . '%')
            ->Where('passport_no', 'like', '%' . $request->input('passport_number') . '%')
            ->orWhere('name', 'like', '%' . $request->input('first_name') . '%')
            ->orWhere('name', 'like', '%' . $request->input('last_name') . '%')
            ->orWhere('nationality', 'like', '%' . $request->input('nationality'). '%')
        ->get();
        $blacklists_str = '';
        foreach($blacklistExists as $cust ){
            $blacklists_str .= '1';
        }

        //show caution icon
        $show_caution_mark =''; 
        if($blacklists_str || $crminal_cust_str){
            $show_caution_mark = '1';
        }

        // return $recent_cust_id;
        return response()->json(array('cust_id'=>$recent_cust_id,'show_exclamatory_mark'=>$show_exclamatory_mark,'show_multiple_triangles_mark'=>$show_multiple_triangles_mark,'show_caution_mark'=>$show_caution_mark, 'cust_complaints'=>$complaint_cust_str,'crminal_cust_str'=>$crminal_cust_str,'blacklists_str'=>$blacklists_str));
        // return response()->json(array('cust_id'=>$recent_cust_id));
       
        echo "<pre>HERE : ";print_r($data);exit;

    }


    public function finalsubmit(Request $request)
    {
        $alldata = $request->all();
        //  echo "<pre>HERE : ";print_r($alldata);exit;
        $roomid = $request->get('roomid');
        $full_name = $request->get('fname').' '.$request->get('lname');
        $title = "Checked In Alert";
        $body = 'Customer '.$full_name.' has been checked in to this room';
        self::sendNotification($roomid,$title,$body,1);
            
        $request->session()->flash('message', 'Record Added Successfully.');
        return redirect()->route('customers.index'); 
    }

    public function getAllDashboardInfo(Request $request){ 
        $datas = $request->all();

       $main_id = Auth::user()->id;
        $getstaffs_ar = array();
        if(Auth::user()->user_type == 4 || Auth::user()->user_type == 6){//4 = hotel admin staff , 6=govt admin staff ){//4 = hotel admin staff

            //get staff info for group 
            $getGroup = DB::table('staffs')->select('group_id','created_by')->where('main_user_id', Auth::user()->id)->first();
            
            //get groups and privileges
            $getPrivileges = DB::table('groups_privileges')->where('group_id', $getGroup->group_id)->where('module_id','9')->first();//module_id = 5(Only customer module)
            $main_id = $getGroup->created_by;
            $getstaffs_ar =  array($main_id,Auth::user()->id);
        } else {
            $getPrivileges = array();
            $main_id = $main_id;
            $getstaffs_ar_all = DB::table('staffs')->select('main_user_id')->where('created_by', Auth::user()->id)->get();
            
            if($getstaffs_ar_all->isEmpty()){
                $getstaffs_ar = array($main_id);
            } else {
                $getstaffs_ar = $getstaffs_ar_all->pluck('main_user_id')->toArray();
                array_push($getstaffs_ar,$main_id);
            }
        }
        
        
        $currdate =  date('Y-m-d');
        $currdatetime =  date('Y-m-d H:i s',strtotime($currdate));

        //get total checkins todsy
        $total_checkins_today_q = DB::table('customers')->where('deleted_at',null)->where('checkin_date_time', 'like', '%' . $currdate . '%');
        if($datas['property_id'] != 'all'){
            $total_checkins_today_q->where('property_id', $datas['property_id']);
        } 
        $total_checkins_today = $total_checkins_today_q->whereIn('created_by',$getstaffs_ar)->count();
       
        //get total inhouse guests today
        $total_inhouse_guests_today_q =  DB::table('customers')->where('deleted_at',null)->where('checkin_date_time', '<=',  $currdatetime )->where('customers.checkin_date_time','!=','')->where('checkout_date_time','')->orWhere('checkout_date_time','=',NULL);
        if($datas['property_id'] != 'all'){
            $total_inhouse_guests_today_q->where('property_id', $datas['property_id']);
        }
        $total_inhouse_guests_today = $total_inhouse_guests_today_q->whereIn('created_by',$getstaffs_ar)->count();

        //count checkout today
        $total_checkouts_today_q = DB::table('customers')->where('deleted_at',null)->where('checkout_date_time', 'like', '%' . $currdate . '%');
        if($datas['property_id'] != 'all'){
            $total_checkouts_today_q->where('property_id', $datas['property_id']);
        }
        $total_checkouts_today = $total_checkouts_today_q->whereIn('created_by',$getstaffs_ar)->count();
       
        //total complaints 
        $total_complaints_q = DB::table('complaints')->where('complaints.deleted_at',null);
        $total_complaints_q->join('customers','customers.id','=','complaints.complaint_against','left');
        if($datas['property_id'] != 'all'){
            $total_complaints_q->where('customers.property_id', $datas['property_id']);
        } 
        $total_complaints = $total_complaints_q->whereIn('complaints.created_by',$getstaffs_ar)->count();
        //total expected checkins today
        $total_expected_checkins_today_q = DB::table('reservations')->where('deleted_at',null)->where('from_date', 'like', '%' . $currdate . '%');
        if($datas['property_id'] != 'all'){
            $total_expected_checkins_today_q->where('property_id', $datas['property_id']);
        }
        $total_expected_checkins_today = $total_expected_checkins_today_q->whereIn('created_by',$getstaffs_ar)->count();

        //total occupied rooms today
        $total_occupied_rooms_today_q = DB::table('customers')->where('checkin_date_time', '<=',  $currdatetime )->where('customers.checkin_date_time','!=','')->where('checkout_date_time','')->orWhere('checkout_date_time','=',NULL)->where('deleted_at',null)->distinct('room_id');
        if($datas['property_id'] != 'all'){
            $total_occupied_rooms_today_q->where('property_id', $datas['property_id']);
        }
        $total_occupied_rooms_today = $total_occupied_rooms_today_q->whereIn('created_by',$getstaffs_ar)->distinct('room_id')->count('room_id');

         //total due checkouts today
        $total_due_checkouts_today_q = DB::table('customers')->where('tentative_checkout_date', $currdate)->where('deleted_at',null);
        if($datas['property_id'] != 'all'){
            $total_due_checkouts_today_q->where('property_id', $datas['property_id']);
        }
        $total_due_checkouts_today = $total_due_checkouts_today_q->whereIn('created_by',$getstaffs_ar)->count();

        //total active rooms today
        $total_active_rooms_today_q = DB::table('rooms as ro')
                                    ->join('customers as cu','cu.room_id','=' ,'ro.id','left');
                                    if($datas['property_id'] != 'all'){
                                        $total_active_rooms_today_q->where('ro.property_id', $datas['property_id']);
                                    }
        $total_active_rooms_today = $total_active_rooms_today_q->where('cu.checkin_date_time', '<=',  $currdatetime)->where('ro.status', 1)->where('cu.deleted_at',null)->whereIn('ro.created_by',$getstaffs_ar)->count();

        //total stay over rooms
        $total_due_checkouts_rooms_today_q = DB::table('customers')->where('tentative_checkout_date', 'like', '%' . $currdate . '%')->where('deleted_at',null)->distinct('room_id');
        if($datas['property_id'] != 'all'){
            $total_due_checkouts_rooms_today_q->where('property_id', $datas['property_id']);
        } 
        $total_due_checkouts_rooms_today = $total_due_checkouts_rooms_today_q->whereIn('created_by',$getstaffs_ar)->distinct('room_id')->count('room_id');
        $total_stay_over_rooms = $total_occupied_rooms_today - $total_due_checkouts_rooms_today;

        //total checkouts rooms today 
        $total_checked_out_rooms_today_q = DB::table('customers')->where('checkout_date_time', 'like', '%' . $currdate . '%')->where('deleted_at',null)->distinct('room_id');
        if($datas['property_id'] != 'all'){
            $total_checked_out_rooms_today_q->where('property_id', $datas['property_id']);
        }
        $total_checked_out_rooms_today = $total_checked_out_rooms_today_q->where('created_by',Auth::user()->id)->distinct('room_id')->count('room_id');

        //for occupancy percantage
        $total_rooms_by_property_q = DB::table('rooms')->where('status',1)->where('deleted_at',null);
        if($datas['property_id'] != 'all'){
            $total_rooms_by_property_q->where('property_id', $datas['property_id']);
        }
        $total_rooms_by_property = $total_rooms_by_property_q->whereIn('created_by',$getstaffs_ar)->count();
        
        if(!$total_rooms_by_property){
            $total_rooms_by_property = 1;
        } else {
            $total_rooms_by_property = $total_rooms_by_property;
        }
        
        $roomsWithCheckinsToday = DB::table('customers')->where('checkin_date_time', 'like', '%' . $currdate . '%')
    ->distinct('room_id')
    ->count('room_id');
    
    
        // echo $roomsWithCheckinsToday.' + '.$total_occupied_rooms_today.' - '.$total_checked_out_rooms_today.' / '.$total_rooms_by_property;exit;
        $occupancy_percentage = ($roomsWithCheckinsToday + $total_occupied_rooms_today - $total_checked_out_rooms_today) / $total_rooms_by_property;
        // echo $occupancy_percentage
        if($occupancy_percentage >= $total_rooms_by_property){
            $final_occupancy_percentage = 100;
        } else {
            $final_occupancy_percentage = number_format($occupancy_percentage*100,2);
        }
      

        // echo $total_checkins_today.' + '.$total_occupied_rooms_today.' - '.$total_checked_out_rooms_today.' / '.$total_rooms_by_property;exit;
        //total available rooms today 
        $total_available_rooms = $total_rooms_by_property - $total_checkins_today - $total_occupied_rooms_today + $total_checked_out_rooms_today;
        if($total_available_rooms > 0){
            $total_available_rooms = $total_available_rooms;
        } else {
            $total_available_rooms = 0;
        }
        
        //total in-active rooms
        $inactive_rooms_with_reason_q = DB::table('rooms')->select('rooms.title','rooms.reason_for_inactive','properties.name as property_name')->where('rooms.status',0)->where('rooms.deleted_at',null);
        $inactive_rooms_with_reason_q->join('properties','properties.id','=','rooms.property_id','left');

        if($datas['property_id'] != 'all'){
            $inactive_rooms_with_reason_q->where('rooms.property_id', $datas['property_id']);
        }
        $inactive_rooms_with_reason_q_res = $inactive_rooms_with_reason_q->whereIn('rooms.created_by',$getstaffs_ar)->get();
        $inactive_rooms_with_reason = count($inactive_rooms_with_reason_q_res);

        $total_inactive_rooms_with_reason_html = "";
        // echo "<pre>";print_r($nationality_array);exit; 
        $total_inactive_rooms_with_reason_html .= "<table class='table table-striped table-bordered datatable docs' id='total_inactive_rooms'>
            <thead>
                <tr>
                    <th>Room</th>
                    <th>Property</th>
                    <th>Reason</th>
                </tr>
            </thead>
        <tbody>";

        if(!empty($inactive_rooms_with_reason_q_res)){
            foreach($inactive_rooms_with_reason_q_res as $key => $room){
                if($room->reason_for_inactive == 1){
                    $room->reason_for_inactive = 'OOO (Out Of Order)';
                } else if($room->reason_for_inactive == 2){
                    $room->reason_for_inactive = 'Maintainance';
                } else if($room->reason_for_inactive == 3){
                    $room->reason_for_inactive = 'Staff Use';
                } else {
                    $room->reason_for_inactive = 'Others';
                }
                $total_inactive_rooms_with_reason_html .= "<tr>
                    <td>".$room->title."</td>
                    <td>".$room->property_name."</td>
                    <td>".$room->reason_for_inactive."</td>
                </tr>";
            }
        } else {
            $total_inactive_rooms_with_reason_html .= "<tr><td>No data found.</td><td></td></tr>";
        }

        $total_inactive_rooms_with_reason_html .= '</tbody></table>';

        return response()->json(array(
            'success'=>true, 
            'total_checkins_today'=>$total_checkins_today,
            'total_inhouse_guests_today'=> $total_inhouse_guests_today,
            'total_checkouts_today' => $total_checkouts_today,
            'total_complaints' => $total_complaints,
            'total_expected_checkins_today' => $total_expected_checkins_today,
            'total_occupied_rooms_today' => $total_occupied_rooms_today,
            'total_due_checkouts_today' => $total_due_checkouts_today,
            'total_active_rooms_today' => $total_active_rooms_today,
            'total_stay_over_rooms' => $total_stay_over_rooms,
            'total_checked_out_rooms_today' => $total_checked_out_rooms_today,
            'occupancy_percentage' => $final_occupancy_percentage,
            'total_available_rooms' => $total_available_rooms,
            'total_inactive_rooms_with_reason' => $inactive_rooms_with_reason,
            'total_inactive_rooms_with_reason_html' => $total_inactive_rooms_with_reason_html,
        ));
    }

     
      
    public function get_recent_cust(Request $request)
    { 
        $data = $request->all();
        
        // echo "<pre>";print_r($data);exit;
        $all_cust = DB::table('customers')->select('customers.id','customers.first_name','customers.last_name','customers.guest_code','customers.checkin_date_time','rooms.title as room_title')
        ->join('rooms','rooms.id','=','customers.room_id','left')
        ->where('customers.room_id',$data['room_id'])
        ->where('customers.deleted_at',NULL)->get();
        $all_cust_arr = array();
        // echo "<pre>";print_r($all_cust);exit;
        
        $tbl = "<table class='table table-striped table-bordered datatable docs'>
        <thead>
            <tr>
                <th>Name</th>
                <th>Room</th>
                <th>CheckIn Date & Time</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>'";
        if(!empty($all_cust)){
            $action = '';
    
            foreach($all_cust as $cust){
                $id = $cust->id;

                $action = '<a href="/customers/'.$cust->id.'/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';

                $tbl .=   "'<tr>
                <td>".$cust->first_name.' '.$cust->last_name.' ('.$cust->guest_code." )</td>
                <td>".$cust->room_title."</td>
                <td>".$cust->checkin_date_time."</td>
                <td>".$action."</td>
            </tr>";
            }
        } else {
            $tbl .= "<tr>
                <td>Customers not found</td>
                <td></td>
                <td></td>
                <td></td>
            </tr>";
        }
        $tbl .= '</tbody></table>';
        return response()->json(array('success'=>true, 'html'=>$tbl));
        
    }

    public static function sendNotification($room_id,$title,$body,$type)
    {
        $url = 'https://fcm.googleapis.com/v1/projects/hotel-call-938c4/messages:send';

        $credentialsFilePath = Storage::path('json/hotel-call-938c4-firebase-adminsdk-fbsvc-32eb89ecac.json');
        $client = new GoogleClient();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->refreshTokenWithAssertion();
        $token = $client->getAccessToken();
		$access_token = $token['access_token'];

        $notify = array('title'=>$title,'body'=>$body);

        //check notificaion log for duplicates
        $file_data = '';
        $file_data .="\n-------------\n";
        $file_data .="\Notified at \n".date('Y-m-d H:i:s');
        $file_data .="\n-------------\n";
        Storage::disk('local')->append('notification_check.txt', $file_data);    
        $sub_title = '';
        if($type == 1){
            $sub_title = 'customer_checkin';
        } else if($type == 2){
            $sub_title = 'customer_checkout';
        }
        $firebaseToken = DB::table('rooms')->select('device_token')->where('id',$room_id)->first();
        $data = [
            "message" => [
                "token" => $firebaseToken->device_token,
                "notification" =>$notify,
                'data' =>array(
                    'title'=>$title,
                    'body'=>$body,
                    "room_id"=>(string) $room_id,
                    "timestamp"=>date('Y-m-d H:i s'),
                    "mutable-content"=>"1",
                    'subtitle' => $sub_title
                ),
            ]
        ];

        $headers = [
            "Authorization: Bearer $access_token",
            'Content-Type: application/json'
        ];
 
        // $url = 'https://fcm.googleapis.com/fcm/send';
        $ch = curl_init($url);
        curl_setopt_array($ch, array(
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_TIMEOUT => 60
        ));
        $result = curl_exec($ch);
        $responseData = json_decode($result, true);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        // echo "<pre>";print_r( json_encode($data));exit;
        $error = curl_error($ch);
        //  echo "<pre>HERE ";print_r( $responseData);exit;
        curl_close($ch);
       
        return 1;
    }
    
}
