<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\ComplaintTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class ComplaintTypesController extends Controller
{
    public function index(Request $request){
        $main_id = Auth::user()->id;
  

        if ($request->ajax()) {
            $data = DB::table('complaint_types')->select('*')->orderBy('id','desc')->where('deleted_at',null)->get();

            // $data = IdProofTypes::where('created_by',$main_id)->orderBy('id','desc')->get();
     
                foreach($data as $type){
                    $id = $type->id;
                }
                $action = '<a href="/complainttypes/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="cil-pencil" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="cil-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';

                return Datatables::of($data)
                        ->addColumn('action',$action) 
                        ->rawColumns(['action'])
                        ->make(true);
        }
        return view('dashboard.complainttypes.complaintsType');
    }


    public function show(Request $request)
    {
        // $data = $request->all();
        // if(array_key_exists('type',$data) != false){
        //     return  $this->getComplaintDetails($data);
        // }
        return view('dashboard.complainttypes.create');
    }
     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        return view('dashboard.complainttypes.create');
    }
    
   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

        //insert new type
        $type = new ComplaintTypes();
        $type->title    = $request->input('title');
        $type->description   =  $request->input('description');
        $type->action_taken_for_hotel   =  $request->input('action_taken_for_hotel');
        $type->action_taken_for_police_recommanedation   =  $request->input('action_taken_for_police_recommanedation');
        $type->action_by_people_suggesstion   =  $request->input('action_by_people_suggesstion');
        $type->complaint_rating   =  $request->input('complaint_rating'); 
        $type->created_by   = Auth::user()->id;
        $type->save();

        $request->session()->flash('message', 'Complaint Type Created Successfully.');
        return redirect()->route('complainttypes.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $company_type = ComplaintTypes::find($id);
        return view('dashboard.complainttypes.edit', [ 'type' => $company_type ]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'title'      => 'required|min:1|max:64',
            'description'       => 'required|min:1|max:64',
        ]);

          //insert new type
          $type = ComplaintTypes::find($id);
          $type->title    = $request->input('title');
          $type->description   =  $request->input('description');
          $type->action_taken_for_hotel   =  $request->input('action_taken_for_hotel');
          $type->action_taken_for_police_recommanedation   =  $request->input('action_taken_for_police_recommanedation');
          $type->action_by_people_suggesstion   =  $request->input('action_by_people_suggesstion'); 
          $type->complaint_rating   =  $request->input('complaint_rating'); 
          $type->save();

        $request->session()->flash('message', 'Company Type Updated Successfully');
        return redirect()->route('complainttypes.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $type = ComplaintTypes::find($id);
        if($type){
            $type->delete();
        }
        return redirect()->route('complainttypes.index');
    }

    


    
}
