<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use App\Models\HotelAdmin;
use App\Models\Visitors;
use App\Models\Properties;
use App\Models\Customers;
use App\Models\CommercialTax;
use App\Models\CommercialTaxDetails;
use App\Models\CommercialInvoiceReceipt;
use App\Models\PaymentMethod;
use App\Models\ReceiptSettings; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;
use PDF;


class CommercialTaxInvoiceListController extends Controller
{
    public function show(Request $request)
    {    
        $datas = $request->all();

        if(array_key_exists('is_get_cust',$datas) == true){
            return  $this->getCommercialInvoiceListByProperty($datas);
        }
        if(array_key_exists('is_download_commercial_invoice',$datas) == true){
            return  $this->downloadCommercialInvoicePdf($datas);
        }
        
        if(array_key_exists('is_edit',$datas) == true){
            return  $this->editCommercialInvoice($datas);
        }

        if(array_key_exists('is_commercial_invoice_receipt',$datas) == true){
            return  $this->generateCommercialInvoiceReceipt($datas);
        }
        
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.commercialtaxsettings.commercialtaxinvoicelist',['properties'=>$properties]);
    }
    
    public function getCommercialInvoiceListByProperty($data)
    {   
        $taxsettingsItemsq = DB::table('tbl_customers_commercial_tax_invoice_details as tid');
        if($data['curr'] == 'usd'){
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.total_amt_usd as total_amt');
        } else {
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.total_amt_kh as total_amt');
        }
        $taxsettingsItemsq->join('customers as cu','cu.id','=', 'tid.customer_id','left')
        ->join('tbl_commercial_tax_settings as tx','tx.property_id','=','cu.property_id','left')
        ->join('properties as pr','pr.id','=','tx.property_id','left')
        // ->where('cu.deleted_at',NULL)
        ->where('tx.property_id',$data['property_id'])
        ->where('tid.invoice_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $taxsettingsItems = $taxsettingsItemsq->get();
        $cu = $data['curr'];
        foreach($taxsettingsItems as $inv){
            $inv->total_amt = number_format((float)$inv->total_amt, 2, '.', '');
        }
        $action = '<a href="{{ route("commercialtaxinvoicelist.editcommercialInvoice",["id"=>base64_encode($id),"is_edit"=>1]) }}"  style=" animation: flashing-style 0.6s linear infinite;width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
        // $action .= '<a href="/taxinvoicelist/{{$id}}/downloadinvoicepdf"  style=" animation: flashing-style 0.6s linear infinite;width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Download Invoice" ><i class="fa fa-download" style="font-size: 20px;"></i></a>';
        $action .= '<a href="{{ route("commercialtaxinvoicelist.downloadCommercialInvoicePdf",["id"=>base64_encode($id),"is_download_commercial_invoice"=>1,"currency"=> "'.$cu.'"]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="Download Invoice" class="download_invoice_pdf" ><i class="fa fa-download"></i></a>';
        $action .= '<a href="{{ route("commercialtaxinvoicelist.commercialreceiptInvoice",["id"=>base64_encode($id),"is_commercial_invoice_receipt"=>1,"currency"=> "'.$cu.'"]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="Invoice Receipt" class="invoice_receipt" ><i class="fa fa-receipt"></i></a>';
        
        // if ($request->ajax()) {
            return Datatables::of($taxsettingsItems)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                // ->addColumn('check', $check)
                // ->rawColumns(['check'])
                ->make(true);
        // } 
        return $taxsettingsItems;
        // echo "<pre>-------";print_r($taxsettingsItems);exit;
    }
    

    public function downloadCommercialInvoicePdf($data){
        // echo "<pre>";print_r($data);exit; 

        $id = base64_decode($data['id']);;
        $ar['commercialtaxDetails'] = CommercialTaxDetails::find($id);
        $ar['commercialtaxsettings'] = CommercialTax::find($ar['commercialtaxDetails']->commercial_row_id);
        $ar['commercialInvoiceItems'] = DB::table('tbl_customers_commercial_invoice_items')->where('commercial_detail_id',$id)->get();

        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $filename = $ar['commercialtaxDetails']->guest_code.'_commercial_invoice_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.commercialtaxsettings.commercialinvoice',$ar);
        return $pdf->download($filename);
        echo "<pre>";print_r($data);exit; 

    }

    public function editCommercialInvoice($data){
        // echo "<pre>";print_r($data);exit; 

        $id = base64_decode($data['id']);
        $commercialtaxDetails = CommercialTaxDetails::find($id);
        $commercialsettings = CommercialTax::find($commercialtaxDetails->commercial_row_id);
        $commercialsettingsItems = DB::table('tbl_commercial_settings_items')->where('commercial_settings_id',$commercialtaxDetails->commercial_row_id)->get();

        $customer = Customers::find($commercialtaxDetails->customer_id);
        $curr_time = date('H:i');
        $commercialInvoiceItems = DB::table('tbl_customers_commercial_invoice_items')->where('commercial_detail_id',$id)->get();

        $checkreceipt = CommercialInvoiceReceipt::where('customer_id',$commercialtaxDetails->customer_id)->first();
        if(!$checkreceipt){
            $is_valid_to_edit = 1;//can edit
        } else {
            if($checkreceipt->is_close == 1){
                $is_valid_to_edit = 0;//cannot edit
            } else {
                 $is_valid_to_edit = 1;//can edit
            }
        }
        
        return view('dashboard.commercialtaxsettings.editcommercialInvoice', ['customer'=>$customer, 'commercialsettings' => $commercialsettings,'commercialtaxDetails'=>$commercialtaxDetails,'curr_time'=>$curr_time,'commercialsettingsItems' => $commercialsettingsItems,'commercialInvoiceItems' => $commercialInvoiceItems,'is_valid_to_edit' => $is_valid_to_edit]);


    }

    public function downloadCommercialInvoiceReport(Request $request){
        $data = $request->all();
         $taxsettingsItemsq = DB::table('tbl_customers_commercial_tax_invoice_details as tid');
        if($data['currency'] == 'usd'){
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.exchange_rate','tid.total_amt_usd as total_amt');
        } else {
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.exchange_rate','tid.total_amt_kh as total_amt');
        }
        $taxsettingsItemsq->join('customers as cu','cu.id','=', 'tid.customer_id','left')
        ->join('tbl_commercial_tax_settings as tx','tx.property_id','=','cu.property_id','left')
        ->join('properties as pr','pr.id','=','tx.property_id','left')
        // ->where('cu.deleted_at',NULL)
        ->where('tx.property_id',$data['property_id'])
        ->where('tid.invoice_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $taxsettingsItems = $taxsettingsItemsq->get();
        $newdata =  array();
        $propname = '';

        foreach($taxsettingsItems as $inv){
            $propname  = $inv->property_name;
            $newdata[] = $inv;
        }
        $ar['propname'] = $propname;
        $ar['commercialinvoices'] = $newdata;
        $ar['currency'] = $data['currency'];
        $ar['month'] = date("F", mktime(0, 0, 0, $data['month'], 10));

        // echo "<pre>";print_r($ar['invoices']);exit;
        $filename = 'Commercial_Invoice_Report_'.$propname.'_for_'.$ar['month'].'_2024_'.$data['currency'].'_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.commercialtaxsettings.commercial_invoice_report',$ar);
        return $pdf->download($filename);
    }


    public function receiptCommercialInvoice($data){
        // echo "<pre>";print_r($data);exit; 

        $id = base64_decode($data['id']);;
        $ar['commercialtaxDetails'] = CommercialTaxDetails::find($id);
        $ar['commercialtaxsettings'] = CommercialTax::find($ar['taxDetails']->tax_row_id);
        $ar['commercialtaxInvoiceItems'] = DB::table('tbl_customers_commercial_tax_invoice_items')->where('tax_detail_id',$id)->get();
        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $filename = $ar['commercialtaxDetails']->guest_code.'_commercial_invoice_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.commercialinvoicesettings.commercialinvoicereceipt',$ar);
        return $pdf->download($filename);
        echo "<pre>";print_r($data);exit; 

    }

    public function receiptInvoice($data){
        // echo "<pre>";print_r($data);exit; 

        $id = base64_decode($data['id']);;
        $ar['commercialtaxDetails'] = CommercialTaxDetails::find($id);
        $ar['commercialtaxsettings'] = CommercialTax::find($ar['commercialtaxDetails']->commercial_row_id);
        $ar['commercialtaxInvoiceItems'] = DB::table('tbl_customers_commercial_tax_invoice_items')->where('tax_detail_id',$id)->get();
        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $filename = $ar['taxDetails']->guest_code.'_invoice_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.invoicesettings.invoicereceipt',$ar);
        return $pdf->download($filename);
        echo "<pre>";print_r($data);exit; 

    }

    public function generateCommercialInvoiceReceipt($data)
    { 
        $id = base64_decode($data['id']);
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        
        $customer = Customers::find($id);
        $taxInvoiceDetails = DB::table('tbl_customers_commercial_tax_invoice_details')->where('customer_id',$id)->first();
        $paymentmethods = PaymentMethod::select('id','title')->where('created_by', Auth::user()->id)->where('deleted_at',null)->get();
        // echo "<pre>";print_r($taxInvoiceDetails);exit; 
        
        $receiptsettings = ReceiptSettings::where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        return view('dashboard.commercialreceiptsettings.invoicereceipt', ['receiptsettings'=>$receiptsettings,'customer'=>$customer,'taxInvoiceDetails' => $taxInvoiceDetails,'paymentmethods' =>$paymentmethods]);
    }


    public function downloadCommercialCollectionReport(Request $request){
        $data = $request->all();

        $collectionReportq = DB::table('tbl_customers_commercial_tax_invoice_details as tid');
        $collectionReportq->select('pr.name as property_name','tid.customer_id as id','tid.guest_name','tid.invoice_no','ti.receipt_date','ti.amount as total_amt','pm.title as payment_type')
        ->join('tbl_customer_commercial_invoice_receipts as ti','ti.customer_id','=','tid.customer_id','left')
        ->join('payment_methods as pm','pm.id','=','ti.payment_method_id','left')
        ->join('properties as pr','pr.id','=','tid.property_id','left')
        ->where('tid.property_id',$data['property_id']);
        if($data['payment_method_id'] != 'all'){
            $collectionReportq->where('ti.payment_method_id',$data['payment_method_id']);
            $paymentmethod = PaymentMethod::find($data['payment_method_id']);
            $payment_type_selected= $paymentmethod->title;
        } else {
            $payment_type_selected = 'All Payment Types';
        }
        
        
        // ->where('ti.payment_method_id',$data['payment_method_id'])
        $collectionReportq->where('ti.receipt_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $collectionReportRes = $collectionReportq->get();

        $newdata =  array();
        $propname = '';
        if(!empty($collectionReportRes)){
            foreach($collectionReportRes as $collect){
                $propname  = $collect->property_name;
                $payment_type  = $collect->payment_type;
                $newdata[] = $collect;
            }
        }
       
        $ar['propname'] = $propname;
        $ar['payment_type'] = $payment_type_selected;
        $ar['collection_report'] = $newdata;
        $ar['month'] = date("F", mktime(0, 0, 0, $data['month'], 10));

        // echo "<pre>";print_r($ar['invoices']);exit;
        $filename = 'Commercial_Collection_Report_of_'.$propname.'_for_'.$ar['month'].'_in_'.$payment_type_selected.'_2024_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.reports.commercial_collection_report_pdf',$ar);
        return $pdf->download($filename);
    }


    public function downloadCommercialCollectionSummaryReport(Request $request){
        $data = $request->all();
        

        $collectionSummaryReportq = DB::table('tbl_customers_commercial_tax_invoice_details as tid');
        $collectionSummaryReportq->select('pr.name as property_name','pm.title as payment_type','ti.amount as total_amt')
        ->join('tbl_customer_commercial_invoice_receipts as ti','ti.customer_id','=','tid.customer_id','left')
        ->join('payment_methods as pm','pm.id','=','ti.payment_method_id','left')
        ->join('properties as pr','pr.id','=','tid.property_id','left')
        ->where('tid.property_id',$data['property_id']);
        if($data['payment_method_id'] != 'all'){
            $collectionSummaryReportq->where('ti.payment_method_id',$data['payment_method_id']);
            $paymentmethod = PaymentMethod::find($data['payment_method_id']);
            $payment_type_selected= $paymentmethod->title;
        } else {
            $payment_type_selected = 'All Payment Types';
        }
        
        // ->where('ti.payment_method_id',$data['payment_method_id'])
        $collectionSummaryReportq->where('ti.receipt_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $collectionSummaryReportRes = $collectionSummaryReportq->get();

        $newdata =  array();
        $propname = '';
        if(!empty($collectionSummaryReportRes)){
            foreach($collectionSummaryReportRes as $collect){
                $propname  = $collect->property_name;
                $payment_type  = $collect->payment_type;
                $newdata[] = $collect;
            }
        }
      
        $ar['propname'] = $propname;
        $ar['payment_type'] = $payment_type_selected;
        $ar['collection_summary_report'] = $newdata;
        $ar['month'] = date("F", mktime(0, 0, 0, $data['month'], 10));

        // echo "<pre>";print_r($ar['invoices']);exit;
        $filename = 'Commercial_Collection_Summary_Report_of_'.$propname.'_for_'.$ar['month'].'_in_'.$payment_type_selected.'_2024_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.reports.commercial_collection_summary_report_pdf',$ar);
        return $pdf->download($filename);
    }


}
?>