<?php

namespace App\Http\Controllers;

use App\Models\CommercialReceiptSettings;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\Properties;
use App\Models\Customers;
use App\Models\CommercialInvoiceReceipt;
use App\Models\PaymentMethod;
use File;
use PDF;
use DataTables;

class CommercialReceiptSettingsController extends Controller
{
    public function index(Request $request){
        $datas = $request->all();
        $main_id = Auth::user()->id;
        $dataq = DB::table('commercial_receipt_settings as rs')->select('rs.id','rs.title','pr.name');
        $dataq->join('properties as pr','pr.id','=','rs.property_id','left');
        $data = $dataq->orderBy('rs.id','desc')->where('rs.created_by',$main_id)->get();
        // echo "<pre>";print_r($data);exit;
        
        if ($request->ajax()) {
            $action =  '<a href="/commercialreceiptsettings/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';
           return Datatables::of($data)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.commercialreceiptsettings.commercialreceiptsettingsList');
    }

    public function create()
    {
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();  
        return view('dashboard.commercialreceiptsettings.create',['properties'=>$properties]);
    }

    
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'property_id'          => 'required',
            'title'   => 'required',
        ]);

        $data = $request->all();
        // echo "<pre>";print_r($data);exit; 

        //for tax header
        if ($request->hasFile('header_logo')) {

            $headerfilenameWithExt = $request->file('header_logo')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('header_logo')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'receipt_header_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('header_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_receipt_settings', $headerfileNameToStore);    
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }

        //for tax footer
        if ($request->hasFile('footer_logo')) {

            $footerfilenameWithExt = $request->file('footer_logo')->getClientOriginalName ();
            // Get Filename
            $footerfilename = pathinfo($footerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $footerextension = $request->file('footer_logo')->getClientOriginalExtension();
            // Filename To store
            $footerfileNameToStore = 'receipt_footer_'.$footerfilename. '_'. time().'.'.$footerextension;
            // Upload Image$path = 
            $footerimg = $request->file('footer_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_receipt_settings', $footerfileNameToStore);    
        } else {
            $footerfileNameToStore = '';
            $footerimg = '';
        }

        $checksetting = CommercialReceiptSettings::where('property_id',$request->input('property_id'))->first();
        if(!$checksetting){
            $record = new CommercialReceiptSettings();
        } else {
            $record = CommercialReceiptSettings::find($checksetting->id);
        }
        //insert new criminal record
        
        $record->property_id      = $request->input('property_id');
        $record->title    =  $request->input('title');
        $record->footer_text_1    = $request->input('footer_text_1');
        $record->footer_text_2    = $request->input('footer_text_2');
        $record->header_logo   =  $headerfileNameToStore; 
        $record->footer_logo   =  $footerfileNameToStore; 
        $record->created_by     = Auth::user()->id;

        $record->save();
        $seq = 0;
        //echo "<pre>";print_r($tax_detail_id);exit; 

        $request->session()->flash('message', 'Record Created Successfully.');
        return redirect()->route('commercialreceiptsettings.index');
    }

    //for editing criminal record
    public function edit($id)
    {
        $receipt = CommercialReceiptSettings::find($id);
        $curr_year = date('Y');
        $main_id = Auth::user()->id ;
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();    
        $baseUrl = url('/');
        // $visitor->visitor_image = $baseUrl.'/public/storage/uploads/visitors/'. $visitor->visitor_image;
        return view('dashboard.commercialreceiptsettings.edit', [ 'receipt' => $receipt,'properties' => $properties,'curr_year'=> $curr_year]);
    }
    
 /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'property_id'          => 'required',
            'title'   => 'required',
        ]);

         // create or update file in directory if exists 
         $path = public_path('storage/uploads/hotel_admins/'.Auth::user()->id.'/commercial_receipt_settings');
         if(!File::isDirectory($path)){
             File::makeDirectory($path, 0777, true, true);
         }
         
        //get requested rcord id
        $record = CommercialReceiptSettings::find($id);
        $data = $request->all();
        //for tax header
        if ($request->hasFile('header_logo')) {

            $headerfilenameWithExt = $request->file('header_logo')->getClientOriginalName ();
            // Get Filename
            $headerfilename = pathinfo($headerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $headerextension = $request->file('header_logo')->getClientOriginalExtension();
            // Filename To store
            $headerfileNameToStore = 'receipt_header_'.$headerfilename. '_'. time().'.'.$headerextension;
            // Upload Image$path = 
            $headerimg = $request->file('header_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_receipt_settings', $headerfileNameToStore);    
        } else {
            $headerfileNameToStore = '';
            $headerimg = '';
        }

        //for tax footer
        if ($request->hasFile('footer_logo')) {

            $footerfilenameWithExt = $request->file('footer_logo')->getClientOriginalName ();
            // Get Filename
            $footerfilename = pathinfo($footerfilenameWithExt, PATHINFO_FILENAME);
            // Get just Extension
            $footerextension = $request->file('footer_logo')->getClientOriginalExtension();
            // Filename To store
            $footerfileNameToStore = 'receipt_footer_'.$footerfilename. '_'. time().'.'.$footerextension;
            // Upload Image$path = 
            $footerimg = $request->file('footer_logo')->storeAs('public/uploads/hotel_admins/'.Auth::user()->id.'/commercial_receipt_settings', $footerfileNameToStore);    
        } else {
            $footerfileNameToStore = '';
            $footerimg = '';
        }

        $record->property_id      = $request->input('property_id');
        $record->title    = $request->input('title');
        $record->footer_text_1    = $request->input('footer_text_1');
        $record->footer_text_2    = $request->input('footer_text_2');
        $record->header_logo   =  $headerfileNameToStore; 
        $record->footer_logo   =  $footerfileNameToStore; 
        $record->updated_by     = Auth::user()->id;
        $record->save();

        $request->session()->flash('message', 'Record Updated Successfully');
        return redirect()->route('commercialreceiptsettings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $record = CommercialReceiptSettings::find($id);
        if($record){
            $record->delete();
        }
        return redirect()->route('commercialreceiptsettings.index');
    }

    public function show(Request $request)
    {   
       $data = $request->all();
       if(array_key_exists('is_commercial_collection_report',$data) == true){
            return  $this->getCommercialCollectionReports($data);
        }
        if(array_key_exists('is_commercial_collection_summary_report',$data) == true){
            return  $this->getCommercialCollectionSummaryReports($data);
        }
    }

    public function commercial_invoice_receipt(Request $request)
    {   
        ini_set('max_execution_time', 180); //3 minutes
        $data = $request->all();

        $customer = Customers::find($data['customer_id']);

        $checkreceipt = CommercialInvoiceReceipt::where('customer_id',$data['customer_id'])->first();
        
        if(!$checkreceipt){
            $record = new CommercialInvoiceReceipt();

            $checklastreceiptno = CommercialInvoiceReceipt::where('deleted_at',null)->orderBy('id','DESC')->first();
            if(!$checklastreceiptno){
                $latest_receipt_no = date('Y').'-00001';
            } else {
                $curr_reciept_no_ar = explode('-',$checklastreceiptno->receipt_no);
                $latest_receipt_no_suffix = $curr_reciept_no_ar[1] + 1;
                $latest_receipt_no = date('Y').'-'.$latest_receipt_no_suffix;
            }

        } else {
            $record = CommercialInvoiceReceipt::find($checkreceipt->id);
            $latest_receipt_no = $record->receipt_no;
        }

        $checksetting = CommercialReceiptSettings::where('property_id',$customer->property_id)->first();
        //  echo "<pre>HERE: ";print_r($latest_receipt_no);exit;
        $record->commercial_receipt_setting_id = $checksetting->id;

        $record->customer_id = $data['customer_id'];
        $record->receipt_no = $latest_receipt_no;
        $record->property_id = $customer->property_id;
        $record->receipt_date = $data['date'];
        $record->amount = $data['amount'];
        $record->payment_method_id = $data['payment_method_id'];
        $record->is_close = $data['is_close'];
        $record->remark = $data['remark'];
        $record->created_by     = Auth::user()->id;
        // echo "<pre>";print_r($record);exit; 
        $record->save();

        $ar['receipt_settings'] = $checksetting;
        $ar['receipt_data'] = $data;
        $ar['receipt_no'] = $latest_receipt_no;

        $payment_type = PaymentMethod::find($data['payment_method_id']);
        $ar['payment_type'] = $payment_type;

        $filename = 'commercial_receipt_'.date('Ymdhis').'.pdf';
        // echo $filename;exit;
        $pdf = PDF::loadView('dashboard.commercialreceiptsettings.receipt',$ar);
        return $pdf->download($filename);
    }
    

    public function getCommercialCollectionReports($data){
        // echo "<pre>HERE: ";print_r($data);exit;

        $collectionReportq = DB::table('tbl_customers_commercial_tax_invoice_details as tid');
        $collectionReportq->select('tid.invoice_no','ti.receipt_date','ti.amount as total_amt','pm.title as payment_type')
        ->join('tbl_customer_commercial_invoice_receipts as ti','ti.customer_id','=','tid.customer_id','left')
        ->join('payment_methods as pm','pm.id','=','ti.payment_method_id','left')
        ->where('tid.property_id',$data['property_id']);
          if($data['payment_method_id'] != 'all'){
            $collectionReportq->where('ti.payment_method_id',$data['payment_method_id']);
        }
        // ->where('ti.payment_method_id',$data['payment_method_id'])
        $collectionReportq->where('ti.receipt_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $collectionReportRes = $collectionReportq->get();
        foreach($collectionReportRes as $collect){
            $collect->total_amt = number_format((float)$collect->total_amt, 2, '.', '');;
        }
        return Datatables::of($collectionReportRes)
            // ->addColumn('action', $action)
            // ->rawColumns(['action'])
            ->make(true);
        return $collectionReportRes;
    }

    public function getCommercialCollectionSummaryReports($data){
        // echo "<pre>HERE: ";print_r($data);exit;

        $collectionSummaryReportq = DB::table('tbl_customers_commercial_tax_invoice_details as tid');
        $collectionSummaryReportq->select('pm.title as payment_type','ti.amount as total_amt')
        ->join('tbl_customer_commercial_invoice_receipts as ti','ti.customer_id','=','tid.customer_id','left')
        ->join('payment_methods as pm','pm.id','=','ti.payment_method_id','left')
        ->where('tid.property_id',$data['property_id']);
        if($data['payment_method_id'] != 'all'){
            $collectionSummaryReportq->where('ti.payment_method_id',$data['payment_method_id']);
        }
        // ->where('ti.payment_method_id',$data['payment_method_id'])
        $collectionSummaryReportq->where('ti.receipt_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $collectionSummaryReportRes = $collectionSummaryReportq->get();
        foreach($collectionSummaryReportRes as $collect){
            $collect->total_amt = number_format((float)$collect->total_amt, 2, '.', '');;
        }
        return Datatables::of($collectionSummaryReportRes)
            // ->addColumn('action', $action)
            // ->rawColumns(['action'])
            ->make(true);
        return $collectionSummaryReportRes;
    }

    
    
}
