<?php 
namespace App\Http\Controllers;

use App\Models\Chat;
use App\Models\Customers;
use App\Models\HotelAdmin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Events\NewChatMessage;
use Illuminate\Support\Facades\Storage;
use Google\Client as GoogleClient;
use DB;

class ChatController extends Controller
{
    //send msg
    public function send(Request $request)
    {
        $data = $request->validate([
            'property_id' => 'required|integer',
            'sender_id' => 'required|integer',
            'receiver_id' => 'required|integer',
            'sender_type' => 'required|in:admin,guest',
            'message' => 'required|string',
        ]);
        
        //for android end validation
        $data = $request->all();
        if(array_key_exists('access_token',$data)){
            $getRoomInfo = DB::table('rooms')->where('id',$data['room_id'])->get()->first();
            if(!empty($getRoomInfo)){
                if($data['access_token'] != $getRoomInfo->access_token){
                           return response()->json(["status"=> "false",'msg'=>"Logged Out"]);
                 }
            }
        }
      
        $chat = Chat::create($data);
        broadcast(new NewChatMessage($chat))->toOthers();
        
        $custid = 0;
        $roomid = 0;
        if(array_key_exists('access_token',$data) == false){
            $custid = $data['receiver_id'];
            $custinfo = DB::table('customers')->select('room_id')->where('id',$custid)->get()->first();
            $title = "New Chat";
            $body = $data['message'];
            self::sendNotification($custinfo->room_id,$title,$body);
        }
       
        return response()->json(['success' => true]);
    }

    public function getunreadcnt(Request $request)
    {
        $hotelAdmin_id = HotelAdmin::where('main_user_id', Auth::user()->id)->first();
        
        
    
        $propertyIds = DB::table('properties')
            ->where('owner', $hotelAdmin_id->id)
            ->whereNull('deleted_at')
            ->pluck('id');
    
        $customerIds = Customers::whereIn('property_id', $propertyIds)
            ->whereNull('checkout_date_time')
            ->whereNull('deleted_at')
            ->pluck('id');
    
        $admin_id = Auth::user()->id;
    
        // ingle optimized query to count all unread messages
        $total_unread_cnt = Chat::where(function ($query) use ($admin_id, $customerIds) {
                $query->whereIn('sender_id', $customerIds)
                      ->where('receiver_id', $admin_id);
            })
            ->where('is_read', 0)
            ->count();
    
        return response()->json(['total_unread_count' => $total_unread_cnt]);
    }
        
    //get chat history
    public function history(Request $request)
    {
        $request->validate([
            'property_id' => 'required|integer',
            'user1' => 'required|integer',
            'user2' => 'required|integer'
        ]);
        
        //for android end validation
        $data = $request->all();
        if(array_key_exists('access_token',$data)){
            $getRoomInfo = DB::table('rooms')->where('id',$data['room_id'])->get()->first();
            if(!empty($getRoomInfo)){
                if($data['access_token'] != $getRoomInfo->access_token){
                    return response()->json(["status"=> "false",'msg'=>"Logged Out"]);
                }
            }
        }
        
        $chats = Chat::select('id','sender_type','message','created_at')->where('property_id', $request->property_id)->whereNull('deleted_at')
            ->where(function ($q) use ($request) {
                $q->where('sender_id', $request->user1)->where('receiver_id', $request->user2);
            })->orWhere(function ($q) use ($request) {
                $q->where('sender_id', $request->user2)->where('receiver_id', $request->user1);
            })
            ->orderBy('created_at')
            ->get();
            
        $chatIds = $chats->pluck('id')->toArray();

        return response()->json(['chats' => $chats]);
    }

    public function updateReadStatus(Request $request){
         $hotelAdmin_id = HotelAdmin::where('main_user_id', Auth::user()->id)->first();
    
        $propertyIds = DB::table('properties')
            ->where('owner', $hotelAdmin_id->id)
            ->whereNull('deleted_at')
            ->pluck('id');
            
        $customerIds = Customers::whereIn('property_id', $propertyIds)
            ->whereNull('checkout_date_time')
            ->whereNull('deleted_at')
            ->pluck('id');
    
        $admin_id = Auth::user()->id;
    
 // 
    $chats = Chat::select('id', 'sender_type', 'message', 'created_at')
        ->where(function ($query) use ($admin_id, $customerIds) {
            $query->where(function ($q) use ($admin_id, $customerIds) {
                $q->whereIn('sender_id', $customerIds)
                  ->where('receiver_id', $admin_id);
            })->orWhere(function ($q) use ($admin_id, $customerIds) {
                $q->where('sender_id', $admin_id)
                  ->whereIn('receiver_id', $customerIds);
            });
        })
        ->where('is_read', 0)
        ->whereNull('deleted_at')
        ->orderBy('created_at')
        ->get();
            
        $chatIds = $chats->pluck('id')->toArray();

        if (!empty($chatIds)) {
            DB::table('chats')
                ->whereIn('id', $chatIds)
                ->update(['is_read' => 1]);
        }
        return response()->json(['data' => true]);
    }
 
    //get guest by property
    // public function getCustomersByProperty($property_id){
        
    //     $admin_id =  Auth::user()->id;
    //     $customers = Customers::where('property_id', $property_id)
    //     ->orderBy('id', 'desc')
    //     ->get(['id', 'first_name', 'last_name','guest_code']);
      
    //     $customerList = $customers->map(function ($customer) {
    //         $admin_id = Auth::user()->id;

    //         $unreadCount = Chat::where(function ($query) use ($admin_id, $customer) {
    //             $query->where(function ($q) use ($admin_id, $customer) {
    //                 $q->where('sender_id', $admin_id)
    //                   ->where('receiver_id', $customer->id);
    //             })->orWhere(function ($q) use ($admin_id, $customer) {
    //                 $q->where('sender_id', $customer->id)
    //                   ->where('receiver_id', $admin_id);
    //             });
    //         })
    //     ->where('is_read', 0)
        
    //     ->count();
    //         return [
    //             'id' => $customer->id,
    //             'full_name' => $customer->first_name.' '.$customer->last_name.'('.$customer->guest_code.')',
    //             'unread_count' => $unreadCount,
    //         ];
    //     });
    //     return response()->json(['customers' => $customerList]);
    // }


// public function getCustomersByProperty($property_id)
// {
//     $admin_id = Auth::id();

//     // Step 1: Get latest chat IDs per customer (between admin & customer only)
//     $latestChatIds = DB::table('chats')
//         ->where('property_id', $property_id)
//         ->where(function ($query) use ($admin_id) {
//             $query->where('sender_id', $admin_id)
//                   ->orWhere('receiver_id', $admin_id);
//         })
//         ->select(DB::raw('MAX(id) as id'))
//         ->groupBy(DB::raw('CASE WHEN sender_id = ' . $admin_id . ' THEN receiver_id ELSE sender_id END'))
//         ->pluck('id');

//     // Step 2: Get latest chats with customer info
//     // $latestChats = DB::table('chats')
//     //     ->whereIn('id', $latestChatIds)
//     //     ->get();
        
//         $latestChats = DB::table('chats')
//     ->whereIn('id', $latestChatIds)
//     ->orderByDesc('created_at') // or ->orderByDesc('created_at') if available
//     ->get();

//     $customerList = [];

//     foreach ($latestChats as $chat) {
//         // Determine who is the guest (not admin)
//         $guest_id = $chat->sender_id == $admin_id ? $chat->receiver_id : $chat->sender_id;

//         // Fetch guest info from customers table
//         $customer = DB::table('customers')
//             ->where('id', $guest_id)
//             ->where('property_id', $property_id)
//             ->first();

//         if ($customer) {
//             // Count unread messages from guest to admin
//             $unreadCount = DB::table('chats')
//                 ->where('sender_id', $guest_id)
//                 ->where('receiver_id', $admin_id)
//                 ->where('is_read', 0)
//                 ->count();

//             $customerList[] = [
//                 'id' => $customer->id,
//                 'full_name' => $customer->first_name . ' ' . $customer->last_name . ' (' . $customer->guest_code . ')',
//                 'unread_count' => $unreadCount,
//                 'last_chat_id' => $chat->id,
//             ];
//         }
//     }

//     return response()->json(['customers' => $customerList]);
// }

public function getCustomersByProperty($property_id)
{
    $admin_id = Auth::id();

    // Step 1: Get all customers for the property
    $customers = DB::table('customers')
        ->where('property_id', $property_id)
        ->get();

    $customerList = [];

    foreach ($customers as $customer) {
        // Step 2: Get latest chat between this customer and the admin
        $latestChat = DB::table('chats')
            ->where('property_id', $property_id)
            ->where(function ($query) use ($admin_id, $customer) {
                $query->where(function ($q) use ($admin_id, $customer) {
                    $q->where('sender_id', $admin_id)
                      ->where('receiver_id', $customer->id);
                })->orWhere(function ($q) use ($admin_id, $customer) {
                    $q->where('sender_id', $customer->id)
                      ->where('receiver_id', $admin_id);
                });
            })
            ->orderByDesc('created_at')
            ->first();

        // Count unread messages from customer to admin
        $unreadCount = DB::table('chats')
            ->where('sender_id', $customer->id)
            ->where('receiver_id', $admin_id)
            ->where('is_read', 0)
            ->count();

        $customerList[] = [
            'id' => $customer->id,
            'full_name' => $customer->first_name . ' ' . $customer->last_name . ' (' . $customer->guest_code . ')',
            'unread_count' => $unreadCount,
            'last_chat_id' => $latestChat ? $latestChat->id : null,
            'last_chat_time' => $latestChat ? $latestChat->created_at : null,
        ];
    }

    // Step 3: Sort the array — customers with chats first, then without
    usort($customerList, function ($a, $b) {
        if ($a['last_chat_time'] && !$b['last_chat_time']) return -1;
        if (!$a['last_chat_time'] && $b['last_chat_time']) return 1;
        if ($a['last_chat_time'] == $b['last_chat_time']) return 0;
        return strtotime($b['last_chat_time']) - strtotime($a['last_chat_time']);
    });

    return response()->json(['customers' => $customerList]);
}


    //get msgs
    public function getMessages(Request $request)
    {
        $admin_id = auth()->id(); // or fixed value for now if not authenticated

        $hotelAdmin = HotelAdmin::where('main_user_id', $admin_id)->first();

        if (!$hotelAdmin) {
            return response()->json(['error' => 'Hotel Admin not found'], 404);
        }

        $adminDbId = $hotelAdmin->id;
        $customerId = $request->input('customer_id');
        $propertyId = $request->input('property_id');

        $messages = Chat::where('property_id', $propertyId)
            ->where(function ($query) use ($adminDbId, $customerId) {
                $query->where(function ($q) use ($adminDbId, $customerId) {
                    $q->where('sender_id', $adminDbId)
                    ->where('receiver_id', $customerId)
                    ->where('sender_type', 'admin')
                    ->where('receiver_type', 'guest');
                })
                ->orWhere(function ($q) use ($adminDbId, $customerId) {
                    $q->where('sender_id', $customerId)
                    ->where('receiver_id', $adminDbId)
                    ->where('sender_type', 'guest')
                    ->where('receiver_type', 'admin');
                });
            })
            ->orderBy('created_at', 'asc')
            ->get();

      
        return response()->json(['messages' => $messages]);
    }
    
     public static function sendNotification($room_id,$title,$body)
    {
        $url = 'https://fcm.googleapis.com/v1/projects/hotel-call-938c4/messages:send';

        $credentialsFilePath = Storage::path('json/hotel-call-938c4-firebase-adminsdk-fbsvc-32eb89ecac.json');
        $client = new GoogleClient();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->refreshTokenWithAssertion();
        $token = $client->getAccessToken();
		$access_token = $token['access_token'];

        $notify = array('title'=>$title,'body'=>$body);

        //check notificaion log for duplicates
        $file_data = '';
        $file_data .="\n-------------\n";
        $file_data .="\Notified at \n".date('Y-m-d H:i:s');
        $file_data .="\n-------------\n";
        Storage::disk('local')->append('notification_check.txt', $file_data);    
        $firebaseToken = DB::table('rooms')->select('device_token')->where('id',$room_id)->first();
        $data = [
            "message" => [
                "token" => $firebaseToken->device_token,
                "notification" =>$notify,
                'data' =>array(
                    'title'=>$title,
                    'body'=>$body,
                    "room_id"=>(string) $room_id,
                    "timestamp"=>date('Y-m-d H:i s'),
                    "mutable-content"=>"1",
                    'subtitle' => 'new_chat'
                ),
            ]
        ];

        $headers = [
            "Authorization: Bearer $access_token",
            'Content-Type: application/json'
        ];
 
        // $url = 'https://fcm.googleapis.com/fcm/send';
        $ch = curl_init($url);
        curl_setopt_array($ch, array(
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_TIMEOUT => 60
        ));
        $result = curl_exec($ch);
        $responseData = json_decode($result, true);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        // echo "<pre>";print_r( json_encode($data));exit;
        $error = curl_error($ch);
        //  echo "<pre>HERE ";print_r( $responseData);exit;
        curl_close($ch);
       
        return 1;
    }
}
?>
