<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use App\Models\HotelAdmin;
use App\Models\IdProofTypes;
use App\Models\BlackLists;
use App\Models\Country;
use App\Models\Properties;
use App\Models\ComplaintTypes;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use DataTables;

class BlackListsController extends Controller
{
    public function index(Request $request){
        $main_id = Auth::user()->id;

        if ($request->ajax()) {
            $data = BlackLists::select('id','name','passport_no','date_of_birth','nationality')->where('created_by',Auth::user()->id)->orderBy('id','desc')->get();
            foreach($data as $blacklist){
                $id = $blacklist->id;
            }
            $action =  '<a href="/blacklists/{{$id}}/edit" style="width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>  <button style="padding: 0;border: none;background: none;" class="delete" data-toggle="modal" data-target="#dangerModal"  data-record-id={{$id}} data-toggle="tooltip" data-placement="top" title="Delete" >@csrf<i class="fa fa-trash" style="font-size: 20px;margin-left: 9px;"></i></button>';

            return Datatables::of($data)
                ->addColumn('action',$action) 
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('dashboard.blacklists.blacklistsList');
    }

     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $statuses = Status::all();
        $complaint_types = ComplaintTypes::all();
        $properties = Properties::where('status_id','1')->where('created_by',Auth::user()->id)->get();    
        $countries = Country::all(); 
        return view('dashboard.blacklists.create', ['complaint_types' => $complaint_types,'countries'=>$countries,'properties'=>$properties]);
    }

   /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name'      => 'required|min:1|max:64',
            'passport_no'       => 'required',
            'date_of_birth'       => 'required',
            'nationality'       => 'required',
            'property_id'       => 'required',
        ]);

        //check complaint exists for this name,dob,passport no and nationality
                     
        //insert new type
        $blacklist = new BlackLists();
        $blacklist->name    = $request->input('name');
        $blacklist->passport_no    = $request->input('passport_no');
        $blacklist->date_of_birth    = $request->input('date_of_birth');
        $blacklist->nationality    = $request->input('nationality');
        $blacklist->property_id    = $request->input('property_id');
        $blacklist->reason =  $request->input('reason');
        $blacklist->block_status =  $request->input('block_status');
        $blacklist->complaint_type  =  $request->input('complaint_type');
        $blacklist->severity =  $request->input('severity');
        $blacklist->share_to_other_hotel_status  =  $request->input('share_to_other_hotel_status');
        $blacklist->action_taken	   =  $request->input('action_taken');
        $blacklist->created_by   = Auth::user()->id;
        $blacklist->save();

        $request->session()->flash('message', 'Blacklist Created Successfully.');
        return redirect()->route('blacklists.index');
    }

    //for editing hotel admin
    public function edit($id)
    {
        $blacklist = BlackLists::find($id);
        $properties = Properties::where('status_id','1')->where('created_by',Auth::user()->id)->get();      
        $complaint_types = ComplaintTypes::all();
        $countries = Country::all(); 
        return view('dashboard.blacklists.edit', [ 'blacklist' => $blacklist,'complaint_types' => $complaint_types ,'countries'=>$countries,'properties'=>$properties]);
    }

   /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name'      => 'required|min:1|max:64',
            'passport_no'       => 'required',
            'date_of_birth'       => 'required',
            'nationality'       => 'required',
            'property_id'       => 'required',
        ]);

        //insert new type
        $blacklist = BlackLists::find($id);
        $blacklist->name    = $request->input('name');
        $blacklist->passport_no    = $request->input('passport_no');
        $blacklist->date_of_birth    = $request->input('date_of_birth');
        $blacklist->nationality    = $request->input('nationality');
        $blacklist->property_id    = $request->input('property_id');
        $blacklist->reason =  $request->input('reason');
        $blacklist->block_status =  $request->input('block_status');
        $blacklist->complaint_type  =  $request->input('complaint_type');
        $blacklist->severity =  $request->input('severity');
        $blacklist->share_to_other_hotel_status  =  $request->input('share_to_other_hotel_status');
        $blacklist->action_taken	   =  $request->input('action_taken');
        $blacklist->save();
   
        $request->session()->flash('message', 'Blacklist Updated Successfully');
        return redirect()->route('blacklists.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = $request->all();
        $id = $data['id'];
        $blacklist = BlackLists::find($id);
        if($blacklist){
            $blacklist->delete();
        }
        return redirect()->route('blacklists.index');
    }

    
}


 