<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Api;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class ApiController extends Controller
{
    //for hotel admin and hotel admin staff login
    public function hotelAdminLogin(Request $request){
        // $request = $request->all();
        $username = $request->input('username');
        $password = $request->input('password');
        $headers = apache_request_headers();
        //   // $headers = $getHeaders['auth_key'];;
        //$headers =$_SERVER;
        //$headers =$this->input->get_request_header('auth_key');;
        // print_r($headers);exit;
        $check_auth_key = $this->checkSecurityKey($headers);
        // print_r($check_auth_key);exit;
        // return error if auth key doesn not match  
        if(!$check_auth_key){
           $error_info = Api::getErrorCode('101');
           return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //get hotel admin
        $getHotelAdminUser = Api::getUserForLogin($username,$password);
        
        if($getHotelAdminUser){
            return response()->json(["status"=> "true",'data'=>$getHotelAdminUser]);
        } else {
            $error_info = Api::getErrorCode('102');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

  //for customers list 
    public function getCustomers(Request $request){ 
        $request = $request->all();
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);
    
        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //check if have privilege for view customers 
        if($request['is_staff']){ //if its staff
            $module_name = 'Customers';
            $getViewPrivilege = Api::getPrivileges($request['group_id'],$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->view == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //get hotel admin
        $getCustomersList = Api::getCustomersList($request);
         
        if($getCustomersList){
            return response()->json(["status"=> "true",'data'=>$getCustomersList]);
        } else {
         $error_info = Api::getErrorCode('103');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    //get requested custmer details
    public function getCustomersDetails(Request $request){
        $headers = apache_request_headers(); 
        $check_auth_key = $this->checkSecurityKey($headers);
        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }
        
        //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'Customers';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->view == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }
        

        //get hotel admin
        $getCustomersDetails = Api::getCustomersDetails($request->customer_id);
         
        if($getCustomersDetails){
            return response()->json(["status"=> "true",'data'=>$getCustomersDetails]);
        } else {
         $error_info = Api::getErrorCode('104');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    
    //get all rooms under logged in hotel admin
    public function getRooms(Request $request){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'Rooms';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->view == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //getrooms
        $getRooms = Api::getRooms($request);
        
        if($getRooms){
            return response()->json(["status"=> "true",'data'=>$getRooms]);
        } else {
        $error_info = Api::getErrorCode('105');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    
    //get all document types list
    public function getDocTypes(Request $request){
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'ID Proof Type';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->view == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //getrooms
        $getDocTypes = Api::getAllDocTypes($request);
        
        if($getDocTypes){
            return response()->json(["status"=> "true",'data'=>$getDocTypes]);
        } else {
        $error_info = Api::getErrorCode('106');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //get all document types list
    public function getAllProperties(Request $request){
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'Properties';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->view == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //getrooms
        $getAllProperties = Api::getAllProperties($request);
        
        if($getAllProperties){
            return response()->json(["status"=> "true",'data'=>$getAllProperties]);
        } else {
        $error_info = Api::getErrorCode('107');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //get all document types list
    public function getProperty(Request $request,$id){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'Properties';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->view == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //getrooms
        $getProperty = Api::getProperty($id);
        
        if($getProperty){
            return response()->json(["status"=> "true",'data'=>$getProperty]);
        } else {
        $error_info = Api::getErrorCode('107');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    
        //add customers
        public function addCustomer(Request $request){
            $headers = apache_request_headers();
            $check_auth_key = $this->checkSecurityKey($headers);
    
            // return error if auth key doesn not match  
            if(!$check_auth_key){
                $error_info = Api::getErrorCode('101');
                return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
            }
    
             //check if have privilege for view customers 
            if($request->is_staff){ //if its staff
                $module_name = 'Customers';
                $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
                if(!empty($getViewPrivilege)){
                    if($getViewPrivilege->add == ''){
                        $error_info = Api::getErrorCode('116');
                        return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                    }
                }
            }

            //add customer
            $updateCustomer = Api::addCustomer($request);
            
            if($updateCustomer){
                return response()->json(["status"=> "true","data" =>$updateCustomer]);
            } else {
            $error_info = Api::getErrorCode('108');
                return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
            }
        }

    //update customers
    public function updateCustomer(Request $request){ 
        //   switch($_SERVER['REQUEST_METHOD']){
        //     case 'PUT':
        $put_data = $request->all();
        
        $id = $put_data['customer_id'];
        // echo "<pre>";print_r($id);exit;
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'Customers';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->edit == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //add customer
        $updateCustomer = Api::updateCustomer($request,$id);
        
        if($updateCustomer){
            return response()->json(["status"=> "true","data" =>$updateCustomer]);
        } else {
        $error_info = Api::getErrorCode('109');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
        //  break;
        // }
    }

    //add customer document
    public function addCustomerDocument(Request $request){
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //add customer
        $addDocs = Api::addDocument($request);
        
        if($addDocs){
            return response()->json(["status"=> "true","data" =>$addDocs]);
        } else {
        $error_info = Api::getErrorCode('110');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //remove document of customer
    public function removeCustomerDocument(Request $request){
        // echo "<pre>";print_r($request->all());exit;
        $req_data = $request->all();
        $id = $req_data['document_id'];
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //remove customer docs
        $getDocs = Api::removeCustomerDocument($id);
        
        if($getDocs){
            return response()->json(["status"=> "true","message" =>'Document removed successfully']);
        } else {
        $error_info = Api::getErrorCode('111');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }


    //get all countries list
    public function getCountries(){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //get countries
        $getCountries = Api::getAllCountries();
        
        if($getCountries){
            return response()->json(["status"=> "true",'data'=>$getCountries]);
        } else {
        $error_info = Api::getErrorCode('112');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    

    
    //user profile update
    public function manageProfile(Request $request){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //upate profile
        $updateProfile = Api::updateMyProfile($request);
        
        if($updateProfile){
            return response()->json(["status"=> "true",'data'=>$updateProfile]);
        } else {
        $error_info = Api::getErrorCode('113');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    

    //for change password
    public function changePassword(Request $request){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //change pass
        $result = Api::changePassword($request);
        
        if($result){
            return response()->json($result);
        } else {
        $error_info = Api::getErrorCode('115');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    

    
    //validate auth key 
    public function checkSecurityKey($headers){
    
        $auth_key = \Config::get('constants.auth_key');
     // print_r($headers['Host']);exit;
       // $headers['Authorization'] = 'zJbxN6PeUFu6KLmLy1Wr';
        if($headers['Authorization']){
            if($headers['Authorization'] == $auth_key){
                return true;
            } else {
                return false;
            }
        } else { 
            return false;
        }
    }
    
        //get all assigned property list
    public function getAssignedProperties($id){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //get countries
        $getAssignedProperties = Api::getAssignedProperties($id);
        
        if($getAssignedProperties){
            return response()->json(["status"=> "true",'data'=>$getAssignedProperties]);
        } else {
        $error_info = Api::getErrorCode('117');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    
    //get all infor for customers
    public function getCustomerData(Request $request){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //get countries
        $data = Api::getCustomerData($request->all());
        
        if($data){
            return response()->json(["status"=> "true",'data'=>$data]);
        } else {
        $error_info = Api::getErrorCode('114');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    
    //get all infor for logged in user
    public function getAccountInfo(Request $request){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //get countries
        $data = Api::getAccountInfo($request->all());
        
        if($data){
            return response()->json(["status"=> "true",'data'=>$data]);
        } else {
        $error_info = Api::getErrorCode('114');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //get guest code
    public function getguestcode(Request $request){ 
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //get countries
        $data = Api::getguestcode($request->all());
        
        if($data){
            return response()->json(["status"=> "true",'data'=>$data]);
        } else {
        $error_info = Api::getErrorCode('114');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    
    }
    
    //add customers note
    public function addNote(Request $request){
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

         //check if have privilege for view customers 
        if($request->is_staff){ //if its staff
            $module_name = 'Customers';
            $getViewPrivilege = Api::getPrivileges($request->group_id,$module_name);
            if(!empty($getViewPrivilege)){
                if($getViewPrivilege->add == ''){
                    $error_info = Api::getErrorCode('116');
                    return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
                }
            }
        }

        //add note
        $addNote = Api::addNote($request);
        
        if($addNote){
            return response()->json(["status"=> "true","data" =>'Note added successfully...!']);
        } else {
            $error_info = Api::getErrorCode('108');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

        
    //get all booking types
    public function getBookingTypes(Request $request){ 
        // $headers = apache_request_headers();
        // $check_auth_key = $this->checkSecurityKey($headers);

        // // return error if auth key doesn not match  
        // if(!$check_auth_key){
        //     $error_info = Api::getErrorCode('101');
        //     return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        // }

        //get types
        $getBookingTypes = Api::getBookingTypes($request);
        
        if($getBookingTypes){
            return response()->json(["status"=> "true",'data'=>$getBookingTypes]);
        } else {
        $error_info = Api::getErrorCode('105');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }


        
    //add submitDigitalSign
    public function submitDigitalSign(Request $request){
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        if(!$check_auth_key){
            $error_info = Api::getErrorCode('101');
            return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        }

        //add note
        $addNote = Api::submitDigitalSign($request);
        
        if($addNote){
            return response()->json(["status"=> "true","data" =>'Sign Submitted successfully...!']);
        } else {
            $error_info = Api::getErrorCode('108');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
        
    //add visiyor
    public function addVisitor(Request $request){
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        // return error if auth key doesn not match  
        // if(!$check_auth_key){
        //     $error_info = Api::getErrorCode('101');
        //     return response()->json(["status"=> "false",'message'=>$error_info->message,'code'=>$error_info->code]);
        // }
        // echo "<pre>";print_r($request->file('visitor_image'));exit;
    
        //add note
        $addNote = Api::addVisitor($request);
        
        if($addNote){
            return response()->json(["status"=> "true","data" =>'Visitor added successfully...!']);
        } else {
            $error_info = Api::getErrorCode('108');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //get all visitors
    public function getVisitors(Request $request){ 
        //get types
        $getVisitors = Api::getVisitors($request);
        
        if($getVisitors){
            return response()->json(["status"=> "true",'data'=>$getVisitors]);
        } else {
        $error_info = Api::getErrorCode('105');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //update visitor
    public function updateVisitor(Request $request){ 
        $put_data = $request->all();
        
        $id = $put_data['visitor_id'];
        // echo "<pre>";print_r($id);exit;
        $headers = apache_request_headers();
        $check_auth_key = $this->checkSecurityKey($headers);

        //add customer
        $updateVisitor = Api::updateVisitor($request,$id);
        
        if($updateVisitor){
            return response()->json(["status"=> "true","data" =>$updateVisitor]);
        } else {
            $error_info = Api::getErrorCode('109');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
        
    //get all room call details
    public function getRoomCallInfo(Request $request){ 
        //get room call details
        $room_call_details = Api::getRoomCallInfo($request);
        // echo "<pre>";print_r($room_call_details);exit;
        if($room_call_details == 5){
            return response()->json(["status"=> "false",'msg'=>"Logged Out"]);
        }
        if(!empty($room_call_details)){
            return response()->json(["status"=> "true",'data'=>$room_call_details]);
        } else {
            return response()->json(["status"=> "false",'msg'=>'Checked Out']);
            // $error_info = Api::getErrorCode('105');
            // return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }

    //add room login
    public function roomLogin(Request $request){
        //add room login
        $roomlogin = Api::roomLogin($request);
        
        if(!empty($roomlogin)){
            return response()->json(["status"=> "true","data" => $roomlogin]);
        } else {
            $error_info = Api::getErrorCode('102');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
    
    //add room logout
    public function roomLogout(Request $request){
        //add room login
        $roomlogout = Api::roomLogout($request);
        
        if($roomlogout){
            return response()->json(["status"=> "true","data" => []]);
        } else {
            $error_info = Api::getErrorCode('102');
            return response()->json(["status"=> "false","message" =>$error_info->message,'code'=>$error_info->code]);
        }
    }
}
