<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\CriminalRecords;
use App\Models\Country;
use App\Models\HotelAdmin;
use App\Models\Visitors;
use App\Models\Properties;
use App\Models\Customers;
use App\Models\Tax;
use App\Models\TaxDetails;
use App\Models\PaymentMethod;
use App\Models\ReceiptSettings;
use App\Models\TaxInvoiceItems;
use App\Models\TaxSettingsItems;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use DataTables;
use File;
use PDF;


class TaxInvoiceListController extends Controller
{
    public function show(Request $request)
    {    
        $datas = $request->all();

        if(array_key_exists('is_get_cust',$datas) == true){
            return  $this->getInvoiceListByProperty($datas);
        }
        if(array_key_exists('is_download_invoice',$datas) == true){
            return  $this->downloadInvoicePdf($datas);
        }
        
        if(array_key_exists('is_edit',$datas) == true){
            return  $this->editInvoice($datas);
        }

        if(array_key_exists('is_invoice_receipt',$datas) == true){
            return  $this->generateInvoiceReceipt($datas);
        }
        
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        $properties = Properties::where('status_id','1')->where('owner',$hotelAdmin_id->id)->get();
        return view('dashboard.taxsettings.taxinvoicelist',['properties'=>$properties]);
    }
    
    public function getInvoiceListByProperty($data)
    {   
        $taxsettingsItemsq = DB::table('tbl_customers_tax_invoice_details as tid');
        if($data['curr'] == 'usd'){
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.exchange_rate','tid.total_sc_usd as total_sc','tid.total_at_usd as total_at','tid.total_vat_usd as total_vat','tid.total_amt_usd as total_amt');
        } else {
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.exchange_rate','tid.total_sc_kh as total_sc','tid.total_at_kh as total_at','tid.total_vat_kh as total_vat','tid.total_amt_kh as total_amt');
        }
        $taxsettingsItemsq->join('customers as cu','cu.id','=', 'tid.customer_id','left')
        ->join('tbl_tax_settings as tx','tx.property_id','=','cu.property_id','left')
        ->join('properties as pr','pr.id','=','tx.property_id','left')
        // ->where('cu.deleted_at',NULL)
        ->where('tx.property_id',$data['property_id'])
        ->where('tid.invoice_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $taxsettingsItems = $taxsettingsItemsq->get();
$cu = $data['curr'];
        foreach($taxsettingsItems as $inv){
            $inv->total_sc = number_format((float)$inv->total_sc, 2, '.', '');;
            $inv->total_at = number_format((float)$inv->total_at, 2, '.', '');;
            $inv->total_vat = number_format((float)$inv->total_vat, 2, '.', '');;
            $inv->total_amt = number_format((float)$inv->total_amt, 2, '.', '');;
        }
        $action = '<a href="{{ route("taxinvoicelist.editInvoice",["id"=>base64_encode($id),"is_edit"=>1]) }}"  style=" animation: flashing-style 0.6s linear infinite;width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Edit" ><i class="fa fa-edit" style="font-size: 20px;"></i></a>';
        // $action .= '<a href="/taxinvoicelist/{{$id}}/downloadinvoicepdf"  style=" animation: flashing-style 0.6s linear infinite;width: 51px;padding: 7px;color: black;" data-toggle="tooltip" data-placement="top" title="Download Invoice" ><i class="fa fa-download" style="font-size: 20px;"></i></a>';
        $action .= '<a href="{{ route("taxinvoicelist.downloadInvoicePdf",["id"=>base64_encode($id),"is_download_invoice"=>1,"currency"=> "'.$cu.'"]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="Download Invoice" class="download_invoice_pdf" ><i class="fa fa-download"></i></a>';
        
        $action .= '<a href="{{ route("taxinvoicelist.receiptInvoice",["id"=>base64_encode($id),"is_invoice_receipt"=>1,"currency"=> "'.$cu.'"]) }}" style="width: 51px;padding: 7px;color: black;margin-left:7px;margin-top:-147px;" data-toggle="tooltip" data-placement="top" title="Invoice Receipt" class="invoice_receipt" ><i class="fa fa-receipt"></i></a>';

        // if ($request->ajax()) {
            return Datatables::of($taxsettingsItems)
                ->addColumn('action', $action)
                ->rawColumns(['action'])
                // ->addColumn('check', $check)
                // ->rawColumns(['check'])
                ->make(true);
        // } 
        return $taxsettingsItems;
        // echo "<pre>-------";print_r($taxsettingsItems);exit;
    }
    

    public function downloadInvoicePdf($data){
       

        $id = base64_decode($data['id']);;
        $ar['taxDetails'] = TaxDetails::find($id);
        
        //  echo "<pre>";print_r($id );exit; 
        $ar['taxsettings'] = Tax::find($ar['taxDetails']->tax_row_id);
        $ar['taxInvoiceItems'] = DB::table('tbl_customers_tax_invoice_items')->where('tax_detail_id',$id)->get();
        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $filename = $ar['taxDetails']->guest_code.'_invoice_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.taxsettings.invoice',$ar);
        return $pdf->download($filename);
        echo "<pre>";print_r($data);exit; 

    }

    public function editInvoice($data){
        // echo "<pre>";print_r($data);exit; 

        $id = base64_decode($data['id']);
        $taxDetails = TaxDetails::find($id);
        $taxsettings = Tax::find($taxDetails->tax_row_id);
        $taxsettingsItems = DB::table('tbl_tax_settings_items')->where('tax_settings_id',$taxDetails->tax_row_id)->get();
        $customer = Customers::find($taxDetails->customer_id);
        $curr_time = date('H:i');
        $taxInvoiceItems = DB::table('tbl_customers_tax_invoice_items')->where('tax_detail_id',$id)->get();
        return view('dashboard.taxsettings.editInvoice', ['customer'=>$customer, 'taxsettings' => $taxsettings,'taxDetails'=>$taxDetails,'taxsettingsItems' => $taxsettingsItems,'taxInvoiceItems'=>$taxInvoiceItems,'curr_time'=>$curr_time]);


    }
    
    public function downloadInvoiceReport(Request $request){
        $data = $request->all();
         $taxsettingsItemsq = DB::table('tbl_customers_tax_invoice_details as tid');
        if($data['currency'] == 'usd'){
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.exchange_rate','tid.total_sc_usd as total_sc','tid.total_at_usd as total_at','tid.total_vat_usd as total_vat','tid.total_amt_usd as total_amt');
        } else {
            $taxsettingsItemsq->select('pr.name as property_name','tid.customer_id as id','tid.invoice_no','tid.guest_name','tid.exchange_rate','tid.total_sc_kh as total_sc','tid.total_at_kh as total_at','tid.total_vat_kh as total_vat','tid.total_amt_kh as total_amt');
        }
        $taxsettingsItemsq->join('customers as cu','cu.id','=', 'tid.customer_id','left')
        ->join('tbl_tax_settings as tx','tx.property_id','=','cu.property_id','left')
        ->join('properties as pr','pr.id','=','tx.property_id','left')
        // ->where('cu.deleted_at',NULL)
        ->where('tx.property_id',$data['property_id'])
        ->where('tid.invoice_date', 'like', '%' .date('Y').'-'.$data['month'] . '%');
        $taxsettingsItems = $taxsettingsItemsq->get();
        $newdata =  array();
        $propname = '';

        foreach($taxsettingsItems as $inv){
            $propname  = $inv->property_name;
            $newdata[] = $inv;
        }
        $ar['propname'] = $propname;
        $ar['invoices'] = $newdata;
        $ar['currency'] = $data['currency'];
        $ar['month'] = date("F", mktime(0, 0, 0, $data['month'], 10));

        // echo "<pre>";print_r($ar['invoices']);exit;
        $filename = 'Invoice_Report_'.$propname.'_for_'.$ar['month'].'_2024_'.$data['currency'].'_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.taxsettings.invoice_report',$ar);
        return $pdf->download($filename);
    }
    
    
    
    public function receiptInvoice($data){
        // echo "<pre>";print_r($data);exit; 

        $id = base64_decode($data['id']);;
        $ar['taxDetails'] = TaxDetails::find($id);
        $ar['taxsettings'] = Tax::find($ar['taxDetails']->tax_row_id);
        $ar['taxInvoiceItems'] = DB::table('tbl_customers_tax_invoice_items')->where('tax_detail_id',$id)->get();
        // echo "<pre>";print_r($ar['taxInvoiceItems']);exit; 
        $filename = $ar['taxDetails']->guest_code.'_invoice_'.date('Ymdhis').'.pdf';
        $pdf = PDF::loadView('dashboard.invoicesettings.invoicereceipt',$ar);
        return $pdf->download($filename);
        echo "<pre>";print_r($data);exit; 

    }

    public function generateInvoiceReceipt($data)
    { 
        $id = base64_decode($data['id']);
        $hotelAdmin_id = HotelAdmin::where('main_user_id',Auth::user()->id)->first();
        
        $customer = Customers::find($id);
        $taxInvoiceDetails = DB::table('tbl_customers_tax_invoice_details')->where('customer_id',$id)->first();
        $paymentmethods = PaymentMethod::select('id','title')->where('created_by', Auth::user()->id)->where('deleted_at',null)->get();
        // echo "<pre>";print_r($taxInvoiceDetails);exit; 
        
        $receiptsettings = ReceiptSettings::where('property_id',$customer->property_id)->orderBy('id','desc')->first();
        return view('dashboard.receiptsettings.invoicereceipt', ['receiptsettings'=>$receiptsettings,'customer'=>$customer,'taxInvoiceDetails' => $taxInvoiceDetails,'paymentmethods' =>$paymentmethods]);
    }


}
?>