					  
@extends('dashboard.base')

@section('content')

<style>
#export_button_govt{
  float:right;
  border: 1px solid darkblue;
  color: darkblue;
  margin-top: -53px;
}

#after_filter_val{
  background-color: white;
  width: 710px;
  border: 1px solid black;
  padding: 8px;
  /* margin: -37px; */
  border-radius: 13px;
  height: 43px;
  margin-left: -9px;
  margin-top: -4px;
  margin-bottom: 13px;
 }

#label_id{
  margin-left: 11px;
}

#open_filter_form{
  float: right;
  border: 1px solid darkblue;
  color: darkblue;
  margin-top: -53px;
  margin-right: 104px;
  margin-left: -198px;
}

</style>
    @if(Session::has('message'))
        <div class="row">
          <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show" role="alert">{{ Session::get('message') }}
              <button class="close" type="button" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
            </div>
            <!-- <div class="col-12">
                <div class="alert alert-success" role="alert">{{ Session::get('message') }}</div>
            </div> -->
          </div>
        </div>
      @endif                 
    <div class="container-fluid">
        <div class="animated fadeIn">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="fa fa-align-justify"></i>{{ __(' Guests') }}
                        </div>
                        <div class="card-body">
                          <div class="row">
                            <div class="col-md-3" >
                              <div class="form-group" id="from_date_div" >
                                <label>From date</label>
                                <input type="date" placeholder="Enter date" id="from_date" name="from_date" value="<?php echo date('Y-m-d');?>" class="form-control">
                              </div>
                            </div>
                            <div class="col-md-3" >
                              <div class="form-group" id="from_date_div" >
                                <label>To date</label>
                                <input type="date" placeholder="Enter date" id="to_date" name="to_date" value="<?php echo date('Y-m-d');?>" class="form-control">
                              </div>
                            </div>
                            <div class="col-md-3" >
                              <div class="form-group">
                                <button type ="button" id="export_button" class="btn">Export <i class="fa fa-download"></i></button><br/><br/>
                              </div>
                            </div>
                          </div>

                          <table style="width: 102%; margin-left: -8px;" class="table table-bordered data-table" id="scan_datatable">
                              <thead>
                              <tr>
                                  <!-- <th width="50">No</th> -->
                                  <th>Name</th>
                                  <th>Code</th>
                                  <th>Room</th>
                                  <th>Nationality</th>
                                  <th>CheckIn Date-Time</th>
                                  <th>CheckOut Date-Time</th>
                              </tr>
                              </thead>
                              <tbody>
                              </tbody>
                          </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('javascript')


<script type="text/javascript">
  $(function () {
    var from = $("#from_date").val();
    var to = $("#to_date").val();
    //load customers list in datatable
    var table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      ajax: {
            url: "{{ route('reports.checkoutguestsreport')}}",
            data: {
                    from_date :from,
                    to_date :to,
                  },
          },
      order: [],
      columns: [
          {data: 'full_name', name: 'full_name'},
          {data: 'guest_code', name: 'guest_code'},
          {data: 'room_title', name: 'room_title'},
          {data: 'country_name', name: 'country_name'},
          {data: 'checkin_date_time', name: 'checkin_date_time'},
          {data: 'checkout_date_time', name: 'checkout_date_time'},
      ]
    });
      

    //customer list using stay filter
    $(document).on("change", "#from_date", function() {
        var from = $(this).val();
        var to = $("#to_date").val();

      $('.data-table').DataTable({
        bDestroy: true,
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('reports.checkoutguestsreport')}}",
            data: {
                    from_date :from,
                    to_date :to,
                  },
          },
        order: [],
        columns: [
          {data: 'full_name', name: 'full_name'},
          {data: 'guest_code', name: 'guest_code'},
          {data: 'room_title', name: 'room_title'},
          {data: 'country_name', name: 'country_name'},
          {data: 'checkin_date_time', name: 'checkin_date_time'},
          {data: 'checkout_date_time', name: 'checkout_date_time'},
        ]
      });

    });

    // export cutsomers data
    $(document).on( "click", "#export_button", function() {
        var from = $("#from_date").val();
        var to = $("#to_date").val();

        //get base url 
        var base_url = "{{ url('/')}}"; 
        var export_url = base_url+'/reports/checkoutguestreportexport?from_date='+from+'&to_date='+to+'&type=checkoutguestreportexport';
        window.location.href = export_url;
    });
  });

</script>
@endsection



